/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.jboss.jms.delegate.BrowserDelegate;

public class JBossQueueBrowser
implements QueueBrowser,
Serializable {
    private static final long serialVersionUID = 4245650830082712281L;
    private BrowserDelegate delegate;
    private Queue queue;
    private String messageSelector;

    JBossQueueBrowser(Queue queue, String messageSelector, BrowserDelegate delegate) {
        this.delegate = delegate;
        this.queue = queue;
        this.messageSelector = messageSelector;
    }

    public void close() throws JMSException {
        this.delegate.closing();
        this.delegate.close();
    }

    public Enumeration getEnumeration() throws JMSException {
        this.delegate.reset();
        return new BrowserEnumeration();
    }

    public String getMessageSelector() throws JMSException {
        return this.messageSelector;
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public String toString() {
        return "JBossQueueBrowser->" + this.delegate;
    }

    public BrowserDelegate getDelegate() {
        return this.delegate;
    }

    private class BrowserEnumeration
    implements Enumeration {
        private BrowserEnumeration() {
        }

        public boolean hasMoreElements() {
            try {
                return JBossQueueBrowser.this.delegate.hasNextMessage();
            }
            catch (JMSException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }

        public Object nextElement() {
            try {
                return JBossQueueBrowser.this.delegate.nextMessage();
            }
            catch (JMSException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }
}

