/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.jboss.jms.delegate.ProducerDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.logging.Logger;

public class JBossMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher,
Serializable {
    private static final long serialVersionUID = 1080736785725023015L;
    private static final Logger log = Logger.getLogger(JBossMessageProducer.class);
    protected ProducerDelegate delegate;

    public JBossMessageProducer(ProducerDelegate delegate) {
        this.delegate = delegate;
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        log.warn((Object)"JBoss Messaging does not support disabling message ID generation");
        this.delegate.setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.delegate.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.delegate.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.delegate.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.delegate.setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.delegate.getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.delegate.setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.delegate.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.delegate.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.delegate.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.delegate.getDestination();
    }

    public void close() throws JMSException {
        this.delegate.closing();
        this.delegate.close();
    }

    public void send(Message message) throws JMSException {
        this.send(message, -1, -1, Long.MIN_VALUE);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Queue)null, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, -1, -1, Long.MIN_VALUE);
    }

    public void send(Destination destination, Message m, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (destination != null && !(destination instanceof JBossDestination)) {
            throw new InvalidDestinationException("Not a JBossDestination:" + destination);
        }
        this.delegate.send((JBossDestination)destination, m, deliveryMode, priority, timeToLive);
    }

    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.send((Destination)topic, message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)topic, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public ProducerDelegate getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return "JBossMessageProducer->" + this.delegate;
    }
}

