/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import org.jboss.jms.client.JBossSession;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.ConsumerState;
import org.jboss.jms.delegate.ConnectionDelegate;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.message.MessageProxy;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.MessageQueueNameHelper;

public class JBossConnectionConsumer
implements ConnectionConsumer,
Runnable {
    private static Logger log = Logger.getLogger(JBossConnectionConsumer.class);
    private static boolean trace = log.isTraceEnabled();
    private static final int TIMEOUT = 20000;
    private ConsumerDelegate cons;
    private SessionDelegate sess;
    private String consumerID;
    private ServerSessionPool serverSessionPool;
    private int maxMessages;
    private volatile boolean closed;
    private Thread internalThread;
    private int id;
    private static SynchronizedInt threadId = new SynchronizedInt(0);
    private int maxDeliveries;
    private String queueName;
    private boolean shouldAck;

    public JBossConnectionConsumer(ConnectionDelegate conn, JBossDestination dest, String subName, String messageSelector, ServerSessionPool sessPool, int maxMessages) throws JMSException {
        this.serverSessionPool = sessPool;
        this.maxMessages = maxMessages;
        if (this.maxMessages < 1) {
            this.maxMessages = 1;
        }
        this.sess = conn.createSessionDelegate(false, 2, false);
        this.cons = this.sess.createConsumerDelegate(dest, messageSelector, false, subName, true, true);
        ConsumerState state = (ConsumerState)((DelegateSupport)((Object)this.cons)).getState();
        this.consumerID = state.getConsumerID();
        this.maxDeliveries = state.getMaxDeliveries();
        this.shouldAck = state.isShouldAck();
        this.queueName = subName != null ? MessageQueueNameHelper.createSubscriptionName(conn.getClientID(), subName) : dest.getName();
        this.id = threadId.increment();
        this.internalThread = new Thread((Runnable)this, "Connection Consumer for dest " + dest + " id=" + this.id);
        this.internalThread.start();
        if (trace) {
            log.trace((Object)(this + " created"));
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    public void close() throws JMSException {
        block6: {
            if (trace) {
                log.trace((Object)("close " + this));
            }
            this.doClose();
            if (trace) {
                log.trace((Object)(this + " Waiting for internal thread to complete"));
            }
            try {
                this.internalThread.join(20000L);
                if (this.internalThread.isAlive()) {
                    throw new JMSException(this + " Waited " + 20000 + " ms for internal thread to complete, but it didn't");
                }
            }
            catch (InterruptedException e) {
                if (!trace) break block6;
                log.trace((Object)(this + " Thread interrupted while waiting for internal thread to complete"));
            }
        }
        if (trace) {
            log.trace((Object)("Closed: " + this));
        }
    }

    public void run() {
        if (trace) {
            log.trace((Object)"running connection consumer");
        }
        try {
            ArrayList<Message> mesList = new ArrayList<Message>();
            while (true) {
                ServerSession serverSession;
                JBossSession session;
                MessageListener listener;
                if (this.closed) {
                    if (!trace) break;
                    log.trace((Object)"Connection consumer is closed, breaking");
                    break;
                }
                if (mesList.isEmpty()) {
                    for (int i = 0; i < this.maxMessages; ++i) {
                        Message m;
                        block27: {
                            if (trace) {
                                log.trace((Object)(this + " attempting to get message with receiveNoWait"));
                            }
                            m = null;
                            try {
                                m = this.cons.receive(-1L);
                            }
                            catch (JMSException e) {
                                if (this.closed) break block27;
                                throw e;
                            }
                        }
                        if (m == null) {
                            if (!trace) break;
                            log.trace((Object)"receiveNoWait did not retrieve any message");
                            break;
                        }
                        if (trace) {
                            log.trace((Object)("receiveNoWait got message " + m + " adding to queue"));
                        }
                        mesList.add(m);
                    }
                    if (mesList.isEmpty()) {
                        Message m;
                        block28: {
                            if (trace) {
                                log.trace((Object)(this + " attempting to get message with blocking receive (no timeout)"));
                            }
                            m = null;
                            try {
                                m = this.cons.receive(0L);
                            }
                            catch (JMSException e) {
                                if (this.closed) break block28;
                                throw e;
                            }
                        }
                        if (m != null) {
                            if (trace) {
                                log.trace((Object)("receive (no timeout) got message " + m + " adding to queue"));
                            }
                            mesList.add(m);
                        } else {
                            if (!trace) break;
                            log.trace((Object)"blocking receive returned null, consumer must have closed");
                            break;
                        }
                    }
                }
                if (mesList.isEmpty()) continue;
                if (trace) {
                    log.trace((Object)("there are " + mesList.size() + " messages to send to session"));
                }
                if ((listener = (session = (JBossSession)(serverSession = this.serverSessionPool.getServerSession()).getSession()).getMessageListener()) == null && trace) {
                    log.trace((Object)(this + ": session " + session + " did not have a set MessageListener"));
                }
                for (int i = 0; i < mesList.size(); ++i) {
                    MessageProxy m = (MessageProxy)mesList.get(i);
                    session.addAsfMessage(m, this.consumerID, this.queueName, this.maxDeliveries, this.sess, this.shouldAck);
                    if (!trace) continue;
                    log.trace((Object)("added " + m + " to session"));
                }
                if (trace) {
                    log.trace((Object)(this + " starting serverSession " + serverSession));
                }
                serverSession.start();
                if (trace) {
                    log.trace((Object)(this + "'s serverSession processed messages"));
                }
                mesList.clear();
            }
            if (trace) {
                log.trace((Object)"ConnectionConsumer run() exiting");
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Connection consumer closing due to error in listening thread " + this), t);
            try {
                this.doClose();
            }
            catch (JMSException e) {
                log.error((Object)"Failed to close connection consumer", (Throwable)e);
            }
        }
    }

    protected synchronized void doClose() throws JMSException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.sess.closing();
            this.sess.close();
        }
        catch (Throwable t) {
            log.trace((Object)"Failed to close session", t);
        }
        if (trace) {
            log.trace((Object)(this + "Closed message handler"));
        }
    }

    public String toString() {
        return "JBossConnectionConsumer[" + this.consumerID + ", " + this.id + "]";
    }
}

