/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import org.drools.FactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.leaps.LeapsFactHandle;
import org.drools.leaps.LeapsRule;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;

class LeapsTuple
implements Tuple,
Serializable {
    private static final long serialVersionUID = 1L;
    private PropagationContext context;
    private boolean readyForActivation;
    private final LeapsFactHandle[] factHandles;
    private LeapsFactHandle[] blockingNotFactHandles = null;
    private LeapsFactHandle[] existsFactHandles = null;
    private Activation activation;
    private final LeapsRule leapsRule;

    LeapsTuple(LeapsFactHandle[] leapsFactHandleArray, LeapsRule leapsRule, PropagationContext propagationContext) {
        this.factHandles = leapsFactHandleArray;
        this.leapsRule = leapsRule;
        this.context = propagationContext;
        if (this.leapsRule != null) {
            int n;
            if (this.leapsRule.containsNotColumns()) {
                this.blockingNotFactHandles = new LeapsFactHandle[this.leapsRule.getNotColumnConstraints().length];
                for (n = 0; n < this.blockingNotFactHandles.length; ++n) {
                    this.blockingNotFactHandles[n] = null;
                }
            }
            if (this.leapsRule.containsExistsColumns()) {
                this.existsFactHandles = new LeapsFactHandle[this.leapsRule.getExistsColumnConstraints().length];
                for (n = 0; n < this.existsFactHandles.length; ++n) {
                    this.existsFactHandles[n] = null;
                }
            }
        }
        this.readyForActivation = this.leapsRule == null || !this.leapsRule.containsExistsColumns();
    }

    protected LeapsRule getLeapsRule() {
        return this.leapsRule;
    }

    public boolean dependsOn(FactHandle factHandle) {
        int n = this.factHandles.length;
        for (int i = 0; i < n; ++i) {
            if (!factHandle.equals(this.factHandles[i])) continue;
            return true;
        }
        return false;
    }

    public InternalFactHandle get(int n) {
        return this.factHandles[n];
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getColumn());
    }

    public InternalFactHandle[] getFactHandles() {
        return this.factHandles;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    protected boolean isActivationNull() {
        return this.activation == null;
    }

    protected Activation getActivation() {
        return this.activation;
    }

    public long getRecency() {
        return 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof LeapsTuple)) {
            return false;
        }
        InternalFactHandle[] internalFactHandleArray = ((LeapsTuple)object).getFactHandles();
        if (internalFactHandleArray.length != this.factHandles.length) {
            return false;
        }
        int n = this.factHandles.length;
        for (int i = 0; i < n; ++i) {
            if (this.factHandles[i].equals(internalFactHandleArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isReadyForActivation() {
        return this.readyForActivation;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("LeapsTuple [" + this.leapsRule.getRule().getName() + "] ");
        int n2 = this.factHandles.length;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append((n == 0 ? "" : ", ") + this.factHandles[n]);
        }
        if (this.existsFactHandles != null) {
            stringBuffer.append("\nExists fact handles by position");
            n2 = this.existsFactHandles.length;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("\nposition " + n).append(this.existsFactHandles[n]);
            }
        }
        if (this.blockingNotFactHandles != null) {
            stringBuffer.append("\nblockingNot fact handles by position");
            n2 = this.blockingNotFactHandles.length;
            for (n = 0; n < n2; ++n) {
                stringBuffer.append("\nposition " + n).append(this.blockingNotFactHandles[n]);
            }
        }
        return stringBuffer.toString();
    }

    protected void setBlockingNotFactHandle(LeapsFactHandle leapsFactHandle, int n) {
        this.readyForActivation = false;
        this.blockingNotFactHandles[n] = leapsFactHandle;
    }

    protected boolean isBlockingNotFactHandle(int n) {
        return this.blockingNotFactHandles[n] != null;
    }

    protected void removeBlockingNotFactHandle(int n) {
        this.blockingNotFactHandles[n] = null;
        this.setReadyForActivation();
    }

    protected void setExistsFactHandle(LeapsFactHandle leapsFactHandle, int n) {
        this.existsFactHandles[n] = leapsFactHandle;
        this.setReadyForActivation();
    }

    protected boolean isExistsFactHandle(int n) {
        return this.existsFactHandles[n] != null;
    }

    protected void removeExistsFactHandle(int n) {
        this.existsFactHandles[n] = null;
        this.setReadyForActivation();
    }

    private void setReadyForActivation() {
        int n;
        int n2;
        this.readyForActivation = true;
        if (this.blockingNotFactHandles != null) {
            n2 = this.blockingNotFactHandles.length;
            for (n = 0; n < n2; ++n) {
                if (this.blockingNotFactHandles[n] == null) continue;
                this.readyForActivation = false;
                return;
            }
        }
        if (this.existsFactHandles != null) {
            n2 = this.existsFactHandles.length;
            for (n = 0; n < n2; ++n) {
                if (this.existsFactHandles[n] != null) continue;
                this.readyForActivation = false;
                return;
            }
        }
    }

    protected PropagationContext getContext() {
        return this.context;
    }

    protected void setContext(PropagationContext propagationContext) {
        this.context = propagationContext;
    }
}

