/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listing;

import java.io.IOException;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.listing.FileFilter;
import org.apache.ftpserver.listing.FileFormater;
import org.apache.ftpserver.listing.ListArgument;
import org.apache.ftpserver.listing.RegexFileFilter;
import org.apache.ftpserver.listing.VisibleFileFilter;

public class DirectoryLister {
    private String traverseFiles(FileObject[] files, FileFilter filter, FileFormater formater) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.traverseFiles(files, filter, formater, true));
        sb.append(this.traverseFiles(files, filter, formater, false));
        return sb.toString();
    }

    private String traverseFiles(FileObject[] files, FileFilter filter, FileFormater formater, boolean matchDirs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null || filter != null && !filter.accept(files[i]) || files[i].isDirectory() != matchDirs) continue;
            sb.append(formater.format(files[i]));
        }
        return sb.toString();
    }

    public String listFiles(ListArgument argument, FileSystemView fileSystemView, FileFormater formater) throws IOException {
        StringBuffer sb = new StringBuffer();
        FileObject[] files = this.listFiles(fileSystemView, argument.getFile());
        if (files != null) {
            FileFilter filter = null;
            if (argument.hasOption('a')) {
                filter = new VisibleFileFilter();
            }
            if (argument.getPattern() != null) {
                filter = new RegexFileFilter(argument.getPattern(), filter);
            }
            sb.append(this.traverseFiles(files, filter, formater));
        }
        return sb.toString();
    }

    private FileObject[] listFiles(FileSystemView fileSystemView, String file) {
        FileObject[] files = null;
        try {
            FileObject virtualFile = fileSystemView.getFileObject(file);
            files = virtualFile.isFile() ? new FileObject[]{virtualFile} : virtualFile.listFiles();
        }
        catch (FtpException ex) {
            // empty catch block
        }
        return files;
    }
}

