/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.listener.mina;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.ConnectionObserver;
import org.apache.ftpserver.listener.FtpProtocolHandler;
import org.apache.ftpserver.listener.mina.MinaConnection;
import org.apache.ftpserver.listener.mina.MinaFtpResponseOutput;
import org.apache.ftpserver.listener.mina.MinaListener;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.util.SessionLog;

public class MinaFtpProtocolHandler
extends IoHandlerAdapter {
    private static final String OUTPUT_KEY = "output";
    private static final String CONNECTION_KEY = "connection";
    private FtpServerContext serverContext;
    private FtpProtocolHandler protocolHandler;
    private MinaListener listener;

    public MinaFtpProtocolHandler(FtpServerContext serverContext, FtpProtocolHandler protocolHandler, MinaListener listener) throws IOException {
        this.serverContext = serverContext;
        this.protocolHandler = protocolHandler;
        this.listener = listener;
    }

    public void sessionCreated(IoSession session) throws Exception {
        MinaConnection connection = new MinaConnection(this.serverContext, session, this.listener);
        session.setAttribute(CONNECTION_KEY, (Object)connection);
        MinaFtpResponseOutput output = new MinaFtpResponseOutput(session);
        session.setAttribute(OUTPUT_KEY, (Object)output);
    }

    public void sessionOpened(IoSession session) throws Exception {
        MinaConnection connection = (MinaConnection)session.getAttribute(CONNECTION_KEY);
        MinaFtpResponseOutput output = (MinaFtpResponseOutput)session.getAttribute(OUTPUT_KEY);
        this.protocolHandler.onConnectionOpened(connection, (FtpSessionImpl)connection.getSession(), output);
    }

    public void sessionClosed(IoSession session) throws Exception {
        MinaConnection connection = (MinaConnection)session.getAttribute(CONNECTION_KEY);
        MinaFtpResponseOutput output = (MinaFtpResponseOutput)session.getAttribute(OUTPUT_KEY);
        this.protocolHandler.onConnectionClosed(connection, (FtpSessionImpl)connection.getSession(), output);
    }

    public void messageReceived(IoSession session, Object message) throws IOException, FtpException {
        FtpRequest request = (FtpRequest)message;
        ConnectionObserver observer = (ConnectionObserver)session.getAttribute("observer");
        if (observer != null) {
            observer.request(request.toString());
        }
        MinaConnection connection = (MinaConnection)session.getAttribute(CONNECTION_KEY);
        MinaFtpResponseOutput output = (MinaFtpResponseOutput)session.getAttribute(OUTPUT_KEY);
        this.protocolHandler.onRequestReceived(connection, (FtpSessionImpl)connection.getSession(), output, request);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        SessionLog.info((IoSession)session, (String)"Disconnecting the idle.");
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }
}

