/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.DefaultFtpReply;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpStatistics;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.DateUtils;
import org.apache.ftpserver.util.FtpReplyUtil;

public class SITE_STAT
extends AbstractCommand {
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        session.resetState();
        UserManager userManager = connection.getServerContext().getUserManager();
        boolean isAdmin = userManager.isAdmin(session.getUser().getName());
        if (!isAdmin) {
            out.write(FtpReplyUtil.translate(session, 530, "SITE", null));
            return;
        }
        FtpStatistics stat = connection.getServerContext().getFtpStatistics();
        StringBuffer sb = new StringBuffer(256);
        sb.append('\n');
        sb.append("Start Time               : ").append(DateUtils.getISO8601Date(stat.getStartTime().getTime())).append('\n');
        sb.append("File Upload Number       : ").append(stat.getTotalUploadNumber()).append('\n');
        sb.append("File Download Number     : ").append(stat.getTotalDownloadNumber()).append('\n');
        sb.append("File Delete Number       : ").append(stat.getTotalDeleteNumber()).append('\n');
        sb.append("File Upload Bytes        : ").append(stat.getTotalUploadSize()).append('\n');
        sb.append("File Download Bytes      : ").append(stat.getTotalDownloadSize()).append('\n');
        sb.append("Directory Create Number  : ").append(stat.getTotalDirectoryCreated()).append('\n');
        sb.append("Directory Remove Number  : ").append(stat.getTotalDirectoryRemoved()).append('\n');
        sb.append("Current Logins           : ").append(stat.getCurrentLoginNumber()).append('\n');
        sb.append("Total Logins             : ").append(stat.getTotalLoginNumber()).append('\n');
        sb.append("Current Anonymous Logins : ").append(stat.getCurrentAnonymousLoginNumber()).append('\n');
        sb.append("Total Anonymous Logins   : ").append(stat.getTotalAnonymousLoginNumber()).append('\n');
        sb.append("Current Connections      : ").append(stat.getCurrentConnectionNumber()).append('\n');
        sb.append("Total Connections        : ").append(stat.getTotalConnectionNumber()).append('\n');
        sb.append('\n');
        out.write((FtpReply)new DefaultFtpReply(200, sb.toString()));
    }
}

