/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.interfaces.DataConnectionConfig;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PORT
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)PORT.class);

    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException {
        InetAddress clientAddr;
        session.resetState();
        if (!request.hasArgument()) {
            out.write(FtpReplyUtil.translate(session, 501, "PORT", null));
            return;
        }
        StringTokenizer st = new StringTokenizer(request.getArgument(), ",");
        if (st.countTokens() != 6) {
            out.write(FtpReplyUtil.translate(session, 510, "PORT", null));
            return;
        }
        DataConnectionConfig dataCfg = session.getListener().getDataConnectionConfig();
        if (!dataCfg.isActiveEnabled()) {
            out.write(FtpReplyUtil.translate(session, 510, "PORT.disabled", null));
            return;
        }
        String dataSrvName = st.nextToken() + '.' + st.nextToken() + '.' + st.nextToken() + '.' + st.nextToken();
        InetAddress dataAddr = null;
        try {
            dataAddr = InetAddress.getByName(dataSrvName);
        }
        catch (UnknownHostException ex) {
            this.LOG.debug("Unknown host: " + dataSrvName, (Throwable)ex);
            out.write(FtpReplyUtil.translate(session, 553, "PORT.host", null));
            return;
        }
        if (dataCfg.isActiveIpCheck() && !dataAddr.equals(clientAddr = session.getClientAddress())) {
            out.write(FtpReplyUtil.translate(session, 510, "PORT.mismatch", null));
            return;
        }
        int dataPort = 0;
        try {
            int hi = Integer.parseInt(st.nextToken());
            int lo = Integer.parseInt(st.nextToken());
            dataPort = hi << 8 | lo;
        }
        catch (NumberFormatException ex) {
            this.LOG.debug("Invalid data port: " + request.getArgument(), (Throwable)ex);
            out.write(FtpReplyUtil.translate(session, 552, "PORT.invalid", null));
            return;
        }
        session.getServerDataConnection().setPortCommand(dataAddr, dataPort);
        out.write(FtpReplyUtil.translate(session, 200, "PORT", null));
    }
}

