/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.FileObject;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletEnum;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.util.FtpReplyUtil;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APPE
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger((Class)APPE.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        block32: {
            try {
                DataConnection dataConnection;
                FtpletEnum ftpletRet;
                session.resetState();
                FtpServerContext serverContext = connection.getServerContext();
                String fileName = request.getArgument();
                if (fileName == null) {
                    out.write(FtpReplyUtil.translate(session, 501, "APPE", null));
                    return;
                }
                Ftplet ftpletContainer = serverContext.getFtpletContainer();
                try {
                    ftpletRet = ftpletContainer.onAppendStart((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_SKIP) {
                    return;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
                FileObject file = null;
                try {
                    file = session.getFileSystemView().getFileObject(fileName);
                }
                catch (Exception e) {
                    this.LOG.debug("File system threw exception", (Throwable)e);
                }
                if (file == null) {
                    out.write(FtpReplyUtil.translate(session, 550, "APPE.invalid", fileName));
                    return;
                }
                fileName = file.getFullName();
                if (file.doesExist() && !file.isFile()) {
                    out.write(FtpReplyUtil.translate(session, 550, "APPE.invalid", fileName));
                    return;
                }
                if (!file.hasWritePermission()) {
                    out.write(FtpReplyUtil.translate(session, 550, "APPE.permission", fileName));
                    return;
                }
                out.write(FtpReplyUtil.translate(session, 150, "APPE", fileName));
                try {
                    dataConnection = session.getDataConnection().openConnection();
                }
                catch (Exception e) {
                    this.LOG.debug("Exception when getting data input stream", (Throwable)e);
                    out.write(FtpReplyUtil.translate(session, 425, "APPE", fileName));
                    session.getDataConnection().closeDataConnection();
                    return;
                }
                boolean failure = false;
                OutputStream os = null;
                try {
                    long offset = 0L;
                    if (file.doesExist()) {
                        offset = file.getSize();
                    }
                    os = file.createOutputStream(offset);
                    long transSz = dataConnection.transferFromClient(os);
                    String userName = session.getUser().getName();
                    this.LOG.info("File upload : " + userName + " - " + fileName);
                    ServerFtpStatistics ftpStat = (ServerFtpStatistics)serverContext.getFtpStatistics();
                    ftpStat.setUpload(connection, file, transSz);
                }
                catch (SocketException e) {
                    this.LOG.debug("SocketException during file upload", (Throwable)e);
                    failure = true;
                    out.write(FtpReplyUtil.translate(session, 426, "APPE", fileName));
                    IoUtils.close(os);
                }
                catch (IOException e2) {
                    this.LOG.debug("IOException during file upload", (Throwable)e2);
                    failure = true;
                    out.write(FtpReplyUtil.translate(session, 551, "APPE", fileName));
                    {
                        catch (Throwable throwable) {
                            IoUtils.close(os);
                            throw throwable;
                        }
                    }
                    IoUtils.close(os);
                }
                IoUtils.close(os);
                if (failure) break block32;
                out.write(FtpReplyUtil.translate(session, 226, "APPE", fileName));
                try {
                    ftpletRet = ftpletContainer.onAppendEnd((FtpSession)session, request, out);
                }
                catch (Exception e) {
                    this.LOG.debug("Ftplet container threw exception", (Throwable)e);
                    ftpletRet = FtpletEnum.RET_DISCONNECT;
                }
                if (ftpletRet == FtpletEnum.RET_DISCONNECT) {
                    serverContext.getConnectionManager().closeConnection(connection);
                    return;
                }
            }
            finally {
                session.getDataConnection().closeDataConnection();
            }
        }
    }
}

