/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PassivePorts {
    private static final int MAX_PORT = 65535;
    private int[] passivePorts;
    private boolean[] reservedPorts;

    public static PassivePorts parse(String portsString) {
        ArrayList passivePortsList = new ArrayList();
        boolean inRange = false;
        Integer lastPort = new Integer(1);
        StringTokenizer st = new StringTokenizer(portsString, ",;-", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (",".equals(token) || ";".equals(token)) {
                if (inRange) {
                    PassivePorts.fillRange(passivePortsList, lastPort, new Integer(65535));
                }
                lastPort = new Integer(1);
                inRange = false;
                continue;
            }
            if ("-".equals(token)) {
                inRange = true;
                continue;
            }
            if (token.length() == 0) continue;
            Integer port = Integer.valueOf(token);
            PassivePorts.verifyPort(port);
            if (inRange) {
                PassivePorts.fillRange(passivePortsList, lastPort, port);
                inRange = false;
            }
            PassivePorts.addPort(passivePortsList, port);
            lastPort = port;
        }
        if (inRange) {
            PassivePorts.fillRange(passivePortsList, lastPort, new Integer(65535));
        }
        int[] passivePorts = new int[passivePortsList.size()];
        Iterator iter = passivePortsList.iterator();
        int counter = 0;
        while (iter.hasNext()) {
            Integer port = (Integer)iter.next();
            passivePorts[counter] = port;
            ++counter;
        }
        return new PassivePorts(passivePorts);
    }

    private static void fillRange(List passivePortsList, Integer beginPort, Integer endPort) {
        for (int i = beginPort.intValue(); i <= endPort; ++i) {
            Integer rangePort = new Integer(i);
            PassivePorts.addPort(passivePortsList, rangePort);
        }
    }

    private static void addPort(List passivePortsList, Integer rangePort) {
        if (!passivePortsList.contains(rangePort)) {
            passivePortsList.add(rangePort);
        }
    }

    private static void verifyPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException("Port can not be negative: " + port);
        }
        if (port > 65535) {
            throw new IllegalArgumentException("Port too large: " + port);
        }
    }

    private PassivePorts(int[] passivePorts) {
        this.passivePorts = passivePorts;
        this.reservedPorts = new boolean[passivePorts.length];
    }

    public int reserveNextPort() {
        for (int i = 0; i < this.passivePorts.length; ++i) {
            if (this.reservedPorts[i]) continue;
            if (this.passivePorts[i] != 0) {
                this.reservedPorts[i] = true;
            }
            return this.passivePorts[i];
        }
        return -1;
    }

    public void releasePort(int port) {
        for (int i = 0; i < this.passivePorts.length; ++i) {
            if (this.passivePorts[i] != port) continue;
            this.reservedPorts[i] = false;
            break;
        }
    }
}

