/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metamodel.descriptor;

import java.util.Collection;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.EjbLocalRef;
import org.jboss.metamodel.descriptor.EjbRef;
import org.jboss.metamodel.descriptor.EnvEntry;
import org.jboss.metamodel.descriptor.JndiRef;
import org.jboss.metamodel.descriptor.MessageDestinationRef;
import org.jboss.metamodel.descriptor.ResourceEnvRef;
import org.jboss.metamodel.descriptor.ResourceRef;
import org.jboss.metamodel.descriptor.WebServiceRef;

public abstract class EnvironmentRefGroup {
    private static final Logger log = Logger.getLogger(EnvironmentRefGroup.class);
    protected HashMap ejbLocalRefs = new HashMap();
    protected HashMap ejbRefs = new HashMap();
    protected HashMap envEntries = new HashMap();
    protected HashMap resourceEnvRefs = new HashMap();
    protected HashMap resourceRefs = new HashMap();
    protected HashMap messageDestinationRefs = new HashMap();
    protected HashMap webServiceRefs = new HashMap();
    protected HashMap jndiRefs = new HashMap();

    public Collection getMessageDestinationRefs() {
        return this.messageDestinationRefs.values();
    }

    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
        this.messageDestinationRefs.put(messageDestinationRef.getMessageDestinationRefName(), messageDestinationRef);
    }

    public Collection getEjbLocalRefs() {
        return this.ejbLocalRefs.values();
    }

    public void addEjbLocalRef(EjbLocalRef ref) {
        this.ejbLocalRefs.put(ref.getEjbRefName(), ref);
    }

    public Collection getEjbRefs() {
        return this.ejbRefs.values();
    }

    public void addEjbRef(EjbRef ref) {
        this.ejbRefs.put(ref.getEjbRefName(), ref);
    }

    public Collection getEnvEntries() {
        return this.envEntries.values();
    }

    public void addEnvEntry(EnvEntry entry) {
        this.envEntries.put(entry.getEnvEntryName(), entry);
    }

    public Collection getResourceEnvRefs() {
        return this.resourceEnvRefs.values();
    }

    public void addResourceEnvRef(ResourceEnvRef envRef) {
        this.resourceEnvRefs.put(envRef.getResRefName(), envRef);
    }

    public Collection getResourceRefs() {
        return this.resourceRefs.values();
    }

    public void addResourceRef(ResourceRef ref) {
        this.resourceRefs.put(ref.getResRefName(), ref);
    }

    public Collection getJndiRefs() {
        return this.jndiRefs.values();
    }

    public void addJndiRef(JndiRef ref) {
        this.jndiRefs.put(ref.getJndiRefName(), ref);
    }

    public Collection getWebServiceRefs() {
        return this.webServiceRefs.values();
    }

    public void addWebServiceRef(WebServiceRef ref) {
        this.webServiceRefs.put(ref.getServiceRefName(), ref);
    }

    public void updateEjbRef(EjbRef updatedRef) {
        EjbRef ref = (EjbRef)this.ejbRefs.get(updatedRef.getEjbRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
            ref.setIgnoreDependency(updatedRef.isIgnoreDependency());
        } else {
            this.ejbRefs.put(updatedRef.getEjbRefName(), updatedRef);
        }
    }

    public void updateEjbLocalRef(EjbLocalRef updatedRef) {
        EjbLocalRef ref = (EjbLocalRef)this.ejbLocalRefs.get(updatedRef.getEjbRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
            ref.setIgnoreDependency(updatedRef.isIgnoreDependency());
        } else {
            this.ejbLocalRefs.put(updatedRef.getEjbRefName(), updatedRef);
        }
    }

    public void updateResourceRef(ResourceRef updatedRef) {
        ResourceRef ref = (ResourceRef)this.resourceRefs.get(updatedRef.getResRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
            ref.setResUrl(updatedRef.getResUrl());
            ref.setResourceName(updatedRef.getResourceName());
        } else {
            this.resourceRefs.put(updatedRef.getResRefName(), updatedRef);
        }
    }

    public void updateResourceEnvRef(ResourceEnvRef updatedRef) {
        ResourceEnvRef ref = (ResourceEnvRef)this.resourceEnvRefs.get(updatedRef.getResRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
        } else {
            this.resourceEnvRefs.put(updatedRef.getResRefName(), updatedRef);
        }
    }

    public void updateMessageDestinationRef(MessageDestinationRef updatedRef) {
        MessageDestinationRef ref = (MessageDestinationRef)this.messageDestinationRefs.get(updatedRef.getMessageDestinationRefName());
        if (ref != null) {
            ref.setMappedName(updatedRef.getMappedName());
        } else {
            this.messageDestinationRefs.put(updatedRef.getMessageDestinationRefName(), updatedRef);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        return sb.toString();
    }
}

