/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.security.ssl.DomainServerSocketFactory;

public class SSLSessionInterceptor
extends AbstractInterceptor {
    private CertificatePrincipal cpMapping = new SubjectDNMapping();
    private String sessionIDKey = "SESSION_ID";

    public Object invokeHome(Invocation mi) throws Exception {
        this.extractSessionPrincipal(mi);
        Object returnValue = this.getNext().invoke(mi);
        return returnValue;
    }

    public CertificatePrincipal getPrincialMapping() {
        return this.cpMapping;
    }

    public void setPrincialMapping(CertificatePrincipal cpMapping) {
        this.cpMapping = cpMapping;
    }

    public String getSessionIDKey() {
        return this.sessionIDKey;
    }

    public void setSessionIDKey(String sessionIDKey) {
        this.sessionIDKey = sessionIDKey;
    }

    public Object invoke(Invocation mi) throws Exception {
        this.extractSessionPrincipal(mi);
        Object returnValue = this.getNext().invoke(mi);
        return returnValue;
    }

    private void extractSessionPrincipal(Invocation mi) throws SSLPeerUnverifiedException {
        SSLSession session;
        String sessionID = (String)mi.getValue(this.sessionIDKey);
        if (sessionID != null && (session = DomainServerSocketFactory.getSSLSession(sessionID)) != null) {
            X509Certificate[] certs = (X509Certificate[])session.getPeerCertificates();
            Principal caller = this.cpMapping.toPrinicipal(certs);
            mi.setPrincipal(caller);
            mi.setCredential(certs);
        }
    }
}

