/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.Principal;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.StatefulSessionContainer;

public class StatefulSessionEnterpriseContext
extends EnterpriseContext
implements Serializable {
    private EJBObject ejbObject;
    private EJBLocalObject ejbLocalObject;
    private SessionContext ctx = new StatefulSessionContextImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulSessionEnterpriseContext(Object instance, Container con) throws RemoteException {
        super(instance, con);
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_SET_SESSION_CONTEXT);
            ((SessionBean)instance).setSessionContext(this.ctx);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    public void discard() throws RemoteException {
    }

    public EJBContext getEJBContext() {
        return this.ctx;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
        try {
            ((SessionBean)instance).setSessionContext(this.ctx);
        }
        catch (Exception x) {
            log.error("Failed to setSessionContext", x);
        }
    }

    public void setEJBObject(EJBObject eo) {
        this.ejbObject = eo;
    }

    public EJBObject getEJBObject() {
        return this.ejbObject;
    }

    public void setEJBLocalObject(EJBLocalObject eo) {
        this.ejbLocalObject = eo;
    }

    public EJBLocalObject getEJBLocalObject() {
        return this.ejbLocalObject;
    }

    public SessionContext getSessionContext() {
        return this.ctx;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    protected class StatefulSessionContextImpl
    extends EnterpriseContext.EJBContextImpl
    implements SessionContext {
        protected StatefulSessionContextImpl() {
        }

        public EJBHome getEJBHome() {
            AllowedOperationsAssociation.assertAllowedIn("getEJBHome", AllowedOperationsFlags.IN_SET_SESSION_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
            return super.getEJBHome();
        }

        public EJBLocalHome getEJBLocalHome() {
            AllowedOperationsAssociation.assertAllowedIn("getEJBLocalHome", AllowedOperationsFlags.IN_SET_SESSION_CONTEXT | AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
            return super.getEJBLocalHome();
        }

        public Principal getCallerPrincipal() {
            AllowedOperationsAssociation.assertAllowedIn("getCallerPrincipal", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
            return super.getCallerPrincipal();
        }

        public boolean isCallerInRole(String id) {
            AllowedOperationsAssociation.assertAllowedIn("isCallerInRole", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
            return super.isCallerInRole(id);
        }

        public EJBObject getEJBObject() {
            AllowedOperationsAssociation.assertAllowedIn("getEJBObject", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
            if (((StatefulSessionContainer)StatefulSessionEnterpriseContext.this.con).getRemoteClass() == null) {
                throw new IllegalStateException("No remote interface defined.");
            }
            if (StatefulSessionEnterpriseContext.this.ejbObject == null) {
                EJBProxyFactory proxyFactory = StatefulSessionEnterpriseContext.this.con.getProxyFactory();
                if (proxyFactory == null) {
                    String defaultInvokerName = StatefulSessionEnterpriseContext.this.con.getBeanMetaData().getContainerConfiguration().getDefaultInvokerName();
                    proxyFactory = StatefulSessionEnterpriseContext.this.con.lookupProxyFactory(defaultInvokerName);
                }
                StatefulSessionEnterpriseContext.this.ejbObject = (EJBObject)proxyFactory.getStatefulSessionEJBObject(StatefulSessionEnterpriseContext.this.id);
            }
            return StatefulSessionEnterpriseContext.this.ejbObject;
        }

        public Object getBusinessObject(Class businessInterface) throws IllegalStateException {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        public Object getInvokedBusinessInterface() throws IllegalStateException {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        public EJBLocalObject getEJBLocalObject() {
            AllowedOperationsAssociation.assertAllowedIn("getEJBLocalObject", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION | AllowedOperationsFlags.IN_AFTER_COMPLETION);
            if (StatefulSessionEnterpriseContext.this.con.getLocalHomeClass() == null) {
                throw new IllegalStateException("No local interface for bean.");
            }
            if (StatefulSessionEnterpriseContext.this.ejbLocalObject == null) {
                StatefulSessionEnterpriseContext.this.ejbLocalObject = ((StatefulSessionContainer)StatefulSessionEnterpriseContext.this.con).getLocalProxyFactory().getStatefulSessionEJBLocalObject(StatefulSessionEnterpriseContext.this.id);
            }
            return StatefulSessionEnterpriseContext.this.ejbLocalObject;
        }

        public boolean getRollbackOnly() {
            AllowedOperationsAssociation.assertAllowedIn("getRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION);
            return super.getRollbackOnly();
        }

        public void setRollbackOnly() {
            AllowedOperationsAssociation.assertAllowedIn("setRollbackOnly", AllowedOperationsFlags.IN_BUSINESS_METHOD | AllowedOperationsFlags.IN_AFTER_BEGIN | AllowedOperationsFlags.IN_BEFORE_COMPLETION);
            super.setRollbackOnly();
        }

        public UserTransaction getUserTransaction() {
            AllowedOperationsAssociation.assertAllowedIn("getUserTransaction", AllowedOperationsFlags.IN_EJB_CREATE | AllowedOperationsFlags.IN_EJB_REMOVE | AllowedOperationsFlags.IN_EJB_ACTIVATE | AllowedOperationsFlags.IN_EJB_PASSIVATE | AllowedOperationsFlags.IN_BUSINESS_METHOD);
            return super.getUserTransaction();
        }

        public TimerService getTimerService() throws IllegalStateException {
            throw new IllegalStateException("getTimerService should not be access from a stateful session bean");
        }

        public MessageContext getMessageContext() throws IllegalStateException {
            AllowedOperationsAssociation.assertAllowedIn("getMessageContext", 0);
            return null;
        }

        public Object getPrimaryKey() {
            return StatefulSessionEnterpriseContext.this.id;
        }
    }
}

