/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aspects.dbc.DesignByContractAspect;
import org.jboss.aspects.dbc.PostCond;
import org.jboss.aspects.dbc.PreCond;
import org.jboss.aspects.dbc.condition.ConditionManager;
import org.jboss.aspects.dbc.condition.ConstructorCondition;
import org.jboss.aspects.dbc.condition.ExecutableCondition;
import org.jboss.aspects.dbc.condition.InvariantCondition;

public class ConstructorConditionManager
extends ConditionManager {
    public static synchronized ExecutableCondition[] getPreConditions(Constructor constructor) {
        ExecutableCondition[] pre = (ExecutableCondition[])preConditions.get(constructor);
        if (pre != null) {
            return pre;
        }
        ConstructorConditionManager.initialise(constructor);
        return (ExecutableCondition[])preConditions.get(constructor);
    }

    public static synchronized ExecutableCondition[] getPostConditions(Constructor constructor) {
        ExecutableCondition[] post = (ExecutableCondition[])postConditions.get(constructor);
        if (post != null) {
            return post;
        }
        ConstructorConditionManager.initialise(constructor);
        return (ExecutableCondition[])postConditions.get(constructor);
    }

    public static synchronized InvariantCondition[] getInvariants(Constructor constructor) {
        return ConstructorConditionManager.getInvariants(constructor.getDeclaringClass());
    }

    private static void initialise(Constructor constructor) {
        Class clazz;
        if (DesignByContractAspect.verbose) {
            System.out.println("[dbc] ===== Intitalising constructor: " + constructor);
        }
        ArrayList preConds = new ArrayList();
        ArrayList postConds = new ArrayList();
        boolean first = true;
        Constructor superConstructor = constructor;
        for (Class curClazz = clazz = constructor.getDeclaringClass(); curClazz != null; curClazz = curClazz.getSuperclass()) {
            if (first) {
                first = false;
            } else {
                superConstructor = ConstructorConditionManager.findConstructorInClass(curClazz, constructor);
            }
            if (superConstructor == null) continue;
            ConstructorConditionManager.addConstructorConditions(constructor, superConstructor, preConds, postConds);
        }
        ExecutableCondition[] pre = preConds.toArray(new ExecutableCondition[preConds.size()]);
        preConditions.put(constructor, pre);
        ExecutableCondition[] post = postConds.toArray(new ExecutableCondition[postConds.size()]);
        postConditions.put(constructor, post);
    }

    private static void addConstructorConditions(Constructor realConstructor, Constructor currentConstructor, ArrayList preConds, ArrayList postConds) {
        PostCond post;
        PreCond pre = (PreCond)AnnotationElement.getAnyAnnotation(currentConstructor, PreCond.class);
        if (pre != null) {
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Found preconditions in method: " + currentConstructor);
            }
            ConstructorConditionManager.addConstructorConditions(realConstructor, preConds, pre.value());
        }
        if ((post = (PostCond)AnnotationElement.getAnyAnnotation(currentConstructor, PostCond.class)) != null) {
            if (DesignByContractAspect.verbose) {
                System.out.println("[dbc] Found postconditions in method: " + currentConstructor);
            }
            ConstructorConditionManager.addConstructorConditions(realConstructor, postConds, post.value());
        }
    }

    private static ArrayList addConstructorConditions(Constructor realConstructor, ArrayList conditions, String[] exprs) {
        if (exprs == null) {
            return conditions;
        }
        for (int i = 0; i < exprs.length; ++i) {
            conditions.add(new ConstructorCondition(realConstructor, exprs[i]));
        }
        return conditions;
    }

    private static Constructor findConstructorInClass(Class clazz, Constructor constructor) {
        String name = constructor.getName();
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] foundParams;
            Class<?>[] soughtParams;
            if (!constructors[i].getName().equals(name) || (soughtParams = constructor.getParameterTypes()).length != (foundParams = constructors[i].getParameterTypes()).length) continue;
            for (int j = 0; j < soughtParams.length && soughtParams[j] == foundParams[j]; ++j) {
            }
            return constructors[i];
        }
        return null;
    }
}

