/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactoryWrapper;
import org.jboss.aop.joinpoint.Joinpoint;

public abstract class JoinPointInfo {
    public InterceptorFactoryWrapper[] factories;
    public ArrayList factoryChain = new ArrayList();
    public Interceptor[] interceptors;
    public ArrayList interceptorChain = new ArrayList();
    private WeakReference advisor;
    protected volatile Joinpoint joinpoint;

    protected JoinPointInfo() {
    }

    protected JoinPointInfo(Advisor advisor) {
        this.setAdvisor(advisor);
    }

    protected JoinPointInfo(JoinPointInfo other) {
        this.advisor = other.advisor;
        if (other.factories != null) {
            this.factories = new InterceptorFactoryWrapper[other.factories.length];
            System.arraycopy(other.factories, 0, this.factories, 0, other.factories.length);
        }
        if (other.factoryChain != null) {
            this.factoryChain = (ArrayList)this.factoryChain.clone();
        }
        if (other.interceptors != null) {
            this.interceptors = new Interceptor[other.interceptors.length];
            System.arraycopy(other.interceptors, 0, this.interceptors, 0, other.interceptors.length);
        }
        if (other.interceptorChain != null) {
            this.interceptorChain = (ArrayList)this.interceptorChain.clone();
        }
    }

    protected void clear() {
        this.factoryChain.clear();
        this.interceptorChain.clear();
        this.interceptors = null;
        this.factories = null;
    }

    public Advisor getAdvisor() {
        if (this.advisor == null) {
            return null;
        }
        return (Advisor)this.advisor.get();
    }

    public void setAdvisor(Advisor advisor) {
        this.advisor = new WeakReference<Advisor>(advisor);
    }

    public boolean hasAdvices() {
        return this.interceptors != null && this.interceptors.length > 0 || this.factories != null && this.factories.length > 0;
    }

    public JoinPointInfo initialiseInterceptors() {
        if (this.factories == null || this.interceptors != null) {
            return this;
        }
        this.interceptors = new Interceptor[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            this.interceptors[i] = this.factories[i].create(this.getAdvisor(), this.getJoinpoint());
        }
        return this;
    }

    public boolean equalChains(JoinPointInfo other) {
        if (this.factories == null && other.factories == null) {
            return true;
        }
        if (this.factories == null || other.factories == null) {
            return false;
        }
        if (this.factories.length != other.factories.length) {
            return false;
        }
        for (int i = 0; i < this.factories.length; ++i) {
            if (this.factories[i].equals(other.factories[i])) continue;
            return false;
        }
        return true;
    }

    public Joinpoint getJoinpoint() {
        if (this.joinpoint == null) {
            this.joinpoint = this.internalGetJoinpoint();
        }
        return this.joinpoint;
    }

    public ArrayList getInterceptorChain() {
        return this.interceptorChain;
    }

    public void setInterceptorChain(ArrayList interceptorChain) {
        this.interceptorChain = interceptorChain;
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public InterceptorFactoryWrapper[] getFactories() {
        return this.factories;
    }

    public void setFactories(InterceptorFactoryWrapper[] factories) {
        this.factories = factories;
    }

    public ArrayList getFactoryChain() {
        return this.factoryChain;
    }

    public void setFactoryChain(ArrayList factoryChain) {
        this.factoryChain = factoryChain;
    }

    protected abstract Joinpoint internalGetJoinpoint();

    public abstract JoinPointInfo copy();
}

