/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.command;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.UnresolvedSymbolDescription;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.analysis.QueryAnnotation;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.StoredProcedureInfo;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.parser.QueryParser;
import com.metamatrix.query.resolver.CommandResolver;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.util.BindVariableVisitor;
import com.metamatrix.query.resolver.util.ResolveExpressionsAndCriteriaVisitor;
import com.metamatrix.query.resolver.util.ResolveGroupsVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.resolver.util.ResolverVisitor;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.GroupContext;
import com.metamatrix.query.sql.lang.Into;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.navigator.AggregateStopNavigator;
import com.metamatrix.query.sql.navigator.PostOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.AllInGroupSymbol;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleQueryResolver
implements CommandResolver {
    private static final String ALL_IN_GROUP_SUFFIX = ".*";

    private static Command resolveVirtualGroup(GroupSymbol virtualGroup, Command parentCommand, QueryMetadataInterface metadata, QueryParser parser, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        QueryNode qnode = null;
        Object metadataID = virtualGroup.getMetadataID();
        boolean isSelectInto = ((Query)parentCommand).getInto() != null;
        boolean isMaterializedViewLoad = false;
        boolean noCache = false;
        boolean isMaterializedGroup = metadata.hasMaterialization(metadataID);
        if (isMaterializedGroup) {
            Option option;
            if (isSelectInto) {
                Object intoGrpID = ((Query)parentCommand).getInto().getGroup().getMetadataID();
                Object matID = metadata.getMaterialization(metadataID);
                Object matSTID = metadata.getMaterializationStage(metadataID);
                if (matID != null) {
                    isMaterializedViewLoad = matID.equals(intoGrpID);
                }
                if (matSTID != null && !isMaterializedViewLoad) {
                    isMaterializedViewLoad = matSTID.equals(intoGrpID);
                }
            }
            if (noCache = SimpleQueryResolver.isNoCacheGroup(metadata, metadataID, option = parentCommand.getOption())) {
                qnode = metadata.getVirtualPlan(metadataID);
                String matTableName = metadata.getFullName(metadata.getMaterialization(metadataID));
                SimpleQueryResolver.recordMaterializedTableNotUsedAnnotation(virtualGroup, analysis, matTableName);
            } else if (!isMaterializedViewLoad) {
                String groupName = metadata.getFullName(metadataID);
                String matTableName = metadata.getFullName(metadata.getMaterialization(metadataID));
                qnode = new QueryNode(groupName, "SELECT * FROM " + matTableName);
                SimpleQueryResolver.recordMaterializationTableAnnotation(virtualGroup, analysis, matTableName);
            } else {
                qnode = metadata.getVirtualPlan(metadataID);
                SimpleQueryResolver.recordLoadingMaterializationTableAnnotation(virtualGroup, analysis);
            }
        } else {
            if (metadata.isXMLGroup(virtualGroup.getMetadataID())) {
                throw new QueryResolverException("ERR.015.008.0003", QueryPlugin.Util.getString("ERR.015.008.0003"));
            }
            qnode = metadata.getVirtualPlan(metadataID);
        }
        Command subCommand = SimpleQueryResolver.convertToSubquery(parser, qnode, noCache, metadata);
        subCommand.setVirtualGroup(virtualGroup);
        return subCommand;
    }

    public static boolean isNoCacheGroup(QueryMetadataInterface metadata, Object metadataID, Option option) throws QueryMetadataException, MetaMatrixComponentException {
        if (option == null) {
            return false;
        }
        if (option.isNoCache() && (option.getNoCacheGroups() == null || option.getNoCacheGroups().isEmpty())) {
            return true;
        }
        if (option.getNoCacheGroups() != null) {
            for (int i = 0; i < option.getNoCacheGroups().size(); ++i) {
                String groupName = (String)option.getNoCacheGroups().get(i);
                try {
                    Object noCacheGroupID = metadata.getGroupID(groupName);
                    if (metadataID.equals(noCacheGroupID)) {
                        return true;
                    }
                    continue;
                }
                catch (QueryMetadataException e) {
                    LogManager.logError((String)"QUERY_RESOLVER", (Throwable)e, (String)QueryPlugin.Util.getString("SimpleQueryResolver.unknown_group_in_nocache", (Object)groupName));
                }
            }
        }
        return false;
    }

    private static void recordMaterializedTableNotUsedAnnotation(GroupSymbol virtualGroup, AnalysisRecord analysis, String matTableName) {
        if (analysis.recordAnnotations()) {
            Object[] params = new Object[]{virtualGroup, matTableName};
            QueryAnnotation annotation = new QueryAnnotation("Materialized View", QueryPlugin.Util.getString("SimpleQueryResolver.materialized_table_not_used", params), null, 1);
            analysis.addAnnotation(annotation);
        }
    }

    private static void recordMaterializationTableAnnotation(GroupSymbol virtualGroup, AnalysisRecord analysis, String matTableName) {
        if (analysis.recordAnnotations()) {
            Object[] params = new Object[]{virtualGroup, matTableName};
            QueryAnnotation annotation = new QueryAnnotation("Materialized View", QueryPlugin.Util.getString("SimpleQueryResolver.Query_was_redirected_to_Mat_table", params), null, 1);
            analysis.addAnnotation(annotation);
        }
    }

    private static void recordLoadingMaterializationTableAnnotation(GroupSymbol virtualGroup, AnalysisRecord analysis) {
        if (analysis.recordAnnotations()) {
            Object[] params = new Object[]{virtualGroup};
            QueryAnnotation annotation = new QueryAnnotation("Materialized View", QueryPlugin.Util.getString("SimpleQueryResolver.Loading_materialized_table", params), null, 1);
            analysis.addAnnotation(annotation);
        }
    }

    private static Command convertToSubquery(QueryParser parser, QueryNode qnode, boolean nocache, QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException {
        Command command = qnode.getCommand();
        if (command == null) {
            try {
                command = parser.parseCommand(qnode.getQuery());
            }
            catch (QueryParserException e) {
                throw new QueryResolverException((Throwable)e, "ERR.015.008.0011", QueryPlugin.Util.getString("ERR.015.008.0011", (Object)qnode.getGroupName()));
            }
            List bindings = qnode.getBindings();
            if (bindings != null) {
                BindVariableVisitor.bindReferences((LanguageObject)command, (List)bindings, (QueryMetadataInterface)metadata);
            }
        }
        if (nocache) {
            Option option = command.getOption();
            if (option == null) {
                option = new Option();
                command.setOption(option);
            }
            option.setNoCache(true);
            if (option.getNoCacheGroups() != null) {
                option.getNoCacheGroups().clear();
            }
        }
        return command;
    }

    public void resolveCommand(Command command, boolean useMetadataCommands, TempMetadataAdapter metadata, AnalysisRecord analysis, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
        Query query = (Query)command;
        try {
            QueryResolverVisitor qrv = new QueryResolverVisitor(query, metadata, useMetadataCommands, analysis);
            qrv.visit(query);
        }
        catch (MetaMatrixRuntimeException e) {
            if (e.getChild() instanceof QueryMetadataException) {
                throw (QueryMetadataException)e.getChild();
            }
            if (e.getChild() instanceof QueryResolverException) {
                throw (QueryResolverException)e.getChild();
            }
            if (e.getChild() instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)e.getChild();
            }
            throw e;
        }
        if (query.getLimit() != null) {
            ResolverUtil.resolveLimit((Limit)query.getLimit());
        }
        List symbols = query.getSelect().getProjectedSymbols();
        if (query.getInto() != null) {
            GroupSymbol symbol = query.getInto().getGroup();
            ResolverUtil.resolveImplicitTempGroup((TempMetadataAdapter)metadata, (GroupSymbol)symbol, (List)symbols);
            ResolverUtil.resolveElementsInGroup((GroupSymbol)symbol, (QueryMetadataInterface)metadata);
        } else if (resolveNullLiterals) {
            ResolverUtil.resolveNullLiterals((List)symbols);
        }
    }

    private static GroupSymbol resolveAllInGroup(AllInGroupSymbol allInGroupSymbol, Set groups, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, MetaMatrixComponentException {
        int index;
        String name = allInGroupSymbol.getName();
        String groupAlias = name.substring(0, index = name.lastIndexOf(ALL_IN_GROUP_SUFFIX));
        List groupSymbols = ResolverUtil.findMatchingGroups((String)groupAlias.toUpperCase(), (Collection)groups, (QueryMetadataInterface)metadata);
        if (groupSymbols.isEmpty() || groupSymbols.size() > 1) {
            String msg = QueryPlugin.Util.getString(groupSymbols.isEmpty() ? "ERR.015.008.0047" : "SimpleQueryResolver.ambiguous_all_in_group", (Object)allInGroupSymbol);
            QueryResolverException qre = new QueryResolverException(msg);
            qre.addUnresolvedSymbol(new UnresolvedSymbolDescription((Symbol)allInGroupSymbol, msg));
            throw qre;
        }
        return (GroupSymbol)groupSymbols.get(0);
    }

    private static void correctGroupByExpressions(Query query) {
        GroupBy groupBy = query.getGroupBy();
        if (groupBy == null) {
            return;
        }
        HashMap<Expression, Object> exprMap = null;
        List groupSymbols = groupBy.getSymbols();
        Iterator iter = groupSymbols.iterator();
        while (iter.hasNext()) {
            Object symbol = iter.next();
            if (!(symbol instanceof ExpressionSymbol)) continue;
            if (exprMap == null) {
                exprMap = new HashMap<Expression, Object>();
            }
            ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
            exprMap.put(exprSymbol.getExpression(), exprSymbol.clone());
        }
        if (exprMap == null) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(exprMap);
        AggregateStopNavigator nav = new AggregateStopNavigator((LanguageVisitor)visitor);
        if (query.getHaving() != null) {
            query.getHaving().acceptVisitor((LanguageVisitor)nav);
        }
        Iterator symbolIter = query.getSelect().getSymbols().iterator();
        while (symbolIter.hasNext()) {
            SelectSymbol symbol = (SelectSymbol)symbolIter.next();
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if (symbol instanceof AggregateSymbol) {
                symbol.acceptVisitor((LanguageVisitor)nav);
                continue;
            }
            if (!(symbol instanceof ExpressionSymbol)) continue;
            ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
            ExpressionSymbol matchSymbol = (ExpressionSymbol)exprMap.get(exprSymbol.getExpression());
            if (matchSymbol != null) {
                exprSymbol.setName(matchSymbol.getName());
                continue;
            }
            exprSymbol.getExpression().acceptVisitor((LanguageVisitor)nav);
        }
    }

    public static class QueryResolverVisitor
    extends PostOrderNavigator {
        LinkedHashSet currentGroupNames = new LinkedHashSet();
        private TempMetadataAdapter metadata;
        private boolean expandCommand;
        private Query query;
        private AnalysisRecord analysis;
        private QueryParser parser;

        public QueryResolverVisitor(Query query, TempMetadataAdapter metadata, boolean expandCommand, AnalysisRecord record) {
            super((LanguageVisitor)new ResolveExpressionsAndCriteriaVisitor((QueryMetadataInterface)metadata));
            this.query = query;
            this.metadata = metadata;
            this.expandCommand = expandCommand;
            this.analysis = record;
        }

        protected void postVisitVisitor(LanguageObject obj) {
            super.postVisitVisitor(obj);
            ResolveExpressionsAndCriteriaVisitor visitor = (ResolveExpressionsAndCriteriaVisitor)this.getVisitor();
            if (visitor.getComponentException() != null) {
                throw new MetaMatrixRuntimeException((Throwable)visitor.getComponentException());
            }
            if (visitor.getResolverException() != null) {
                throw new MetaMatrixRuntimeException((Throwable)visitor.getResolverException());
            }
        }

        public void visit(Query obj) {
            this.visitNode((LanguageObject)obj.getInto());
            this.visitNode((LanguageObject)obj.getFrom());
            this.visitNode((LanguageObject)obj.getCriteria());
            this.visitNode((LanguageObject)obj.getGroupBy());
            this.visitNode((LanguageObject)obj.getHaving());
            this.visitNode((LanguageObject)obj.getSelect());
            this.visitNode((LanguageObject)obj.getOrderBy());
        }

        public void visit(JoinPredicate obj) {
            this.visitNode((LanguageObject)obj.getLeftClause());
            LinkedHashSet allGroups = new LinkedHashSet();
            allGroups.addAll(this.currentGroupNames);
            this.currentGroupNames.clear();
            this.visitNode((LanguageObject)obj.getRightClause());
            this.mergecheckForDuplicateGroup(allGroups, this.currentGroupNames);
            this.currentGroupNames = allGroups;
            this.visitNodes(obj.getJoinCriteria());
        }

        public void visit(From obj) {
            LinkedHashSet allGroups = new LinkedHashSet();
            Assertion.assertTrue((boolean)this.currentGroupNames.isEmpty());
            Iterator iter = obj.getClauses().iterator();
            while (iter.hasNext()) {
                FromClause clause = (FromClause)iter.next();
                this.visitNode((LanguageObject)clause);
                this.mergecheckForDuplicateGroup(allGroups, this.currentGroupNames);
                this.currentGroupNames.clear();
            }
            allGroups.addAll(this.currentGroupNames);
            this.currentGroupNames = allGroups;
        }

        public void visit(Select obj) {
            super.visit(obj);
            SimpleQueryResolver.correctGroupByExpressions(this.query);
        }

        public void visit(ElementSymbol obj) {
            try {
                ResolverVisitor.resolveLanguageObject((LanguageObject)obj, (Collection)this.currentGroupNames, (GroupContext)this.query.getExternalGroupContexts(), (QueryMetadataInterface)this.metadata);
            }
            catch (QueryResolverException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
            catch (MetaMatrixComponentException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
        }

        public void visit(GroupSymbol obj) {
            try {
                ResolveGroupsVisitor.resolveGroups((LanguageObject)obj, (QueryMetadataInterface)this.metadata);
            }
            catch (QueryResolverException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
            catch (MetaMatrixComponentException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
        }

        private void resolveSubQuery(SubqueryContainer obj) {
            Command command = obj.getCommand();
            QueryResolver.setChildMetadata((Command)command, (Command)this.query);
            command.pushNewResolvingContext((Collection)this.currentGroupNames);
            try {
                QueryResolver.resolveCommand((Command)command, (Map)Collections.EMPTY_MAP, (boolean)this.expandCommand, (QueryMetadataInterface)this.metadata.getMetadata(), (AnalysisRecord)this.analysis, (boolean)false);
            }
            catch (QueryResolverException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
            catch (MetaMatrixComponentException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
        }

        public void visit(AllSymbol obj) {
            try {
                ArrayList elementSymbols = new ArrayList();
                Iterator groupIter = this.currentGroupNames.iterator();
                while (groupIter.hasNext()) {
                    GroupSymbol group = (GroupSymbol)groupIter.next();
                    List elements = this.resolveSelectableElements(group);
                    elementSymbols.addAll(elements);
                }
                obj.setElementSymbols(elementSymbols);
            }
            catch (QueryResolverException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
            catch (MetaMatrixComponentException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
            catch (QueryMetadataException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }

        private List resolveSelectableElements(GroupSymbol group) throws QueryMetadataException, QueryResolverException, MetaMatrixComponentException {
            List elements = ResolverUtil.resolveElementsInGroup((GroupSymbol)group, (QueryMetadataInterface)this.metadata);
            ArrayList<Object> result = new ArrayList<Object>(elements.size());
            Iterator elementIter = elements.iterator();
            while (elementIter.hasNext()) {
                ElementSymbol element = (ElementSymbol)elementIter.next();
                if (!this.metadata.elementSupports(element.getMetadataID(), 0)) continue;
                result.add(element.clone());
            }
            return result;
        }

        public void visit(AllInGroupSymbol obj) {
            try {
                GroupSymbol group = SimpleQueryResolver.resolveAllInGroup(obj, this.currentGroupNames, this.metadata);
                List elements = this.resolveSelectableElements(group);
                obj.setElementSymbols(elements);
            }
            catch (QueryResolverException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
            catch (MetaMatrixComponentException err) {
                throw new MetaMatrixRuntimeException((Throwable)err);
            }
            catch (QueryMetadataException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }

        public void visit(ScalarSubquery obj) {
            this.resolveSubQuery((SubqueryContainer)obj);
            List projSymbols = obj.getCommand().getProjectedSymbols();
            if (projSymbols.size() != 1) {
                QueryResolverException qre = new QueryResolverException(QueryPlugin.Util.getString("ERR.015.008.0032", (Object)obj));
                throw new MetaMatrixRuntimeException((Throwable)qre);
            }
        }

        public void visit(ExistsCriteria obj) {
            this.resolveSubQuery((SubqueryContainer)obj);
        }

        public void visit(SubqueryCompareCriteria obj) {
            this.visitNode((LanguageObject)obj.getLeftExpression());
            this.resolveSubQuery((SubqueryContainer)obj);
            this.postVisitVisitor((LanguageObject)obj);
        }

        public void visit(SubquerySetCriteria obj) {
            this.visitNode((LanguageObject)obj.getExpression());
            this.resolveSubQuery((SubqueryContainer)obj);
            this.postVisitVisitor((LanguageObject)obj);
        }

        public void visit(SubqueryFromClause obj) {
            this.resolveSubQuery((SubqueryContainer)obj);
            this.checkForDuplicateGroup(obj.getGroupSymbol());
            this.metadata.getMetadataStore().addTempGroup(obj.getGroupSymbol().getName(), obj.getCommand().getProjectedSymbols());
            obj.getGroupSymbol().setMetadataID((Object)this.metadata.getMetadataStore().getTempGroupID(obj.getGroupSymbol().getName()));
        }

        public void visit(UnaryFromClause obj) {
            GroupSymbol group = obj.getGroup();
            this.visitNode((LanguageObject)group);
            this.checkForDuplicateGroup(group);
            try {
                if (!(!this.expandCommand || group.isTempGroupSymbol() || group.isProcedure() || group.getMetadataID() instanceof TempMetadataID && this.metadata.getVirtualPlan(group.getMetadataID()) == null || !this.metadata.isVirtualGroup(group.getMetadataID()))) {
                    if (this.parser == null) {
                        this.parser = new QueryParser();
                    }
                    Command command = SimpleQueryResolver.resolveVirtualGroup(group, (Command)this.query, this.metadata.getMetadata(), this.parser, this.analysis);
                    QueryResolver.resolveCommand((Command)command, (Map)Collections.EMPTY_MAP, (boolean)this.expandCommand, (QueryMetadataInterface)this.metadata.getMetadata(), (AnalysisRecord)this.analysis);
                    obj.setExpandedCommand(command);
                } else if (group.isProcedure()) {
                    String fullName = this.metadata.getFullName(group.getMetadataID());
                    String queryName = group.getName();
                    StoredProcedureInfo storedProcedureInfo = this.metadata.getStoredProcedureInfoForProcedure(fullName);
                    StoredProcedure storedProcedureCommand = new StoredProcedure();
                    storedProcedureCommand.setProcedureName(fullName);
                    List metadataParams = storedProcedureInfo.getParameters();
                    Query query = new Query();
                    From from = new From();
                    from.addClause((FromClause)new SubqueryFromClause("X", (Command)storedProcedureCommand));
                    query.setFrom(from);
                    Select select = new Select();
                    select.addSymbol((SelectSymbol)new AllInGroupSymbol("X.*"));
                    query.setSelect(select);
                    LinkedList<String> accessPatternElementNames = new LinkedList<String>();
                    int paramIndex = 1;
                    Iterator paramIter = metadataParams.iterator();
                    while (paramIter.hasNext()) {
                        SPParameter metadataParameter = (SPParameter)paramIter.next();
                        SPParameter clonedParam = (SPParameter)metadataParameter.clone();
                        if (clonedParam.getParameterType() != 1 && metadataParameter.getParameterType() != 3) continue;
                        ElementSymbol paramSymbol = clonedParam.getParameterSymbol();
                        Reference ref = new Reference(0, (Expression)paramSymbol);
                        clonedParam.setExpression((Expression)ref);
                        clonedParam.setIndex(paramIndex++);
                        storedProcedureCommand.setParameter(clonedParam);
                        String aliasName = paramSymbol.getShortName();
                        if (metadataParameter.getParameterType() == 3) {
                            aliasName = aliasName + "_IN";
                        }
                        AliasSymbol newSymbol = new AliasSymbol(aliasName, (SingleElementSymbol)new ExpressionSymbol(paramSymbol.getShortName(), (Expression)ref));
                        select.addSymbol((SelectSymbol)newSymbol);
                        accessPatternElementNames.add(queryName + "." + aliasName);
                    }
                    QueryResolver.resolveCommand((Command)query, (Map)Collections.EMPTY_MAP, (boolean)this.expandCommand, (QueryMetadataInterface)this.metadata.getMetadata(), (AnalysisRecord)this.analysis);
                    List projectedSymbols = query.getProjectedSymbols();
                    HashSet<String> foundNames = new HashSet<String>();
                    Iterator i = projectedSymbols.iterator();
                    while (i.hasNext()) {
                        SingleElementSymbol ses = (SingleElementSymbol)i.next();
                        if (foundNames.add(ses.getShortCanonicalName())) continue;
                        throw new QueryResolverException(QueryPlugin.Util.getString("SimpleQueryResolver.Proc_Relational_Name_conflict", (Object)fullName));
                    }
                    TempMetadataID id = this.metadata.getMetadataStore().getTempGroupID(queryName);
                    if (id == null) {
                        this.metadata.getMetadataStore().addTempGroup(queryName, projectedSymbols, true);
                        id = this.metadata.getMetadataStore().getTempGroupID(queryName);
                        id.setOriginalMetadataID(storedProcedureCommand.getProcedureID());
                        LinkedList<TempMetadataID> accessPatternIds = new LinkedList<TempMetadataID>();
                        Iterator i2 = accessPatternElementNames.iterator();
                        while (i2.hasNext()) {
                            String name = (String)i2.next();
                            accessPatternIds.add(this.metadata.getMetadataStore().getTempElementID(name));
                        }
                        id.setAccessPatterns(Arrays.asList(new TempMetadataID("procedure access pattern", accessPatternIds)));
                    }
                    group.setMetadataID((Object)id);
                    query.setVirtualGroup(group);
                    if (this.expandCommand) {
                        obj.setExpandedCommand((Command)query);
                    }
                }
            }
            catch (QueryMetadataException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
            catch (QueryResolverException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
            catch (MetaMatrixComponentException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }

        public void visit(OrderBy obj) {
            try {
                ResolverUtil.resolveOrderBy((OrderBy)obj, new ArrayList(this.currentGroupNames), (List)this.query.getSelect().getProjectedSymbols(), (QueryMetadataInterface)this.metadata);
            }
            catch (QueryMetadataException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
            catch (QueryResolverException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
            catch (MetaMatrixComponentException e) {
                throw new MetaMatrixRuntimeException((Throwable)e);
            }
        }

        public void visit(Into obj) {
            if (!obj.getGroup().isImplicitTempGroupSymbol()) {
                super.visit(obj);
            }
        }

        private void mergecheckForDuplicateGroup(Set existingGroups, Set groupsToAdd) {
            Iterator it = groupsToAdd.iterator();
            while (it.hasNext()) {
                GroupSymbol gsGroup = (GroupSymbol)it.next();
                if (!existingGroups.contains(gsGroup)) continue;
                String msg = QueryPlugin.Util.getString("ERR.015.008.0046", (Object)gsGroup.getName());
                QueryResolverException qre = new QueryResolverException("ERR.015.008.0046", msg);
                qre.addUnresolvedSymbol(new UnresolvedSymbolDescription((Symbol)gsGroup, msg));
                throw new MetaMatrixRuntimeException((Throwable)qre);
            }
            existingGroups.addAll(groupsToAdd);
        }

        private void checkForDuplicateGroup(GroupSymbol group) {
            if (!this.currentGroupNames.add(group)) {
                String msg = QueryPlugin.Util.getString("ERR.015.008.0046", (Object)group.getName());
                QueryResolverException qre = new QueryResolverException("ERR.015.008.0046", msg);
                qre.addUnresolvedSymbol(new UnresolvedSymbolDescription((Symbol)group, msg));
                throw new MetaMatrixRuntimeException((Throwable)qre);
            }
        }
    }
}

