/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.relational.BaseJoinStrategy;
import com.metamatrix.query.processor.relational.SourceState;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.TypeRetrievalUtil;
import java.util.ArrayList;
import java.util.List;

public class NestedLoopJoinStrategy
extends BaseJoinStrategy {
    private static final short STATE_LOAD_DATA = 2;
    private static final short STATE_MATCH_INNER_LEFTOUTER = 3;
    private static final short STATE_MATCH_FULLOUTER = 4;
    private boolean isLeftMatched = false;
    private boolean setUpTupleSources = false;
    private List[] leftData = null;

    public void initialize(ProcessorDataManager dataManager, CommandContext context, BufferManager bufferManager, JoinType joinType, boolean isDependentJoin) throws MetaMatrixComponentException {
        super.initialize(dataManager, context, bufferManager, joinType, isDependentJoin);
        List leftElements = this.leftSource.elements;
        List rightElements = this.rightSource.elements;
        this.leftSource.tupleSourceID = this.bufferManager.createTupleSource(leftElements, TypeRetrievalUtil.getTypeNames((List)leftElements), this.context.getConnectionID(), 1);
        this.rightSource.tupleSourceID = this.bufferManager.createTupleSource(rightElements, TypeRetrievalUtil.getTypeNames((List)rightElements), this.context.getConnectionID(), 1);
        ArrayList combinedElements = new ArrayList(leftElements);
        combinedElements.addAll(rightElements);
        this.combinedElementMap = this.createLookupMap(combinedElements);
        this.state = (short)2;
    }

    public List execute() throws MetaMatrixComponentException, MetaMatrixProcessingException {
        if (this.state == 2) {
            this.loadDataIntoBuffer(this.leftSource);
            this.loadDataIntoBuffer(this.rightSource);
            if (this.leftSource.readState == 3 && this.rightSource.readState == 3) {
                this.state = (short)3;
                this.setUpTupleSources = true;
            }
        }
        if (this.state != 2) {
            if (this.setUpTupleSources) {
                this.setTupleSourceForRead(this.leftSource);
                this.setTupleSourceForRead(this.rightSource);
                this.setUpTupleSources = false;
            }
            if (this.leftData == null) {
                this.leftData = this.readTupleAndProbe(this.leftSource);
                if (this.leftSource.readState == 3) {
                    if (this.joinType.equals((Object)JoinType.JOIN_FULL_OUTER) && this.state != 4) {
                        SourceState temp = this.rightSource;
                        this.rightSource = this.leftSource;
                        this.leftSource = temp;
                        temp = null;
                        ArrayList combinedElements = new ArrayList(this.leftSource.elements);
                        combinedElements.addAll(this.rightSource.elements);
                        this.combinedElementMap = this.createLookupMap(combinedElements);
                        this.leftData = null;
                        this.setUpTupleSources = true;
                        this.state = (short)4;
                        return null;
                    }
                    this.state = 0;
                    return null;
                }
            }
            List[] rightData = this.readTupleAndProbe(this.rightSource);
            if (this.rightSource.readState == 3) {
                this.setTupleSourceForRead(this.rightSource);
                List outputTuple = null;
                if (this.joinType.isOuter() && !this.isLeftMatched) {
                    outputTuple = this.state == 4 ? this.outputTuple(this.leftOuterVals, this.leftData[0]) : this.outputTuple(this.leftData[0], this.rightOuterVals);
                }
                this.isLeftMatched = false;
                this.leftData = null;
                return outputTuple;
            }
            if (this.joinType.equals((Object)JoinType.JOIN_CROSS)) {
                return this.outputTuple(this.leftData[0], rightData[0]);
            }
            return this.outputMatch(this.leftData, rightData);
        }
        return null;
    }

    private List outputMatch(List[] leftData, List[] rightData) throws MetaMatrixComponentException {
        List leftTuple = leftData[0];
        List rightTuple = rightData[0];
        List outputTuple = this.outputTuple(leftTuple, rightTuple);
        boolean match = false;
        try {
            if (this.joinCriteria == null || CriteriaEvaluator.evaluate(this.joinCriteria, this.combinedElementMap, outputTuple, (LookupEvaluator)this.dataManager, this.context)) {
                match = true;
                this.isLeftMatched = true;
            }
        }
        catch (CriteriaEvaluationException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        if (match && this.state != 4) {
            return this.outputTuple(leftTuple, rightTuple);
        }
        return null;
    }

    public Object clone() {
        return new NestedLoopJoinStrategy();
    }

    public void reset() {
        super.reset();
        this.isLeftMatched = false;
        this.setUpTupleSources = false;
        this.leftData = null;
        this.state = (short)2;
    }

    public String toString() {
        return "NESTED LOOP JOIN";
    }
}

