/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.dqp.service;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageListener;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.CapabilitiesMessage;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.connector.comm.ConnectorInstance;
import com.metamatrix.server.connector.comm.ConnectorServerConnectionFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PlatformDataService
implements DataService {
    private Object clientId;
    private Map instanceMap;
    private Map connectorBindingMap;
    private ServerConnection serverConnection;

    public PlatformDataService(Object clientId) {
        this.clientId = clientId;
    }

    public ConnectorID selectConnector(String connectorBindingID) {
        try {
            ConnectorInstance serverInstance = (ConnectorInstance)this.serverConnection.selectServerInstance(connectorBindingID);
            this.instanceMap.put(serverInstance.getConnectorID(), serverInstance);
            this.connectorBindingMap.put(serverInstance.getConnectorID(), connectorBindingID);
            return serverInstance.getConnectorID();
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{connectorBindingID};
            String msg = ServerPlugin.Util.getString("DQPDataService.Unable_to_select_a_connector_for_connector_binding_ID__{0}", params);
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            return null;
        }
    }

    public void executeRequest(AtomicRequestMessage request, ConnectorID connector, MessageListener resultListener) throws MetaMatrixComponentException {
        ServerInstance serverInstance = null;
        serverInstance = this.findServerInstance(connector);
        if (serverInstance == null) {
            Object[] params = new Object[]{connector};
            String msg = ServerPlugin.Util.getString("DQPDataService.Unable_to_find_a_connector_for_connector_ID__{0}", params);
            ServerPlugin.Util.log(4, msg);
            throw new MetaMatrixComponentException(msg);
        }
        String key = request.getMessageKey();
        try {
            this.serverConnection.send((Message)request, resultListener, key, serverInstance);
        }
        catch (CommunicationException e) {
            String msg = ServerPlugin.Util.getString("DQPDataService.Unable_to_send_request__{0}", (Object)e.getMessage());
            ServerPlugin.Util.log(4, msg);
            throw new MetaMatrixComponentException(msg);
        }
    }

    public SourceCapabilities getCapabilities(RequestMessage request, ConnectorID connector) throws MetaMatrixComponentException {
        ServerInstance serverInstance = null;
        serverInstance = this.findServerInstance(connector);
        if (serverInstance == null) {
            Object[] params = new Object[]{connector};
            String msg = ServerPlugin.Util.getString("DQPDataService.Unable_to_find_a_connector_for_connector_ID__{0}", params);
            ServerPlugin.Util.log(4, msg);
            throw new MetaMatrixComponentException(msg);
        }
        try {
            CapabilitiesMessage capMsg = new CapabilitiesMessage();
            ClientConnection clientConn = request.getClientConnection();
            capMsg.assignToClientConnection(clientConn);
            capMsg.setUserParameters(clientConn);
            capMsg.setExecutionPayload(request.getExecutionPayload());
            CapabilitiesMessage resultMsg = (CapabilitiesMessage)this.serverConnection.send((Message)capMsg, serverInstance);
            return resultMsg.getCaps();
        }
        catch (ApplicationException e) {
            Object[] params = new Object[]{connector};
            String msg = ServerPlugin.Util.getString("DQPDataService.Unable_to_find_a_connector_for_connector_ID__{0}", params);
            ServerPlugin.Util.log(4, msg);
            throw new MetaMatrixComponentException(msg);
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{connector};
            String msg = ServerPlugin.Util.getString("DQPDataService.Unable_to_find_a_connector_for_connector_ID__{0}", params);
            ServerPlugin.Util.log(4, msg);
            throw new MetaMatrixComponentException(msg);
        }
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        ConnectorServerConnectionFactory connFact = new ConnectorServerConnectionFactory(this.clientId);
        try {
            this.serverConnection = connFact.establishConnection(null, props);
        }
        catch (CommunicationException e) {
            String msg = ServerPlugin.Util.getString("DQPDataService.Unable_to_create_ConnectorServerConnection");
            ApplicationInitializationException appE = new ApplicationInitializationException((Throwable)e, msg);
            ServerPlugin.Util.log((Throwable)appE);
            throw appE;
        }
        this.instanceMap = Collections.synchronizedMap(new HashMap());
        this.connectorBindingMap = Collections.synchronizedMap(new HashMap());
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void bind() throws ApplicationLifecycleException {
    }

    public void unbind() throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
    }

    private ServerInstance findServerInstance(ConnectorID connectorID) {
        return (ServerInstance)this.instanceMap.get(connectorID);
    }

    public Map getConnectorStatus() {
        throw new UnsupportedOperationException();
    }

    public ConnectionStatus getConnectorStatus(String connectorName) {
        throw new UnsupportedOperationException();
    }

    public String[] getConnectorNames() {
        throw new UnsupportedOperationException();
    }

    public void restartConnector(String connectorName) throws ApplicationLifecycleException {
        throw new UnsupportedOperationException();
    }

    public void startConnectorBinding(String connectorBindingName) throws ApplicationLifecycleException, ComponentNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void stopConnectorBinding(String connectorBindingName) throws ApplicationLifecycleException, ComponentNotFoundException {
        throw new UnsupportedOperationException();
    }

    public List getConnectorBindings() throws ComponentNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void addConnectorType(String name, ConnectorBindingType type) throws ApplicationLifecycleException, MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public void deleteConnectorType(String name) throws ApplicationLifecycleException, MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public List getConnectorTypes() throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public AliveStatus getConnectorBindingState(String connectorBindingName) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public String getConnectorBindingName(ConnectorID connector) {
        String bindingName = (String)this.connectorBindingMap.get(connector);
        if (bindingName == null) {
            bindingName = "UNKNOWN";
        }
        return bindingName;
    }

    public ConnectorBinding getConnectorBinding(String connectorBindingName) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public Collection getConnectorBindingStatistics(String connectorBindingName) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }

    public void clearConnectorBindingCache(String connectorBindingName) throws MetaMatrixComponentException {
        throw new UnsupportedOperationException();
    }
}

