/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.resolver.util;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.internal.core.xml.XPathHelper;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionForm;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.resolver.util.ResolveCaseExpressionVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AbstractCaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import java.util.Collection;
import net.sf.saxon.trans.XPathException;

public class ResolveFunctionsVisitor
extends LanguageVisitor {
    private QueryMetadataInterface metadata;
    private MetaMatrixComponentException componentException;
    private QueryResolverException functionException;

    public ResolveFunctionsVisitor(QueryMetadataInterface metadata) {
        this.metadata = metadata;
    }

    public void visit(Function obj) {
        try {
            this.resolveFunction(obj);
        }
        catch (QueryResolverException e) {
            this.handleException(e);
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    public MetaMatrixComponentException getComponentException() {
        return this.componentException;
    }

    public QueryResolverException getResolverException() {
        return this.functionException;
    }

    private void handleException(MetaMatrixComponentException e) {
        this.componentException = e;
        this.setAbort(true);
    }

    private void handleException(QueryResolverException e) {
        this.functionException = e;
        this.setAbort(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveFunction(Function function) throws QueryResolverException, MetaMatrixComponentException {
        FunctionDescriptor fd;
        FunctionLibrary library;
        Expression[] args;
        boolean hasArgWithoutType;
        block26: {
            if (function.getFunctionDescriptor() != null) {
                return;
            }
            hasArgWithoutType = false;
            boolean hasArgWithoutTypeHint = false;
            args = function.getArgs();
            Class[] types = new Class[args.length];
            Class[] typeHints = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.resolveExpressionContainers(args[i]);
                types[i] = args[i].getType();
                typeHints[i] = types[i];
                if (types[i] != null) continue;
                if (!(args[i] instanceof Reference)) throw new QueryResolverException("ERR.015.008.0035", QueryPlugin.Util.getString("ERR.015.008.0035", new Object[]{args[i], function}));
                hasArgWithoutType = true;
                typeHints[i] = ((Reference)args[i]).getTypeHint();
                if (typeHints[i] != null) continue;
                hasArgWithoutTypeHint = true;
            }
            library = FunctionLibraryManager.getFunctionLibrary();
            fd = null;
            if (hasArgWithoutType) {
                fd = this.matchPartialFunction(library, function.getName(), types);
                if (fd == null) {
                    if (hasArgWithoutTypeHint) {
                        fd = this.matchPartialFunction(library, function.getName(), typeHints);
                        if (fd == null) {
                            throw new QueryResolverException("ERR.015.008.0036", QueryPlugin.Util.getString("ERR.015.008.0036", (Object)function));
                        }
                    } else {
                        fd = library.findFunction(function.getName(), typeHints);
                    }
                }
            } else {
                fd = library.findFunction(function.getName(), types);
            }
            if (fd == null) {
                fd = !hasArgWithoutType ? this.findWithImplicitConversions(library, function, args, types) : this.findWithImplicitConversions(library, function, args, typeHints);
            } else if (fd.getName().equalsIgnoreCase("convert") || fd.getName().equalsIgnoreCase("cast")) {
                if (!(args[1] instanceof Constant) || !((Constant)args[1]).getValue().getClass().equals(DataTypeManager.DefaultDataClasses.STRING)) throw new QueryResolverException("ERR.015.008.0038", QueryPlugin.Util.getString("ERR.015.008.0038", (Object)function));
                String dataType = (String)((Constant)args[1]).getValue();
                Class dataTypeClass = DataTypeManager.getDataTypeClass((String)dataType);
                fd = library.findTypedConversionFunction(args[0].getType(), dataTypeClass);
                Class srcTypeClass = args[0].getType();
                if (srcTypeClass != null && dataTypeClass != null && !srcTypeClass.equals(dataTypeClass) && DataTypeManager.getTransform((Class)srcTypeClass, (Class)dataTypeClass) == null) {
                    throw new QueryResolverException("ERR.015.008.0037", QueryPlugin.Util.getString("ERR.015.008.0037", new Object[]{DataTypeManager.getDataTypeName((Class)srcTypeClass), dataType}));
                }
            } else {
                Constant xpathConst;
                if (fd.getName().equalsIgnoreCase("lookup")) {
                    if (!(args[0] instanceof Constant) || !(args[1] instanceof Constant) || !(args[2] instanceof Constant)) throw new QueryResolverException("ERR.015.008.0063", QueryPlugin.Util.getString("ERR.015.008.0063"));
                    String returnElementName = (String)((Constant)args[0]).getValue() + "." + (String)((Constant)args[1]).getValue();
                    try {
                        Object metadataID = this.metadata.getElementID(returnElementName);
                        ElementSymbol symbol = new ElementSymbol(returnElementName);
                        symbol.setMetadataID(metadataID);
                        String dataType = this.metadata.getElementType(symbol.getMetadataID());
                        Class dataTypeClass = DataTypeManager.getDataTypeClass((String)dataType);
                        fd = library.copyFunctionChangeReturnType(fd, dataTypeClass);
                    }
                    catch (QueryMetadataException e) {
                        throw new QueryResolverException("ERR.015.008.0062", QueryPlugin.Util.getString("ERR.015.008.0062", (Object)returnElementName));
                    }
                    GroupSymbol groupSym = new GroupSymbol((String)((Constant)args[0]).getValue());
                    try {
                        groupSym.setMetadataID(this.metadata.getGroupID((String)((Constant)args[0]).getValue()));
                        if (this.metadata.isVirtualGroup(groupSym.getMetadataID())) {
                            throw new QueryResolverException("ERR.015.008.0065", QueryPlugin.Util.getString("ERR.015.008.0065", ((Constant)args[0]).getValue()));
                        }
                        break block26;
                    }
                    catch (QueryMetadataException e) {
                        throw new QueryResolverException("ERR.015.008.0062", QueryPlugin.Util.getString("ERR.015.008.0062", ((Constant)args[0]).getValue()));
                    }
                }
                if (fd.getName().equalsIgnoreCase("xpathvalue") && args[1] != null && args[1] instanceof Constant && (xpathConst = (Constant)args[1]).getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
                    String value = (String)xpathConst.getValue();
                    if (value == null) {
                        throw new QueryResolverException(QueryPlugin.Util.getString("QueryResolver.invalid_xpath", (Object)QueryPlugin.Util.getString("ResolveFunctionsVisitor.xpath_cant_be_null")));
                    }
                    try {
                        XPathHelper.validateXpath((String)value);
                    }
                    catch (XPathException e) {
                        throw new QueryResolverException(QueryPlugin.Util.getString("QueryResolver.invalid_xpath", (Object)e.getMessage()));
                    }
                }
            }
        }
        if (fd == null) {
            FunctionForm form = library.findFunctionForm(function.getName(), args.length);
            if (form != null) throw new QueryResolverException("ERR.015.008.0040", QueryPlugin.Util.getString("ERR.015.008.0040", (Object)function));
            throw new QueryResolverException("ERR.015.008.0039", QueryPlugin.Util.getString("ERR.015.008.0039", (Object)function));
        }
        if (hasArgWithoutType) {
            Class[] argTypes = fd.getTypes();
            for (int i = 0; i < args.length; ++i) {
                ResolverUtil.setTypeIfReference(args[i], argTypes[i]);
            }
        }
        function.setFunctionDescriptor(fd);
        function.setType(fd.getReturnType());
    }

    private FunctionDescriptor matchPartialFunction(FunctionLibrary library, String functionName, Class[] types) {
        Collection partialFds = library.findPartialFunction(functionName, types);
        FunctionDescriptor fd = null;
        if (partialFds.size() == 1) {
            fd = (FunctionDescriptor)partialFds.iterator().next();
        }
        return fd;
    }

    private FunctionDescriptor findWithImplicitConversions(FunctionLibrary library, Function function, Expression[] args, Class[] types) throws QueryResolverException {
        FunctionDescriptor[] conversions = library.determineNecessaryConversions(function.getName(), types);
        if (conversions != null) {
            Class[] newSignature = new Class[conversions.length];
            for (int i = 0; i < conversions.length; ++i) {
                if (conversions[i] != null) {
                    ResolverUtil.setTypeIfReference(args[i], types[i]);
                    function.insertConversion(i, conversions[i]);
                    newSignature[i] = conversions[i].getReturnType();
                    continue;
                }
                newSignature[i] = types[i];
            }
            return library.findFunction(function.getName(), newSignature);
        }
        return null;
    }

    private void resolveExpressionContainers(Expression expr) throws QueryResolverException, MetaMatrixComponentException {
        Expression innerExpr;
        if (expr instanceof Function) {
            this.resolveFunction((Function)expr);
        } else if (expr instanceof AbstractCaseExpression) {
            ResolveCaseExpressionVisitor.resolveCaseExpressions((LanguageObject)expr, (QueryMetadataInterface)this.metadata);
        } else if (expr instanceof ExpressionSymbol && (innerExpr = ((ExpressionSymbol)expr).getExpression()) != null) {
            this.resolveExpressionContainers(innerExpr);
        }
    }

    public static void resolveFunctions(LanguageObject obj, QueryMetadataInterface metadata) throws QueryResolverException, MetaMatrixComponentException {
        ResolveFunctionsVisitor visitor = new ResolveFunctionsVisitor(metadata);
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        if (visitor.getComponentException() != null) {
            throw visitor.getComponentException();
        }
        if (visitor.getResolverException() != null) {
            throw visitor.getResolverException();
        }
    }
}

