/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BlockedOnMemoryException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.query.processor.relational.ListNestedSortComparator;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.util.TypeRetrievalUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SortUtility {
    private TupleSourceID sourceID;
    private List sourceElements;
    private List sortElements;
    private List sortTypes;
    private boolean removeDuplicates;
    private BufferManager bufferManager;
    private String groupName;
    private int batchSize;
    private List schema;
    private String[] schemaTypes;
    private int sortPhaseRow = 1;
    private int phase = 1;
    private int rowCount;
    private int[] sortCols;
    private List activeTupleIDs = new ArrayList();
    private List workingBatches;
    private int[] workingPointers;
    private static final int SORT = 1;
    private static final int MERGE = 2;
    private static final int DONE = 3;

    public SortUtility(TupleSourceID sourceID, List sourceElements, List sortElements, List sortTypes, boolean removeDuplicates, BufferManager bufferMgr, String groupName) {
        this.sourceID = sourceID;
        this.sourceElements = sourceElements;
        this.sortElements = sortElements;
        this.sortTypes = sortTypes;
        this.removeDuplicates = removeDuplicates;
        this.bufferManager = bufferMgr;
        this.groupName = groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleSourceID sort() throws BlockedException, MetaMatrixComponentException {
        block10: {
            try {
                block11: {
                    if (this.schema == null) {
                        this.schema = this.bufferManager.getTupleSchema(this.sourceID);
                        this.schemaTypes = TypeRetrievalUtil.getTypeNames((List)this.schema);
                        this.batchSize = this.bufferManager.getProcessorBatchSize();
                        this.rowCount = this.bufferManager.getRowCount(this.sourceID);
                        this.sortCols = this.getSortCols();
                    }
                    if (this.rowCount == 0) {
                        TupleSourceID mergedID = this.bufferManager.createTupleSource(this.schema, this.schemaTypes, this.groupName, 1);
                        this.bufferManager.setStatus(mergedID, 2);
                        this.activeTupleIDs.add(mergedID);
                        this.phase = 3;
                    }
                    if (this.phase == 1) {
                        this.sortPhase();
                    }
                    if (this.phase != 2) break block10;
                    try {
                        this.mergePhase();
                        Object var3_3 = null;
                        if (this.workingBatches == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        if (this.workingBatches != null) {
                            for (int i = 0; i < this.workingBatches.size(); ++i) {
                                TupleBatch tupleBatch = (TupleBatch)this.workingBatches.get(i);
                                if (tupleBatch == null) continue;
                                this.unpinWorkingBatch(i, tupleBatch);
                            }
                        }
                        this.workingBatches = null;
                        throw throwable;
                    }
                    for (int i = 0; i < this.workingBatches.size(); ++i) {
                        TupleBatch tupleBatch = (TupleBatch)this.workingBatches.get(i);
                        if (tupleBatch == null) continue;
                        this.unpinWorkingBatch(i, tupleBatch);
                    }
                }
                this.workingBatches = null;
                {
                }
            }
            catch (TupleSourceNotFoundException e) {
                throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
            }
        }
        return (TupleSourceID)this.activeTupleIDs.get(0);
    }

    protected void sortPhase() throws BlockedException, TupleSourceNotFoundException, MetaMatrixComponentException {
        ArrayList<int[]> pinned = new ArrayList<int[]>();
        while (this.sortPhaseRow <= this.rowCount) {
            TupleBatch writeBatch;
            ArrayList<List> workingTuples = new ArrayList<List>();
            while (this.sortPhaseRow <= this.rowCount) {
                try {
                    TupleBatch batch = this.bufferManager.pinTupleBatch(this.sourceID, this.sortPhaseRow, this.sortPhaseRow + this.batchSize - 1);
                    if (batch.getRowCount() <= 0) continue;
                    pinned.add(new int[]{this.sortPhaseRow, batch.getEndRow()});
                    workingTuples.addAll(Arrays.asList(batch.getAllTuples()));
                    this.sortPhaseRow = batch.getEndRow() + 1;
                }
                catch (MemoryNotAvailableException e) {
                    // empty catch block
                    break;
                }
            }
            if (workingTuples.isEmpty()) {
                throw BlockedOnMemoryException.INSTANCE;
            }
            ListNestedSortComparator comp = new ListNestedSortComparator(this.sortCols, this.sortTypes);
            Collections.sort(workingTuples, comp);
            TupleSourceID sortedID = this.bufferManager.createTupleSource(this.schema, this.schemaTypes, this.groupName, 1);
            this.activeTupleIDs.add(sortedID);
            int sortedThisPass = workingTuples.size();
            for (int writeBegin = 1; writeBegin <= sortedThisPass; writeBegin += writeBatch.getRowCount()) {
                int writeEnd = Math.min(sortedThisPass, writeBegin + this.batchSize - 1);
                writeBatch = new TupleBatch(writeBegin, workingTuples.subList(writeBegin - 1, writeEnd));
                this.bufferManager.addTupleBatch(sortedID, writeBatch);
            }
            Iterator iter = pinned.iterator();
            while (iter.hasNext()) {
                int[] bounds = (int[])iter.next();
                this.bufferManager.unpinTupleBatch(this.sourceID, bounds[0], bounds[1]);
            }
            pinned.clear();
        }
        this.phase = 2;
    }

    protected void mergePhase() throws BlockedException, TupleSourceNotFoundException, MetaMatrixComponentException {
        if (this.activeTupleIDs.size() > 1 || this.removeDuplicates) {
            do {
                int sortedIndex;
                this.workingBatches = new ArrayList(this.activeTupleIDs.size());
                for (sortedIndex = 0; sortedIndex < this.activeTupleIDs.size(); ++sortedIndex) {
                    TupleSourceID activeID = (TupleSourceID)this.activeTupleIDs.get(sortedIndex);
                    try {
                        TupleBatch sortedBatch = this.bufferManager.pinTupleBatch(activeID, 1, this.batchSize);
                        this.workingBatches.add(sortedBatch);
                        continue;
                    }
                    catch (MemoryNotAvailableException e) {
                        break;
                    }
                }
                if (!(this.workingBatches.size() >= 2 || this.workingBatches.size() == 1 && this.removeDuplicates && this.activeTupleIDs.size() == 1)) {
                    throw BlockedOnMemoryException.INSTANCE;
                }
                this.workingPointers = new int[this.workingBatches.size()];
                for (int i = 0; i < this.workingBatches.size(); ++i) {
                    this.workingPointers[i] = 1;
                }
                TupleSourceID mergedID = this.bufferManager.createTupleSource(this.schema, this.schemaTypes, this.groupName, 1);
                int mergedRowBegin = 1;
                ArrayList<List> currentRows = new ArrayList<List>(this.batchSize);
                ListNestedSortComparator comparator = new ListNestedSortComparator(this.sortCols, this.sortTypes);
                while (true) {
                    List testRow;
                    TupleBatch batch;
                    int i;
                    List currentRow = null;
                    int chosenBatchIndex = -1;
                    TupleBatch chosenBatch = null;
                    for (i = 0; i < this.workingBatches.size(); ++i) {
                        batch = (TupleBatch)this.workingBatches.get(i);
                        if (batch == null) continue;
                        testRow = batch.getTuple(this.workingPointers[i]);
                        if (currentRow != null && comparator.compare((Object)testRow, (Object)currentRow) >= 0) continue;
                        currentRow = testRow;
                        chosenBatchIndex = i;
                        chosenBatch = batch;
                    }
                    if (currentRow == null) break;
                    currentRows.add(currentRow);
                    this.incrementWorkingBatch(chosenBatchIndex, chosenBatch);
                    if (this.removeDuplicates) {
                        for (i = 0; i < this.workingBatches.size(); ++i) {
                            batch = (TupleBatch)this.workingBatches.get(i);
                            while (batch != null && comparator.compare((Object)(testRow = batch.getTuple(this.workingPointers[i])), (Object)currentRow) == 0) {
                                if (!this.incrementWorkingBatch(i, batch)) continue;
                                batch = (TupleBatch)this.workingBatches.get(i);
                            }
                        }
                    }
                    if (currentRows.size() != this.batchSize) continue;
                    this.bufferManager.addTupleBatch(mergedID, new TupleBatch(mergedRowBegin, currentRows));
                    mergedRowBegin += this.batchSize;
                    currentRows = new ArrayList(this.batchSize);
                }
                if (currentRows.size() > 0) {
                    this.bufferManager.addTupleBatch(mergedID, new TupleBatch(mergedRowBegin, currentRows));
                }
                for (int i = 0; i < sortedIndex; ++i) {
                    this.bufferManager.removeTupleSource((TupleSourceID)this.activeTupleIDs.remove(0));
                }
                this.activeTupleIDs.add(mergedID);
            } while (this.activeTupleIDs.size() > 1);
        }
        this.bufferManager.setStatus((TupleSourceID)this.activeTupleIDs.get(0), 2);
        this.phase = 3;
    }

    private boolean incrementWorkingBatch(int batchIndex, TupleBatch currentBatch) throws BlockedOnMemoryException, TupleSourceNotFoundException, MetaMatrixComponentException {
        int n = batchIndex;
        this.workingPointers[n] = this.workingPointers[n] + 1;
        if (this.workingPointers[batchIndex] > currentBatch.getEndRow()) {
            TupleSourceID tsID = this.unpinWorkingBatch(batchIndex, currentBatch);
            int beginRow = this.workingPointers[batchIndex];
            int endRow = beginRow + this.batchSize - 1;
            try {
                TupleBatch newBatch = this.bufferManager.pinTupleBatch(tsID, beginRow, endRow);
                if (newBatch.getRowCount() == 0) {
                    this.workingBatches.set(batchIndex, null);
                } else {
                    this.workingBatches.set(batchIndex, newBatch);
                }
                return true;
            }
            catch (MemoryNotAvailableException e) {
                throw BlockedOnMemoryException.INSTANCE;
            }
        }
        return false;
    }

    private TupleSourceID unpinWorkingBatch(int batchIndex, TupleBatch currentBatch) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        TupleSourceID tsID = (TupleSourceID)this.activeTupleIDs.get(batchIndex);
        int lastBeginRow = currentBatch.getBeginRow();
        int lastEndRow = currentBatch.getEndRow();
        this.bufferManager.unpinTupleBatch(tsID, lastBeginRow, lastEndRow);
        return tsID;
    }

    private int[] getSortCols() {
        int[] cols = new int[this.sortElements.size()];
        int colCount = 0;
        Iterator iter = this.sortElements.iterator();
        while (iter.hasNext()) {
            SingleElementSymbol elem = (SingleElementSymbol)iter.next();
            cols[colCount] = this.sourceElements.indexOf(elem);
            if (cols[colCount] < 0 && elem instanceof ExpressionSymbol) {
                Expression sortExpr = ((ExpressionSymbol)elem).getExpression();
                for (int i = 0; i < this.sourceElements.size(); ++i) {
                    Expression sourceExpr;
                    Object sourceElem = this.sourceElements.get(i);
                    if (!(sourceElem instanceof ExpressionSymbol) || !sortExpr.equals(sourceExpr = ((ExpressionSymbol)sourceElem).getExpression())) continue;
                    cols[colCount] = i;
                }
            }
            if (cols[colCount] < 0) continue;
            ++colCount;
        }
        if (colCount < cols.length) {
            int[] copy = new int[colCount];
            System.arraycopy(cols, 0, copy, 0, colCount);
            return copy;
        }
        return cols;
    }
}

