/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.lob.ValueGlob;
import com.metamatrix.common.lob.ValueID;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.util.CommandContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class QueryProcessor {
    private CommandContext context;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private ProcessorPlan processPlan;
    private boolean initialized = false;
    private MetaMatrixException dataError;
    private boolean requestCancelled = false;
    private boolean processorClosed = false;
    private static final int DEFAULT_WAIT = 50;
    private HashSet lobRequests = null;
    private HashMap lobResponseMap = null;
    private Object lock = new Object();

    public QueryProcessor(ProcessorPlan plan, CommandContext context, BufferManager bufferMgr, ProcessorDataManager dataMgr) {
        this.context = context;
        this.dataMgr = dataMgr;
        this.bufferMgr = bufferMgr;
        this.processPlan = plan;
        this.dataMgr.registerProcessor(context.getProcessorID(), this);
        this.processPlan.initialize(context, this.dataMgr, bufferMgr);
    }

    public Object getProcessID() {
        return this.context.getProcessorID();
    }

    public TupleSourceID getResultsID() {
        return this.context.getTupleSourceID();
    }

    public ProcessorPlan getProcessorPlan() {
        return this.processPlan;
    }

    private void initialize() throws MetaMatrixComponentException {
        if (!this.initialized) {
            this.processPlan.open();
            this.initialized = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() throws MetaMatrixComponentException, MetaMatrixException {
        try {
            while (true) {
                try {
                    this.initialize();
                }
                catch (BlockedException be) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException err) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (MetaMatrixComponentException e) {
            this.closeProcessing();
            throw e;
        }
        catch (MetaMatrixException e) {
            this.closeProcessing();
            throw e;
        }
        while (true) {
            this.checkState();
            try {
                TupleBatch batch = this.processPlan.nextBatch();
                this.flushBatch(batch);
                if (!batch.getTerminationFlag()) continue;
            }
            catch (BlockedException e) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        this.closeProcessing();
        this.checkState();
    }

    public void processNoTimeSlice() throws MetaMatrixComponentException, MetaMatrixException {
        try {
            TupleBatch batch;
            this.initialize();
            do {
                this.checkState();
                batch = this.processPlan.nextBatch();
                this.flushBatch(batch);
            } while (!batch.getTerminationFlag());
        }
        catch (BlockedException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            this.closeProcessing();
            throw e;
        }
        catch (MetaMatrixException e) {
            this.closeProcessing();
            throw e;
        }
        this.closeProcessing();
        this.checkState();
    }

    public boolean process(long time, boolean clientNeedsBatch) throws BlockedException, MetaMatrixComponentException, MetaMatrixException {
        boolean done = false;
        try {
            this.initialize();
            long end = System.currentTimeMillis() + time;
            while (System.currentTimeMillis() < end) {
                this.checkState();
                TupleBatch batch = this.processPlan.nextBatch();
                this.flushBatch(batch);
                if (batch.getTerminationFlag()) {
                    done = true;
                } else if (!clientNeedsBatch || batch == null || batch.getRowCount() <= 0) continue;
                break;
            }
        }
        catch (BlockedException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            this.closeProcessing();
            throw e;
        }
        catch (MetaMatrixException e) {
            this.closeProcessing();
            throw e;
        }
        this.checkState();
        if (done) {
            this.closeProcessing();
            this.checkState();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverLobChunk(ValueID id, ValueGlob glob) {
        if (this.processorClosed) {
            this.dataMgr.unregisterProcessor(this.context.getProcessorID());
        }
        if (this.lobResponseMap == null) {
            this.lobResponseMap = new HashMap();
        }
        Object object = this.lock;
        synchronized (object) {
            this.lobResponseMap.put(id, glob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueGlob processLob(ValueID id, int size) throws MetaMatrixComponentException {
        if (this.lobRequests == null) {
            this.lobRequests = new HashSet();
        }
        if (!this.lobRequests.contains(id)) {
            Object object = this.lock;
            synchronized (object) {
                this.lobRequests.add(id);
            }
            if (this.processorClosed) {
                this.dataMgr.registerProcessor(this.context.getProcessorID(), this);
            }
            this.dataMgr.registerLobRequest(this.context.getProcessorID(), id, size);
        } else if (this.lobResponseMap != null && this.lobResponseMap.containsKey(id)) {
            Object object = this.lock;
            synchronized (object) {
                ValueGlob value = (ValueGlob)this.lobResponseMap.remove(id);
                this.lobRequests.remove(id);
                return value;
            }
        }
        throw BlockedException.INSTANCE;
    }

    private void flushBatch(TupleBatch batch) {
        if (batch != null && batch.getRowCount() > 0) {
            try {
                this.bufferMgr.addTupleBatch(this.context.getTupleSourceID(), batch);
            }
            catch (MetaMatrixException e) {
                this.errorOccurred(e);
            }
        }
    }

    private void closeProcessor() {
        if (!this.processorClosed) {
            this.dataMgr.unregisterProcessor(this.context.getProcessorID());
            try {
                this.processPlan.close();
            }
            catch (MetaMatrixException e) {
                this.errorOccurred(e);
            }
            this.processorClosed = true;
        }
    }

    private void closeProcessing() {
        this.closeProcessor();
        if (this.bufferMgr != null) {
            try {
                this.bufferMgr.setStatus(this.context.getTupleSourceID(), 2);
            }
            catch (MetaMatrixException e) {
                this.errorOccurred(e);
            }
        }
    }

    public void connectTupleSource(TupleSource source, int nodeID) {
        this.processPlan.connectTupleSource(source, nodeID);
    }

    public void errorOccurred(MetaMatrixException e) {
        this.dataError = e;
    }

    private void checkState() throws MetaMatrixException {
        if (this.requestCancelled) {
            this.dataError = new MetaMatrixComponentException(QueryExecPlugin.Util.getString("QueryProcessor.request_cancelled", this.getProcessID()));
        }
        if (this.dataError != null) {
            try {
                this.processPlan.close();
            }
            catch (MetaMatrixException metaMatrixException) {
                // empty catch block
            }
            throw this.dataError;
        }
    }

    public List getAndClearWarnings() {
        return this.processPlan.getAndClearWarnings();
    }

    public CommandContext getContext() {
        return this.context;
    }

    public void requestCancelled() {
        this.requestCancelled = true;
        this.closeProcessor();
    }
}

