/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function.load;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.metamodels.function.FunctionParameter;
import com.metamatrix.metamodels.function.PushDownType;
import com.metamatrix.metamodels.function.ScalarFunction;
import com.metamatrix.query.function.UserFunctionPlugin;
import com.metamatrix.query.function.load.FunctionModelHelper;
import com.metamatrix.query.function.metadata.FunctionMethod;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class FunctionMetadataUtil {
    public static final String OUTPUT_PARAMETER_NAME = "result";

    private FunctionMetadataUtil() {
    }

    public static Collection getFunctionMetadata(URI uri) {
        Collection functionMethods = null;
        FunctionModelHelper helper = new FunctionModelHelper();
        try {
            helper.load(uri);
            functionMethods = FunctionMetadataUtil.getFunctionMetadata(helper);
        }
        catch (CoreException e) {
            String mess = UserFunctionPlugin.Util.getString("FunctionMetadataUtil.Error_loading_defns", (Object)e.getMessage());
            throw new MetaMatrixRuntimeException((Throwable)e, mess);
        }
        finally {
            helper.unload();
        }
        return functionMethods;
    }

    public static Collection getFunctionMetadata(InputStream stream) {
        Collection functionMethods = null;
        FunctionModelHelper helper = new FunctionModelHelper();
        try {
            helper.load(stream);
            functionMethods = FunctionMetadataUtil.getFunctionMetadata(helper);
        }
        catch (CoreException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, UserFunctionPlugin.Util.getString("FunctionMetadataUtil.Unable_to_get_function_metadata__Failed_loading_from_stream."));
        }
        finally {
            helper.unload();
        }
        return functionMethods;
    }

    private static Collection getFunctionMetadata(FunctionModelHelper helper) {
        ArrayList<FunctionMethod> functionMethods = new ArrayList<FunctionMethod>();
        TreeIterator iter = helper.getTreeIterator();
        int i = 0;
        EList params = null;
        EObject modelObj = null;
        ScalarFunction function = null;
        FunctionParameter param = null;
        com.metamatrix.query.function.metadata.FunctionParameter[] paramArray = null;
        while (iter.hasNext()) {
            try {
                modelObj = (EObject)iter.next();
                if (!(modelObj instanceof ScalarFunction)) continue;
                function = (ScalarFunction)modelObj;
                params = function.getInputParameters();
                paramArray = new com.metamatrix.query.function.metadata.FunctionParameter[params.size()];
                for (i = 0; i < params.size(); ++i) {
                    param = (FunctionParameter)params.get(i);
                    paramArray[i] = new com.metamatrix.query.function.metadata.FunctionParameter(param.getName(), param.getType(), helper.getDescription((EObject)param));
                }
                int pushdown = FunctionMetadataUtil.decodePushDownType(function);
                if (function.getReturnParameter() == null) continue;
                functionMethods.add(new FunctionMethod(function.getName(), helper.getDescription((EObject)function), function.getCategory(), pushdown, function.getInvocationClass(), function.getInvocationMethod(), paramArray, new com.metamatrix.query.function.metadata.FunctionParameter(OUTPUT_PARAMETER_NAME, function.getReturnParameter().getType(), helper.getDescription((EObject)function.getReturnParameter())), true, function.isDeterministic() ? 0 : 4));
            }
            catch (Throwable t) {
                UserFunctionPlugin.Util.log(2, t, UserFunctionPlugin.Util.getString("FunctionMetadataUtil.Error_while_reading_UDFs_from_a_source._Will_skip_this_function_definition_and_attempt_to_continue._1"));
            }
        }
        return functionMethods;
    }

    private static int decodePushDownType(ScalarFunction function) {
        PushDownType pdType = function.getPushDown();
        switch (pdType.getValue()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 0: {
                return 2;
            }
        }
        return 0;
    }
}

