/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.MMTransactionManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.api.AsynchQueryExecution;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.BatchedExecution;
import com.metamatrix.data.api.BatchedUpdatesExecution;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.api.SynchQueryExecution;
import com.metamatrix.data.api.UpdateExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.xa.api.XAConnection;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorStateManager;
import com.metamatrix.dqp.internal.datamgr.impl.IConnectorStateManager;
import com.metamatrix.dqp.internal.datamgr.impl.PollingRequestTask;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.lang.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class ConnectorWorker
extends QueueWorker {
    private IConnectorStateManager stateMgr;
    private MetadataService metadataService;
    private TrackingService tracker;
    private int maxResultRows;
    private boolean exceptionOnMaxRows = true;
    private TransactionService transactionService;
    private ClassLoader connectorClassLoader;
    private Lock transactionLock;
    private LockKey lockKey;
    private WorkerPool workerPool;
    private static Map transactionLocks = new HashMap();
    static /* synthetic */ Class class$com$metamatrix$dqp$message$AtomicRequestMessage;

    public ConnectorWorker(ConnectorStateManager stateMgr, ApplicationEnvironment connectorMgrEnv, MetadataService metadataService, TrackingService tracker, TransactionService transactionService, ClassLoader connectorClassLoader, WorkerPool workerPool) {
        String exceptionOnMaxRowsString;
        this.stateMgr = stateMgr;
        this.metadataService = metadataService;
        this.tracker = tracker;
        this.transactionService = transactionService;
        this.connectorClassLoader = connectorClassLoader;
        this.workerPool = workerPool;
        String maxResultRowsString = connectorMgrEnv.getApplicationProperties().getProperty("MaxResultRows");
        if (maxResultRowsString != null && maxResultRowsString.trim().length() > 0) {
            try {
                this.maxResultRows = Integer.parseInt(maxResultRowsString);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{"MaxResultRows"};
                String msg = DQPPlugin.Util.getString("ConnectorManagerImpl.Couldn__t_parse_property", params);
                LogManager.logWarning("CONNECTOR", (Throwable)e, msg);
            }
        }
        if ((exceptionOnMaxRowsString = connectorMgrEnv.getApplicationProperties().getProperty("ExceptionOnMaxRows")) != null) {
            Boolean bool = Boolean.valueOf(exceptionOnMaxRowsString);
            this.exceptionOnMaxRows = bool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Object request) throws QueueWorkerException {
        ArgCheck.isInstanceOf((Class)(class$com$metamatrix$dqp$message$AtomicRequestMessage == null ? (class$com$metamatrix$dqp$message$AtomicRequestMessage = ConnectorWorker.class$("com.metamatrix.dqp.message.AtomicRequestMessage")) : class$com$metamatrix$dqp$message$AtomicRequestMessage), (Object)request, (String)DQPPlugin.Util.getString("ERR.018.003.0021"));
        AtomicRequestMessage atomicReq = (AtomicRequestMessage)request;
        try {
            this.setContextClassLoader(this.connectorClassLoader);
            this.processRequest(atomicReq);
        }
        catch (Throwable t) {
            this.logSRCCommand(atomicReq, (short)4, -1);
            LogManager.logError("CONNECTOR", t, t.getMessage());
        }
        finally {
            this.releaseTransactionLock();
        }
    }

    private void processRequest(AtomicRequestMessage atomicReq) throws ConnectorException, MetaMatrixComponentException {
        switch (atomicReq.getType()) {
            case 1: 
            case 2: {
                this.processBatchRequest(atomicReq);
                break;
            }
            case 3: {
                this.processCancelRequest(atomicReq);
                break;
            }
            default: {
                throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ConnectorWorker.invalidAtomicType", atomicReq.getType()));
            }
        }
    }

    private void processBatchRequest(AtomicRequestMessage atomicReq) {
        try {
            if (this.stateMgr.startProcessing(atomicReq)) {
                if (atomicReq.getType() == 1) {
                    QueryMetadataInterface queryMetadata = this.metadataService.lookupMetadata(atomicReq.getVdbName(), atomicReq.getVdbVersion());
                    this.processNewRequest(atomicReq, queryMetadata);
                } else {
                    this.processMoreRequest(atomicReq);
                }
            } else {
                LogManager.logDetail("CONNECTOR", DQPPlugin.Util.getString("ConnectorWorker.requestID_does_not_exist", (Object)atomicReq.getRequestID()));
            }
        }
        catch (Throwable t) {
            this.logSRCCommand(atomicReq, (short)4, -1);
            if (this.stateMgr.isCancelled(atomicReq)) {
                LogManager.logDetail("CONNECTOR", t, t.getMessage());
            } else {
                LogManager.logError("CONNECTOR", t, t.getMessage());
            }
            this.rollbackTransaction(atomicReq);
            this.closeProcessing(atomicReq);
            this.sendError(atomicReq, t);
        }
    }

    private void processNewRequest(AtomicRequestMessage atomicReq, QueryMetadataInterface queryMetadata) throws ConnectorException, XATransactionException, MetaMatrixComponentException {
        RequestID requestID = atomicReq.getRequestID();
        LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Processing NEW request:", atomicReq.getCommand()});
        this.logSRCCommand(atomicReq, (short)1, -1);
        Execution execution = this.stateMgr.createExecution(atomicReq, queryMetadata);
        LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Obtained execution"});
        ICommand translatedCommand = this.stateMgr.getTranslatedCommand(atomicReq);
        int executionMode = this.stateMgr.getExecutionMode(atomicReq);
        if (atomicReq.isTransactional()) {
            this.startSubTransaction(atomicReq, executionMode);
        }
        BasicBatch aBatch = null;
        switch (executionMode) {
            case 0: {
                ((SynchQueryExecution)execution).execute((IQuery)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            case 1: 
            case 4: {
                int count = ((UpdateExecution)execution).execute(translatedCommand);
                aBatch = new BasicBatch();
                aBatch.addRow(Arrays.asList(new Integer(count)));
                aBatch.setLast();
                break;
            }
            case 3: {
                List updates = ((IBatchedUpdates)translatedCommand).getUpdateCommands();
                ICommand[] updatesArray = updates.toArray(new ICommand[updates.size()]);
                int[] count = ((BatchedUpdatesExecution)execution).execute(updatesArray);
                aBatch = new BasicBatch();
                for (int i = 0; i < count.length; ++i) {
                    aBatch.addRow(Arrays.asList(new Integer(count[i])));
                }
                aBatch.setLast();
                break;
            }
            case 2: {
                ((ProcedureExecution)execution).execute((IProcedure)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            case 5: {
                ((AsynchQueryExecution)execution).executeAsynch((IQuery)translatedCommand, atomicReq.getFetchSize());
                break;
            }
            default: {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.Unable_to_open_connector_execution");
                throw new MetaMatrixComponentException(msg);
            }
        }
        LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Executed command"});
        if (executionMode == 0 || executionMode == 2 || executionMode == 5) {
            aBatch = this.getNextBatch((BatchedExecution)execution, translatedCommand);
            LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Obtained first batch, row count:" + aBatch.getRowCount()});
            boolean exceededMax = this.checkMaxResultRows(aBatch.getRowCount());
            if (exceededMax) {
                aBatch = this.setBatchAtMaxRows((Batch)aBatch, this.maxResultRows);
            }
        }
        this.handleBatch(atomicReq, execution, (Batch)aBatch, aBatch.getRowCount());
    }

    private boolean checkMaxResultRows(int rowCount) throws ConnectorException {
        boolean exceededMax = false;
        if (this.maxResultRows != 0 && rowCount > this.maxResultRows) {
            if (this.exceptionOnMaxRows) {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.MaxResultRowsExceed", this.maxResultRows);
                throw new ConnectorException(msg);
            }
            exceededMax = true;
        }
        return exceededMax;
    }

    private Batch setBatchAtMaxRows(Batch origBatch, int maxRowsAllowed) {
        List[] origResults = origBatch.getResults();
        List[] newResults = new List[maxRowsAllowed];
        System.arraycopy(origResults, 0, newResults, 0, maxRowsAllowed);
        List<List> newResultsList = Arrays.asList(newResults);
        BasicBatch newBatch = new BasicBatch(newResultsList);
        newBatch.setLast();
        return newBatch;
    }

    private void handleBatch(AtomicRequestMessage atomicReq, Execution execution, Batch aBatch, int rowCount) throws XATransactionException, ConnectorException, MetaMatrixComponentException {
        RequestID requestID = atomicReq.getRequestID();
        if (this.stateMgr.isCancelled(atomicReq)) {
            this.rollbackTransaction(atomicReq);
            this.closeProcessing(atomicReq, execution);
        } else {
            LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Sending results from connector"});
            boolean lastBatch = aBatch.isLast();
            if (atomicReq.isTransactional()) {
                this.endSubTransaction(atomicReq, lastBatch);
            }
            if (lastBatch) {
                LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Obtained last batch, total row count:" + rowCount});
                this.logSRCCommand(atomicReq, (short)2, rowCount);
                if (!this.stateMgr.hasValueReferences(atomicReq)) {
                    this.closeProcessing(atomicReq, execution);
                } else {
                    this.stateMgr.addRowsProcessed(atomicReq, aBatch.getRowCount());
                    this.stateMgr.endProcessing(atomicReq);
                }
            } else {
                this.stateMgr.addRowsProcessed(atomicReq, aBatch.getRowCount());
                this.stateMgr.endProcessing(atomicReq);
            }
            if (aBatch.getRowCount() == 0 && !aBatch.isLast() && execution instanceof AsynchQueryExecution && atomicReq.getType() == 2) {
                this.schedulePollingTask((AsynchQueryExecution)execution, atomicReq);
            } else {
                try {
                    this.sendResults(atomicReq, aBatch, atomicReq.getCommand().getProjectedSymbols(), rowCount);
                }
                catch (Throwable t) {
                    this.logSRCCommand(atomicReq, (short)4, -1);
                    if (this.stateMgr.isCancelled(atomicReq)) {
                        LogManager.logDetail("CONNECTOR", t, t.getMessage());
                    } else {
                        LogManager.logError("CONNECTOR", t, t.getMessage());
                    }
                    if (!lastBatch) {
                        this.rollbackTransaction(atomicReq);
                        this.closeProcessing(atomicReq, execution);
                    }
                    this.sendError(atomicReq, t);
                }
            }
        }
    }

    private void schedulePollingTask(AsynchQueryExecution execution, AtomicRequestMessage request) {
        PollingRequestTask task = new PollingRequestTask(request, this.workerPool);
        long delay = execution.getPollInterval();
        this.stateMgr.scheduleTask((TimerTask)task, delay);
    }

    private void processMoreRequest(AtomicRequestMessage atomicReq) throws XATransactionException, ConnectorException, MetaMatrixComponentException {
        RequestID requestID = atomicReq.getRequestID();
        LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Processing MORE request"});
        Execution execution = this.stateMgr.getExecution(atomicReq);
        if (execution == null) {
            throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.could_not_retrieve_execution", (Object)requestID));
        }
        if (atomicReq.isTransactional()) {
            this.resumeTransaction(atomicReq);
        }
        this.verifyIsQuery(atomicReq, execution);
        Batch aBatch = ((BatchedExecution)execution).nextBatch();
        LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Obtained batch, row count:" + aBatch.getRowCount()});
        int rowsSoFar = this.stateMgr.getRowsProcessed(atomicReq);
        int rowCnt = rowsSoFar + aBatch.getRowCount();
        boolean exceededMax = this.checkMaxResultRows(rowCnt);
        if (exceededMax) {
            int maxAllowedForBatch = this.maxResultRows - rowsSoFar;
            aBatch = this.setBatchAtMaxRows(aBatch, maxAllowedForBatch);
            rowCnt = rowsSoFar + aBatch.getRowCount();
        }
        this.handleBatch(atomicReq, execution, aBatch, rowCnt);
    }

    private void startSubTransaction(AtomicRequestMessage atomicReq, int executionMode) throws ConnectorException, XATransactionException, MetaMatrixComponentException {
        Connection conn = this.stateMgr.getConnection(atomicReq, false);
        if (!conn.getCapabilities().supportsXATransactions()) {
            if (executionMode != 0) {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.transactionNotSupported");
                throw new ConnectorException(msg);
            }
        } else {
            XAResource xaRes;
            XAConnection xaConn = (XAConnection)conn;
            try {
                xaRes = xaConn.getXAResource();
            }
            catch (ConnectorException err) {
                throw new XATransactionException((Throwable)err);
            }
            this.acquireTransactionLock(atomicReq.getTransactionContext(), xaRes);
            this.getTransactionManager().importTransaction(atomicReq.getTransactionContext(), xaRes);
            this.getTransactionManager().enlistResource(xaRes);
        }
    }

    private void resumeTransaction(AtomicRequestMessage atomicReq) throws XATransactionException, ConnectorException, MetaMatrixComponentException {
        Connection conn = this.stateMgr.getConnection(atomicReq, false);
        if (conn.getCapabilities().supportsXATransactions()) {
            XAResource xaRes;
            TransactionContext txnCtx = this.stateMgr.getTransactionContext(atomicReq);
            try {
                xaRes = ((XAConnection)conn).getXAResource();
            }
            catch (ConnectorException err) {
                throw new XATransactionException((Throwable)err);
            }
            this.acquireTransactionLock(txnCtx, xaRes);
            this.getTransactionManager().resumeTransaction(txnCtx, xaRes);
        }
    }

    private void endSubTransaction(AtomicRequestMessage atomicReq, boolean commit) throws ConnectorException, XATransactionException, MetaMatrixComponentException {
        LogManager.logDetail("CONNECTOR", new Object[]{"endSubTransaction(" + (commit ? " Committing -" : " Suspending -") + atomicReq.getTransactionContext() + ")"});
        Connection conn = this.stateMgr.getConnection(atomicReq, false);
        if (conn.getCapabilities().supportsXATransactions()) {
            TransactionContext txnCtx = this.stateMgr.getTransactionContext(atomicReq);
            if (commit) {
                XAResource xaRes;
                XAConnection xaConn = (XAConnection)conn;
                try {
                    xaRes = xaConn.getXAResource();
                }
                catch (ConnectorException err) {
                    throw new XATransactionException((Throwable)err);
                }
                this.getTransactionManager().delistResource(xaRes);
                this.getTransactionManager().terminateSubTransaction(txnCtx, true);
            } else {
                this.getTransactionManager().suspendTransaction(txnCtx);
            }
            this.releaseTransactionLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackTransaction(AtomicRequestMessage atomicReq) {
        block9: {
            if (atomicReq.isTransactional()) {
                LogManager.logDetail("CONNECTOR", new Object[]{"Rolling back request"});
                try {
                    Connection conn = this.stateMgr.getConnection(atomicReq, false);
                    if (!conn.getCapabilities().supportsXATransactions()) break block9;
                    XAConnection xaConn = (XAConnection)conn;
                    try {
                        this.getTransactionManager().delistResource(xaConn.getXAResource());
                    }
                    finally {
                        this.getTransactionManager().terminateSubTransaction(atomicReq.getTransactionContext(), false);
                    }
                }
                catch (Throwable e) {
                    String msg = DQPPlugin.Util.getString("ConnectorWorker.canNotRollBack", (Object)atomicReq.getRequestID());
                    LogManager.logWarning("CONNECTOR", e, msg);
                }
                finally {
                    this.releaseTransactionLock();
                }
            }
        }
    }

    private void verifyIsQuery(AtomicRequestMessage atomicReq, Execution execution) throws ConnectorException {
        int executionMode = this.stateMgr.getExecutionMode(atomicReq);
        if (executionMode != 0 && executionMode != 2 && executionMode != 5) {
            Object[] params = new Object[]{execution.getClass().getName()};
            throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.ConnectorWorker_expecting_an_Execution_of_type_SynchExecution,_got", params));
        }
    }

    private void processCancelRequest(AtomicRequestMessage atomicReq) throws ConnectorException {
        boolean shouldClose = this.stateMgr.setRequestCancelled(atomicReq);
        RequestID requestID = atomicReq.getRequestID();
        LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Processing CANCEL request"});
        Execution execution = this.stateMgr.getExecution(atomicReq);
        if (execution != null) {
            execution.cancel();
            LogManager.logDetail("CONNECTOR", new Object[]{requestID, "Cancelled command"});
        }
        if (shouldClose) {
            this.rollbackTransaction(atomicReq);
            this.closeProcessing(atomicReq);
        }
        this.logSRCCommand(atomicReq, (short)3, -1);
    }

    private Batch getNextBatch(BatchedExecution execution, ICommand command) throws ConnectorException {
        if (command instanceof IProcedure) {
            return ConnectorWorker.getNextProcedureBatch((ProcedureExecution)execution, (IProcedure)command);
        }
        return execution.nextBatch();
    }

    static Batch getNextProcedureBatch(ProcedureExecution execution, IProcedure command) throws ConnectorException {
        ArrayList results = new ArrayList();
        List params = command.getParameters();
        int paramCols = 0;
        int resultSetCols = 0;
        if (params != null && !params.isEmpty()) {
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                IParameter param = (IParameter)iter.next();
                if (param.getDirection() == 4) {
                    resultSetCols = param.getMetadataID().getChildIDs().size();
                    continue;
                }
                if (param.getDirection() != 3 && param.getDirection() != 1 && param.getDirection() != 2) continue;
                ++paramCols;
            }
        }
        Batch abatch = execution.nextBatch();
        boolean atLast = false;
        if (abatch.getResults() != null && abatch.getResults().length > 0) {
            for (int i = 0; i < abatch.getResults().length; ++i) {
                results.add(new ArrayList(abatch.getResults()[i]));
            }
            int resultSetSize = ((List)results.get(0)).size();
            if (resultSetSize != resultSetCols) {
                throw new ConnectorException(DQPPlugin.Util.getString("ConnectorWorker.ConnectorWorker_result_set_unexpected_columns", new Object[]{command, new Integer(resultSetCols), new Integer(resultSetSize)}));
            }
            if (paramCols != 0) {
                List<Object> resultsPadding = Arrays.asList(new Object[paramCols]);
                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    ((List)iter.next()).addAll(resultsPadding);
                }
            }
        } else {
            atLast = true;
        }
        if (atLast || abatch.isLast()) {
            return ConnectorWorker.prepareLastProcedureBatch(execution, results, params, paramCols, resultSetCols);
        }
        BasicBatch batch = new BasicBatch(results);
        return batch;
    }

    private static Batch prepareLastProcedureBatch(ProcedureExecution execution, List results, List params, int paramCols, int resultSetCols) throws ConnectorException {
        ArrayList<Object> outParamValues = new ArrayList<Object>(params.size());
        if (params != null && !params.isEmpty()) {
            IParameter param;
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                param = (IParameter)iter.next();
                if (param.getDirection() != 3) continue;
                outParamValues.add(execution.getOutputValue(param));
            }
            iter = params.iterator();
            while (iter.hasNext()) {
                param = (IParameter)iter.next();
                if (param.getDirection() != 1 && param.getDirection() != 2) continue;
                outParamValues.add(execution.getOutputValue(param));
            }
            Iterator i = outParamValues.iterator();
            int index = resultSetCols;
            while (i.hasNext()) {
                Object[] newRow = new Object[paramCols + resultSetCols];
                newRow[index] = i.next();
                results.add(Arrays.asList(newRow));
                ++index;
            }
        }
        BasicBatch batch = new BasicBatch(results);
        batch.setLast();
        return batch;
    }

    public void initialize() throws QueueWorkerException {
    }

    public void cleanup() throws QueueWorkerException {
    }

    private void sendResults(AtomicRequestMessage request, Batch batch, List elements, int rowsProcessed) throws CommunicationException {
        boolean done = batch.isLast();
        int rowCount = batch.getRowCount();
        if (!done && rowCount == 0) {
            LogManager.logWarning("CONNECTOR", DQPPlugin.Util.getString("ConnectorWorker.zero_size_non_last_batch", (Object)request.getConnectorID()));
        }
        ResultsMessage response = new ResultsMessage((RequestMessage)request, batch.getResults(), elements, true);
        response.setFirstRow(rowsProcessed + 1 - rowCount);
        response.setLastRow(rowsProcessed);
        if (done) {
            response.setFinalRow(rowsProcessed);
            response.setPartialResults(false);
        } else {
            response.setFinalRow(-1);
            response.setPartialResults(true);
        }
        this.sendResponse(request, response, done);
    }

    private void sendResponse(AtomicRequestMessage request, ResultsMessage response, boolean done) throws CommunicationException {
        try {
            this.basicSendResponse(request, response);
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{request.getRequestID().getConnectionID()};
            String msg = DQPPlugin.Util.getString("ConnectorWorker.Error_communicating_results_to_client", params);
            LogManager.logError("CONNECTOR", (Throwable)e, msg);
            throw e;
        }
    }

    private void basicSendResponse(AtomicRequestMessage request, ResultsMessage response) throws CommunicationException {
        request.getClientConnection().send((Message)response, request.getMessageKey());
    }

    private void sendError(AtomicRequestMessage request, Throwable error) {
        if (request != null) {
            ResultsMessage response = new ResultsMessage((RequestMessage)request, true);
            response.setException(error);
            try {
                this.basicSendResponse(request, response);
            }
            catch (CommunicationException e) {
                String msg = DQPPlugin.Util.getString("ConnectorWorker.Can__t_communicate_error_to_client");
                LogManager.logError("CONNECTOR", (Throwable)e, msg);
            }
        }
    }

    private void logSRCCommand(AtomicRequestMessage qr, short cmdStatus, int finalRowCnt) {
        if (this.tracker == null || !this.tracker.willRecordSrcCmd()) {
            return;
        }
        Command sqlCmd = null;
        if (cmdStatus == 1) {
            sqlCmd = qr.getCommand();
        }
        String userName = qr.getUserName();
        TransactionID transactionID = null;
        if (qr.isTransactional()) {
            transactionID = qr.getTransactionContext().getTopLevelTxnID();
        }
        String modelName = qr.getModelName();
        this.tracker.log(qr.getRequestID().toString(), (long)qr.getNodeID(), transactionID == null ? null : transactionID.asString(), cmdStatus, modelName == null ? "null" : modelName, qr.getConnectorBindingID(), cmdStatus == 1 ? (short)1 : 2, qr.getConnectionID(), userName == null ? "unknown" : userName, sqlCmd, finalRowCnt);
    }

    private void closeConnection(AtomicRequestMessage atomicReq) throws ConnectorException {
        Connection connection = this.stateMgr.getConnection(atomicReq, false);
        if (connection != null) {
            connection.release();
            LogManager.logDetail("CONNECTOR", new Object[]{atomicReq.getRequestID(), "Closed connection"});
        }
        this.stateMgr.removeRequestState(atomicReq);
    }

    private void closeProcessing(AtomicRequestMessage atomicReq) {
        this.closeProcessing(atomicReq, this.stateMgr.getExecution(atomicReq));
    }

    private void closeProcessing(AtomicRequestMessage atomicReq, Execution execution) {
        try {
            if (execution != null) {
                execution.close();
                LogManager.logDetail("CONNECTOR", new Object[]{atomicReq.getRequestID(), "Closed execution"});
            }
        }
        catch (ConnectorException e) {
            LogManager.logError("CONNECTOR", (Throwable)e, "Error closing the execution");
        }
        try {
            this.closeConnection(atomicReq);
        }
        catch (ConnectorException e) {
            LogManager.logError("CONNECTOR", (Throwable)e, DQPPlugin.Util.getString("ConnectorWorker.Error_closing_conn"));
        }
    }

    private MMTransactionManager getTransactionManager() throws MetaMatrixComponentException {
        return this.transactionService.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireTransactionLock(TransactionContext tc, XAResource resource) throws MetaMatrixComponentException {
        this.lockKey = new LockKey(tc, resource);
        Map map = transactionLocks;
        synchronized (map) {
            this.transactionLock = (Lock)transactionLocks.get(this.lockKey);
            if (this.transactionLock == null) {
                this.transactionLock = new Lock();
                transactionLocks.put(this.lockKey, this.transactionLock);
            }
            this.transactionLock.increaseWaitCount();
        }
        try {
            this.transactionLock.acquire();
        }
        catch (InterruptedException err) {
            this.releaseTransactionLock(false);
            throw new MetaMatrixComponentException((Throwable)err);
        }
        map = transactionLocks;
        synchronized (map) {
            this.transactionLock.setHeld();
        }
    }

    private void releaseTransactionLock() {
        this.releaseTransactionLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTransactionLock(boolean held) {
        if (this.lockKey != null) {
            if (held) {
                this.transactionLock.release();
            }
            Map map = transactionLocks;
            synchronized (map) {
                if (!held) {
                    this.transactionLock.decreaseWaitCount();
                }
                if (!this.transactionLock.isHeld() && this.transactionLock.getWaitCount() <= 0) {
                    transactionLocks.remove(this.lockKey);
                }
            }
        }
        this.transactionLock = null;
        this.lockKey = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LockKey {
        private String tid;
        private XAResource resource;

        public LockKey(TransactionContext tc, XAResource resource) {
            this.tid = tc.getTopLevelTxnID().asString();
            this.resource = resource;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LockKey) {
                LockKey key = (LockKey)obj;
                try {
                    return this.tid.equals(key.tid) && this.resource.isSameRM(key.resource);
                }
                catch (XAException err) {
                    return false;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.tid.hashCode();
        }
    }

    private static class Lock {
        private Semaphore semaphore = new Semaphore(1L);
        private int waitCount = 0;
        private boolean held;

        public void acquire() throws InterruptedException {
            this.semaphore.acquire();
        }

        public void increaseWaitCount() {
            ++this.waitCount;
        }

        public void decreaseWaitCount() {
            --this.waitCount;
        }

        public void setHeld() {
            this.held = true;
            --this.waitCount;
        }

        public int getWaitCount() {
            return this.waitCount;
        }

        public void release() {
            this.held = false;
            this.semaphore.release();
        }

        public boolean isHeld() {
            return this.held;
        }
    }
}

