/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.JoinUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleBreakCriteria;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class RulePushSelectCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean movedAnyNode = true;
        HashSet<PlanNode> deadNodes = new HashSet<PlanNode>();
        while (movedAnyNode) {
            PlanNode critNode;
            movedAnyNode = false;
            ArrayList critNodes = new ArrayList();
            this.findCriteria(plan, critNodes, deadNodes, metadata, capFinder);
            Iterator nodeIter = critNodes.iterator();
            while (nodeIter.hasNext()) {
                critNode = (PlanNode)nodeIter.next();
                this.pushTowardOriginatingNode(critNode, metadata, capFinder);
            }
            nodeIter = critNodes.iterator();
            while (nodeIter.hasNext()) {
                critNode = (PlanNode)nodeIter.next();
                boolean moved = false;
                if (FrameUtil.hasSubquery(critNode) || critNode.getGroups().size() == 0) {
                    deadNodes.add(critNode);
                    continue;
                }
                PlanNode sourceNode = FrameUtil.findOriginatingNode(critNode, critNode.getGroups());
                if (sourceNode == null || !this.atBoundary(critNode, sourceNode)) {
                    deadNodes.add(critNode);
                    continue;
                }
                switch (sourceNode.getType()) {
                    case 19: {
                        moved = this.pushAcrossFrame(sourceNode, plan, critNode, metadata);
                        break;
                    }
                    case 23: {
                        moved = this.pushAcrossGroupBy(plan, critNode, sourceNode);
                        break;
                    }
                    case 7: {
                        moved = this.handleJoinCriteria(sourceNode, critNode);
                    }
                }
                if (!moved) {
                    deadNodes.add(critNode);
                    continue;
                }
                movedAnyNode = true;
            }
        }
        if (rules.contains(RuleConstants.ACCESS_PATTERN_VALIDATION)) {
            rules.push(RuleConstants.CHOOSE_ACCESS_PATTERN);
        }
        return plan;
    }

    private boolean handleJoinCriteria(PlanNode joinNode, PlanNode critNode) {
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jt == null && critNode.getGroups().size() == 2 && !JoinUtil.doesJoinPreventCriteriaOptimization(joinNode, critNode)) {
            this.moveCriteriaIntoOnClause(critNode, joinNode);
            return false;
        }
        if (jt == JoinType.JOIN_CROSS || jt == JoinType.JOIN_INNER) {
            if (jt == JoinType.JOIN_CROSS) {
                joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_INNER);
            }
            this.moveCriteriaIntoOnClause(critNode, joinNode);
        } else {
            JoinType optimized = JoinUtil.optimizeJoinType(critNode, joinNode);
            if (optimized == JoinType.JOIN_INNER) {
                this.moveCriteriaIntoOnClause(critNode, joinNode);
                return true;
            }
        }
        return false;
    }

    private void moveCriteriaIntoOnClause(PlanNode critNode, PlanNode joinNode) {
        LinkedList<Criteria> joinCriteria = (LinkedList<Criteria>)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        Criteria criteria = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (joinCriteria == null || joinCriteria.size() == 0) {
            joinCriteria = new LinkedList<Criteria>();
            joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
        }
        if (!joinCriteria.contains(criteria)) {
            joinCriteria.add(criteria);
        }
        NodeEditor.removeChildNode(critNode.getParent(), critNode);
    }

    void findCriteria(PlanNode root, List foundNodes, Set deadNodes, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        if (!deadNodes.contains(root) && root.getType() == 13) {
            boolean isHaving = root.hasBooleanProperty(NodeConstants.Info.IS_HAVING);
            boolean isPhantom = root.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM);
            boolean isCopied = root.hasBooleanProperty(NodeConstants.Info.COPIED);
            boolean isPushed = root.hasBooleanProperty(NodeConstants.Info.PUSHED);
            if (!(isHaving || isPhantom || isCopied || isPushed)) {
                if (root.getGroups().size() == 0 && QueryRewriter.FALSE_CRITERIA.equals(root.getProperty(NodeConstants.Info.SELECT_CRITERIA))) {
                    FrameUtil.replaceWithNullNode(root);
                    return;
                }
                boolean hasSubquery = FrameUtil.hasSubquery(root);
                if (!hasSubquery || CapabilitiesUtil.isEligibleSubquery(root, metadata, capFinder)) {
                    foundNodes.add(root);
                }
            }
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findCriteria(child, foundNodes, deadNodes, metadata, capFinder);
            }
        }
    }

    boolean pushTowardOriginatingNode(PlanNode critNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode sourceNode = null;
        if (critNode.getGroups().size() == 0 && FrameUtil.hasSubquery(critNode)) {
            Object modelID = this.getUniqueModel(critNode, metadata);
            if (modelID != null) {
                List allSrcNodes = NodeEditor.findAllNodes(critNode, 19);
                Iterator iter = allSrcNodes.iterator();
                while (iter.hasNext()) {
                    PlanNode node = (PlanNode)iter.next();
                    Set groups = node.getGroups();
                    GroupSymbol group = (GroupSymbol)groups.iterator().next();
                    Object srcModelID = metadata.getModelID(group.getMetadataID());
                    if (srcModelID == null || !srcModelID.equals(modelID)) continue;
                    sourceNode = node;
                    break;
                }
            }
        } else {
            sourceNode = FrameUtil.findOriginatingNode(critNode, critNode.getGroups());
        }
        if (sourceNode == null) {
            return false;
        }
        PlanNode[] destination = this.examinePath(critNode, sourceNode, metadata, capFinder);
        if (destination != null && destination[0] != null) {
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
            NodeEditor.insertNode(destination[0], destination[1], critNode);
            return true;
        }
        return false;
    }

    private Object getUniqueModel(PlanNode critNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        List plans = (List)critNode.getProperty(NodeConstants.Info.SUBQUERY_PLANS);
        if (plans == null) {
            return null;
        }
        Iterator planIter = plans.iterator();
        while (planIter.hasNext()) {
            Object plan = planIter.next();
            if (!(plan instanceof RelationalPlan)) continue;
            RelationalPlan subPlan = (RelationalPlan)plan;
            LinkedList<RelationalNode> nodes = new LinkedList<RelationalNode>();
            nodes.add(subPlan.getRootNode());
            while (nodes.size() > 0) {
                RelationalNode node = (RelationalNode)nodes.removeFirst();
                if (node instanceof AccessNode) {
                    Command command = ((AccessNode)node).getCommand();
                    Collection groups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)command, (boolean)true);
                    if (groups.size() <= 0) continue;
                    GroupSymbol group = (GroupSymbol)groups.iterator().next();
                    if (modelID == null) {
                        modelID = metadata.getModelID(group.getMetadataID());
                        continue;
                    }
                    if (modelID.equals(metadata.getModelID(group.getMetadataID()))) continue;
                    return null;
                }
                RelationalNode[] children = node.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] == null) continue;
                    nodes.add(children[i]);
                }
            }
        }
        return modelID;
    }

    PlanNode[] examinePath(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        PlanNode currentNode;
        if (sourceNode == null || this.atBoundary(critNode, sourceNode)) {
            return null;
        }
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Stack<PlanNode> path = new Stack<PlanNode>();
        for (currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            path.push(currentNode);
        }
        PlanNode destinationParent = null;
        PlanNode destinationChild = null;
        while (!path.empty()) {
            block12: {
                JoinType optimized;
                currentNode = (PlanNode)path.pop();
                if (currentNode.getType() == 3) {
                    Iterator groupIter;
                    GroupSymbol group = null;
                    if (critNode.getGroups().size() == 0) {
                        groupIter = sourceNode.getGroups().iterator();
                        group = (GroupSymbol)groupIter.next();
                    } else {
                        groupIter = critNode.getGroups().iterator();
                        group = (GroupSymbol)groupIter.next();
                    }
                    try {
                        if (metadata.isTemporaryGroup(group.getMetadataID())) {
                            destinationChild = currentNode;
                            break;
                        }
                        Object modelID = metadata.getModelID(group.getMetadataID());
                        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)crit, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
                            destinationChild = currentNode;
                            break;
                        }
                        break block12;
                    }
                    catch (QueryMetadataException e) {
                        throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0020", (Object)group));
                    }
                }
                if (currentNode.getType() == 7 && JoinUtil.doesJoinPreventCriteriaOptimization(currentNode, critNode) && ((optimized = JoinUtil.optimizeJoinType(critNode, currentNode)) == null || optimized.isOuter())) {
                    destinationChild = currentNode;
                    break;
                }
            }
            destinationParent = currentNode;
        }
        if (destinationChild == null) {
            destinationChild = path.isEmpty() ? sourceNode : (PlanNode)path.pop();
        }
        return new PlanNode[]{destinationParent, destinationChild};
    }

    boolean pushAcrossFrame(PlanNode sourceNode, PlanNode plan, PlanNode critNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        if (sourceNode.getChildCount() > 0) {
            PlanNode child = sourceNode.getFirstChild();
            if ((child = FrameUtil.findOriginatingNode(child, child.getGroups())) != null && child.getType() == 29) {
                return this.moveNodeAcrossUnion(critNode, child, metadata);
            }
        }
        if (this.canCrossSource(critNode, sourceNode, metadata) && this.canConvertSymbols(critNode, sourceNode)) {
            this.moveNodeAcrossFrame(critNode, sourceNode);
            return true;
        }
        return false;
    }

    boolean atBoundary(PlanNode critNode, PlanNode sourceNode) {
        for (PlanNode currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == 13) continue;
            return false;
        }
        return true;
    }

    boolean canCrossSource(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata) {
        if (sourceNode.getChildCount() == 0) {
            return false;
        }
        PlanNode projectNode = sourceNode.getFirstChild();
        if (projectNode.getType() == 11) {
            if (projectNode.getChildCount() > 0) {
                Command command;
                PlanNode procSourceNode;
                PlanNode accessNode = projectNode.getFirstChild();
                if (accessNode.getType() == 3 && accessNode.getChildCount() > 0 && (procSourceNode = accessNode.getFirstChild()).getType() == 19 && (command = (Command)procSourceNode.getProperty(NodeConstants.Info.VIRTUAL_COMMAND)) instanceof StoredProcedure) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    boolean canConvertSymbols(PlanNode critNode, PlanNode sourceNode) {
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Map symbolMap = (Map)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        return this.canConvertSymbols(crit, symbolMap);
    }

    boolean canConvertSymbols(Criteria crit, Map symbolMap) {
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            SingleElementSymbol element = (SingleElementSymbol)iter.next();
            Expression converted = (Expression)symbolMap.get(element);
            if (converted != null && !(converted instanceof AggregateSymbol)) continue;
            return false;
        }
        Iterator symbolIterator = symbolMap.values().iterator();
        while (symbolIterator.hasNext()) {
            Expression symbol = (Expression)symbolIterator.next();
            Collection scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)symbol);
            if (scalarSubqueries.isEmpty()) continue;
            return false;
        }
        return true;
    }

    void moveNodeAcrossFrame(PlanNode critNode, PlanNode sourceNode) throws QueryPlannerException {
        Assertion.isNotNull((Object)critNode.getParent());
        critNode.setProperty(NodeConstants.Info.IS_PHANTOM, Boolean.TRUE);
        PlanNode copyNode = this.copyNode(critNode);
        Map symbolMap = (Map)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        this.convertSelectNode(copyNode, symbolMap);
        PlanNode currentNode = sourceNode.getLastChild();
        PlanNode projectNode = null;
        boolean done = false;
        while (!done) {
            switch (currentNode.getType()) {
                case 11: {
                    projectNode = currentNode;
                    done = true;
                    break;
                }
                case 5: 
                case 17: {
                    break;
                }
                case 29: {
                    done = true;
                    break;
                }
                default: {
                    done = true;
                }
            }
            if (done) continue;
            currentNode = currentNode.getLastChild();
        }
        if (projectNode != null) {
            NodeEditor.insertNode(projectNode, projectNode.getLastChild(), copyNode);
        } else {
            NodeEditor.insertNode(sourceNode, sourceNode.getLastChild(), copyNode);
        }
    }

    PlanNode copyNode(PlanNode critNode) {
        Object depCrits;
        Object correlatedReferences;
        Object subqueryValueProviders;
        PlanNode copyNode = NodeFactory.getNewNode((int)13);
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Criteria copyCrit = (Criteria)crit.clone();
        copyNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, copyCrit);
        Object subqueryPlans = critNode.getProperty(NodeConstants.Info.SUBQUERY_PLANS);
        if (subqueryPlans != null) {
            copyNode.setProperty(NodeConstants.Info.SUBQUERY_PLANS, subqueryPlans);
        }
        if ((subqueryValueProviders = critNode.getProperty(NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS)) != null) {
            copyNode.setProperty(NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, subqueryValueProviders);
        }
        if ((correlatedReferences = critNode.getProperty(NodeConstants.Info.CORRELATED_REFERENCES)) != null) {
            copyNode.setProperty(NodeConstants.Info.CORRELATED_REFERENCES, correlatedReferences);
        }
        if ((depCrits = critNode.getProperty(NodeConstants.Info.DEPENDENT_SET_CRITS)) != null) {
            copyNode.setProperty(NodeConstants.Info.DEPENDENT_SET_CRITS, depCrits);
        }
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)copyCrit, (boolean)true);
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol element = (ElementSymbol)elementIter.next();
            copyNode.addGroup(element.getGroupSymbol());
        }
        return copyNode;
    }

    void convertSelectNode(PlanNode selectNode, Map symbolMap) throws QueryPlannerException {
        Criteria crit = (Criteria)selectNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        crit = FrameUtil.convertCriteria(crit, symbolMap);
        selectNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, crit);
        selectNode.getGroups().clear();
        selectNode.addGroups(FrameUtil.getGroups(crit));
    }

    boolean moveNodeAcrossUnion(PlanNode critNode, PlanNode unionNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        List firstProjectCols;
        if (!unionNode.getProperty(NodeConstants.Info.SET_OPERATION).equals(new Integer(0))) {
            return false;
        }
        PlanNode sourceNode = unionNode.getParent();
        while (sourceNode.getType() != 19) {
            sourceNode = sourceNode.getParent();
        }
        Map symbolMap = (Map)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        LinkedList unionChildren = new LinkedList();
        this.collectUnionChildren(unionNode, unionChildren);
        int movedCount = 0;
        Iterator childIter = unionChildren.iterator();
        PlanNode firstChild = (PlanNode)childIter.next();
        GroupSymbol sourceGroup = (GroupSymbol)sourceNode.getGroups().iterator().next();
        if (this.moveCritThroughUnion(critNode, firstChild, null, symbolMap, sourceGroup, metadata)) {
            ++movedCount;
        }
        if ((firstProjectCols = (List)firstChild.getProperty(NodeConstants.Info.PROJECT_COLS)) == null) {
            PlanNode firstBranchNode = firstChild;
            while (firstProjectCols == null) {
                firstBranchNode = firstBranchNode.getFirstChild();
                firstProjectCols = (List)firstBranchNode.getProperty(NodeConstants.Info.PROJECT_COLS);
            }
        }
        while (childIter.hasNext()) {
            PlanNode childNode = (PlanNode)childIter.next();
            if (!this.moveCritThroughUnion(critNode, childNode, firstProjectCols, symbolMap, sourceGroup, metadata)) continue;
            ++movedCount;
        }
        if (movedCount == unionChildren.size()) {
            critNode.setProperty(NodeConstants.Info.IS_PHANTOM, Boolean.TRUE);
            return true;
        }
        critNode.setProperty(NodeConstants.Info.PUSHED, Boolean.TRUE);
        return false;
    }

    void collectUnionChildren(PlanNode unionNode, LinkedList unionChildren) {
        if (unionNode.getFirstChild().getType() == 29) {
            this.collectUnionChildren(unionNode.getFirstChild(), unionChildren);
        } else {
            unionChildren.add(unionNode.getFirstChild());
        }
        unionChildren.add(unionNode.getLastChild());
    }

    boolean moveCritThroughUnion(PlanNode critNode, PlanNode subUnionRoot, List firstProjectSymbols, Map sourceMap, GroupSymbol sourceGroup, QueryMetadataInterface metadata) throws QueryPlannerException {
        PlanNode projectNode = NodeEditor.findNodePreOrder(subUnionRoot, 11);
        if (projectNode.getChildCount() == 0) {
            return false;
        }
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Criteria copyCrit = (Criteria)crit.clone();
        Map symbolMap = null;
        if (firstProjectSymbols == null) {
            symbolMap = sourceMap;
        } else {
            ArrayList<ElementSymbol> virtualElements = new ArrayList<ElementSymbol>(firstProjectSymbols.size());
            String groupName = sourceGroup.getName();
            Iterator firstProjIter = firstProjectSymbols.iterator();
            while (firstProjIter.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)firstProjIter.next();
                String symbolShortName = symbol.getShortName();
                ElementSymbol element = new ElementSymbol(groupName + "." + symbolShortName);
                element.setGroupSymbol(sourceGroup);
                element.setType(symbol.getType());
                virtualElements.add(element);
            }
            symbolMap = this.createSymbolMap((List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS), virtualElements, metadata);
        }
        if (!this.canConvertSymbols(copyCrit, symbolMap)) {
            return false;
        }
        copyCrit = FrameUtil.convertCriteria(copyCrit, symbolMap);
        PlanNode newCritNode = RuleBreakCriteria.createSelectNode(copyCrit);
        Boolean hasDepCrits = (Boolean)critNode.getProperty(NodeConstants.Info.DEPENDENT_SET_CRITS);
        if (hasDepCrits != null) {
            newCritNode.setProperty(NodeConstants.Info.DEPENDENT_SET_CRITS, hasDepCrits);
        }
        NodeEditor.insertNode(projectNode, projectNode.getFirstChild(), newCritNode);
        return true;
    }

    Map createSymbolMap(List laterSymbols, List virtualElements, QueryMetadataInterface metadata) {
        HashMap<ElementSymbol, Object> symbolMap = new HashMap<ElementSymbol, Object>();
        for (int i = 0; i < virtualElements.size(); ++i) {
            ElementSymbol virtualElement = (ElementSymbol)virtualElements.get(i);
            SingleElementSymbol laterSymbol = (SingleElementSymbol)laterSymbols.get(i);
            if (laterSymbol instanceof AliasSymbol) {
                laterSymbol = ((AliasSymbol)laterSymbol).getSymbol();
            }
            if (laterSymbol instanceof ExpressionSymbol && !(laterSymbol instanceof AggregateSymbol)) {
                symbolMap.put(virtualElement, ((ExpressionSymbol)laterSymbol).getExpression());
                continue;
            }
            symbolMap.put(virtualElement, laterSymbol);
        }
        return symbolMap;
    }

    boolean pushAcrossGroupBy(PlanNode plan, PlanNode critNode, PlanNode groupNode) {
        if (this.canMoveAcrossGroup(critNode, groupNode)) {
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
            NodeEditor.insertNode(groupNode, groupNode.getLastChild(), critNode);
            return true;
        }
        return false;
    }

    boolean canMoveAcrossGroup(PlanNode critNode, PlanNode groupNode) {
        List groupElements = (List)groupNode.getProperty(NodeConstants.Info.GROUP_COLS);
        if (groupElements != null) {
            Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            Set critElements = (Set)ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
            return groupElements.containsAll(critElements);
        }
        return false;
    }

    public String toString() {
        return "PushSelectCriteria";
    }
}

