/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RulePlanUnions
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        this.optimizeUnions(plan, metadata, capabilitiesFinder);
        return plan;
    }

    private void optimizeUnions(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder) throws QueryMetadataException, MetaMatrixComponentException {
        List unions = NodeEditor.findAllNodes(plan, 29, 87);
        Iterator i = unions.iterator();
        while (i.hasNext()) {
            PlanNode unionNode = (PlanNode)i.next();
            List accessNodes = NodeEditor.findAllNodes(unionNode, 3);
            Object id = this.getModelId(metadata, accessNodes, capabilitiesFinder);
            if (id != null) continue;
            LinkedHashMap sourceNodes = new LinkedHashMap();
            boolean all = Boolean.TRUE.equals(unionNode.getProperty(NodeConstants.Info.USE_ALL));
            this.collectUnionSources(metadata, capabilitiesFinder, unionNode, sourceNodes, all, (Integer)unionNode.getProperty(NodeConstants.Info.SET_OPERATION));
            if (sourceNodes.size() == 1) continue;
            boolean shouldRebuild = false;
            Iterator j = sourceNodes.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry entry = j.next();
                if (entry.getKey() == null || ((List)entry.getValue()).size() <= 1) continue;
                shouldRebuild = true;
                break;
            }
            if (!shouldRebuild) continue;
            LinkedList<PlanNode> sourceUnions = new LinkedList<PlanNode>();
            Iterator j2 = sourceNodes.entrySet().iterator();
            while (j2.hasNext()) {
                Map.Entry entry = j2.next();
                List sources = (List)entry.getValue();
                sourceUnions.add(this.buildUnionTree(unionNode, sources));
            }
            PlanNode tempRoot = this.buildUnionTree(unionNode, sourceUnions);
            unionNode.getChildren().clear();
            unionNode.getChildren().addAll(tempRoot.getChildren());
            Iterator j3 = unionNode.getChildren().iterator();
            while (j3.hasNext()) {
                PlanNode child = (PlanNode)j3.next();
                child.setParent(unionNode);
            }
        }
    }

    private PlanNode buildUnionTree(PlanNode rootUnionNode, List sources) {
        PlanNode root = null;
        Iterator k = sources.iterator();
        while (k.hasNext()) {
            PlanNode source = (PlanNode)k.next();
            if (k.hasNext()) {
                PlanNode union = NodeFactory.getNewNode((int)29);
                union.setProperty(NodeConstants.Info.SET_OPERATION, rootUnionNode.getProperty(NodeConstants.Info.SET_OPERATION));
                union.setProperty(NodeConstants.Info.USE_ALL, rootUnionNode.getProperty(NodeConstants.Info.USE_ALL));
                if (root != null) {
                    NodeEditor.attachLast(union, root);
                    union.addGroups(root.getGroups());
                }
                root = union;
            }
            if (root != null) {
                NodeEditor.attachLast(root, source);
                root.addGroups(source.getGroups());
                continue;
            }
            root = source;
        }
        return root;
    }

    private void collectUnionSources(QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, PlanNode unionNode, Map sourceNodes, boolean all, Integer setOp) throws QueryMetadataException, MetaMatrixComponentException {
        Iterator j = unionNode.getChildren().iterator();
        while (j.hasNext()) {
            Object id;
            List accessNodes;
            PlanNode child = (PlanNode)j.next();
            if (child.getType() == 29) {
                if (all == Boolean.TRUE.equals(child.getProperty(NodeConstants.Info.USE_ALL)) && setOp.equals(child.getProperty(NodeConstants.Info.SET_OPERATION))) {
                    accessNodes = NodeEditor.findAllNodes(child, 3);
                    id = this.getModelId(metadata, accessNodes, capabilitiesFinder);
                    if (id != null) {
                        this.buildModelMap(metadata, capabilitiesFinder, sourceNodes, child, id);
                        continue;
                    }
                    this.collectUnionSources(metadata, capabilitiesFinder, child, sourceNodes, all, setOp);
                    continue;
                }
                this.optimizeUnions(child, metadata, capabilitiesFinder);
                continue;
            }
            accessNodes = NodeEditor.findAllNodes(child, 3);
            id = this.getModelId(metadata, accessNodes, capabilitiesFinder);
            boolean supportsUnions = true;
            if (id != null && !CapabilitiesUtil.supportsUnion(id, metadata, capabilitiesFinder)) {
                supportsUnions = false;
                id = null;
            }
            this.buildModelMap(metadata, capabilitiesFinder, sourceNodes, child, id);
            if (id != null || !supportsUnions) continue;
            this.optimizeUnions(child, metadata, capabilitiesFinder);
        }
    }

    private Object getModelId(QueryMetadataInterface metadata, List accessNodes, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        Iterator k = accessNodes.iterator();
        while (k.hasNext()) {
            PlanNode accessNode = (PlanNode)k.next();
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
            if (accessModelID == null) {
                return null;
            }
            if (modelID == null) {
                modelID = accessModelID;
            }
            if (CapabilitiesUtil.isSameConnector(modelID, accessModelID, metadata, capFinder)) continue;
            return null;
        }
        return modelID;
    }

    private void buildModelMap(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Map accessMap, PlanNode node, Object accessModelID) throws QueryMetadataException, MetaMatrixComponentException {
        List<PlanNode> accessNodes = null;
        Iterator i = accessMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (accessModelID != entry.getKey() && !CapabilitiesUtil.isSameConnector(accessModelID, entry.getKey(), metadata, capFinder)) continue;
            accessNodes = (List)entry.getValue();
            break;
        }
        if (accessNodes == null) {
            accessNodes = new ArrayList<PlanNode>();
            accessMap.put(accessModelID, accessNodes);
        }
        accessNodes.add(node);
    }
}

