/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.db.model.component;

import com.metamatrix.metamodels.db.model.DBModelPlugin;
import com.metamatrix.metamodels.db.model.component.MetabaseRepositoryShredderComponent;
import com.metamatrix.metamodels.db.model.component.ShredderRequestKey;
import java.util.Iterator;
import java.util.List;

class StartupQueueingThread
extends Thread {
    private static final int DELAY_INIT_WAIT_TIME = 30000;
    private MetabaseRepositoryShredderComponent rep;

    StartupQueueingThread(MetabaseRepositoryShredderComponent repository) {
        super("ShredQueueingThread");
        this.rep = repository;
    }

    public void run() {
        try {
            ShredderRequestKey key;
            Iterator it;
            boolean hasQueue = false;
            List keys = null;
            keys = this.rep.getIDHelper().getKeysToRequeue("MetaDataShredding");
            if (keys != null && keys.size() > 0) {
                DBModelPlugin.Util.log(1, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Num_models_to_requeue", keys.size()));
                hasQueue = true;
            }
            boolean hasRequeue = false;
            List rkeys = this.rep.getIDHelper().getKeysToQueue("MetaDataShredding");
            if (rkeys != null && rkeys.size() > 0) {
                DBModelPlugin.Util.log(1, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.Num_models_to_queue", rkeys.size()));
                hasRequeue = true;
            }
            if (!hasQueue && !hasRequeue) {
                DBModelPlugin.Util.log(1, DBModelPlugin.Util.getString("MetabaseRepositoryShredderComponent.No_models_to_queue"));
                return;
            }
            Thread.sleep(30000L);
            if (hasQueue) {
                it = keys.iterator();
                while (it.hasNext()) {
                    key = (ShredderRequestKey)it.next();
                    this.rep.processNextRequest(key);
                }
            }
            if (hasRequeue) {
                it = rkeys.iterator();
                while (it.hasNext()) {
                    key = (ShredderRequestKey)it.next();
                    key = this.rep.getIDHelper().addModelToReQueue("MetaDataShredding", key);
                    this.rep.processNextRequest(key);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

