/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.ConnectorBinding;
import com.metamatrix.admin.api.objects.Entitlement;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.ScriptsContainer;
import com.metamatrix.admin.api.objects.SystemObject;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.admin.server.AdminServerPlugin;
import com.metamatrix.admin.server.ServerConfigAdminImpl;
import com.metamatrix.admin.server.ServerMonitoringAdminImpl;
import com.metamatrix.admin.server.ServerRuntimeStateAdminImpl;
import com.metamatrix.admin.server.ServerSecurityAdminImpl;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.PasswordCryptoFactory;
import com.metamatrix.core.proxy.SecurityContext;
import com.metamatrix.metabase.platform.DirectoryServiceFactory;
import com.metamatrix.metabase.platform.DirectoryServiceProxy;
import com.metamatrix.platform.admin.apiimpl.RuntimeStateAdminAPIHelper;
import com.metamatrix.platform.config.api.service.ConfigurationServiceProxy;
import com.metamatrix.platform.config.api.service.IConfigurationServiceProxy;
import com.metamatrix.platform.registry.MetaMatrixRegistry;
import com.metamatrix.platform.registry.MetaMatrixVMRegistry;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.registry.exception.RegistryException;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.service.AuthorizationServiceProxy;
import com.metamatrix.platform.security.api.service.IAuthorizationServiceProxy;
import com.metamatrix.platform.security.api.service.IMembershipServiceProxy;
import com.metamatrix.platform.security.api.service.ISessionServiceProxy;
import com.metamatrix.platform.security.api.service.MembershipServiceProxy;
import com.metamatrix.platform.security.api.service.SessionServiceProxy;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.util.PlatformProxyHelper;
import com.metamatrix.server.query.service.IQueryServiceProxy;
import com.metamatrix.server.query.service.QueryServiceProxy;
import com.metamatrix.server.util.ServerProxyHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ServerAdminImpl
implements ServerAdmin {
    private ServerRuntimeStateAdminImpl runtime = null;
    private ServerConfigAdminImpl config = null;
    private ServerMonitoringAdminImpl monitoring = null;
    private ServerSecurityAdminImpl security = null;
    private SessionServiceProxy sessionServiceProxy = null;
    private DirectoryServiceProxy directoryServiceProxy = null;
    private ConfigurationServiceProxy configurationServiceProxy = null;
    private MembershipServiceProxy membershipServiceProxy = null;
    private AuthorizationServiceProxy authorizationServiceProxy = null;
    private QueryServiceProxy queryServiceProxy = null;
    private ExtensionModuleManager extensionModuleManager = null;
    private RuntimeStateAdminAPIHelper runtimeStateAdminAPIHelper = null;
    private MetaMatrixRegistry metaMatrixRegistry = null;
    private SecurityContext securityContext = null;
    protected static final int SERVICE_WAIT_INTERVAL = 500;

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    protected MetaMatrixSessionID getSessionID() {
        long sessionIDValue = Long.parseLong(this.securityContext.getConnectionId());
        String userName = this.securityContext.getUserName();
        return new MetaMatrixSessionID(sessionIDValue, userName);
    }

    public Collection getCaches(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getCaches(identifier);
    }

    public Collection getConnectionPools(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getConnectionPools(identifier);
    }

    public Collection getConnectorBindings(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getConnectorBindings(identifier);
    }

    public Collection getConnectorBindingsInVDB(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getConnectorBindingsInVDB(identifier);
    }

    public Collection getConnectorTypes(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getConnectorTypes(identifier);
    }

    public Collection getDQPs(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getDQPs(identifier);
    }

    public Collection getExtensionModules(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getExtensionModules(identifier);
    }

    public Collection getHosts(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getHosts(identifier);
    }

    public Collection getProcesses(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getProcesses(identifier);
    }

    public Collection getQueueWorkerPools(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getQueueWorkerPools(identifier);
    }

    public Collection getRequests(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getRequests(identifier);
    }

    public Collection getResources(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getResources(identifier);
    }

    public Collection getSessions(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getSessions(identifier);
    }

    public Collection getSourceRequests(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getSourceRequests(identifier);
    }

    public SystemObject getSystem() throws AdminException {
        return this.getMonitoringAdmin().getSystem();
    }

    public Collection getVDBs(String identifier) throws AdminException {
        return this.getMonitoringAdmin().getVDBs(identifier);
    }

    public Collection getPropertyDefinitions(String identifier, String className) throws AdminException {
        return this.getMonitoringAdmin().getPropertyDefinitions(identifier, className);
    }

    public byte[] exportLogs() throws AdminException {
        return this.getMonitoringAdmin().exportLogs();
    }

    public ConnectorBinding addConnectorBinding(String connectorBindingIdentifier, String connectorTypeIdentifier, Properties props, AdminOptions options) throws AdminException {
        return this.getConfigurationAdmin().addConnectorBinding(connectorBindingIdentifier, connectorTypeIdentifier, props, options);
    }

    public ConnectorBinding addConnectorBinding(String name, char[] xmlFile, AdminOptions options) throws AdminException {
        return this.getConfigurationAdmin().addConnectorBinding(name, xmlFile, options);
    }

    public void addConnectorType(String name, char[] cdkFile) throws AdminException {
        this.getConfigurationAdmin().addConnectorType(name, cdkFile);
    }

    public void addConnectorArchive(byte[] archiveContents, AdminOptions options) throws AdminException {
        this.getConfigurationAdmin().addConnectorArchive(archiveContents, options);
    }

    public void addExtensionModule(String type, String sourceName, byte[] source, String description) throws AdminException {
        this.getConfigurationAdmin().addExtensionModule(type, sourceName, source, description);
    }

    public void addHost(String hostName, Properties properties) throws AdminException {
        this.getConfigurationAdmin().addHost(hostName, properties);
    }

    public void addProcess(String processIdentifier, Properties properties) throws AdminException {
        this.getConfigurationAdmin().addProcess(processIdentifier, properties);
    }

    public VDB addVDB(String name, byte[] vdbFile, AdminOptions options) throws AdminException {
        return this.getConfigurationAdmin().addVDB(name, vdbFile, options);
    }

    public VDB addVDB(String name, String version, String repositoryLocation) throws AdminException {
        return this.getConfigurationAdmin().addVDB(name, version, repositoryLocation);
    }

    public void changeVDBStatus(String name, String version, int status) throws AdminException {
        this.getRuntimeAdmin().changeVDBStatus(name, version, status);
    }

    public void disableHost(String identifier) throws AdminException {
        this.getConfigurationAdmin().disableHost(identifier);
    }

    public void disableProcess(String identifier) throws AdminException {
        this.getConfigurationAdmin().disableProcess(identifier);
    }

    public void enableHost(String identifier) throws AdminException {
        this.getConfigurationAdmin().enableHost(identifier);
    }

    public void enableProcess(String identifier) throws AdminException {
        this.getConfigurationAdmin().enableProcess(identifier);
    }

    public LogConfiguration getLogConfiguration() throws AdminException {
        return this.getConfigurationAdmin().getLogConfiguration();
    }

    public void setLogConfiguration(LogConfiguration config) throws AdminException {
        this.getConfigurationAdmin().setLogConfiguration(config);
    }

    public void setSystemProperty(String property, String value) throws AdminException {
        this.getConfigurationAdmin().setSystemProperty(property, value);
    }

    public void updateSystemProperties(Properties properties) throws AdminException {
        this.getConfigurationAdmin().updateSystemProperties(properties);
    }

    public void cancelRequest(String identifier) throws AdminException {
        this.getRuntimeAdmin().cancelRequest(identifier);
    }

    public void cancelSourceRequest(String identifier) throws AdminException {
        this.getRuntimeAdmin().cancelSourceRequest(identifier);
    }

    public void startConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        this.getRuntimeAdmin().startConnectorBinding(connectorBindingIdentifier);
    }

    public void startHost(String hostName, boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().startHost(hostName, waitUntilDone);
    }

    public void stopConnectorBinding(String connectorBindingIdentifier, boolean stopNow) throws AdminException {
        this.getRuntimeAdmin().stopConnectorBinding(connectorBindingIdentifier, stopNow);
    }

    public void stopHost(String hostName, boolean stopNow, boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().stopHost(hostName, stopNow, waitUntilDone);
    }

    public void stopProcess(String identifier, boolean stopNow, boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().stopProcess(identifier, stopNow, waitUntilDone);
    }

    public void startProcess(String identifier, boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().startProcess(identifier, waitUntilDone);
    }

    public void stopSystem() throws AdminException {
        this.getRuntimeAdmin().stopSystem();
    }

    public void bounceSystem(boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().bounceSystem(waitUntilDone);
    }

    public void synchronizeSystem(boolean waitUntilDone) throws AdminException {
        this.getRuntimeAdmin().synchronizeSystem(waitUntilDone);
    }

    public void terminateSession(String identifier) throws AdminException {
        this.getRuntimeAdmin().terminateSession(identifier);
    }

    public void clearCache(String cacheIdentifier) throws AdminException {
        this.getRuntimeAdmin().clearCache(cacheIdentifier);
    }

    public void setProperty(String identifier, String className, String propertyName, String propertyValue) throws AdminException {
        this.getConfigurationAdmin().setProperty(identifier, className, propertyName, propertyValue);
    }

    public void updateProperties(String identifier, String className, Properties properties) throws AdminException {
        this.getConfigurationAdmin().updateProperties(identifier, className, properties);
    }

    public void addUser(String identifier, String pwd) throws AdminException {
        this.getSecurityAdmin().addUser(identifier, pwd);
    }

    public void setUserProperties(String userIdentifier, Properties properties) throws AdminException {
        this.getSecurityAdmin().setUserProperties(userIdentifier, properties);
    }

    public void removeUser(String userIdentifier) throws AdminException {
        this.getSecurityAdmin().removeUser(userIdentifier);
    }

    public void addGroup(String identifier, String pwd) throws AdminException {
        this.getSecurityAdmin().addGroup(identifier, pwd);
    }

    public void addMemberToGroup(String memberIdentifier, String className, String parentIdentifier) throws AdminException {
        this.getSecurityAdmin().addMemberToGroup(memberIdentifier, className, parentIdentifier);
    }

    public void removeMemberFromGroup(String memberIdentifier, String className, String parentIdentifier) throws AdminException {
        this.getSecurityAdmin().removeMemberFromGroup(memberIdentifier, className, parentIdentifier);
    }

    public void deleteConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        this.getConfigurationAdmin().deleteConnectorBinding(connectorBindingIdentifier);
    }

    public void deleteConnectorType(String name) throws AdminException {
        this.getConfigurationAdmin().deleteConnectorType(name);
    }

    public void deleteExtensionModule(String sourceName) throws AdminException {
        this.getConfigurationAdmin().deleteExtensionModule(sourceName);
    }

    public void deleteHost(String identifier) throws AdminException {
        this.getConfigurationAdmin().deleteHost(identifier);
    }

    public void deleteProcess(String identifier) throws AdminException {
        this.getConfigurationAdmin().deleteProcess(identifier);
    }

    private synchronized ServerRuntimeStateAdminImpl getRuntimeAdmin() {
        if (this.runtime == null) {
            this.runtime = new ServerRuntimeStateAdminImpl(this);
        }
        return this.runtime;
    }

    private synchronized ServerConfigAdminImpl getConfigurationAdmin() {
        if (this.config == null) {
            this.config = new ServerConfigAdminImpl(this);
        }
        return this.config;
    }

    private synchronized ServerMonitoringAdminImpl getMonitoringAdmin() {
        if (this.monitoring == null) {
            this.monitoring = new ServerMonitoringAdminImpl(this);
        }
        return this.monitoring;
    }

    private synchronized ServerSecurityAdminImpl getSecurityAdmin() {
        if (this.security == null) {
            this.security = new ServerSecurityAdminImpl(this);
        }
        return this.security;
    }

    protected synchronized ISessionServiceProxy getSessionServiceProxy() throws ServiceException {
        if (this.sessionServiceProxy == null || !this.sessionServiceProxy.isConnected()) {
            this.sessionServiceProxy = PlatformProxyHelper.getSessionServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
            this.sessionServiceProxy.connect();
        }
        return this.sessionServiceProxy;
    }

    protected synchronized IConfigurationServiceProxy getConfigurationServiceProxy() throws ServiceException {
        if (this.configurationServiceProxy == null || !this.configurationServiceProxy.isConnected()) {
            this.configurationServiceProxy = PlatformProxyHelper.getConfigurationServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
            this.configurationServiceProxy.connect();
        }
        return this.configurationServiceProxy;
    }

    protected synchronized DirectoryServiceProxy getDirectoryServiceProxy() throws ServiceException {
        if (this.directoryServiceProxy == null || !this.directoryServiceProxy.isConnected()) {
            try {
                this.directoryServiceProxy = DirectoryServiceFactory.getDirectoryServiceProxy();
            }
            catch (RegistryException e) {
                throw new ServiceException((Throwable)e, AdminServerPlugin.Util.getString("ServerAdminImpl.Error_creating_DirectoryServiceProxy"));
            }
        }
        return this.directoryServiceProxy;
    }

    protected synchronized IMembershipServiceProxy getMembershipServiceProxy() throws ServiceException {
        if (this.membershipServiceProxy == null || !this.membershipServiceProxy.isConnected()) {
            this.membershipServiceProxy = PlatformProxyHelper.getMembershipServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
            this.membershipServiceProxy.connect();
        }
        return this.membershipServiceProxy;
    }

    protected synchronized IAuthorizationServiceProxy getAuthorizationServiceProxy() throws ServiceException {
        if (this.authorizationServiceProxy == null || !this.authorizationServiceProxy.isConnected()) {
            this.authorizationServiceProxy = PlatformProxyHelper.getAuthorizationServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
            this.authorizationServiceProxy.connect();
        }
        return this.authorizationServiceProxy;
    }

    protected synchronized IQueryServiceProxy getQueryServiceProxy() throws ServiceException {
        if (this.queryServiceProxy == null || !this.queryServiceProxy.isConnected()) {
            this.queryServiceProxy = ServerProxyHelper.getQueryServiceProxy((String)"ROUND_ROBIN_LOCAL_SELECTION_POLICY");
            this.queryServiceProxy.connect();
        }
        return this.queryServiceProxy;
    }

    protected ExtensionModuleManager getExtensionSourceManager() {
        if (this.extensionModuleManager == null) {
            this.extensionModuleManager = ExtensionModuleManager.getInstance();
        }
        return this.extensionModuleManager;
    }

    protected RuntimeStateAdminAPIHelper getRuntimeStateAdminAPIHelper() {
        if (this.runtimeStateAdminAPIHelper == null) {
            this.runtimeStateAdminAPIHelper = RuntimeStateAdminAPIHelper.getInstance();
        }
        return this.runtimeStateAdminAPIHelper;
    }

    protected MetaMatrixRegistry getMetaMatrixRegistry() throws RegistryException {
        if (this.metaMatrixRegistry == null) {
            this.metaMatrixRegistry = MetaMatrixVMRegistry.getInstance();
        }
        return this.metaMatrixRegistry;
    }

    public Collection getUsers(String userIdentifier) throws AdminException {
        return this.getSecurityAdmin().getUsers(userIdentifier);
    }

    public Collection getRolesForUser(String userIdentifier) throws AdminException {
        return this.getSecurityAdmin().getRolesForUser(userIdentifier);
    }

    public Collection getGroupsForUser(String userIdentifier, boolean explicitOnly) throws AdminException {
        return this.getSecurityAdmin().getGroupsForUser(userIdentifier, explicitOnly);
    }

    public Collection getUsersForGroup(String userIdentifier, boolean explicitOnly) throws AdminException {
        return this.getSecurityAdmin().getUsersForGroup(userIdentifier, explicitOnly);
    }

    public Collection getGroups(String groupIdentifier) throws AdminException {
        return this.getSecurityAdmin().getGroups(groupIdentifier);
    }

    public Collection getRolesForGroup(String groupIdentifier) throws AdminException {
        return this.getSecurityAdmin().getRolesForGroup(groupIdentifier);
    }

    public Collection getChildrenOfGroup(String groupIdentifier, boolean explicitOnly) throws AdminException {
        return this.getSecurityAdmin().getChildrenOfGroup(groupIdentifier, explicitOnly);
    }

    public Collection getParentsOfGroup(String groupIdentifier, boolean explicitOnly) throws AdminException {
        return this.getSecurityAdmin().getParentsOfGroup(groupIdentifier, explicitOnly);
    }

    public void assignRoleToUser(String roleIdentifier, String userIdentifier) throws AdminException {
        this.getSecurityAdmin().assignRoleToUser(roleIdentifier, userIdentifier);
    }

    public void assignBindingToModel(String connectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        this.getConfigurationAdmin().assignBindingToModel(connectorBindingName, vdbName, vdbVersion, modelName);
    }

    public void deassignBindingFromModel(String connectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        this.getConfigurationAdmin().deassignBindingFromModel(connectorBindingName, vdbName, vdbVersion, modelName);
    }

    public void assignBindingsToModel(String[] connectorBindingNames, String vdbName, String vdbVersion, String modelName) throws AdminException {
        this.getConfigurationAdmin().assignBindingsToModel(connectorBindingNames, vdbName, vdbVersion, modelName);
    }

    public void deassignBindingsFromModel(String[] connectorBindingNames, String vdbName, String vdbVersion, String modelName) throws AdminException {
        this.getConfigurationAdmin().deassignBindingsFromModel(connectorBindingNames, vdbName, vdbVersion, modelName);
    }

    public void removeRoleFromUser(String roleIdentifier, String userlIdentifier) throws AdminException {
        this.getSecurityAdmin().removeRoleFromUser(roleIdentifier, userlIdentifier);
    }

    public void importPrincipals(char[] fileContents) throws AdminException {
        this.getSecurityAdmin().importPrincipals(fileContents);
    }

    public void importEntitlements(char[] fileContents) throws AdminException {
        this.getSecurityAdmin().importEntitlements(fileContents);
    }

    public char[] exportPrincipals() throws AdminException {
        return this.getSecurityAdmin().exportPrincipals();
    }

    public char[] exportEntitlements() throws AdminException {
        return this.getSecurityAdmin().exportEntitlements();
    }

    public char[] exportConfiguration() throws AdminException {
        return this.getConfigurationAdmin().exportConfiguration();
    }

    public void importConfiguration(char[] fileData) throws AdminException {
        this.getConfigurationAdmin().importConfiguration(fileData);
    }

    public char[] exportConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        return this.getConfigurationAdmin().exportConnectorBinding(connectorBindingIdentifier);
    }

    public char[] exportConnectorType(String connectorTypeIdentifier) throws AdminException {
        return this.getConfigurationAdmin().exportConnectorType(connectorTypeIdentifier);
    }

    public byte[] exportConnectorArchive(String connectorTypeIdentifier) throws AdminException {
        return this.getConfigurationAdmin().exportConnectorArchive(connectorTypeIdentifier);
    }

    public byte[] exportExtensionModule(String sourceName) throws AdminException {
        return this.getConfigurationAdmin().exportExtensionModule(sourceName);
    }

    public byte[] exportVDB(String name, String version) throws AdminException {
        return this.getConfigurationAdmin().exportVDB(name, version);
    }

    public Entitlement createDataEntitlement(String displayName, String description, String vdbName, String vdbVersion) throws AdminException {
        return this.getSecurityAdmin().createDataEntitlement(displayName, description, vdbName, vdbVersion);
    }

    public void addPrincipalToDataEntitlement(String entitlementIdentifier, String userIdentifier) throws AdminException {
        this.getSecurityAdmin().addPrincipalToDataEntitlement(entitlementIdentifier, userIdentifier);
    }

    public void addPermissionToDataEntitlement(String entitlementIdentifier, String resourceName, String action) throws AdminException {
        this.getSecurityAdmin().addPermissionToDataEntitlement(entitlementIdentifier, resourceName, action);
    }

    public Entitlement createMetabaseEntitlement(String displayName, String description) throws AdminException {
        return this.getSecurityAdmin().createMetabaseEntitlement(displayName, description);
    }

    public Collection getDataEntitlementID(String vdbIdentifier) throws AdminException {
        return this.getSecurityAdmin().getDataEntitlementID(vdbIdentifier);
    }

    public void addPrincipalToMetaBaseEntitlement(String entitlementIdentifier, String principalIdentifier) throws AdminException {
        this.getSecurityAdmin().addPrincipalToMetaBaseEntitlement(entitlementIdentifier, principalIdentifier);
    }

    public void addPermissionToMetaBaseEntitlement(String entitlementIdentifier, String resourceName, String action) throws AdminException {
        this.getSecurityAdmin().addPermissionToMetaBaseEntitlement(entitlementIdentifier, resourceName, action);
    }

    public Encryptor getEncryptor() throws AdminException {
        try {
            return PasswordCryptoFactory.getEncryptor();
        }
        catch (CryptoException err) {
            AdminComponentException e = new AdminComponentException(AdminServerPlugin.Util.getString("ServerAdminImpl.Unable_to_aquire_encryptor"));
            e.initCause((Throwable)err);
            throw e;
        }
    }

    public void removeGroup(String groupIdentifier) throws AdminException {
        this.getSecurityAdmin().removeGroup(groupIdentifier);
    }

    public void assignRoleToGroup(String roleIdentifier, String groupIdentifier) throws AdminException {
        this.getSecurityAdmin().assignRoleToGroup(roleIdentifier, groupIdentifier);
    }

    public void removeRoleFromGroup(String roleIdentifier, String grouplIdentifier) throws AdminException {
        this.getSecurityAdmin().removeRoleFromGroup(roleIdentifier, grouplIdentifier);
    }

    public void setUserPassword(String userIdentifier, String pwd) throws AdminException {
        this.getSecurityAdmin().setUserPassword(userIdentifier, pwd);
    }

    public void close() {
    }

    protected void waitForServicesToStart(Collection expectedServiceNames) throws Exception {
        boolean done = false;
        while (!done) {
            done = this.areServicesAttempted(expectedServiceNames);
            Thread.sleep(500L);
        }
    }

    protected void waitForServicesToStop(Collection expectedServiceNames) throws Exception {
        boolean done = false;
        while (!done) {
            done = this.areServicesStopped(expectedServiceNames);
            Thread.sleep(500L);
        }
    }

    private boolean areServicesStopped(Collection expectedServiceNames) throws Exception {
        List serviceIDs = this.getRuntimeStateAdminAPIHelper().getServices(this.getMetaMatrixRegistry());
        Iterator iter = serviceIDs.iterator();
        while (iter.hasNext()) {
            int state;
            boolean stopped;
            ServiceID id = (ServiceID)iter.next();
            ServiceRegistryBinding serviceBinding = this.getRuntimeStateAdminAPIHelper().getServiceBinding(this.getMetaMatrixRegistry(), id);
            DeployedComponent deployedComponent = serviceBinding.getDeployedComponent();
            if (!expectedServiceNames.contains(deployedComponent.getID().getFullName()) || (stopped = this.isStateStopped(state = serviceBinding.getCurrentState()))) continue;
            return false;
        }
        return true;
    }

    private boolean areServicesAttempted(Collection expectedServiceNames) throws Exception {
        ArrayList<String> attemptedServiceNames = new ArrayList<String>();
        ArrayList<String> notAttemptedServiceNames = new ArrayList<String>();
        List serviceIDs = this.getRuntimeStateAdminAPIHelper().getServices(this.getMetaMatrixRegistry());
        Iterator iter = serviceIDs.iterator();
        while (iter.hasNext()) {
            ServiceID id = (ServiceID)iter.next();
            ServiceRegistryBinding serviceBinding = this.getRuntimeStateAdminAPIHelper().getServiceBinding(this.getMetaMatrixRegistry(), id);
            DeployedComponent deployedComponent = serviceBinding.getDeployedComponent();
            int state = serviceBinding.getCurrentState();
            boolean attempted = this.isStateAttempted(state);
            if (attempted) {
                attemptedServiceNames.add(deployedComponent.getID().getFullName());
                continue;
            }
            notAttemptedServiceNames.add(deployedComponent.getID().getFullName());
        }
        if (notAttemptedServiceNames.size() > 0) {
            return false;
        }
        return attemptedServiceNames.containsAll(expectedServiceNames);
    }

    private boolean isStateStopped(int state) {
        return state != 1 && state != 6;
    }

    private boolean isStateAttempted(int state) {
        return state == 1 || state == 3 || state == 4 || state == 6;
    }

    public ScriptsContainer generateMaterializationScripts(String vdbName, String vdbVersion, String metamatrixUserName, String metamatrixUserPwd, String materializationUserName, String materializationUserPwd) throws AdminException {
        return this.getConfigurationAdmin().generateMaterializationScripts(vdbName, vdbVersion, metamatrixUserName, metamatrixUserPwd, materializationUserName, materializationUserPwd);
    }
}

