/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.PlanHints;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.symbol.Symbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.FunctionCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class RuleRaiseAccess
implements OptimizerRule {
    private static final String AUTO_EXRESSION_ALIAS = "EXPR";

    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode accessNode;
        Iterator iter;
        List nodes;
        boolean raisedNode = true;
        while (raisedNode) {
            raisedNode = false;
            nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)0);
            iter = nodes.iterator();
            while (iter.hasNext()) {
                accessNode = (PlanNode)iter.next();
                PlanNode newRoot = this.raiseAccessNode(plan, accessNode, metadata, capFinder);
                if (newRoot == null) continue;
                raisedNode = true;
                plan = newRoot;
            }
        }
        nodes = NodeEditor.findAllNodes((PlanNode)plan, (int)0);
        iter = nodes.iterator();
        while (iter.hasNext()) {
            accessNode = (PlanNode)iter.next();
            plan = this.fixAccessFrame(plan, accessNode);
        }
        return plan;
    }

    PlanNode raiseAccessNode(PlanNode rootNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode parentNode = accessNode.getParent();
        if (parentNode == null) {
            return null;
        }
        switch (parentNode.getType()) {
            case 2: {
                Object modelID = RuleRaiseAccess.canRaiseOverJoin(parentNode, metadata, capFinder, false);
                if (modelID != null) {
                    this.raiseAccessOverJoin(parentNode, modelID);
                    return rootNode;
                }
                return null;
            }
            case 3: {
                List projectCols = (List)parentNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                ArrayList exprSymbols = new ArrayList(projectCols.size());
                Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (modelID == null) {
                    return null;
                }
                for (int i = 0; i < projectCols.size(); ++i) {
                    Expression expr;
                    SingleElementSymbol symbol = (SingleElementSymbol)projectCols.get(i);
                    if (!this.canPushSymbol(symbol, true, exprSymbols, modelID, metadata, capFinder)) {
                        return null;
                    }
                    boolean hasAlias = false;
                    if (symbol instanceof AliasSymbol) {
                        symbol = ((AliasSymbol)symbol).getSymbol();
                        hasAlias = true;
                    }
                    if (!(symbol instanceof ExpressionSymbol) || (expr = ((ExpressionSymbol)symbol).getExpression()) == null || expr instanceof Constant || !EvaluateExpressionVisitor.isRuntimeEvaluatable((LanguageObject)expr, true)) continue;
                    if (!hasAlias) {
                        return null;
                    }
                    exprSymbols.add(projectCols.get(i));
                }
                if (exprSymbols.size() > 0) {
                    accessNode.setProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED, exprSymbols);
                }
                return this.performRaise(rootNode, accessNode, parentNode);
            }
            case 1: {
                Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (modelID == null) {
                    return null;
                }
                if (CapabilitiesUtil.supportsSelectDistinct(modelID, metadata, capFinder)) {
                    return this.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 5: {
                Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (modelID == null) {
                    return null;
                }
                if (CapabilitiesUtil.supportsOrderBy(modelID, metadata, capFinder)) {
                    this.handleOrderBy(accessNode, parentNode);
                    return this.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 7: {
                Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (modelID == null || metadata.isVirtualModel(modelID)) {
                    return null;
                }
                List groupCols = (List)parentNode.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                if (CapabilitiesUtil.supportsAggregates(groupCols, modelID, metadata, capFinder) && this.checkParentAggregates(parentNode.getParent(), modelID, metadata, capFinder)) {
                    return this.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
            case 4: {
                GroupSymbol group;
                Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
                if (modelID == null) {
                    return null;
                }
                if (this.isHaving(parentNode)) {
                    if (!CapabilitiesUtil.supportsAggregates(null, modelID, metadata, capFinder)) {
                        return null;
                    }
                    Criteria crit = (Criteria)parentNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                    Collection aggregates = AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)crit, (boolean)true);
                    Iterator iter = aggregates.iterator();
                    while (iter.hasNext()) {
                        AggregateSymbol aggregate = (AggregateSymbol)iter.next();
                        if (CapabilitiesUtil.supportsAggregateFunction(modelID, aggregate, metadata, capFinder)) continue;
                        return null;
                    }
                    return this.performRaise(rootNode, accessNode, parentNode);
                }
                Criteria crit = (Criteria)parentNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit);
                if (groups.size() == 0) {
                    return null;
                }
                if (groups.size() == 1 && metadata.isTemporaryGroup((group = (GroupSymbol)groups.iterator().next()).getMetadataID())) {
                    return null;
                }
                boolean hasSubquery = FrameUtil.hasSubquery(parentNode);
                if (hasSubquery && !CapabilitiesUtil.isEligibleSubquery(parentNode, metadata, capFinder)) {
                    return null;
                }
                if (CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)crit, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
                    return this.performRaise(rootNode, accessNode, parentNode);
                }
                return null;
            }
        }
        return null;
    }

    private void handleOrderBy(PlanNode accessNode, PlanNode sortNode) {
        ArrayList expressionsCreated;
        List orderBySymbols = (List)sortNode.getProperty((Object)NodeConstants.Info.SORT_ORDER);
        List projectSymbols = null;
        List projectNodes = NodeEditor.findAllNodes((PlanNode)accessNode, (int)3);
        Assertion.assertTrue((projectNodes.size() <= 1 ? 1 : 0) != 0);
        if (projectNodes.size() == 1) {
            PlanNode projectNode = (PlanNode)projectNodes.get(0);
            projectSymbols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        }
        if (projectSymbols == null) {
            projectSymbols = new ArrayList();
        }
        if ((expressionsCreated = (ArrayList)accessNode.getProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED)) == null) {
            expressionsCreated = new ArrayList();
            accessNode.setProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED, expressionsCreated);
        }
        ArrayList orderBySymbolsCopy = new ArrayList(orderBySymbols);
        Iterator i = orderBySymbolsCopy.iterator();
        while (i.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)i.next();
            if (symbol instanceof AliasSymbol) {
                RuleRaiseAccess.processAliasedOrderBySymbol((AliasSymbol)symbol, expressionsCreated, orderBySymbols, projectSymbols);
                continue;
            }
            if (!(symbol instanceof ExpressionSymbol)) continue;
            RuleRaiseAccess.processOrderBySymbol(symbol, symbol, expressionsCreated, orderBySymbols, projectSymbols);
        }
    }

    private static void processAliasedOrderBySymbol(AliasSymbol aliasSymbol, List expressionsCreated, List orderBySymbols, List projectSymbols) {
        SingleElementSymbol aliased = aliasSymbol.getSymbol();
        int projectIndex = projectSymbols.indexOf(aliasSymbol);
        if (projectIndex != -1 && aliased instanceof ElementSymbol) {
            int orderByIndex = orderBySymbols.indexOf(aliasSymbol);
            if (orderByIndex != -1) {
                orderBySymbols.remove(orderByIndex);
                orderBySymbols.add(orderByIndex, aliased);
            }
            projectSymbols.remove(projectIndex);
            projectSymbols.add(projectIndex, aliased);
        } else if (projectIndex != -1 && aliased instanceof ExpressionSymbol) {
            RuleRaiseAccess.processOrderBySymbol((SingleElementSymbol)aliasSymbol, aliased, expressionsCreated, orderBySymbols, projectSymbols);
        }
    }

    private static void processOrderBySymbol(SingleElementSymbol symbol, SingleElementSymbol symbolToAlias, List expressionsCreated, List orderBySymbols, List projectSymbols) {
        String aliasName = RuleRaiseAccess.generateUniqueAlias(orderBySymbols, projectSymbols);
        AliasSymbol alias = new AliasSymbol(aliasName, symbolToAlias);
        int orderByIndex = orderBySymbols.indexOf(symbol);
        if (orderByIndex != -1) {
            orderBySymbols.remove(orderByIndex);
            orderBySymbols.add(orderByIndex, alias);
        }
        AliasSymbol selectAlias = new AliasSymbol(aliasName, symbolToAlias);
        int exprCreatedIndex = expressionsCreated.indexOf(symbol);
        if (exprCreatedIndex != -1) {
            expressionsCreated.remove(exprCreatedIndex);
            expressionsCreated.add(exprCreatedIndex, selectAlias);
        } else {
            expressionsCreated.add(selectAlias);
        }
        int projIndex = projectSymbols.indexOf(symbol);
        if (projIndex != -1) {
            projectSymbols.remove(projIndex);
            projectSymbols.add(projIndex, selectAlias);
        }
    }

    private static String generateUniqueAlias(List orderBySymbols, List expressionsCreated) {
        if (orderBySymbols.isEmpty() || expressionsCreated.isEmpty()) {
            return AUTO_EXRESSION_ALIAS;
        }
        HashSet<String> existingNames = new HashSet<String>();
        Iterator orderByVariables = orderBySymbols.iterator();
        while (orderByVariables.hasNext()) {
            Symbol next = (Symbol)orderByVariables.next();
            existingNames.add(next.getName().toUpperCase());
            if (!(next instanceof AliasSymbol)) continue;
            existingNames.add(((AliasSymbol)next).getSymbol().getName().toUpperCase());
        }
        Iterator selectSymbols = expressionsCreated.iterator();
        while (selectSymbols.hasNext()) {
            Symbol next = (Symbol)selectSymbols.next();
            existingNames.add(next.getName().toUpperCase());
            if (!(next instanceof AliasSymbol)) continue;
            existingNames.add(((AliasSymbol)next).getSymbol().getName().toUpperCase());
        }
        String tmpName = AUTO_EXRESSION_ALIAS;
        int incr = 1;
        while (existingNames.contains(tmpName)) {
            int index = tmpName.lastIndexOf("_" + (incr - 1));
            if (index != -1) {
                tmpName = tmpName.substring(0, index);
                tmpName = tmpName + "_" + incr;
            } else {
                tmpName = tmpName + "_" + incr;
            }
            ++incr;
        }
        return tmpName;
    }

    boolean canPushSymbol(SingleElementSymbol symbol, boolean inSelectClause, Collection createdExpressions, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws MetaMatrixComponentException, QueryMetadataException {
        Expression expr;
        if (symbol instanceof AliasSymbol) {
            symbol = ((AliasSymbol)symbol).getSymbol();
        }
        if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)symbol, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
            return false;
        }
        if (symbol instanceof ExpressionSymbol && (expr = ((ExpressionSymbol)symbol).getExpression()) != null && inSelectClause) {
            if (ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)expr).size() > 0) {
                return false;
            }
            if ((expr instanceof Constant || EvaluateExpressionVisitor.isRuntimeEvaluatable((LanguageObject)expr, true)) && !CapabilitiesUtil.supportsSelectLiterals(modelID, metadata, capFinder)) {
                return false;
            }
            if (!(expr instanceof Reference)) {
                createdExpressions.add(symbol);
            }
        }
        return true;
    }

    PlanNode performRaise(PlanNode rootNode, PlanNode accessNode, PlanNode parentNode) {
        NodeEditor.removeChildNode((PlanNode)parentNode, (PlanNode)accessNode);
        accessNode.setParent(null);
        PlanNode grandparentNode = parentNode.getParent();
        if (grandparentNode != null) {
            NodeEditor.insertNode((PlanNode)parentNode.getParent(), (PlanNode)parentNode, (PlanNode)accessNode);
            return rootNode;
        }
        NodeEditor.attachLast((PlanNode)accessNode, (PlanNode)parentNode);
        return accessNode;
    }

    boolean isHaving(PlanNode selectNode) {
        Boolean isHaving = (Boolean)selectNode.getProperty((Object)NodeConstants.Info.IS_HAVING);
        return isHaving != null && isHaving.equals(Boolean.TRUE);
    }

    boolean checkParentAggregates(PlanNode node, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        while (node != null && node.getType() != 6) {
            if (node.getType() == 4) {
                if (!this.isHaving(node)) {
                    return false;
                }
                Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                if (!CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)crit, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
                    return false;
                }
            } else if (node.getType() == 3) {
                List selectElements = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                Iterator selectIter = selectElements.iterator();
                while (selectIter.hasNext()) {
                    SingleElementSymbol element = (SingleElementSymbol)selectIter.next();
                    if (CriteriaCapabilityValidatorVisitor.canPushLanguageObject((LanguageObject)element, (Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) continue;
                    return false;
                }
            }
            node = node.getParent();
        }
        return true;
    }

    static Object canRaiseOverJoin(PlanNode joinNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, boolean isJoinParentOfJoin) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Object modelID = null;
        ArrayList<Object> groupIDs = new ArrayList<Object>();
        List children = joinNode.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            boolean isJoinNode;
            PlanNode childNode = (PlanNode)childIter.next();
            boolean isAccessNode = childNode.getType() == 0;
            boolean bl = isJoinNode = childNode.getType() == 2;
            if (!(isAccessNode || isJoinParentOfJoin && isJoinNode)) {
                return null;
            }
            Object accessModelID = RuleRaiseAccess.getModelIDFromAccess(childNode, metadata);
            if (accessModelID == null) {
                return null;
            }
            if (accessModelID.equals(modelID)) {
                joinNode.setProperty((Object)NodeConstants.Info.MODEL_ID, accessModelID);
            }
            boolean supportsSelfJoins = CapabilitiesUtil.supportsSelfJoins(accessModelID, metadata, capFinder);
            Iterator groupIter = childNode.getGroups().iterator();
            while (groupIter.hasNext()) {
                GroupSymbol groupSymbol = (GroupSymbol)groupIter.next();
                Object groupID = groupSymbol.getMetadataID();
                if (!supportsSelfJoins && groupIDs.contains(groupID)) {
                    return null;
                }
                groupIDs.add(groupID);
            }
            if (modelID == null) {
                if (!RuleRaiseAccess.isBlackBoxJoin(joinNode, metadata, accessModelID)) {
                    List crits = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                    if (CapabilitiesUtil.supportsJoins(accessModelID, metadata, capFinder)) {
                        JoinType type = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
                        if (type.isOuter() && !CapabilitiesUtil.supportsOuterJoin(accessModelID, type, metadata, capFinder)) {
                            return null;
                        }
                        if (crits != null) {
                            boolean hasExpression = false;
                            Iterator critIter = crits.iterator();
                            while (critIter.hasNext()) {
                                Criteria crit = (Criteria)critIter.next();
                                if (FunctionCollectorVisitor.getFunctions((LanguageObject)crit, (boolean)false).size() <= 0) continue;
                                hasExpression = true;
                                break;
                            }
                            if (hasExpression && !CapabilitiesUtil.supportsJoinExpression(accessModelID, crits, metadata, capFinder)) {
                                return null;
                            }
                        }
                        Set projectedGroups = null;
                        if (metadata.modelSupports(accessModelID, 10) && (projectedGroups = RuleRaiseAccess.getProjectedGroups(joinNode, metadata, capFinder)).size() > 1) {
                            return null;
                        }
                        if (metadata.modelSupports(accessModelID, 11)) {
                            if (projectedGroups == null) {
                                projectedGroups = RuleRaiseAccess.getProjectedGroups(joinNode, metadata, capFinder);
                            }
                            if (RuleRaiseAccess.isInvalidQueryForLeafSelectHandicap(joinNode, projectedGroups, crits, metadata)) {
                                return null;
                            }
                        }
                    } else {
                        return null;
                    }
                }
                modelID = accessModelID;
                continue;
            }
            if (modelID.equals(accessModelID)) continue;
            return null;
        }
        return modelID;
    }

    private static boolean isBlackBoxJoin(PlanNode joinNode, QueryMetadataInterface metadata, Object accessModelID) throws QueryMetadataException, MetaMatrixComponentException {
        boolean isBlackBoxJoin = false;
        List crits = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        if (metadata.modelSupports(accessModelID, 12) && crits != null) {
            Iterator critIter = crits.iterator();
            while (critIter.hasNext()) {
                CompareCriteria crit;
                PredicateCriteria predCrit = (PredicateCriteria)critIter.next();
                if (!(predCrit instanceof CompareCriteria) || !((crit = (CompareCriteria)predCrit).getLeftExpression() instanceof ElementSymbol) || !(crit.getRightExpression() instanceof ElementSymbol)) continue;
                ElementSymbol leftSymbol = (ElementSymbol)crit.getLeftExpression();
                ElementSymbol rightSymbol = (ElementSymbol)crit.getRightExpression();
                Object leftMetadataID = leftSymbol.getMetadataID();
                Object rightMetadataID = rightSymbol.getMetadataID();
                if (!RuleRaiseAccess.isJoinSAPRelation(leftSymbol, rightSymbol, metadata)) break;
                if (metadata.elementSupports(leftMetadataID, 1) && metadata.elementSupports(leftMetadataID, 2) && !metadata.elementSupports(leftMetadataID, 0)) {
                    isBlackBoxJoin = true;
                    continue;
                }
                if (!metadata.elementSupports(rightMetadataID, 1) || !metadata.elementSupports(rightMetadataID, 2) || metadata.elementSupports(rightMetadataID, 0)) break;
                isBlackBoxJoin = true;
            }
        }
        return isBlackBoxJoin;
    }

    private static boolean isJoinSAPRelation(ElementSymbol leftElement, ElementSymbol rightElement, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        boolean foundRelation = false;
        GroupSymbol rightGroup = rightElement.getGroupSymbol();
        Object rightGroupID = rightGroup.getMetadataID();
        GroupSymbol leftGroup = leftElement.getGroupSymbol();
        Object leftGroupID = leftGroup.getMetadataID();
        Collection rightForeignKeys = metadata.getForeignKeysInGroup(rightGroupID);
        Collection leftUniqueKeys = metadata.getUniqueKeysInGroup(leftGroupID);
        Iterator foreignKeyIter = rightForeignKeys.iterator();
        while (foreignKeyIter.hasNext()) {
            List primaryElemIDs;
            Object foreignKeyID = foreignKeyIter.next();
            Object primaryKeyID = metadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
            if (!leftUniqueKeys.contains(primaryKeyID) || (primaryElemIDs = metadata.getElementIDsInKey(primaryKeyID)).size() != 1 || !primaryElemIDs.contains(leftElement.getMetadataID())) continue;
            foundRelation = true;
            break;
        }
        if (!foundRelation) {
            Collection leftForeignKeys = metadata.getForeignKeysInGroup(leftGroupID);
            Collection rightUniqueKeys = metadata.getUniqueKeysInGroup(rightGroupID);
            foreignKeyIter = leftForeignKeys.iterator();
            while (foreignKeyIter.hasNext()) {
                List primaryElemIDs;
                Object foreignKeyID = foreignKeyIter.next();
                Object primaryKeyID = metadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
                if (!rightUniqueKeys.contains(primaryKeyID) || (primaryElemIDs = metadata.getElementIDsInKey(primaryKeyID)).size() != 1 || !primaryElemIDs.contains(rightElement.getMetadataID())) continue;
                foundRelation = true;
                break;
            }
        }
        return foundRelation;
    }

    static Set getProjectedGroups(PlanNode joinNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        HashSet projectedGroups = new HashSet();
        for (PlanNode parent = joinNode.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() == 4) {
                Criteria selectCrit = (Criteria)parent.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                boolean REMOVE_DUPLICATES = true;
                Collection singleElementSymbols = ElementCollectorVisitor.getElements((LanguageObject)selectCrit, (boolean)true);
                RuleRaiseAccess.collectProjectedGroups(singleElementSymbols, projectedGroups);
                continue;
            }
            if (parent.getType() == 3) {
                List projectCols = (List)parent.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                RuleRaiseAccess.collectProjectedGroups(projectCols, projectedGroups);
                continue;
            }
            if (parent.getType() == 7) {
                List groupCols = (List)parent.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                RuleRaiseAccess.collectProjectedGroups(groupCols, projectedGroups);
                continue;
            }
            if (parent.getType() != 2 || RuleRaiseAccess.canRaiseOverJoin(parent, metadata, capFinder, true) != null) continue;
            List joinCriteria = (List)parent.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
            Iterator i = joinCriteria.iterator();
            while (i.hasNext()) {
                Criteria crit = (Criteria)i.next();
                GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit, projectedGroups);
            }
        }
        return projectedGroups;
    }

    static void collectProjectedGroups(Collection singleElementSymbols, Set projectedGroups) {
        Iterator i = singleElementSymbols.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof ElementSymbol)) continue;
            ElementSymbol element = (ElementSymbol)obj;
            projectedGroups.add(element.getGroupSymbol());
        }
    }

    static boolean isInvalidQueryForLeafSelectHandicap(PlanNode joinNode, Collection projectGroupSymbols, List joinCriteria, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode selectNode;
        HashSet<Object> nonLeafGroupIDs = new HashSet<Object>();
        HashSet<Object> leafGroupIDs = new HashSet<Object>();
        Iterator i = joinCriteria.iterator();
        while (i.hasNext()) {
            boolean foundJoin = false;
            Criteria theCrit = (Criteria)i.next();
            if (theCrit instanceof CompareCriteria) {
                CompareCriteria join = (CompareCriteria)theCrit;
                ElementSymbol rightElement = (ElementSymbol)join.getRightExpression();
                ElementSymbol leftElement = (ElementSymbol)join.getLeftExpression();
                GroupSymbol rightGroup = rightElement.getGroupSymbol();
                Object rightGroupID = rightGroup.getMetadataID();
                GroupSymbol leftGroup = leftElement.getGroupSymbol();
                Object leftGroupID = leftGroup.getMetadataID();
                Collection rightKeys = metadata.getForeignKeysInGroup(rightGroup.getMetadataID());
                Iterator keysIter = rightKeys.iterator();
                while (keysIter.hasNext()) {
                    Object foreignKeyID = keysIter.next();
                    Object primaryKeyID = metadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
                    List primaryElemIDs = metadata.getElementIDsInKey(primaryKeyID);
                    Object targetGroupID = metadata.getGroupIDForElementID(primaryElemIDs.iterator().next());
                    if (!targetGroupID.equals(leftGroupID) || primaryElemIDs.size() != 1 || !primaryElemIDs.contains(leftElement.getMetadataID())) continue;
                    nonLeafGroupIDs.add(leftGroupID);
                    leafGroupIDs.add(rightGroupID);
                    leafGroupIDs.remove(leftGroupID);
                    foundJoin = true;
                    break;
                }
                if (!foundJoin) {
                    Collection leftKeys = metadata.getForeignKeysInGroup(leftGroup.getMetadataID());
                    keysIter = leftKeys.iterator();
                    while (keysIter.hasNext()) {
                        Object foreignKeyID = keysIter.next();
                        Object primaryKeyID = metadata.getPrimaryKeyIDForForeignKeyID(foreignKeyID);
                        List primaryElemIDs = metadata.getElementIDsInKey(primaryKeyID);
                        Object targetGroupID = metadata.getGroupIDForElementID(primaryElemIDs.iterator().next());
                        if (!targetGroupID.equals(rightGroupID) || primaryElemIDs.size() != 1 || !primaryElemIDs.contains(rightElement.getMetadataID())) continue;
                        nonLeafGroupIDs.add(rightGroupID);
                        leafGroupIDs.add(leftGroupID);
                        leafGroupIDs.remove(rightGroupID);
                        foundJoin = true;
                        break;
                    }
                }
            }
            if (foundJoin) continue;
            return true;
        }
        i = projectGroupSymbols.iterator();
        while (i.hasNext()) {
            GroupSymbol groupSymbol = (GroupSymbol)i.next();
            if (!nonLeafGroupIDs.contains(groupSymbol.getMetadataID())) continue;
            return true;
        }
        boolean childFilter = false;
        boolean parentFilter = false;
        List nodes = NodeEditor.findAllNodes((PlanNode)joinNode, (int)4);
        Iterator iter = nodes.iterator();
        while (iter.hasNext() && (selectNode = (PlanNode)iter.next()).getGroups().size() <= 1) {
            CompareCriteria compareCriteria;
            Criteria crit = (Criteria)selectNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            if (!(crit instanceof CompareCriteria) || !((compareCriteria = (CompareCriteria)crit).getLeftExpression() instanceof ElementSymbol) || !(compareCriteria.getRightExpression() instanceof Constant) || compareCriteria.getOperator() != 1) continue;
            GroupSymbol gs = (GroupSymbol)selectNode.getGroups().iterator().next();
            if (!RuleRaiseAccess.isIndexed((ElementSymbol)compareCriteria.getLeftExpression(), gs, metadata)) continue;
            if (leafGroupIDs.contains(gs.getMetadataID())) {
                childFilter = true;
                continue;
            }
            if (!nonLeafGroupIDs.contains(gs.getMetadataID())) continue;
            parentFilter = true;
        }
        return childFilter && !parentFilter;
    }

    private static boolean isIndexed(ElementSymbol symbol, GroupSymbol gs, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Collection indexes = metadata.getIndexesInGroup(gs.getMetadataID());
        Iterator i = indexes.iterator();
        while (i.hasNext()) {
            Object index = i.next();
            List elementIDs = metadata.getElementIDsInIndex(index);
            if (elementIDs.size() != 1 || !elementIDs.contains(symbol.getMetadataID())) continue;
            return true;
        }
        return false;
    }

    void raiseAccessOverJoin(PlanNode joinNode, Object modelID) {
        Object rightHint;
        PlanNode leftAccess = joinNode.getFirstChild();
        PlanNode rightAccess = joinNode.getLastChild();
        NodeEditor.removeChildNode((PlanNode)joinNode, (PlanNode)leftAccess);
        NodeEditor.removeChildNode((PlanNode)joinNode, (PlanNode)rightAccess);
        PlanNode parent = joinNode.getParent();
        PlanNode newAccess = NodeFactory.getNewNode((int)0);
        newAccess.setProperty((Object)NodeConstants.Info.MODEL_ID, modelID);
        newAccess.addGroups((Collection)rightAccess.getGroups());
        newAccess.addGroups((Collection)leftAccess.getGroups());
        Object leftHint = leftAccess.getProperty((Object)NodeConstants.Info.MAKE_DEP);
        if (leftHint != null) {
            newAccess.setProperty((Object)NodeConstants.Info.MAKE_DEP, leftHint);
        } else {
            rightHint = rightAccess.getProperty((Object)NodeConstants.Info.MAKE_DEP);
            if (rightHint != null) {
                newAccess.setProperty((Object)NodeConstants.Info.MAKE_DEP, rightHint);
            }
        }
        leftHint = leftAccess.getProperty((Object)NodeConstants.Info.MAKE_NOT_DEP);
        if (leftHint != null) {
            newAccess.setProperty((Object)NodeConstants.Info.MAKE_NOT_DEP, leftHint);
        } else {
            rightHint = rightAccess.getProperty((Object)NodeConstants.Info.MAKE_NOT_DEP);
            if (rightHint != null) {
                newAccess.setProperty((Object)NodeConstants.Info.MAKE_NOT_DEP, rightHint);
            }
        }
        leftAccess.setParent(null);
        rightAccess.setParent(null);
        NodeEditor.insertNode((PlanNode)parent, (PlanNode)joinNode, (PlanNode)newAccess);
    }

    static Object getModelIDFromAccess(PlanNode accessNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Object accessModelID = accessNode.getProperty((Object)NodeConstants.Info.MODEL_ID);
        if (accessModelID == null) {
            GroupSymbol group = (GroupSymbol)accessNode.getGroups().iterator().next();
            if (metadata.isVirtualGroup(group.getMetadataID())) {
                return null;
            }
            accessModelID = metadata.getModelID(group.getMetadataID());
            if (accessModelID == null) {
                return null;
            }
            accessNode.setProperty((Object)NodeConstants.Info.MODEL_ID, accessModelID);
        }
        return accessModelID;
    }

    private PlanNode fixAccessFrame(PlanNode rootNode, PlanNode accessNode) {
        PlanNode parentNode = accessNode.getParent();
        if (parentNode == null) {
            PlanNode newProject = this.copyLowerProjectNode(accessNode);
            NodeEditor.attachFirst((PlanNode)newProject, (PlanNode)accessNode);
            return newProject;
        }
        int type = parentNode.getType();
        if (type == 6 || type == 1 || type == 8 || type == 5) {
            PlanNode newProject = this.copyLowerProjectNode(accessNode);
            NodeEditor.insertNode((PlanNode)parentNode, (PlanNode)accessNode, (PlanNode)newProject);
        }
        return rootNode;
    }

    private PlanNode copyLowerProjectNode(PlanNode planNode) {
        while (planNode.getType() != 3) {
            planNode = planNode.getFirstChild();
        }
        PlanNode copyNode = NodeFactory.getNewNode((int)3);
        List projectCols = (List)planNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        int numCols = projectCols.size();
        ArrayList<Object> copyCols = new ArrayList<Object>(numCols);
        for (int i = 0; i < numCols; ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)projectCols.get(i);
            copyCols.add(symbol.clone());
        }
        copyNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, (Object)projectCols);
        planNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, copyCols);
        PlanHints hints = (PlanHints)planNode.getProperty((Object)NodeConstants.Info.PLAN_HINTS);
        copyNode.setProperty((Object)NodeConstants.Info.PLAN_HINTS, (Object)hints);
        List subqueryPlans = (List)planNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
        List subqueryValueProviders = (List)planNode.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
        List correlatedReferences = (List)planNode.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
        if (subqueryPlans != null) {
            copyNode.setProperty((Object)NodeConstants.Info.SUBQUERY_PLANS, (Object)subqueryPlans);
            copyNode.setProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, (Object)subqueryValueProviders);
        }
        if (correlatedReferences != null) {
            copyNode.setProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES, (Object)correlatedReferences);
        }
        List topCols = null;
        while (topCols == null && planNode != null && planNode.getType() != 0) {
            topCols = (List)planNode.getProperty((Object)NodeConstants.Info.TOP_COLS);
            planNode = planNode.getParent();
        }
        copyNode.setProperty((Object)NodeConstants.Info.TOP_COLS, topCols);
        return copyNode;
    }

    public String toString() {
        return "RaiseAccess";
    }
}

