/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.navigator.AggregateStopNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.sql.visitor.RemoveGroupAliasMappingVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleAssignOutputElements
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        PlanNode projectNode = RuleAssignOutputElements.findFirstProject(plan);
        if (projectNode == null) {
            return plan;
        }
        if (projectNode.getChildren() == null || projectNode.getChildren().isEmpty()) {
            boolean foundUnion = false;
            for (PlanNode searchNode = projectNode.getParent(); searchNode != null; searchNode = searchNode.getParent()) {
                if (searchNode.getType() != 8) continue;
                foundUnion = true;
                break;
            }
            if (!foundUnion) {
                projectNode.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
                return plan;
            }
        }
        List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
        this.assignOutputElements(plan, projectCols, metadata, capFinder);
        this.fixNoElements(plan, metadata, capFinder);
        return plan;
    }

    static PlanNode findFirstProject(PlanNode node) {
        if (node.getType() == 3) {
            return node;
        }
        List children = node.getChildren();
        if (children != null && children.size() > 0) {
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                PlanNode childNode = (PlanNode)childIter.next();
                PlanNode foundNode = RuleAssignOutputElements.findFirstProject(childNode);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    void findAllProjects(PlanNode node, List projects) {
        if (node.getType() == 3) {
            projects.add(node);
        } else {
            List children = node.getChildren();
            if (children != null && children.size() > 0) {
                Iterator childIter = children.iterator();
                while (childIter.hasNext()) {
                    PlanNode childNode = (PlanNode)childIter.next();
                    this.findAllProjects(childNode, projects);
                }
            }
        }
    }

    void assignOutputElements(PlanNode root, List outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        block15: {
            int nodeType;
            block14: {
                root.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, (Object)outputElements);
                nodeType = root.getType();
                if (nodeType != 0) break block14;
                Command command = (Command)root.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
                if (!(command instanceof Query)) break block15;
                Select select = ((Query)command).getSelect();
                select.clearSymbols();
                select.addSymbols((Collection)outputElements);
                this.removeGroupAliases(root, metadata, capFinder, select);
                OrderBy orderBy = ((Query)command).getOrderBy();
                if (orderBy != null) {
                    Iterator orderIter = orderBy.getVariables().iterator();
                    while (orderIter.hasNext()) {
                        SingleElementSymbol symbol = (SingleElementSymbol)orderIter.next();
                        if (select.containsSymbol((SelectSymbol)symbol)) continue;
                        select.addSymbol((SelectSymbol)symbol);
                        outputElements.add(symbol);
                    }
                }
                break block15;
            }
            if (nodeType == 6) {
                PlanNode virtualRoot = root.getLastChild();
                if (this.hasDupRemoval(virtualRoot)) {
                    Map symbolMap = (Map)root.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                    ArrayList removedSymbols = new ArrayList();
                    this.removeOptionalNodeColumns(root, symbolMap, (List)root.getProperty((Object)NodeConstants.Info.OUTPUT_COLS), removedSymbols);
                    List newOutputElements = this.createOrderedOutputElements(symbolMap.keySet(), this.findTopCols(virtualRoot, NodeConstants.Info.TOP_COLS));
                    root.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, (Object)newOutputElements);
                    if (!removedSymbols.isEmpty()) {
                        this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.TOP_COLS);
                        this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.OUTPUT_COLS);
                        this.removeUnusedColumnsInVirtualRoot(root, removedSymbols, NodeConstants.Info.PROJECT_COLS);
                    }
                }
                this.assignOutputElements(virtualRoot, this.filterVirtualElements(root, metadata), metadata, capFinder);
            } else if (nodeType == 8) {
                Iterator childIter = root.getChildren().iterator();
                while (childIter.hasNext()) {
                    PlanNode childNode = (PlanNode)childIter.next();
                    PlanNode projectNode = RuleAssignOutputElements.findFirstProject(childNode);
                    List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                    this.assignOutputElements(childNode, projectCols, metadata, capFinder);
                }
            } else if (nodeType != 9) {
                ArrayList requiredInput = new ArrayList();
                HashSet created = new HashSet();
                this.collectRequiredInputSymbols(root, requiredInput, created);
                Iterator currentIter = outputElements.iterator();
                while (currentIter.hasNext()) {
                    Object currentOutputSymbol = currentIter.next();
                    if (created.contains(currentOutputSymbol) || requiredInput.contains(currentOutputSymbol)) continue;
                    requiredInput.add(currentOutputSymbol);
                }
                if (root.getChildCount() == 1) {
                    this.assignOutputElements(root.getLastChild(), requiredInput, metadata, capFinder);
                } else {
                    Iterator childIter = root.getChildren().iterator();
                    while (childIter.hasNext()) {
                        PlanNode childNode = (PlanNode)childIter.next();
                        ArrayList filteredElements = new ArrayList();
                        this.collectFilteredElements(requiredInput, filteredElements, this.getSourceGroups(childNode));
                        this.assignOutputElements(childNode, filteredElements, metadata, capFinder);
                    }
                }
            }
        }
    }

    private List createOrderedOutputElements(Set virtualCols, List topCols) {
        if (topCols == null) {
            return new ArrayList(virtualCols);
        }
        HashSet remainingVirtual = new HashSet(virtualCols);
        ArrayList<SingleElementSymbol> newCols = new ArrayList<SingleElementSymbol>();
        Iterator topIter = topCols.iterator();
        block0: while (topIter.hasNext()) {
            SingleElementSymbol topSymbol = (SingleElementSymbol)topIter.next();
            String shortName = topSymbol.getShortCanonicalName();
            Iterator virtualIter = remainingVirtual.iterator();
            while (virtualIter.hasNext()) {
                SingleElementSymbol virtualSymbol = (SingleElementSymbol)virtualIter.next();
                if (!virtualSymbol.getShortCanonicalName().equals(shortName)) continue;
                newCols.add(virtualSymbol);
                virtualIter.remove();
                continue block0;
            }
        }
        return newCols;
    }

    private void removeUnusedColumnsInVirtualRoot(PlanNode sourceNode, List removedSymbols, Integer nodeProperty) {
        PlanNode virtualRoot = sourceNode.getLastChild();
        List cols = this.findTopCols(virtualRoot, nodeProperty);
        if (cols == null) {
            return;
        }
        block0: for (int i = 0; i < removedSymbols.size(); ++i) {
            SingleElementSymbol symbol = (SingleElementSymbol)removedSymbols.get(i);
            String shortName = symbol.getShortName();
            Iterator iter = new ArrayList(cols).iterator();
            while (iter.hasNext()) {
                SingleElementSymbol topCol = (SingleElementSymbol)iter.next();
                if (!shortName.equalsIgnoreCase(topCol.getShortName())) continue;
                cols.remove(topCol);
                continue block0;
            }
        }
    }

    private void removeGroupAliases(PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Select select) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = accessNode.getProperty((Object)NodeConstants.Info.MODEL_ID);
        if (modelID != null && !CapabilitiesUtil.supportsGroupAliases(modelID, metadata, capFinder)) {
            Map symbolMap = RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)select);
            accessNode.setProperty((Object)NodeConstants.Info.SYMBOL_MAP, (Object)symbolMap);
        } else if (modelID == null) {
            Iterator groups = accessNode.getGroups().iterator();
            while (groups.hasNext()) {
                GroupSymbol group = (GroupSymbol)groups.next();
                if (!group.hasAlias() || !group.isTempGroupSymbol()) continue;
                Map symbolMap = RemoveGroupAliasMappingVisitor.removeAliases((LanguageObject)select);
                accessNode.setProperty((Object)NodeConstants.Info.SYMBOL_MAP, (Object)symbolMap);
            }
        }
    }

    Collection getSourceGroups(PlanNode node) {
        HashSet groups = new HashSet();
        this.recurseGetSourceGroups(node, groups);
        return groups;
    }

    void recurseGetSourceGroups(PlanNode node, Collection groups) {
        int nodeType = node.getType();
        if (nodeType == 0 || nodeType == 6) {
            groups.addAll(node.getGroups());
        } else if (node.getChildCount() > 0) {
            Iterator iter = node.getChildren().iterator();
            while (iter.hasNext()) {
                PlanNode childNode = (PlanNode)iter.next();
                this.recurseGetSourceGroups(childNode, groups);
            }
        }
    }

    List filterVirtualElements(PlanNode sourceNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        int i;
        PlanNode virtualRoot = sourceNode.getLastChild();
        List outputColumns = (List)sourceNode.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
        ArrayList allProjects = new ArrayList();
        this.findAllProjects(virtualRoot, allProjects);
        int[] unfilteredIndices = null;
        if (outputColumns == null || outputColumns.size() == 0) {
            unfilteredIndices = new int[]{0};
        } else {
            List topCols = this.findTopCols(virtualRoot, NodeConstants.Info.TOP_COLS);
            unfilteredIndices = new int[outputColumns.size()];
            if (topCols == null) {
                for (i = 0; i < outputColumns.size(); ++i) {
                    unfilteredIndices[i] = i;
                }
            } else {
                for (i = 0; i < outputColumns.size(); ++i) {
                    unfilteredIndices[i] = -1;
                    SingleElementSymbol symbol = (SingleElementSymbol)outputColumns.get(i);
                    String shortName = symbol.getShortName();
                    for (int j = 0; j < topCols.size(); ++j) {
                        SingleElementSymbol topCol = (SingleElementSymbol)topCols.get(j);
                        if (!shortName.equalsIgnoreCase(topCol.getShortName())) continue;
                        unfilteredIndices[i] = j;
                        break;
                    }
                    if (unfilteredIndices[i] != -1) continue;
                    Assertion.failed((String)QueryExecPlugin.Util.getString("ERR.015.004.0058", (Object)shortName));
                }
            }
        }
        ArrayList firstProjColumns = null;
        for (i = 0; i < allProjects.size(); ++i) {
            PlanNode projectNode = (PlanNode)allProjects.get(i);
            List projectCols = (List)projectNode.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
            ArrayList newCols = new ArrayList();
            for (int j = 0; j < unfilteredIndices.length; ++j) {
                newCols.add(projectCols.get(unfilteredIndices[j]));
            }
            projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, newCols);
            if (i != 0) continue;
            firstProjColumns = newCols;
        }
        return firstProjColumns;
    }

    boolean hasDupRemoval(PlanNode node) {
        int nodeType = node.getType();
        if (nodeType == 0 || nodeType == 6 || nodeType == 2) {
            return false;
        }
        if (nodeType == 1 || nodeType == 5 && node.getFirstChild() != null && node.getFirstChild().getType() == 1) {
            return true;
        }
        if (nodeType == 8 && node.getProperty((Object)NodeConstants.Info.SET_OPERATION).equals(new Integer(0)) && node.getProperty((Object)NodeConstants.Info.USE_ALL).equals(Boolean.FALSE)) {
            return true;
        }
        if (node.getChildCount() > 0) {
            Iterator iter = node.getChildren().iterator();
            while (iter.hasNext()) {
                PlanNode childNode = (PlanNode)iter.next();
                boolean childHasNoAll = this.hasDupRemoval(childNode);
                if (!childHasNoAll) continue;
                return true;
            }
        }
        return false;
    }

    List findTopCols(PlanNode node, Integer nodeProperty) {
        List topCols = null;
        for (PlanNode tempNode = node; tempNode != null && (topCols = (List)tempNode.getProperty((Object)nodeProperty)) == null && tempNode.getChildCount() > 0; tempNode = tempNode.getFirstChild()) {
        }
        return topCols;
    }

    void collectRequiredInputSymbols(PlanNode node, Collection requiredSymbols, Set createdSymbols) {
        List<Expression> requiredSymbolsList = new ArrayList<SingleElementSymbol>();
        switch (node.getType()) {
            case 3: {
                GroupSymbol intoGroup = (GroupSymbol)node.getProperty((Object)NodeConstants.Info.INTO_GROUP);
                if (intoGroup == null) {
                    List projectCols = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                    Iterator projectIter = projectCols.iterator();
                    while (projectIter.hasNext()) {
                        SingleElementSymbol ss = (SingleElementSymbol)projectIter.next();
                        if (this.symbolCreatedHere(node, ss)) {
                            createdSymbols.add(ss);
                            if (ss instanceof AliasSymbol) {
                                ss = ((AliasSymbol)ss).getSymbol();
                            }
                            if (this.symbolCreatedHere(node, ss)) {
                                createdSymbols.add(ss);
                                Expression expression = ((ExpressionSymbol)ss).getExpression();
                                AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(requiredSymbolsList, requiredSymbolsList);
                                AggregateStopNavigator nav = new AggregateStopNavigator((LanguageVisitor)visitor);
                                expression.acceptVisitor((LanguageVisitor)nav);
                                continue;
                            }
                            requiredSymbolsList.add((Expression)ss);
                            continue;
                        }
                        requiredSymbolsList.add((Expression)ss);
                    }
                    break;
                }
                PlanNode childNode = node.getLastChild();
                Map symbolMap = (Map)childNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                PlanNode childProject = childNode.getLastChild();
                while (childProject.getType() != 3) {
                    childProject = childProject.getLastChild();
                }
                List projCols = (List)childProject.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                requiredSymbolsList = RuleAssignOutputElements.reverseSymbolLookup(projCols, symbolMap);
                createdSymbols.addAll((List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
                break;
            }
            case 4: {
                Criteria selectCriteria = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                Boolean isHaving = (Boolean)node.getProperty((Object)NodeConstants.Info.IS_HAVING);
                if (isHaving != null && isHaving.equals(Boolean.TRUE)) {
                    AggregateSymbolCollectorVisitor visitor = new AggregateSymbolCollectorVisitor(requiredSymbolsList, requiredSymbolsList);
                    AggregateStopNavigator nav = new AggregateStopNavigator((LanguageVisitor)visitor);
                    selectCriteria.acceptVisitor((LanguageVisitor)nav);
                    break;
                }
                ElementCollectorVisitor.getElements((LanguageObject)selectCriteria, requiredSymbolsList);
                break;
            }
            case 2: {
                List crits = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null) break;
                Iterator critIter = crits.iterator();
                while (critIter.hasNext()) {
                    Criteria joinCriteria = (Criteria)critIter.next();
                    ElementCollectorVisitor.getElements((LanguageObject)joinCriteria, requiredSymbolsList);
                }
                break;
            }
            case 1: 
            case 5: {
                requiredSymbolsList.addAll((List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS));
                break;
            }
            case 7: {
                List groupCols = (List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                if (groupCols != null) {
                    Iterator iter = groupCols.iterator();
                    while (iter.hasNext()) {
                        SingleElementSymbol symbol = (SingleElementSymbol)iter.next();
                        if (symbol instanceof ElementSymbol) {
                            requiredSymbolsList.add((Expression)symbol);
                            continue;
                        }
                        ExpressionSymbol exprSymbol = (ExpressionSymbol)symbol;
                        Expression expr = exprSymbol.getExpression();
                        ElementCollectorVisitor.getElements((LanguageObject)expr, requiredSymbolsList);
                        createdSymbols.add(exprSymbol);
                    }
                }
                ArrayList aggregateCols = (ArrayList)node.getProperty((Object)NodeConstants.Info.AGGREGATES);
                List outputCols = (List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
                Iterator outputIter = outputCols.iterator();
                while (outputIter.hasNext()) {
                    Object outputSymbol = outputIter.next();
                    if (!(outputSymbol instanceof AggregateSymbol)) continue;
                    if (aggregateCols == null) {
                        aggregateCols = new ArrayList();
                        node.setProperty((Object)NodeConstants.Info.AGGREGATES, aggregateCols);
                    }
                    aggregateCols.add(outputSymbol);
                }
                if (aggregateCols == null) break;
                createdSymbols.addAll(aggregateCols);
                Iterator aggIter = aggregateCols.iterator();
                while (aggIter.hasNext()) {
                    AggregateSymbol agg = (AggregateSymbol)aggIter.next();
                    Expression aggExpr = agg.getExpression();
                    if (aggExpr == null) continue;
                    if (aggExpr instanceof AggregateSymbol) {
                        requiredSymbolsList.add(aggExpr);
                        continue;
                    }
                    ElementCollectorVisitor.getElements((LanguageObject)aggExpr, requiredSymbolsList);
                }
                break;
            }
        }
        List refs = (List)node.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
        if (refs != null) {
            Iterator refIter = refs.iterator();
            while (refIter.hasNext()) {
                Reference ref = (Reference)refIter.next();
                Expression expr = ref.getExpression();
                ElementCollectorVisitor.getElements((LanguageObject)expr, requiredSymbolsList);
            }
        }
        if (node.getType() == 1 || node.getType() == 5) {
            requiredSymbols.addAll(requiredSymbolsList);
        } else {
            Iterator elementIter = requiredSymbolsList.iterator();
            while (elementIter.hasNext()) {
                Object symbol = elementIter.next();
                if (requiredSymbols.contains(symbol)) continue;
                requiredSymbols.add(symbol);
            }
        }
    }

    private void removeOptionalNodeColumns(PlanNode node, Map symbolMap, List outColumns, List removedSymbols) {
        if (node.getType() == 2) {
            if (Boolean.TRUE.equals(node.getProperty((Object)NodeConstants.Info.IS_RIGHT_OPTIONAL)) && Boolean.TRUE.equals(node.getProperty((Object)NodeConstants.Info.IS_LEFT_OPTIONAL))) {
                return;
            }
            HashSet groupsInOptionalNode = null;
            if (Boolean.TRUE.equals(node.getProperty((Object)NodeConstants.Info.IS_LEFT_OPTIONAL))) {
                groupsInOptionalNode = ((PlanNode)node.getChildren().get(0)).getGroups();
            }
            if (Boolean.TRUE.equals(node.getProperty((Object)NodeConstants.Info.IS_RIGHT_OPTIONAL))) {
                groupsInOptionalNode = ((PlanNode)node.getChildren().get(1)).getGroups();
            }
            if (groupsInOptionalNode != null) {
                groupsInOptionalNode = new HashSet(groupsInOptionalNode);
                Iterator<Object> iter = outColumns.iterator();
                while (iter.hasNext()) {
                    Object element = symbolMap.get(iter.next());
                    if (element == null || !(element instanceof ElementSymbol)) continue;
                    groupsInOptionalNode.remove(((ElementSymbol)element).getGroupSymbol());
                }
                if (!groupsInOptionalNode.isEmpty()) {
                    iter = new HashSet(symbolMap.entrySet()).iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        Object element = entry.getValue();
                        if (!(element instanceof ElementSymbol) || !groupsInOptionalNode.contains(((ElementSymbol)element).getGroupSymbol())) continue;
                        symbolMap.remove(entry.getKey());
                        removedSymbols.add(entry.getKey());
                    }
                }
            }
        }
        if (node.getChildCount() == 0) {
            return;
        }
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            PlanNode child = (PlanNode)iter.next();
            if (child.getType() == 6) continue;
            this.removeOptionalNodeColumns(child, symbolMap, outColumns, removedSymbols);
        }
    }

    public static List reverseSymbolLookup(List inputList, Map symbolMap) {
        ArrayList result = new ArrayList(inputList.size());
        HashMap reverseMap = new HashMap(symbolMap.size());
        Iterator mapIter = symbolMap.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry entry = mapIter.next();
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        Iterator projIter = inputList.iterator();
        while (projIter.hasNext()) {
            Expression projCol = (Expression)projIter.next();
            Object value = reverseMap.get(projCol);
            if (value == null && projCol instanceof ExpressionSymbol) {
                projCol = ((ExpressionSymbol)projCol).getExpression();
            }
            value = reverseMap.get(projCol);
            Assertion.isNotNull(value);
            result.add(value);
        }
        return result;
    }

    boolean symbolCreatedHere(PlanNode node, SingleElementSymbol symbol) {
        if (symbol instanceof ElementSymbol || symbol instanceof AggregateSymbol) {
            return false;
        }
        if (node.getChildCount() == 0) {
            return true;
        }
        node = node.getFirstChild();
        while (true) {
            switch (node.getType()) {
                case 0: {
                    List exprCreated = (List)node.getProperty((Object)NodeConstants.Info.EXPRESSIONS_CREATED);
                    if (exprCreated != null) {
                        return !exprCreated.contains(symbol);
                    }
                    return true;
                }
                case 7: {
                    List groupElements = (List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS);
                    if (groupElements != null) {
                        return !groupElements.contains(symbol);
                    }
                    return true;
                }
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    return true;
                }
            }
            node = node.getFirstChild();
        }
    }

    void collectFilteredElements(Collection sourceElements, Collection targetElements, Collection filterGroups) {
        if (sourceElements != null) {
            Iterator sourceIter = sourceElements.iterator();
            while (sourceIter.hasNext()) {
                Expression expr;
                SingleElementSymbol element = (SingleElementSymbol)sourceIter.next();
                if (element instanceof ElementSymbol) {
                    if (!filterGroups.contains(((ElementSymbol)element).getGroupSymbol())) continue;
                    targetElements.add(element);
                    continue;
                }
                if (element instanceof AggregateSymbol) {
                    expr = ((AggregateSymbol)element).getExpression();
                    if (expr != null) {
                        Collection aggElem = ElementCollectorVisitor.getElements((LanguageObject)expr, (boolean)true);
                        Iterator iter = aggElem.iterator();
                        while (iter.hasNext()) {
                            ElementSymbol elem = (ElementSymbol)iter.next();
                            if (!filterGroups.contains(elem.getGroupSymbol())) continue;
                            targetElements.add(element);
                        }
                        continue;
                    }
                    targetElements.add(element);
                    continue;
                }
                if (!(element instanceof ExpressionSymbol) || !filterGroups.containsAll(GroupsUsedByElementsVisitor.getGroups((LanguageObject)(expr = ((ExpressionSymbol)element).getExpression())))) continue;
                targetElements.add(element);
            }
        }
    }

    void fixNoElements(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ArrayList<ElementSymbol> outputElements;
        List children = plan.getChildren();
        if (children != null && children.size() > 0) {
            Iterator childIter = children.iterator();
            while (childIter.hasNext()) {
                this.fixNoElements((PlanNode)childIter.next(), metadata, capFinder);
            }
        }
        if ((outputElements = (ArrayList<ElementSymbol>)plan.getProperty((Object)NodeConstants.Info.OUTPUT_COLS)) == null || outputElements.size() == 0) {
            if (plan.getType() == 0) {
                ElementSymbol element = this.findSelectableElement(plan.getGroups(), metadata);
                if (element != null) {
                    if (outputElements == null) {
                        outputElements = new ArrayList<ElementSymbol>();
                        plan.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, outputElements);
                    }
                    outputElements.add(element);
                    Command command = (Command)plan.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
                    if (command.getType() == 1) {
                        Select select = ((Query)command).getSelect();
                        select.addSymbol((SelectSymbol)element);
                        this.removeGroupAliases(plan, metadata, capFinder, select);
                    }
                }
            } else if (plan.getType() != 9) {
                List childElements;
                PlanNode lastChild = plan.getLastChild();
                if (lastChild == null) {
                    Assertion.isNotNull((Object)lastChild, (String)QueryExecPlugin.Util.getString("ERR.015.004.0059"));
                }
                if ((childElements = (List)lastChild.getProperty((Object)NodeConstants.Info.OUTPUT_COLS)) != null && childElements.size() > 0) {
                    if (outputElements == null) {
                        outputElements = new ArrayList();
                        plan.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, outputElements);
                    }
                    outputElements.add((ElementSymbol)childElements.get(0));
                }
            }
        }
    }

    ElementSymbol findSelectableElement(Collection groups, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol group = null;
        ElementSymbol element = null;
        Iterator groupIter = groups.iterator();
        while (groupIter.hasNext() && group == null) {
            group = (GroupSymbol)groupIter.next();
            List elementIDs = metadata.getElementIDsInGroupID(group.getMetadataID());
            if (elementIDs.size() > 0) {
                Iterator elementIter = elementIDs.iterator();
                while (elementIter.hasNext() && element == null) {
                    Object elementID = elementIter.next();
                    String fullName = metadata.getFullName(elementID);
                    String shortName = metadata.getShortElementName(fullName);
                    String elementName = metadata.getFullElementName(group.getName(), shortName);
                    element = new ElementSymbol(elementName);
                    element.setGroupSymbol(group);
                    element.setMetadataID(elementID);
                    element.setType(DataTypeManager.getDataTypeClass((String)metadata.getElementType(elementID)));
                    if (metadata.elementSupports(element.getMetadataID(), 0)) continue;
                    element = null;
                }
            }
            if (element != null) continue;
            group = null;
        }
        return element;
    }

    public String toString() {
        return "AssignOutputElements";
    }
}

