/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.vm.controller;

import com.metamatrix.api.exception.MultipleException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.BufferManagerFactory;
import com.metamatrix.common.buffer.BufferManagerLookup;
import com.metamatrix.common.comm.ServerListenerRegistry;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.id.dbid.DBIDGenerator;
import com.metamatrix.common.log.DbLogListener;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.common.net.MMRMISocketFactory;
import com.metamatrix.common.pooling.api.ResourcePoolMgr;
import com.metamatrix.common.pooling.impl.ResourcePoolMgrImpl;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.remote.MMRemoteObject;
import com.metamatrix.common.util.ApplicationInfo;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.common.xa.TransactionManagerFactory;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.plugin.PlatformPluginRegistry;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import com.metamatrix.core.util.FileUtil;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.core.util.ZipFileUtil;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.exception.LicenseVerificationException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.ConfigurationChangeListener;
import com.metamatrix.platform.registry.MetaMatrixVMRegistry;
import com.metamatrix.platform.registry.ResourcePoolMgrID;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.registry.exception.RegistryException;
import com.metamatrix.platform.registry.exception.ServiceNotBoundException;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotLicensedException;
import com.metamatrix.platform.service.controller.ServiceController;
import com.metamatrix.platform.util.VMResources;
import com.metamatrix.platform.vm.api.controller.VMControllerInterface;
import com.metamatrix.platform.vm.controller.DistributedBufferManagerLookup;
import com.metamatrix.platform.vm.controller.SocketListenerStats;
import com.metamatrix.platform.vm.controller.VMControllerID;
import com.metamatrix.platform.vm.controller.VMStatistics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public abstract class VMController
extends MMRemoteObject
implements VMControllerInterface {
    private static final String STOP_DELAY_TIME = "metamatrix.vm.stop.delay.sec";
    private static final int DEFAULT_FORCE_SHUTDOWN_TIME = 30;
    private static final String pluginsFileName = "pluginList.txt";
    private PlatformPluginRegistry pluginRegistry = null;
    private static ConfigurationChangeListener configListener;
    private Host host;
    private static String hostName;
    private static String vmName;
    protected VMControllerID id;
    private ServiceController serviceController;
    private Date startTime;
    private Properties vmProps;
    private MessageBus messageBus;
    private BufferManager bufferManager;
    private ResourcePoolMgr resourcePoolMgr;
    private ConfigurationModelContainer configModel;
    private HostID hostID;
    private VMComponentDefn deployedVM;
    private VMComponentDefnID vmComponentDefnID;
    private boolean shuttingDown = false;
    private boolean resourcesCleanedUp = false;
    private boolean startDeployedServices;
    private int force_shutdown_time = 30;
    static /* synthetic */ Class class$com$metamatrix$platform$config$event$ConfigurationChangeEvent;

    public VMController(String vmName, String hostname, boolean startDeployedServices) throws Exception {
        RMISocketFactory.setSocketFactory(new MMRMISocketFactory());
        this.startDeployedServices = startDeployedServices;
        VMController.vmName = vmName;
        hostName = hostname;
        this.id = new VMControllerID(DBIDGenerator.getID((String)"VM"), hostname);
        this.init(hostname);
    }

    protected ServerListenerRegistry getServerListenerRegistry() {
        this.logMessage(PlatformPlugin.Util.getString("VMController.0"));
        return new ServerListenerRegistry(){

            public void setServerListener(ServerListener serverLitener) {
            }

            public void registerServiceInterceptor(String name, Class serviceName, ServiceInterceptor[] interceptor, TerminalServiceInterceptor terminal) {
            }

            public int getPort() {
                return 0;
            }

            public String getHost() {
                return "";
            }

            public ServerListener getServerListener() {
                return null;
            }

            public InetAddress getInetAddress() throws RemoteException {
                return null;
            }

            public void registerMBean(Object mBean, String mBeanName) {
            }
        };
    }

    protected void init(String hostname) throws Exception {
        this.initVMProperties(hostname);
        this.initMessaging();
        this.initLicensing();
        boolean passedLicenseCheck = LicenseChecker.hasValidProductLicense((String)"MetaMatrix Enterprise", (String)"5.0");
        if (!passedLicenseCheck) {
            Object[] params = new Object[]{"MetaMatrix Enterprise", "5.0"};
            String msg = PlatformPlugin.Util.getString("VMController.Not_licensed_for_enterprise", params);
            this.logCritical(msg);
            throw new ServiceNotLicensedException(msg);
        }
        this.initRegistry();
        this.initBufferManager();
        this.initPluginRegistry();
        this.initMessageBus();
        this.startTime = new Date();
        this.serviceController = new ServiceController(this);
        this.logCritical(PlatformPlugin.Util.getString("MSG.014.010.0006", (Object)this.id));
        MetaMatrixVMRegistry.registerVMController((VMControllerID)this.id, (VMComponentDefn)this.deployedVM, (VMControllerInterface)this);
        this.resourcePoolMgr = new ResourcePoolMgrImpl();
        ResourcePoolMgrID rpmID = new ResourcePoolMgrID(DBIDGenerator.getID((String)"ResourcePoolMgr"), this.id);
        MetaMatrixVMRegistry.registerResourcePoolMgr((ResourcePoolMgrID)rpmID, (ResourcePoolMgr)this.resourcePoolMgr);
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        }
        catch (Exception e) {
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0007"));
        }
        LogApplicationInfo logApplInfo = new LogApplicationInfo(this.host.getLogDirectory(), VMController.buildVMLogPrefix(hostname, vmName) + "_info.log", this);
        logApplInfo.start();
        if (this.startDeployedServices) {
            this.startDeployedServices();
        }
    }

    private ConfigurationModelContainer getConfigurationModel() throws Exception {
        if (this.configModel == null) {
            CurrentConfiguration.verifyBootstrapProperties();
        }
        this.configModel = CurrentConfiguration.getConfigurationModel();
        return this.configModel;
    }

    private void initVMProperties(String hostname) throws Exception {
        ConfigurationModelContainer config = this.getConfigurationModel();
        this.host = config.getHost(hostname);
        this.hostID = (HostID)this.host.getID();
        this.deployedVM = config.getConfiguration().getVMForHost(hostname, vmName);
        if (this.deployedVM != null) {
            String bindAddress = this.deployedVM.getBindAddress();
            if (bindAddress != null && bindAddress.length() > 0) {
                VMNaming.setBindAddress((String)bindAddress);
            }
            this.vmComponentDefnID = (VMComponentDefnID)this.deployedVM.getID();
            this.vmProps = config.getDefaultPropertyValues(this.deployedVM.getComponentTypeID());
            Properties props = config.getConfiguration().getAllPropertiesForComponent(this.deployedVM.getID());
            this.vmProps.putAll((Map<?, ?>)props);
            this.force_shutdown_time = PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)STOP_DELAY_TIME, (int)30);
            if (30 == this.force_shutdown_time) {
                this.force_shutdown_time = PropertiesUtils.getIntProperty((Properties)this.vmProps, (String)"vm.forced.shutdown.time", (int)30);
            }
            this.logMessage(PlatformPlugin.Util.getString("VMController.VM_Force_Shutdown_Time", this.force_shutdown_time));
        } else {
            this.logError(PlatformPlugin.Util.getString("MSG.014.010.0008", (Object)vmName, (Object)hostname));
        }
    }

    private void initMessaging() {
        this.messageBus = new VMMessageBus();
    }

    private void initRegistry() throws Exception {
        MetaMatrixVMRegistry.getInstance();
    }

    private void initBufferManager() throws Exception {
        try {
            DistributedBufferManagerLookup lookup = new DistributedBufferManagerLookup(this.getID());
            Properties props = new Properties();
            props.putAll((Map<?, ?>)CurrentConfiguration.getProperties());
            String dataDir = this.host.getDataDirectory();
            String relativeLoc = props.getProperty("metamatrix.buffer.relative.storageDirectory");
            String dir = FileUtils.buildDirectoryPath((String[])new String[]{dataDir, relativeLoc});
            props.setProperty("metamatrix.buffer.storageDirectory", dir);
            this.bufferManager = BufferManagerFactory.getServerBufferManager((BufferManagerLookup)lookup, (Properties)props);
        }
        catch (Exception e) {
            this.logException(e);
            throw e;
        }
    }

    private void initPluginRegistry() throws Exception {
        this.pluginRegistry = PlatformPluginRegistry.create((String)pluginsFileName);
        this.pluginRegistry.startup();
        this.logMessage(PlatformPlugin.Util.getString("VMController.PluginRegistry_started_1"));
    }

    protected static void initConfigurationEventListener(DbLogListener dll) throws Exception {
        configListener = new ConfigurationChangeListener(dll);
    }

    protected void initMessageBus() throws Exception {
        this.messageBus.addListener(class$com$metamatrix$platform$config$event$ConfigurationChangeEvent == null ? (class$com$metamatrix$platform$config$event$ConfigurationChangeEvent = VMController.class$("com.metamatrix.platform.config.event.ConfigurationChangeEvent")) : class$com$metamatrix$platform$config$event$ConfigurationChangeEvent, (EventObjectListener)configListener);
        this.logMessage(PlatformPlugin.Util.getString("VMController.Configuration_Event_Listener_started_2"));
    }

    private void initLicensing() throws Exception {
        LicenseChecker.Notifier notifier = new LicenseChecker.Notifier(){

            public void showFailureMessage(String message) {
                System.out.println(message);
                VMController.this.logError(message);
            }

            public void showInfoMessage(String message) {
                VMController.this.logMessage(message);
            }
        };
        LicenseChecker.registerNotifier((LicenseChecker.Notifier)notifier);
        LicenseChecker.loadLicense((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void logMessage(String s) {
        LogManager.logInfo((String)"CONTROLLER", (String)s);
    }

    protected void logCritical(String s) {
        LogManager.logCritical((String)"CONTROLLER", (String)s);
    }

    protected void logCritical(String s, Throwable e) {
        LogManager.logCritical((String)"CONTROLLER", (Throwable)e, (String)s);
    }

    protected void logError(String s) {
        LogManager.logError((String)"CONTROLLER", (String)s);
    }

    protected void logException(Throwable e) {
        LogManager.logError((String)"CONTROLLER", (Throwable)e, (String)PlatformPlugin.Util.getString("MSG.014.010.0009"));
    }

    protected static void doUsage() {
        System.out.println(PlatformPlugin.Util.getString("MSG.014.010.0010"));
        System.out.println(PlatformPlugin.Util.getString("MSG.014.010.0011"));
    }

    public VMControllerID getID() {
        return this.id;
    }

    public String getName() {
        return vmName;
    }

    public static String getVMName() {
        return vmName;
    }

    public void startDeployedServices() {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0013"));
        try {
            ConfigurationModelContainer configuration = this.getConfigurationModel();
            Collection deployedServices = configuration.getConfiguration().getDeployedServicesForVM(this.deployedVM);
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0014", (Object)new Integer(deployedServices.size()), (Object)this.vmComponentDefnID.getName()));
            ArrayList<DeployedComponent> platformServices = new ArrayList<DeployedComponent>();
            ArrayList<DeployedComponent> otherServices = new ArrayList<DeployedComponent>();
            if (deployedServices != null) {
                DeployedComponent depComp;
                Iterator servicesIterator = deployedServices.iterator();
                while (servicesIterator.hasNext()) {
                    depComp = (DeployedComponent)servicesIterator.next();
                    if (depComp.getProductServiceConfigID().getName().equals("PlatformStandard")) {
                        platformServices.add(depComp);
                        continue;
                    }
                    otherServices.add(depComp);
                }
                servicesIterator = platformServices.iterator();
                while (servicesIterator.hasNext()) {
                    depComp = (DeployedComponent)servicesIterator.next();
                    try {
                        this.startDeployedService(depComp, null, configuration, true);
                    }
                    catch (Exception e) {}
                }
                servicesIterator = otherServices.iterator();
                while (servicesIterator.hasNext()) {
                    depComp = (DeployedComponent)servicesIterator.next();
                    try {
                        this.startDeployedService(depComp, null, configuration, false);
                    }
                    catch (Exception e) {}
                }
            } else {
                this.logError(PlatformPlugin.Util.getString("MSG.014.010.0015", (Object)this.vmComponentDefnID.getName(), (Object)this.hostID.getName()));
            }
            this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0016", (Object)new Integer(deployedServices.size()), (Object)this.vmComponentDefnID.getName()));
        }
        catch (ConfigurationException e) {
            this.logError(PlatformPlugin.Util.getString("MSG.014.010.0017", (Object)this.vmComponentDefnID.getName(), (Object)this.hostID.getName()));
            this.logException(e);
        }
        catch (Exception e) {
            this.logException(e);
        }
    }

    public void startService(ServiceID serviceID) throws ServiceException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0018", (Object)serviceID));
        ServiceRegistryBinding binding = null;
        try {
            binding = MetaMatrixVMRegistry.getServiceBinding((ServiceID)serviceID);
        }
        catch (ServiceNotBoundException e) {
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0019", (Object)serviceID);
            this.logCritical(msg, e);
            throw new ServiceException((Throwable)e, msg);
        }
        catch (Exception e) {
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0020", (Object)serviceID);
            this.logCritical(msg, e);
            throw new ServiceException((Throwable)e, msg);
        }
        if (!binding.isServiceBad()) {
            throw new ServiceException(PlatformPlugin.Util.getString("MSG.014.010.0021", (Object)serviceID));
        }
        try {
            ConfigurationModelContainer configuration = this.getConfigurationModel();
            this.startDeployedService(binding.getDeployedComponent(), serviceID, configuration, true);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, PlatformPlugin.Util.getString("MSG.014.010.0022", (Object)serviceID));
        }
    }

    public void startDeployedService(ServiceComponentDefnID id) throws ServiceException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0023", (Object)id));
        this.startDeployedService(id, null);
    }

    private void startDeployedService(ServiceComponentDefnID defnID, ServiceID serviceID) throws ServiceException {
        try {
            ConfigurationModelContainer configuration = this.getConfigurationModel();
            DeployedComponent deployedService = configuration.getConfiguration().getDeployedServiceForVM(defnID, this.vmComponentDefnID, (HostID)this.getConfigHost().getID());
            this.startDeployedService(deployedService, serviceID, configuration, true);
        }
        catch (Exception e) {
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0024", (Object)defnID);
            this.logCritical(msg, e);
            throw new ServiceException((Throwable)e, msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startDeployedService(DeployedComponent deployedService, ServiceID serviceID, ConfigurationModelContainer configModel, boolean synch) throws ServiceException {
        try {
            Properties serviceProps = configModel.getDefaultPropertyValues(deployedService.getComponentTypeID());
            Properties props = configModel.getConfiguration().getAllPropertiesForComponent(deployedService.getID());
            serviceProps.putAll((Map<?, ?>)props);
            serviceProps.putAll((Map<?, ?>)this.host.getProperties());
            ProductServiceConfigID pscID = deployedService.getProductServiceConfigID();
            if (serviceProps == null) {
                String msg = PlatformPlugin.Util.getString("MSG.014.010.0027", (Object)deployedService.getServiceComponentDefnID().getName(), (Object)this.id, (Object)this.hostID.getName());
                this.logError(msg);
                throw new ServiceException(msg);
            }
            String serviceClassName = serviceProps.getProperty("ServiceClassName");
            if (serviceClassName != null && serviceClassName.length() > 0) {
                this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0025", (Object)deployedService.getServiceComponentDefnID().getName(), (Object)this.vmComponentDefnID.getName(), (Object)this.hostID.getName()));
                serviceProps.put("InstanceName", deployedService.getName());
                serviceProps.put("ServiceName", deployedService.getServiceComponentDefnID().getName());
                serviceProps.put("ComponentTypeName", deployedService.getComponentTypeID().getFullName());
                if (!deployedService.isDeployedConnector()) {
                    serviceProps.put("ServiceRoutingID", deployedService.getComponentTypeID().getFullName());
                } else {
                    ServiceComponentDefn scd = (ServiceComponentDefn)deployedService.getDeployedComponentDefn(configModel.getConfiguration());
                    String routingID = scd.getRoutingUUID();
                    serviceProps.put("ServiceRoutingID", routingID);
                }
                this.serviceController.startService(this.getServerListenerRegistry(), serviceClassName, serviceID, deployedService, pscID, serviceProps, synch);
                return;
            }
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0026", new Object[]{"ServiceClassName", deployedService.getServiceComponentDefnID().getName(), this.vmComponentDefnID.getName(), this.hostID.getName()});
            this.logError(msg);
            throw new ServiceException(msg);
        }
        catch (Exception e) {
            this.logException(e);
            String msg = PlatformPlugin.Util.getString("MSG.014.010.0028", (Object)deployedService.getServiceComponentDefnID().getName(), (Object)this.id, (Object)this.hostID.getName());
            this.logError(msg);
            throw new ServiceException((Throwable)e, msg);
        }
    }

    public void stopVM() throws ServiceException {
        this.logCritical(PlatformPlugin.Util.getString("MSG.014.010.0029"));
        this.doStopVM(false, false);
    }

    protected void doStopVM(boolean now, boolean shutdown) throws ServiceException {
        try {
            this.serviceController.stopServices(now, shutdown);
        }
        catch (MultipleException e) {
            this.logError(e.getMessage());
        }
        catch (ServiceException e) {
            this.logError(e.getMessage());
        }
        this.cleanUpResources();
        String propVal = System.getProperty("metamatrix.appserver_vm");
        if (propVal != null && propVal.equalsIgnoreCase("true")) {
            return;
        }
        Thread stopper = new Thread(){

            public void run() {
                try {
                    3.sleep(VMController.this.force_shutdown_time * 1000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(1);
            }
        };
        stopper.start();
    }

    private synchronized void cleanUpResources() {
        if (this.resourcesCleanedUp) {
            return;
        }
        this.resourcesCleanedUp = true;
        boolean txnSvcRunning = false;
        try {
            LicenseChecker.loadLicense((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            txnSvcRunning = LicenseChecker.hasValidProductLicense((String)"Query/Transactions", (String)"5.0");
        }
        catch (LicenseVerificationException e1) {
            txnSvcRunning = false;
        }
        if (txnSvcRunning) {
            try {
                TransactionManagerFactory.shutdown((boolean)true);
            }
            catch (XATransactionException e) {
                this.logCritical(PlatformPlugin.Util.getString("MSG.014.010.0030"), e);
            }
        }
        try {
            MetaMatrixVMRegistry.unregisterVMController((VMControllerID)this.getID());
        }
        catch (RegistryException e) {
            this.logException(e);
        }
        try {
            MetaMatrixVMRegistry.getInstance().close();
        }
        catch (Exception e) {
            this.logCritical(PlatformPlugin.Util.getString("MSG.014.010.0031"), e);
        }
        try {
            this.messageBus.shutdown();
            this.messageBus = null;
        }
        catch (Exception e) {
            this.logCritical(PlatformPlugin.Util.getString("MSG.014.010.0032"), e);
        }
        this.bufferManager = null;
        try {
            if (this.pluginRegistry == null) {
                this.pluginRegistry = PlatformPluginRegistry.instance();
            }
            this.pluginRegistry.shutdown();
        }
        catch (Exception e) {
            this.logCritical(PlatformPlugin.Util.getString("VMController.Problem_calling_shutdown()_on_PluginRegistry_3"), e);
        }
        try {
            configListener.shutdown();
        }
        catch (Exception e) {
            this.logCritical(PlatformPlugin.Util.getString("VMController.Probelm_calling_shutdown()_on_ConfigurationEventListener_4"), e);
        }
        LogManager.stop();
        try {
            this.resourcePoolMgr.shutDown();
            this.resourcePoolMgr = null;
        }
        catch (Exception e) {
            this.logCritical(PlatformPlugin.Util.getString("MSG.014.010.0033"), e);
        }
    }

    public void stopVMNow() throws ServiceException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0034"));
        this.doStopVM(true, false);
    }

    public void stopService(ServiceID id) throws ServiceException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0035", (Object)id));
        this.validateServiceID(id);
        this.serviceController.stopService(id, false, false);
    }

    public void stopServiceNow(ServiceID id) throws ServiceException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0036", (Object)id));
        this.validateServiceID(id);
        this.serviceController.stopService(id, true, false);
    }

    public void stopAllServicesNow() throws ServiceException, MultipleException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0037"));
        this.serviceController.stopServices(true, false);
    }

    public void stopAllServices() throws ServiceException, MultipleException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0038"));
        this.serviceController.stopServices(false, false);
    }

    public void checkService(ServiceID id) throws ServiceException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0054", (Object)id));
        this.validateServiceID(id);
        this.serviceController.checkService(id);
    }

    public void shutdown() throws ServiceException, RemoteException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0040"));
        this.doStopVM(false, true);
    }

    public void shutdownNow() throws ServiceException, RemoteException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0041"));
        this.doStopVM(true, true);
    }

    public void shutdownService(ServiceID serviceID) throws ServiceException, RemoteException {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0042", (Object)serviceID));
        ServiceRegistryBinding serviceBinding = null;
        try {
            serviceBinding = MetaMatrixVMRegistry.getServiceBinding((ServiceID)serviceID);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, PlatformPlugin.Util.getString("MSG.014.010.0043", (Object)serviceID));
        }
        this.validateServiceID(serviceID);
        if (serviceBinding.getService() != null && serviceBinding.getCurrentState() != 4) {
            this.serviceController.stopService(serviceID, false, true);
        }
        try {
            MetaMatrixVMRegistry.unregisterService((ServiceID)serviceID);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, PlatformPlugin.Util.getString("MSG.014.010.0044", (Object)serviceID));
        }
    }

    public void shutdownServiceNow(ServiceID serviceID) throws ServiceException, RemoteException {
        this.logMessage("Shutting down service now:" + serviceID);
        ServiceRegistryBinding serviceBinding = null;
        try {
            serviceBinding = MetaMatrixVMRegistry.getServiceBinding((ServiceID)serviceID);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, PlatformPlugin.Util.getString("MSG.014.010.0043", (Object)serviceID));
        }
        this.validateServiceID(serviceID);
        if (serviceBinding.getService() != null && serviceBinding.getCurrentState() != 4) {
            this.serviceController.stopService(serviceID, true, true);
        }
        try {
            MetaMatrixVMRegistry.unregisterService((ServiceID)serviceID);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, PlatformPlugin.Util.getString("MSG.014.010.0044", (Object)serviceID));
        }
    }

    public LogConfiguration getCurrentLogConfiguration() {
        return LogManager.getLogConfiguration();
    }

    public void setCurrentLogConfiguration(LogConfiguration logConfiguration) {
        this.logMessage(PlatformPlugin.Util.getString("MSG.014.010.0046", (Object)logConfiguration));
        LogManager.setLogConfiguration((LogConfiguration)logConfiguration);
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getHostname() {
        if (this.host != null) {
            return this.host.getFullName();
        }
        return hostName;
    }

    public Host getConfigHost() {
        return this.host;
    }

    public VMComponentDefn getConfigVM() {
        return this.deployedVM;
    }

    public void ping() {
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public VMStatistics getVMStatistics() {
        ThreadGroup tg;
        VMStatistics vmStats = new VMStatistics();
        Runtime rt = Runtime.getRuntime();
        vmStats.freeMemory = rt.freeMemory();
        vmStats.totalMemory = rt.totalMemory();
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while ((tg = root.getParent()) != null) {
            root = tg;
        }
        vmStats.threadCount = root.activeCount();
        vmStats.name = this.getName();
        vmStats.processPoolStats = this.getProcessPoolStats();
        vmStats.socketListenerStats = this.getSocketListenerStats();
        return vmStats;
    }

    public void dumpThreads() {
        ThreadGroup tg;
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while ((tg = root.getParent()) != null) {
            root = tg;
        }
        this.listThreads(root, 0);
    }

    private void listThreads(ThreadGroup tg, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("    ");
        }
        System.out.println(tg);
        ++indent;
        int cnt = tg.activeCount();
        Thread[] threads = new Thread[cnt];
        tg.enumerate(threads, false);
        for (int i = 0; i < cnt; ++i) {
            if (threads[i] == null) continue;
            for (int j = 0; j < indent; ++j) {
                System.out.print("    ");
            }
            System.out.println(threads[i]);
        }
        cnt = tg.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[cnt];
        tg.enumerate(groups);
        for (int i = 0; i < cnt; ++i) {
            this.listThreads(groups[i], indent);
        }
    }

    public void runGC() {
        this.logCritical(PlatformPlugin.Util.getString("MSG.014.010.0005"));
        System.gc();
    }

    private void validateServiceID(ServiceID serviceID) throws ServiceException {
        if (!serviceID.getVMControllerID().equals((Object)this.getID())) {
            throw new ServiceException(PlatformPlugin.Util.getString("MSG.014.010.0047", (Object)serviceID, (Object)this.id));
        }
    }

    protected static String buildVMLogPrefix(String hostName, String vmName) {
        String hostFileName = StringUtil.replaceAll((String)hostName, (String)".", (String)"_");
        return hostFileName + "_" + vmName;
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public byte[] exportLogs() throws ServiceException, RemoteException {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("logs", ".zip");
            tmpFile.deleteOnExit();
            String mainLogDirectory = this.host.getLogDirectory();
            ZipFileUtil.addAll((File)tmpFile, (String)mainLogDirectory, (String)"log");
            String hostLogDirectory = this.host.getProperty("metamatrix.host.dir") + File.separator + "log";
            ZipFileUtil.addAll((File)tmpFile, (String)hostLogDirectory, (String)("hosts_" + this.host.getName() + "_log"));
            String servletLogDirectory = this.host.getProperty("metamatrix.host.dir") + File.separator + "servletengine" + File.separator + "logs";
            ZipFileUtil.addAll((File)tmpFile, (String)servletLogDirectory, (String)("hosts_" + this.host.getName() + "_servletengine_log"));
            byte[] byArray = new FileUtil(tmpFile.getAbsolutePath()).readBytes();
            return byArray;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            try {
                tmpFile.delete();
            }
            catch (Exception e) {}
        }
    }

    public Properties getVMProperties() {
        return this.vmProps;
    }

    public abstract SocketListenerStats getSocketListenerStats();

    public abstract WorkerPoolStats getProcessPoolStats();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        VMResources.initResourceBundles();
        configListener = null;
    }

    private class ShutdownThread
    extends Thread {
        VMController vmController;

        public ShutdownThread(VMController vm) {
            this.vmController = vm;
        }

        public void run() {
            try {
                VMController.this.serviceController.stopServices(true, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.vmController.cleanUpResources();
        }
    }

    private class LogApplicationInfo
    extends Thread {
        String applFileName = null;
        String logPath = null;
        VMController vmcontroller;
        private static final String APPLICATION_PRODUCT_INFORMATION = "Product Information";

        public LogApplicationInfo(String path, String fileName, VMController vm) {
            this.applFileName = fileName;
            this.logPath = path;
            this.vmcontroller = vm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            InputStream is = null;
            ConfigurationModelContainer configmodel = VMController.this.getConfigurationModel();
            Properties configprops = null;
            ApplicationInfo info = ApplicationInfo.getInstance();
            info.setMainComponent("metamatrix-server.jar");
            StringBuffer sb = new StringBuffer();
            sb.append(info.toString());
            sb.append("\n---- System Properties ----\n");
            sb.append(PropertiesUtils.prettyPrint((Properties)System.getProperties()));
            sb.append("\n---- MM Global Properties ----\n");
            sb.append(PropertiesUtils.prettyPrint((Properties)configmodel.getConfiguration().getProperties()));
            sb.append("\n---- Host Properties ----\n");
            configprops = VMController.this.host.getProperties();
            sb.append(PropertiesUtils.prettyPrint((Properties)configprops));
            sb.append("\n# of Processors: " + Runtime.getRuntime().availableProcessors());
            sb.append("\nMax Avail memory: " + Runtime.getRuntime().maxMemory());
            sb.append("\nFree memory: " + Runtime.getRuntime().freeMemory());
            sb.append("\n\n---- VM Properties ----\n");
            sb.append(PropertiesUtils.prettyPrint((Properties)VMController.this.deployedVM.getProperties()));
            sb.append("\n---- JGroups Resource Properties ----\n");
            configprops = configmodel.getResource("JGroups").getProperties();
            sb.append(PropertiesUtils.prettyPrint((Properties)configprops));
            sb.append("\n---- WebServices Resource Properties ----\n");
            configprops = configmodel.getResource("WebServices").getProperties();
            sb.append(PropertiesUtils.prettyPrint((Properties)configprops));
            sb.append(info.getClasspathInfo());
            sb.append("\n\n---- Extension Jars Manifest Info ----\n");
            this.logManifestInfoForExtensionModules(sb);
            is = ByteArrayHelper.toInputStream((byte[])sb.toString().getBytes());
            File logFile = null;
            logFile = this.logPath == null || this.logPath.length() == 0 ? new File(this.applFileName) : new File(this.logPath, this.applFileName);
            FileUtils.write((InputStream)is, (File)logFile);
            is.close();
            Object var8_8 = null;
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException err) {}
            return;
            {
                catch (Exception e) {
                    System.err.println("Error writing application info to " + this.applFileName + ", msg: " + e.getMessage());
                    Object var8_9 = null;
                    if (is == null) return;
                    try {
                        is.close();
                        return;
                    }
                    catch (IOException err) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException err) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logManifestInfoForExtensionModules(StringBuffer sb) {
            Random random = new Random(System.currentTimeMillis());
            TempDirectory tempDir = null;
            try {
                tempDir = new TempDirectory(System.currentTimeMillis(), random.nextLong());
                tempDir.create();
                ExtensionModuleManager em = ExtensionModuleManager.getInstance();
                List descriptors = em.getSourceDescriptors("JAR File");
                if (descriptors != null) {
                    Iterator it = descriptors.iterator();
                    while (it.hasNext()) {
                        Attributes manifestAttributes;
                        ExtensionModuleDescriptor md = (ExtensionModuleDescriptor)it.next();
                        sb.append("\n == Jar: " + md.getName() + " ===== " + APPLICATION_PRODUCT_INFORMATION);
                        byte[] jardata = em.getSource(md.getName());
                        File f = new File(tempDir.getPath(), md.getName());
                        FileUtils.write((byte[])jardata, (File)f);
                        Manifest m = ZipFileUtil.getManifest((File)f);
                        if (m == null || (manifestAttributes = m.getAttributes(APPLICATION_PRODUCT_INFORMATION)) == null || manifestAttributes.isEmpty()) continue;
                        Iterator<Object> ita = manifestAttributes.keySet().iterator();
                        while (ita.hasNext()) {
                            Object n = ita.next();
                            Object v = manifestAttributes.get(n);
                            sb.append("\n");
                            sb.append("   ");
                            sb.append(n.toString());
                            sb.append(":        ");
                            sb.append(v.toString());
                        }
                        sb.append("\n");
                    }
                }
            }
            catch (Exception e) {
                sb.append("**** Error: Unable to list manifest - msg: " + e.getMessage());
            }
            finally {
                if (tempDir != null) {
                    tempDir.remove();
                }
            }
        }
    }
}

