/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.registry;

import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.pooling.api.ResourcePoolMgr;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.registry.MetaMatrixRegistryController;
import com.metamatrix.platform.registry.MetaMatrixRegistryImpl;
import com.metamatrix.platform.registry.ResourcePoolMgrBinding;
import com.metamatrix.platform.registry.ResourcePoolMgrID;
import com.metamatrix.platform.registry.ServiceRegistryBinding;
import com.metamatrix.platform.registry.VMRegistryBinding;
import com.metamatrix.platform.registry.event.RegistryEvent;
import com.metamatrix.platform.registry.exception.RegistryCommunicationException;
import com.metamatrix.platform.registry.exception.RegistryException;
import com.metamatrix.platform.registry.exception.ResourcePoolMgrAlreadyBoundException;
import com.metamatrix.platform.registry.exception.ServiceAlreadyBoundException;
import com.metamatrix.platform.registry.exception.ServiceNotBoundException;
import com.metamatrix.platform.registry.exception.VMControllerAlreadyBoundException;
import com.metamatrix.platform.registry.exception.VMControllerNotBoundException;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.vm.api.controller.VMControllerInterface;
import com.metamatrix.platform.vm.controller.VMControllerID;
import java.util.Date;
import java.util.EventObject;

class MetaMatrixRegistryControllerImpl
extends MetaMatrixRegistryImpl
implements MetaMatrixRegistryController {
    private boolean suspended = false;
    private boolean eventOccured = false;

    public MetaMatrixRegistryControllerImpl(MessageBus messageBus) throws RegistryException {
        super(messageBus);
    }

    public synchronized void unregisterService(ServiceID id) throws RegistryCommunicationException, RegistryException {
        try {
            this.getLocalVMRegistryBinding().removeService(id);
            this.broadcastLocalState();
        }
        catch (VMControllerNotBoundException vMControllerNotBoundException) {
            // empty catch block
        }
    }

    public synchronized void registerService(ServiceRegistryBinding serviceBinding) throws RegistryException, ServiceAlreadyBoundException, RegistryCommunicationException {
        try {
            this.getLocalVMRegistryBinding().addService(serviceBinding);
            this.broadcastLocalState();
        }
        catch (VMControllerNotBoundException e) {
            throw new RegistryException((Throwable)e, "ERR.014.006.0002", PlatformPlugin.Util.getString("ERR.014.006.0002"));
        }
    }

    public void registerResourcePoolMgr(ResourcePoolMgrID resourcePoolMgrID, ResourcePoolMgr resourcePoolMgr) throws RegistryCommunicationException, ResourcePoolMgrAlreadyBoundException, RegistryException {
        ResourcePoolMgrBinding rpmBinding = new ResourcePoolMgrBinding(resourcePoolMgrID, resourcePoolMgr);
        try {
            this.getLocalVMRegistryBinding().addResourcePoolMgr(rpmBinding);
            this.broadcastLocalState();
        }
        catch (VMControllerNotBoundException e) {
            throw new RegistryException((Throwable)e, "ERR.014.006.0002", PlatformPlugin.Util.getString("ERR.014.006.0002"));
        }
    }

    public synchronized void registerVMController(VMControllerID controllerID, VMComponentDefn vmComponent, VMControllerInterface controller) throws VMControllerAlreadyBoundException, RegistryCommunicationException, RegistryException {
        boolean alreadyExists = true;
        try {
            this.getVMController(controllerID);
        }
        catch (VMControllerNotBoundException e) {
            alreadyExists = false;
        }
        if (alreadyExists) {
            throw new VMControllerAlreadyBoundException("ERR.014.006.0001", PlatformPlugin.Util.getString("ERR.014.006.0001", (Object)controllerID));
        }
        this.getLocalHostRegistryBinding().addVMController(controllerID, vmComponent, controller);
        this.setVMControllerID(controllerID);
        this.broadcastLocalState();
    }

    public synchronized void unregisterVMController(VMControllerID controllerID) throws RegistryCommunicationException, RegistryException {
        this.getLocalHostRegistryBinding().removeVMController(controllerID);
        this.notifyOfVMControllerRemoved(controllerID);
    }

    public synchronized void changeServiceState(ServiceID serviceID, int state, Date timestamp) throws RegistryCommunicationException, ServiceNotBoundException, RegistryException {
        try {
            this.getLocalVMRegistryBinding().getServiceRegistryBinding(serviceID).updateState(state, timestamp);
            this.broadcastLocalState();
        }
        catch (VMControllerNotBoundException e) {
            throw new RegistryException((Throwable)e, "ERR.014.006.0002", PlatformPlugin.Util.getString("ERR.014.006.0002"));
        }
    }

    public void setServiceInitException(ServiceID serviceID, Throwable error) throws RegistryException {
        try {
            this.getLocalVMRegistryBinding().getServiceRegistryBinding(serviceID).setInitException(error);
            this.broadcastLocalState();
        }
        catch (VMControllerNotBoundException e) {
            throw new RegistryException((Throwable)e, "ERR.014.006.0002", PlatformPlugin.Util.getString("ERR.014.006.0002"));
        }
    }

    public synchronized void closeService(ServiceID serviceID) throws RegistryCommunicationException, ServiceNotBoundException, RegistryException {
        try {
            this.getLocalVMRegistryBinding().updateServiceInstance(serviceID, null);
            this.broadcastLocalState();
        }
        catch (VMControllerNotBoundException e) {
            throw new RegistryException((Throwable)e, "ERR.014.006.0002", PlatformPlugin.Util.getString("ERR.014.006.0002"));
        }
    }

    private void notifyOfVMControllerRemoved(VMControllerID vmControllerID) {
        RegistryEvent event = new RegistryEvent(this, 3, vmControllerID);
        try {
            if (this.messageBus != null) {
                this.messageBus.processEvent((EventObject)event);
            }
        }
        catch (MessagingException e) {
            LogManager.logError((String)"REGISTRY", (Throwable)e, (String)PlatformPlugin.Util.getString("ERR.014.006.0003", new Object[]{vmControllerID}));
        }
    }

    protected synchronized void broadcastLocalState() throws RegistryCommunicationException, RegistryException {
        if (this.suspended) {
            this.eventOccured = true;
            return;
        }
        VMRegistryBinding binding = null;
        try {
            binding = this.getLocalVMRegistryBinding();
        }
        catch (VMControllerNotBoundException e) {
            return;
        }
        RegistryEvent event = new RegistryEvent(this, 1, binding.getVMControllerID(), binding);
        try {
            if (this.messageBus != null) {
                this.messageBus.processEvent((EventObject)event);
            }
        }
        catch (MessagingException e) {
            throw new RegistryCommunicationException((Throwable)e, "ERR.014.006.0004", PlatformPlugin.Util.getString("ERR.014.006.0004"));
        }
        this.sendRegistryChangedEvent();
    }

    protected synchronized void doMarkServiceAsBad(ServiceID serviceID) {
        try {
            this.getLocalVMRegistryBinding().updateServiceInstance(serviceID, null);
            this.changeServiceState(serviceID, 3, new Date());
            String sServiceDetails = this.getLocalVMRegistryBinding().getServiceRegistryBinding(serviceID).toString();
            LogManager.logInfo((String)"REGISTRY", (String)PlatformPlugin.Util.getString("ERR.014.006.0027", new Object[]{serviceID}));
            LogManager.logInfo((String)"REGISTRY", (String)("Service: " + sServiceDetails));
        }
        catch (Exception e) {
            LogManager.logError((String)"REGISTRY", (Throwable)e, (String)PlatformPlugin.Util.getString("ERR.014.006.0005", new Object[]{serviceID}));
        }
    }

    public synchronized void suspendEvents(boolean suspend) throws RegistryException {
        if (suspend == this.suspended) {
            return;
        }
        this.suspended = suspend;
        if (this.suspended) {
            return;
        }
        if (this.eventOccured) {
            this.broadcastLocalState();
            this.eventOccured = false;
        }
    }
}

