/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core;

import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.core.AnnotationContainer;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.extension.XClass;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class ObjectExtension
extends EObjectImpl {
    private static final String DELIM = " ";
    private EObject extendedObject;
    private Annotation annotation;
    private ModelEditor editor;

    public ObjectExtension() {
    }

    public ObjectExtension(EObject extendedObject, XClass xclass, ModelEditor editor) {
        this.editor = editor;
        this.extendedObject = extendedObject;
        if (this.extendedObject != null && xclass != null) {
            super.eSetClass((EClass)xclass);
        }
    }

    public ObjectExtension(EObject extendedObject, XClass xclass) {
        this(extendedObject, xclass, null);
    }

    public EObject getExtendedObject() {
        return this.extendedObject;
    }

    public void setExtendedObject(EObject extendedObject) {
        this.extendedObject = extendedObject;
    }

    public void eDynamicSet(EStructuralFeature eFeature, Object newValue) {
        super.eDynamicSet(eFeature, newValue);
        if (this.extendedObject != null) {
            if (eFeature.isTransient() || !eFeature.isChangeable()) {
                return;
            }
            this.doDynamicSet(eFeature, newValue);
        }
    }

    public void eDynamicUnset(EStructuralFeature eFeature) {
        super.eDynamicUnset(eFeature);
        this.doDynamicUnset(eFeature);
    }

    public Object eDynamicGet(EStructuralFeature eFeature, boolean resolve) {
        Object result = null;
        if (this.extendedObject != null) {
            result = this.doDynamicGet(eFeature, result);
        }
        if (result == null) {
            result = super.eDynamicGet(eFeature, resolve);
        }
        return result;
    }

    public boolean eDynamicIsSet(EStructuralFeature eFeature) {
        return this.doDynamicIsSet(eFeature);
    }

    public static AnnotationContainer getAnnotationContainer(Resource eResource) {
        Iterator iter = eResource.getContents().iterator();
        while (iter.hasNext()) {
            EObject root = (EObject)iter.next();
            if (!(root instanceof AnnotationContainer)) continue;
            return (AnnotationContainer)root;
        }
        return null;
    }

    protected Annotation getAnnotation(boolean createIfRequired) {
        if (this.annotation == null && this.extendedObject != null) {
            if (this.editor == null) {
                Annotation existing;
                Resource resource = this.extendedObject.eResource();
                AnnotationContainer cntr = ObjectExtension.getAnnotationContainer(resource);
                if (cntr == null && createIfRequired) {
                    if (!ModelUtil.isXsdFile((Resource)resource)) {
                        cntr = CoreFactory.eINSTANCE.createAnnotationContainer();
                        resource.getContents().add((Object)cntr);
                    } else {
                        return null;
                    }
                }
                if ((existing = cntr.findAnnotation(this.extendedObject)) != null) {
                    return existing;
                }
                if (createIfRequired) {
                    Annotation ann = CoreFactory.eINSTANCE.createAnnotation();
                    ann.setAnnotatedObject(this.extendedObject);
                    cntr.getAnnotations().add((Object)ann);
                    return ann;
                }
                return null;
            }
            try {
                ModelEditor ed = this.getModelEditor();
                this.annotation = ed.getAnnotation(this.extendedObject, createIfRequired);
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return this.annotation;
    }

    protected ModelEditor getModelEditor() {
        if (this.editor == null) {
            this.editor = ModelerCore.getModelEditor();
        }
        return this.editor;
    }

    protected void doDynamicSet(EStructuralFeature eFeature, Object newValue) {
        Annotation annotation = this.getAnnotation(true);
        if (annotation != null) {
            EMap tags = annotation.getTags();
            String key = eFeature.getName();
            if (newValue == null || "".equals(newValue)) {
                tags.removeKey((Object)key);
            } else {
                EDataType dt = (EDataType)eFeature.getEType();
                EPackage ePackage = dt.getEPackage();
                EFactory fac = ePackage.getEFactoryInstance();
                String newStringValue = null;
                if (eFeature.isMany()) {
                    List values = (List)newValue;
                    Iterator iter = values.iterator();
                    while (iter.hasNext()) {
                        Object value = iter.next();
                        if (newStringValue == null) {
                            newStringValue = fac.convertToString(dt, value);
                            continue;
                        }
                        newStringValue = newStringValue + DELIM + fac.convertToString(dt, value);
                    }
                } else {
                    newStringValue = fac.convertToString(dt, newValue);
                }
                tags.put((Object)key, (Object)newStringValue);
            }
        }
    }

    protected void doDynamicUnset(EStructuralFeature eFeature) {
        Annotation annotation;
        if (this.extendedObject != null && (annotation = this.getAnnotation(false)) != null) {
            EMap tags = annotation.getTags();
            String key = eFeature.getName();
            tags.removeKey((Object)key);
        }
    }

    protected Object doDynamicGet(EStructuralFeature eFeature, Object result) {
        block8: {
            String value;
            EFactory fac;
            EDataType dt;
            block9: {
                Annotation annotation = this.getAnnotation(true);
                if (annotation == null) break block8;
                EMap tags = annotation.getTags();
                String key = eFeature.getName();
                dt = (EDataType)eFeature.getEType();
                EPackage ePackage = dt.getEPackage();
                fac = ePackage.getEFactoryInstance();
                value = (String)tags.get((Object)key);
                if (value == null || "".equals(value)) {
                    Object defaultValue = eFeature.getDefaultValue();
                    if (defaultValue != null && !"".equals(defaultValue)) {
                        value = defaultValue.toString();
                    } else {
                        Object typeDefault = dt.getDefaultValue();
                        String string = value = typeDefault != null ? typeDefault.toString() : null;
                    }
                }
                if (!eFeature.isMany()) break block9;
                BasicEList values = new BasicEList();
                result = values;
                StringTokenizer stringTokenizer = new StringTokenizer(value, DELIM);
                if (!stringTokenizer.hasMoreTokens()) break block8;
                while (stringTokenizer.hasMoreTokens()) {
                    String token = stringTokenizer.nextToken();
                    try {
                        values.add(fac.createFromString(dt, token));
                    }
                    catch (RuntimeException theException) {
                        values.add(token);
                    }
                }
                break block8;
            }
            try {
                result = fac.createFromString(dt, value);
            }
            catch (RuntimeException theException) {
                result = value;
            }
        }
        return result;
    }

    protected boolean doDynamicIsSet(EStructuralFeature eFeature) {
        Annotation annotation;
        if (this.extendedObject != null && (annotation = this.getAnnotation(false)) != null) {
            String key;
            EMap tags = annotation.getTags();
            String value = (String)tags.get((Object)(key = eFeature.getName()));
            return value != null;
        }
        return super.eDynamicIsSet(eFeature);
    }

    public boolean isValid(Object theExtensionPropertyId) {
        boolean result;
        block9: {
            result = true;
            Annotation annotation = this.getAnnotation(false);
            if (annotation == null) {
                IPath path = ModelerCore.getModelEditor().getModelRelativePath((EObject)this);
                String msg = ModelerCore.Util.getString("ObjectExtension.NullAnnotation", (Object)path);
                ModelerCore.Util.log(4, msg);
            } else {
                EMap tags = annotation.getTags();
                if (tags != null && tags.containsKey(theExtensionPropertyId)) {
                    EClass xclass = this.eProperties.getEClass();
                    EList attributes = xclass.getEAllAttributes();
                    if (attributes != null && !attributes.isEmpty()) {
                        int size = attributes.size();
                        for (int i = 0; i < size; ++i) {
                            StringTokenizer stringTokenizer;
                            EAttribute attribute = (EAttribute)attributes.get(i);
                            if (!attribute.getName().equals(theExtensionPropertyId)) continue;
                            EDataType type = (EDataType)attribute.getEType();
                            EPackage ePackage = type.getEPackage();
                            EFactory factory = ePackage.getEFactoryInstance();
                            String value = (String)tags.get(theExtensionPropertyId);
                            if (value == null || !(stringTokenizer = new StringTokenizer(value, DELIM)).hasMoreTokens()) break;
                            while (stringTokenizer.hasMoreTokens()) {
                                String token = stringTokenizer.nextToken();
                                try {
                                    factory.createFromString(type, token);
                                }
                                catch (RuntimeException theException) {
                                    result = false;
                                    break block9;
                                }
                            }
                            break;
                        }
                    }
                } else {
                    IPath path = ModelerCore.getModelEditor().getModelRelativePath((EObject)annotation);
                    Object[] params = new Object[]{theExtensionPropertyId, path};
                    String msg = ModelerCore.Util.getString("ObjectExtension.ExtendedPropertyNotFound", params);
                    ModelerCore.Util.log(4, msg);
                }
            }
        }
        return result;
    }
}

