/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilByteArray;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class UtilTransliteratorForUTF8
extends UtilTransliterator {
    private static String footprint = "$Revision:   3.7.1.0  $";
    private String encoding = "UTF8";
    private int[] rl;
    private InputStream _in;

    public UtilTransliteratorForUTF8() throws UtilException {
        this.setDefaultCacheSize();
    }

    public boolean isFixedBytesPerChar() {
        return false;
    }

    public int getMaxBytesPerChar() {
        return 3;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        byte[] byArray = this.encode(string, this.rl);
        int n = this.rl[0];
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public byte[] encode(char[] cArray, int n, int n2) throws UtilException {
        this.setCacheSize(n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            if (c >= '\u0000' && c <= '\u007f') {
                this.bytesCache[n3++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.bytesCache[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.bytesCache[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.bytesCache[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.bytesCache[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.bytesCache[n3++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return UtilByteArray.duplicate(this.bytesCache, n3);
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        this.setCacheSize(n);
        string.getChars(0, n, this.charsCache, 0);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = this.charsCache[i];
            if (c >= '\u0000' && c <= '\u007f') {
                this.bytesCache[n2++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.bytesCache[n2++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.bytesCache[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.bytesCache[n2++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.bytesCache[n2++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.bytesCache[n2++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        nArray[0] = n2;
        return this.bytesCache;
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                for (int i = 0; i < n3; ++i) {
                    this.charsCache[i] = (char)(this.bytesCache[i] & 0xFF);
                }
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        this.setCacheSize(this.streamChunkSize);
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.encoding);
            while (n > 0) {
                int n2 = Math.min(n, this.streamChunkSize);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                outputStreamWriter.write(this.charsCache, 0, n3);
                n -= n3;
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private int _decode(byte[] byArray, int n, int n2, char[] cArray, int n3) throws UtilException {
        int n4 = 0;
        int n5 = 0;
        block5: while (n5 < n2 && n4 < n3 + cArray.length) {
            int n6 = byArray[n5 + n] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n5;
                    cArray[n3 + n4++] = (char)n6;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((n5 += 2) > n2) {
                        throw UtilException.createTransliterationFailedException("invalid UTF8 data");
                    }
                    byte by = byArray[n + n5 - 1];
                    if ((by & 0xC0) != 128) {
                        throw UtilException.createTransliterationFailedException("invalid UTF8 data");
                    }
                    cArray[n3 + n4++] = (char)((n6 & 0x1F) << 6 | by & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((n5 += 3) > n2) {
                        throw UtilException.createTransliterationFailedException("invalid UTF8 data");
                    }
                    byte by = byArray[n + n5 - 2];
                    byte by2 = byArray[n + n5 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw UtilException.createTransliterationFailedException("invalid UTF8 data");
                    }
                    cArray[n3 + n4++] = (char)((n6 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw UtilException.createTransliterationFailedException("invalid UTF8 data");
        }
        return n4;
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        this.setCacheSize(n2);
        int n3 = this._decode(byArray, n, n2, this.charsCache, 0);
        return new String(this.charsCache, 0, n3);
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray, int n3) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        return this._decode(byArray, n, n2, cArray, n3);
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        int n4;
        int n5 = Math.max(n2, n3);
        this.setCacheSize(n5);
        for (int i = n4 = this._decode(byArray, n, n2, this.charsCache, 0); i < n3; ++i) {
            this.charsCache[i] = 32;
        }
        return new String(this.charsCache, 0, n3);
    }

    public Reader decodeAsReader(InputStream inputStream) throws UtilException {
        try {
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UtilException(1007, this.encoding);
        }
    }

    public synchronized InputStream decodeAsUCS2ByteStream(InputStream inputStream, int n) throws UtilException {
        this._in = inputStream;
        return new InputStream(){
            private InputStream in;
            {
                this.in = UtilTransliteratorForUTF8.this._in;
            }

            private int _decode(byte[] byArray, int n, int n2) throws IOException {
                int n3;
                boolean bl = false;
                for (n3 = 0; n3 < n2; n3 += 2) {
                    char c;
                    int n4 = UtilTransliteratorForUTF8.this._in.read();
                    if (n4 == -1) {
                        if (n3 == 0) {
                            return -1;
                        }
                        return n3;
                    }
                    switch (n4 >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            c = (char)n4;
                            break;
                        }
                        case 12: 
                        case 13: {
                            int n5 = UtilTransliteratorForUTF8.this._in.read();
                            if (n5 == -1) {
                                throw new IOException();
                            }
                            if ((n5 & 0xC0) != 128) {
                                throw new IOException();
                            }
                            c = (char)((n4 & 0x1F) << 6 | n5 & 0x3F);
                            break;
                        }
                        case 14: {
                            int n5 = UtilTransliteratorForUTF8.this._in.read();
                            if (n5 == -1) {
                                throw new IOException();
                            }
                            int n6 = UtilTransliteratorForUTF8.this._in.read();
                            if (n6 == -1) {
                                throw new IOException();
                            }
                            if ((n5 & 0xC0) != 128 || (n6 & 0xC0) != 128) {
                                throw new IOException();
                            }
                            c = (char)((n4 & 0xF) << 12 | (n5 & 0x3F) << 6 | (n6 & 0x3F) << 0);
                            break;
                        }
                        default: {
                            throw new IOException();
                        }
                    }
                    byArray[n++] = (byte)(c >> 8);
                    byArray[n++] = (byte)c;
                }
                return n3;
            }

            public int read() throws IOException {
                throw new IOException("Single byte reads are not supported by this InputStream derivative");
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                if ((n2 &= 0xFFFFFFFE) == 0) {
                    return 0;
                }
                return this._decode(byArray, n, n2);
            }

            public void close() throws IOException {
                UtilTransliteratorForUTF8.this._in.close();
            }
        };
    }
}

