/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.optimizer.relational.rules.RuleRaiseAccess;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.util.CommandContext;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RulePushLimit
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List limitNodes = NodeEditor.findAllNodes((PlanNode)plan, (int)41);
        boolean pushRaiseNull = false;
        while (!limitNodes.isEmpty()) {
            PlanNode childProject;
            PlanNode limitNode = (PlanNode)limitNodes.get(0);
            Expression limit = (Expression)limitNode.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT);
            if (limit instanceof Constant && new Integer(0).equals(((Constant)limit).getValue()) && (childProject = NodeEditor.findNodePreOrder((PlanNode)limitNode, (int)11)) != null && childProject.getProperty((Object)NodeConstants.Info.INTO_GROUP) == null) {
                FrameUtil.replaceWithNullNode(limitNode.getFirstChild());
                PlanNode projectNode = NodeFactory.getNewNode((int)11);
                projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, childProject.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
                NodeEditor.insertNode((PlanNode)limitNode, (PlanNode)limitNode.getFirstChild(), (PlanNode)projectNode);
                pushRaiseNull = true;
                limitNodes.remove(limitNode);
                continue;
            }
            if (NodeEditor.findAllNodes((PlanNode)limitNode, (int)3).isEmpty()) {
                limitNodes.remove(limitNode);
                continue;
            }
            while (this.canPushLimit(plan, limitNode, limitNodes, metadata, capabilitiesFinder)) {
                if (limitNode.getParent() == null) {
                    limitNode.getFirstChild().setProperty((Object)NodeConstants.Info.TOP_COLS, limitNode.getProperty((Object)NodeConstants.Info.TOP_COLS));
                } else {
                    limitNode.setProperty((Object)NodeConstants.Info.TOP_COLS, limitNode.getFirstChild().getProperty((Object)NodeConstants.Info.TOP_COLS));
                }
                plan = RuleRaiseAccess.performRaise((PlanNode)plan, (PlanNode)limitNode.getFirstChild(), (PlanNode)limitNode);
            }
            limitNodes.remove(limitNode);
        }
        if (pushRaiseNull) {
            rules.push(RuleConstants.RAISE_NULL);
        }
        return plan;
    }

    boolean canPushLimit(PlanNode rootNode, PlanNode limitNode, List limitNodes, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode child = limitNode.getFirstChild();
        if (child == null || child.getChildCount() == 0) {
            return false;
        }
        switch (child.getType()) {
            case 41: {
                Expression minLimit = RulePushLimit.getMinValue((Expression)limitNode.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT), (Expression)child.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT));
                Expression offSet = RulePushLimit.getSum((Expression)limitNode.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT), (Expression)child.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT));
                NodeEditor.removeChildNode((PlanNode)limitNode, (PlanNode)child);
                limitNode.setProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT, (Object)minLimit);
                limitNode.setProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT, (Object)offSet);
                limitNodes.remove(child);
                return this.canPushLimit(rootNode, limitNode, limitNodes, metadata, capFinder);
            }
            case 29: {
                if (!child.hasBooleanProperty((Object)NodeConstants.Info.USE_ALL)) {
                    return false;
                }
                LinkedList children = new LinkedList(child.getChildren());
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    PlanNode grandChild = (PlanNode)i.next();
                    PlanNode newLimit = NodeFactory.getNewNode((int)41);
                    Expression limit = (Expression)limitNode.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT);
                    Expression offset = (Expression)limitNode.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT);
                    newLimit.setProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT, (Object)RulePushLimit.getSum(limit, offset));
                    NodeEditor.insertNode((PlanNode)child, (PlanNode)grandChild, (PlanNode)newLimit);
                    limitNodes.add(newLimit);
                }
                return false;
            }
            case 3: {
                RulePushLimit.raiseAccessOverLimit(rootNode, child, metadata, capFinder, limitNode);
                return false;
            }
            case 11: {
                return child.getProperty((Object)NodeConstants.Info.INTO_GROUP) == null;
            }
            case 19: {
                return true;
            }
        }
        return false;
    }

    static PlanNode raiseAccessOverLimit(PlanNode rootNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode) throws QueryMetadataException, MetaMatrixComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess((PlanNode)accessNode, (QueryMetadataInterface)metadata);
        if (modelID == null) {
            return null;
        }
        List setops = NodeEditor.findAllNodes((PlanNode)accessNode, (int)29, (int)19);
        if (!setops.isEmpty()) {
            return null;
        }
        Expression limit = (Expression)parentNode.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT);
        if (limit != null && !CapabilitiesUtil.supportsRowLimit((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
            return null;
        }
        Expression offset = (Expression)parentNode.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT);
        if (offset != null && !CapabilitiesUtil.supportsRowOffset((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder)) {
            if (limit != null) {
                parentNode.setProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT, null);
                PlanNode pushedLimit = NodeFactory.getNewNode((int)41);
                pushedLimit.setProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT, (Object)RulePushLimit.getSum(limit, offset));
                if (accessNode.getChildCount() == 0) {
                    accessNode.addFirstChild(pushedLimit);
                } else {
                    NodeEditor.insertNode((PlanNode)accessNode, (PlanNode)accessNode.getFirstChild(), (PlanNode)pushedLimit);
                }
            }
            return null;
        }
        return RuleRaiseAccess.performRaise((PlanNode)rootNode, (PlanNode)accessNode, (PlanNode)parentNode);
    }

    static Expression getSum(Expression expr1, Expression expr2) {
        if (expr1 == null) {
            return expr2;
        }
        if (expr2 == null) {
            return expr1;
        }
        Function newExpr = new Function("+", new Expression[]{expr1, expr2});
        newExpr.setFunctionDescriptor(FunctionLibraryManager.getFunctionLibrary().findFunction("+", new Class[]{DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.INTEGER}));
        newExpr.setType(newExpr.getFunctionDescriptor().getReturnType());
        return newExpr;
    }

    static Expression getMinValue(Expression expr1, Expression expr2) {
        if (expr1 == null) {
            return expr2;
        }
        if (expr2 == null) {
            return expr1;
        }
        CompareCriteria crit = new CompareCriteria(expr1, 3, expr2);
        SearchedCaseExpression sce = new SearchedCaseExpression(Arrays.asList(crit), Arrays.asList(expr1));
        sce.setElseExpression(expr2);
        return sce;
    }

    public String toString() {
        return "PushLimit";
    }
}

