/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer;

import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.lang.Command;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommandTreeNode {
    public static final int TYPE_RELATIONAL_COMMAND = 2;
    public static final int TYPE_XML_COMMAND = 3;
    public static final int TYPE_PROCEDURAL_COMMAND = 4;
    public static final int TYPE_XQUERY_COMMAND = 5;
    public static final int TYPE_BATCHED_UPDATE_COMMAND = 6;
    public static final int TYPE_DYNAMIC_COMMAND = 7;
    public static final int TYPE_PREPARED_BATCH_UPDATE_COMMAND = 8;
    private Command command;
    private int commandType;
    private Object canonicalPlan;
    private ProcessorPlan processorPlan;
    private Map properties = new HashMap();
    private CommandTreeNode parent;
    private LinkedList children = new LinkedList();
    private List references = null;
    private static final String TAB = "  ";

    public int getCommandType() {
        return this.commandType;
    }

    public void setCommandType(int commandType) {
        this.commandType = commandType;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Object getCanonicalPlan() {
        return this.canonicalPlan;
    }

    public void setCanonicalPlan(Object canonicalPlan) {
        this.canonicalPlan = canonicalPlan;
    }

    public ProcessorPlan getProcessorPlan() {
        return this.processorPlan;
    }

    public void setProcessorPlan(ProcessorPlan processorPlan) {
        this.processorPlan = processorPlan;
    }

    public List getReferences() {
        if (this.references == null) {
            this.references = Collections.EMPTY_LIST;
        }
        return this.references;
    }

    public void setReferences(List references) {
        this.references = references;
    }

    public CommandTreeNode getParent() {
        return this.parent;
    }

    public void setParent(CommandTreeNode parent) {
        this.parent = parent;
    }

    public List getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public CommandTreeNode getFirstChild() {
        return (CommandTreeNode)this.children.getFirst();
    }

    public CommandTreeNode getLastChild() {
        return (CommandTreeNode)this.children.getLast();
    }

    public void addFirstChild(CommandTreeNode child) {
        this.children.addFirst(child);
    }

    public void addLastChild(CommandTreeNode child) {
        this.children.addLast(child);
    }

    public void addChildren(List otherChildren) {
        this.children.addAll(otherChildren);
    }

    public boolean hasChild(CommandTreeNode child) {
        return this.children.contains(child);
    }

    public boolean removeChild(CommandTreeNode child) {
        return this.children.remove(child);
    }

    public Object getProperty(Integer propertyID) {
        return this.properties.get(propertyID);
    }

    public Map getAllProperties() {
        return this.properties;
    }

    public void setProperty(Integer propertyID, Object value) {
        this.properties.put(propertyID, value);
    }

    public void removeProperty(Integer propertyID) {
        this.properties.remove(propertyID);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.getRecursiveString(str, 0);
        return str.toString();
    }

    public String nodeToString() {
        StringBuffer str = new StringBuffer();
        this.getNodeString(str);
        return str.toString();
    }

    private void setTab(StringBuffer str, int tabStop) {
        for (int i = 0; i < tabStop; ++i) {
            str.append(TAB);
        }
    }

    private void getRecursiveString(StringBuffer str, int tabLevel) {
        this.setTab(str, tabLevel);
        this.getNodeString(str);
        str.append("\n");
        this.getCanonicalPlanString(str);
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            CommandTreeNode child = (CommandTreeNode)iter.next();
            child.getRecursiveString(str, tabLevel + 1);
        }
    }

    private void getNodeString(StringBuffer str) {
        str.append("(type=");
        str.append(CommandTreeNode.getNodeTypeString(this.commandType));
        str.append(", command=");
        str.append(this.command);
        if (this.properties != null) {
            str.append(", props=");
            str.append(this.properties);
        }
        str.append(")");
    }

    private void getCanonicalPlanString(StringBuffer str) {
        if (this.canonicalPlan != null) {
            str.append("canonical plan:\n");
            str.append(this.canonicalPlan);
            str.append("\n");
        }
    }

    private static final String getNodeTypeString(int type) {
        switch (type) {
            case 4: {
                return "Procedural";
            }
            case 2: {
                return "Relational";
            }
            case 3: {
                return "XML";
            }
            case 5: {
                return "XQuery";
            }
            case 6: {
                return "BatchedUpdate";
            }
        }
        return "Unknown: " + type;
    }
}

