/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.audit;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.audit.AuditConfiguration;
import com.metamatrix.platform.security.audit.AuditManager;
import com.metamatrix.platform.security.audit.AuditMessage;
import com.metamatrix.platform.security.audit.config.AuditConfigurationException;
import com.metamatrix.platform.security.audit.config.BasicAuditConfiguration;
import com.metamatrix.platform.security.audit.config.CurrentConfigAuditConfigurationFactory;
import com.metamatrix.platform.security.audit.config.UnmodifiableAuditConfiguration;
import com.metamatrix.platform.security.audit.destination.AuditDestination;
import com.metamatrix.platform.security.audit.destination.AuditDestinationInitFailedException;
import com.metamatrix.platform.security.audit.destination.ConsoleAuditDestination;
import com.metamatrix.platform.security.audit.destination.DatabaseAuditDestination;
import com.metamatrix.platform.security.audit.destination.SingleFileAuditDestination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class AuditManager {
    public static final String NAME = "AuditingService";
    public static final String SYSTEM_AUDIT_LEVEL_PROPERTY_NAME = "metamatrix.audit.enabled";
    public static final String SYSTEM_AUDIT_CONTEXT_PROPERTY_NAME = "metamatrix.audit.contexts";
    public static final String SYSTEM_AUDIT_CONSOLE_PROPERTY_NAME = "metamatrix.audit.console";
    public static final String SYSTEM_AUDIT_MAX_THREADS = "metamatrix.audit.maxThreads";
    public static final String SYSTEM_AUDIT_THREAD_TTL = "metamatrix.audit.threadTTL";
    protected static final String DEFAULT_AUDIT_MAX_THREADS = "1";
    protected static final String DEFAULT_AUDIT_THREAD_TTL = "600000";
    private static AuditManager INSTANCE = new AuditManager();
    private static AuditConfiguration CONFIGURATION = null;
    private static Properties AUDIT_PROPERTIES = new Properties();
    private static Properties UNMODIFIABLE_AUDIT_PROPERTIES = new UnmodifiableProperties(AUDIT_PROPERTIES);
    private List auditDestinations;
    private AuditQueueWorkerFactory workerFactory;
    private LinkedQueue queue;
    private WorkerPool workerPool;
    private boolean isInitialized = false;
    private boolean isStopped = false;
    protected Object initializationLock = new Object();

    protected void finalize() {
        if (this.isManagerStopped()) {
            AuditManager.stop();
        }
    }

    private AuditManager() {
        this.workerFactory = new AuditQueueWorkerFactory(this);
        this.queue = new LinkedQueue();
        this.auditDestinations = new ArrayList();
    }

    private void init() {
        AuditManagerInitializationThread initializerThread = new AuditManagerInitializationThread(this);
        initializerThread.start();
    }

    protected void initialize() {
        I18nLogManager.logCritical((String)"AUDIT", (String)"MSG.014.207.0001", (Object)PlatformPlugin.Util.getString("MSG.014.207.0001"));
        if (CONFIGURATION.getAuditLevel() != 0) {
            this.initializeDestinations();
        }
        this.isInitialized = true;
        I18nLogManager.logCritical((String)"AUDIT", (String)"MSG.014.207.0008", (Object)PlatformPlugin.Util.getString("MSG.014.207.0008", (Object)CONFIGURATION.toString()));
        Iterator iter = this.auditDestinations.iterator();
        StringBuffer dests = new StringBuffer();
        while (iter.hasNext()) {
            AuditDestination dest = (AuditDestination)iter.next();
            dests.append(dest.getDescription());
            dests.append(", ");
        }
        if (dests.length() >= 2) {
            dests.setLength(dests.length() - 2);
        }
        I18nLogManager.logCritical((String)"AUDIT", (String)"MSG.014.207.0002", (Object)PlatformPlugin.Util.getString("MSG.014.207.0002", (Object)dests.toString()));
        this.initializeQueueWorkers();
        I18nLogManager.logCritical((String)"AUDIT", (String)"MSG.014.207.0003", (Object)PlatformPlugin.Util.getString("MSG.014.207.0003"));
    }

    private void initializeDestinations() {
        boolean dbEnabled;
        this.auditDestinations.clear();
        if (!this.isInitialized) {
            Properties currentConfigProperties = new Properties();
            try {
                Properties globalProperties = CurrentConfiguration.getProperties();
                Properties resourceProperties = CurrentConfiguration.getResourceProperties((String)"Audit");
                currentConfigProperties.putAll((Map<?, ?>)globalProperties);
                currentConfigProperties.putAll((Map<?, ?>)resourceProperties);
                AUDIT_PROPERTIES = PropertiesUtils.clone((Properties)currentConfigProperties, (Properties)System.getProperties(), (boolean)true, (boolean)false);
            }
            catch (ConfigurationException e) {
                AUDIT_PROPERTIES = PropertiesUtils.clone((Properties)System.getProperties(), (boolean)false);
            }
        } else {
            AUDIT_PROPERTIES.setProperty("metamatrix.audit.fileAppend", Boolean.TRUE.toString());
        }
        UNMODIFIABLE_AUDIT_PROPERTIES = new UnmodifiableProperties(AUDIT_PROPERTIES);
        String specifiedLogFileName = UNMODIFIABLE_AUDIT_PROPERTIES.getProperty("metamatrix.audit.file");
        if (specifiedLogFileName != null && specifiedLogFileName.trim().length() != 0) {
            SingleFileAuditDestination destination = new SingleFileAuditDestination();
            try {
                destination.initialize(UNMODIFIABLE_AUDIT_PROPERTIES);
                this.auditDestinations.add(destination);
                I18nLogManager.logInfo((String)"AUDIT", (String)"MSG.014.207.0004", (Object)PlatformPlugin.Util.getString("MSG.014.207.0004", (Object)destination.getDescription()));
            }
            catch (AuditDestinationInitFailedException e) {
                I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0006", (Throwable)e, (Object)PlatformPlugin.Util.getString("ERR.014.207.0006", (Object)destination.getDescription()));
            }
        }
        if (dbEnabled = Boolean.valueOf(UNMODIFIABLE_AUDIT_PROPERTIES.getProperty("metamatrix.audit.jdbcDatabase")).booleanValue()) {
            DatabaseAuditDestination destination = new DatabaseAuditDestination();
            try {
                destination.initialize(UNMODIFIABLE_AUDIT_PROPERTIES);
                this.auditDestinations.add(destination);
                I18nLogManager.logInfo((String)"AUDIT", (String)"MSG.014.207.0004", (Object)PlatformPlugin.Util.getString("MSG.014.207.0004", (Object)destination.getDescription()));
            }
            catch (AuditDestinationInitFailedException e) {
                I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0006", (Throwable)e, (Object)PlatformPlugin.Util.getString("ERR.014.207.0006", (Object)destination.getDescription()));
            }
        } else {
            I18nLogManager.logInfo((String)"AUDIT", (String)"MSG.014.207.0005", (Object)PlatformPlugin.Util.getString("MSG.014.207.0005"));
        }
        boolean includeConsole = Boolean.valueOf(UNMODIFIABLE_AUDIT_PROPERTIES.getProperty(SYSTEM_AUDIT_CONSOLE_PROPERTY_NAME));
        if (includeConsole || this.auditDestinations.size() == 0) {
            ConsoleAuditDestination destination = new ConsoleAuditDestination();
            try {
                destination.initialize(UNMODIFIABLE_AUDIT_PROPERTIES);
                this.auditDestinations.add(destination);
                I18nLogManager.logInfo((String)"AUDIT", (String)"MSG.014.207.0004", (Object)PlatformPlugin.Util.getString("MSG.014.207.0004", (Object)destination.getDescription()));
            }
            catch (AuditDestinationInitFailedException e) {
                I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0006", (Throwable)e, (Object)PlatformPlugin.Util.getString("ERR.014.207.0006", (Object)destination.getDescription()));
            }
        }
    }

    private void initializeQueueWorkers() {
        try {
            String maxThreadsString = System.getProperty(SYSTEM_AUDIT_MAX_THREADS, DEFAULT_AUDIT_MAX_THREADS);
            String threadTTLString = System.getProperty(SYSTEM_AUDIT_THREAD_TTL, DEFAULT_AUDIT_THREAD_TTL);
            this.workerPool = new WorkerPool("AuditQueue", (Channel)this.queue, (QueueWorkerFactory)this.workerFactory, Integer.parseInt(maxThreadsString), (long)Integer.parseInt(threadTTLString));
        }
        catch (Exception e) {
            I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0007", (Throwable)e, (Object)PlatformPlugin.Util.getString("ERR.014.207.0007"));
        }
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    protected static AuditManager getInstance() {
        if (!INSTANCE.isInitialized()) {
            INSTANCE.init();
        }
        return INSTANCE;
    }

    public static void record(String context, String activity, String principal, Collection permissions) {
        if (permissions != null && !permissions.isEmpty()) {
            AuditManager.getInstance().recordMessage(context, activity, principal, permissions);
        }
    }

    public static void record(String context, String activity, String principal, Object[] resources) {
        if (resources != null) {
            AuditManager.getInstance().recordMessage(context, activity, principal, resources);
        }
    }

    public static void record(String context, String activity, String principal, String resource) {
        if (resource != null) {
            AuditManager.getInstance().recordMessage(context, activity, principal, resource);
        }
    }

    private boolean isLevelDiscarded(int msgLevel) {
        return CONFIGURATION.isLevelDiscarded(msgLevel);
    }

    private boolean isContextDiscarded(String context) {
        return CONFIGURATION.isContextDiscarded(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        AuditManager manager = AuditManager.getInstance();
        Object object = manager.initializationLock;
        synchronized (object) {
            if (!AuditManager.isStopped()) {
                I18nLogManager.logInfo((String)"AUDIT", (String)"MSG.014.207.0006", (Object)PlatformPlugin.Util.getString("MSG.014.207.0006"));
                try {
                    manager.workerPool.suspend();
                    while (manager.workerPool.hasWork()) {
                        Thread.sleep(100L);
                    }
                    if (manager.workerPool != null) {
                        manager.workerPool.shutdown();
                    }
                    Thread.sleep(1000L);
                    Iterator iter = manager.auditDestinations.iterator();
                    while (iter.hasNext()) {
                        AuditDestination dest = (AuditDestination)iter.next();
                        dest.shutdown();
                    }
                    manager.auditDestinations.clear();
                }
                catch (Exception e) {
                    I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0008", (Throwable)e, (Object)PlatformPlugin.Util.getString("ERR.014.207.0008"));
                }
                manager.isStopped = manager.workerPool.isStopped();
            } else {
                I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0009", (Object)PlatformPlugin.Util.getString("ERR.014.207.0009"));
            }
        }
    }

    public static boolean isStopped() {
        return AuditManager.getInstance().isManagerStopped();
    }

    protected boolean isManagerStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resume() {
        AuditManager manager = AuditManager.getInstance();
        boolean done = false;
        while (!done) {
            Object object = manager.initializationLock;
            synchronized (object) {
                if (manager.isInitialized) {
                    if (AuditManager.isStopped()) {
                        manager.initializeDestinations();
                        manager.workerPool.resume();
                        manager.isStopped = false;
                        I18nLogManager.logCritical((String)"AUDIT", (String)"MSG.014.207.0007", (Object)PlatformPlugin.Util.getString("MSG.014.207.0007"));
                    }
                    done = true;
                }
            }
        }
    }

    public static AuditConfiguration getAuditConfiguration() {
        return CONFIGURATION;
    }

    public static void setAuditConfiguration(AuditConfiguration config) {
        if (config != null) {
            I18nLogManager.logCritical((String)"AUDIT", (String)"MSG.014.207.0008", (Object)PlatformPlugin.Util.getString("MSG.014.207.0008", (Object)config));
            if (config instanceof UnmodifiableAuditConfiguration) {
                UnmodifiableAuditConfiguration unmodConfig = (UnmodifiableAuditConfiguration)config;
                CONFIGURATION = (AuditConfiguration)unmodConfig.deepClone();
            } else {
                CONFIGURATION = new UnmodifiableAuditConfiguration((AuditConfiguration)config.clone());
            }
        }
    }

    public static boolean isMessageToBeRecorded(String context) {
        if (context == null) {
            return false;
        }
        AuditManager manager = AuditManager.getInstance();
        if (manager.isLevelDiscarded(1)) {
            return false;
        }
        return !manager.isContextDiscarded(context);
    }

    public static boolean isMessageToBeRecorded(AuditMessage message) {
        if (message == null) {
            return false;
        }
        AuditManager manager = AuditManager.getInstance();
        if (manager.isLevelDiscarded(1)) {
            return false;
        }
        return !manager.isContextDiscarded(message.getContext());
    }

    protected void recordMessage(String context, String activity, String principal, String resource) {
        if (this.isLevelDiscarded(1)) {
            return;
        }
        AuditMessage msg = new AuditMessage(context, activity, principal, new Object[]{resource});
        try {
            this.addMessageToQueue(msg);
        }
        catch (QueueSuspendedException e2) {
        }
        catch (Exception e2) {
            I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0010", (Throwable)e2, (Object)PlatformPlugin.Util.getString("ERR.014.207.0010"));
        }
    }

    protected void recordMessage(String context, String activity, String principal, Object[] resources) {
        if (this.isLevelDiscarded(1)) {
            return;
        }
        AuditMessage msg = new AuditMessage(context, activity, principal, resources);
        try {
            this.addMessageToQueue(msg);
        }
        catch (QueueSuspendedException e2) {
        }
        catch (Exception e2) {
            I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0010", (Throwable)e2, (Object)PlatformPlugin.Util.getString("ERR.014.207.0010"));
        }
    }

    protected void recordMessage(String context, String activity, String principal, Collection permissions) {
        if (this.isManagerStopped() || this.isLevelDiscarded(1)) {
            return;
        }
        ArrayList<String> resources = new ArrayList<String>(permissions.size());
        Iterator permItr = permissions.iterator();
        while (permItr.hasNext()) {
            resources.add(((AuthorizationPermission)permItr.next()).getResourceName());
        }
        AuditMessage msg = new AuditMessage(context, activity, principal, resources.toArray());
        try {
            this.addMessageToQueue(msg);
        }
        catch (QueueSuspendedException e2) {
        }
        catch (Exception e2) {
            I18nLogManager.logError((String)"AUDIT", (String)"ERR.014.207.0010", (Throwable)e2, (Object)PlatformPlugin.Util.getString("ERR.014.207.0010"));
        }
    }

    private void addMessageToQueue(AuditMessage msg) throws QueueSuspendedException {
        block4: {
            if (this.workerPool == null) {
                while (true) {
                    try {
                        this.queue.put((Object)msg);
                        break block4;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            this.workerPool.addWork((Object)msg);
        }
    }

    void distributeMessage(AuditMessage message) {
        if (!this.isContextDiscarded(message.getContext())) {
            Iterator iter = this.auditDestinations.iterator();
            while (iter.hasNext()) {
                AuditDestination dest = (AuditDestination)iter.next();
                dest.record(message);
            }
        }
    }

    public static void main(String[] args) {
    }

    static /* synthetic */ boolean access$000(AuditManager x0) {
        return x0.isInitialized();
    }

    static {
        CurrentConfigAuditConfigurationFactory configFactory = new CurrentConfigAuditConfigurationFactory();
        Properties currentConfigProperties = new Properties();
        try {
            Properties globalProperties = CurrentConfiguration.getProperties();
            Properties resourceProperties = CurrentConfiguration.getResourceProperties((String)"Audit");
            currentConfigProperties.putAll((Map<?, ?>)globalProperties);
            currentConfigProperties.putAll((Map<?, ?>)resourceProperties);
            AUDIT_PROPERTIES = PropertiesUtils.clone((Properties)currentConfigProperties, (Properties)System.getProperties(), (boolean)true, (boolean)false);
        }
        catch (ConfigurationException e) {
            I18nLogManager.logWarning((String)"AUDIT", (String)"ERR.014.207.0003", (Throwable)e, (Object)PlatformPlugin.Util.getString("ERR.014.207.0003"));
            AUDIT_PROPERTIES = PropertiesUtils.clone((Properties)System.getProperties(), (boolean)false);
        }
        UNMODIFIABLE_AUDIT_PROPERTIES = new UnmodifiableProperties(AUDIT_PROPERTIES);
        try {
            CONFIGURATION = configFactory.getConfiguration(UNMODIFIABLE_AUDIT_PROPERTIES);
        }
        catch (AuditConfigurationException e) {
            I18nLogManager.logWarning((String)"AUDIT", (String)"ERR.014.207.0004", (Throwable)e, (Object)PlatformPlugin.Util.getString("ERR.014.207.0004"));
            CONFIGURATION = new BasicAuditConfiguration();
        }
        CONFIGURATION = new UnmodifiableAuditConfiguration(CONFIGURATION);
    }
}

