/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce;

import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class ConnectorTarget {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String URL = "URL";
    public static final String DEFAULT_URL_LOC = "https://www.salesforce.com/services/Soap/u/10.0";
    private ConnectorLogger logger;
    private String username;
    private String password;
    private URL url;
    private String hashString;

    public ConnectorTarget(Properties props, ConnectorLogger logger) throws ConnectorException {
        String url;
        String password;
        if (logger == null) {
            throw new ConnectorException("Internal Exception: logger is null");
        }
        this.logger = logger;
        String username = props.getProperty(USERNAME);
        if (username != null) {
            this.setUsername(username);
        }
        if ((password = props.getProperty(PASSWORD)) != null) {
            this.setPassword(password);
        }
        if ((url = props.getProperty(URL)) == null) {
            url = DEFAULT_URL_LOC;
        }
        if (null != url && url.length() != 0) {
            URL salesforceURL;
            try {
                salesforceURL = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new ConnectorException((Throwable)e, e.getMessage());
            }
            this.setUrl(salesforceURL);
        }
    }

    private void setUrl(URL salesforceURL) {
        this.url = salesforceURL;
        this.hashString = null;
    }

    private void setUsername(String username) {
        this.username = username;
        this.hashString = null;
    }

    private void setPassword(String password) {
        this.password = password;
        this.hashString = null;
    }

    public URL getURL() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String key() {
        if (this.hashString == null) {
            this.hashString = "user_name=" + this.username + ",url=" + (this.url == null ? "default" : this.url.toString());
        }
        return this.hashString;
    }

    public boolean equals(Object obj) {
        boolean match;
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConnectorTarget other = (ConnectorTarget)obj;
        boolean bl = match = this.username.equals(other.username) && this.password.equals(other.password);
        if (match) {
            if (this.url == null) {
                return other.url == null;
            }
            if (other.url == null) {
                return false;
            }
            return this.url.equals(other.url);
        }
        return false;
    }

    public int hashCode() {
        return this.key().hashCode();
    }
}

