/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.model.internal;

import com.metamatrix.modeler.modelgenerator.wsdl.model.Fault;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Message;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Operation;
import com.metamatrix.modeler.modelgenerator.wsdl.model.Part;
import com.metamatrix.modeler.modelgenerator.wsdl.model.WSDLElement;
import com.metamatrix.modeler.modelgenerator.wsdl.model.internal.WSDLElementImpl;

public class MessageImpl
extends WSDLElementImpl
implements Message {
    private Part[] m_parts;
    private Operation m_operation;
    private Fault m_fault;
    private int m_type;
    private String m_namespace;
    private String m_use;
    private String m_encStyle;

    public MessageImpl(Operation oper) {
        this.m_operation = oper;
    }

    public MessageImpl(Fault fault) {
        this.m_fault = fault;
    }

    public Part[] getParts() {
        Part[] newParts = new Part[this.m_parts.length];
        for (int i = 0; i < this.m_parts.length; ++i) {
            newParts[i] = (Part)this.m_parts[i].copy();
        }
        return newParts;
    }

    public void setParts(Part[] parts) {
        this.m_parts = parts;
    }

    public Operation getOperation() {
        return this.m_operation;
    }

    public boolean isRequest() {
        return this.m_type == 0;
    }

    public boolean isResponse() {
        return this.m_type == 2;
    }

    public boolean isFault() {
        return this.m_type == 4;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public int getType() {
        return this.m_type;
    }

    public WSDLElement copy() {
        MessageImpl message = this.m_operation != null ? new MessageImpl(this.getOperation()) : new MessageImpl(this.getFault());
        message.setName(this.getName());
        message.setId(this.getId());
        message.setType(this.getType());
        message.setEncodingStyle(this.getEncodingStyle());
        message.setUse(this.getUse());
        message.setNamespaceURI(this.getNamespaceURI());
        Part[] newParts = new Part[this.m_parts.length];
        for (int i = 0; i < newParts.length; ++i) {
            newParts[i] = (Part)this.m_parts[i].copy();
        }
        message.setParts(newParts);
        return message;
    }

    public Fault getFault() {
        return this.m_fault;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("<message name='");
        buff.append(this.getName());
        buff.append("' id='");
        buff.append(this.getId());
        buff.append("' typeCode='");
        switch (this.getType()) {
            case 0: {
                buff.append("Request");
                break;
            }
            case 2: {
                buff.append("Response");
                break;
            }
            case 4: {
                buff.append("Fault");
            }
        }
        buff.append("' namespace='");
        buff.append(this.getNamespaceURI());
        buff.append("' use='");
        buff.append(this.getUse());
        buff.append("' ecodingStyles='");
        buff.append(this.getEncodingStyle());
        buff.append("' >");
        for (int i = 0; i < this.m_parts.length; ++i) {
            buff.append(this.m_parts[i].toString());
        }
        buff.append("</message>");
        return buff.toString();
    }

    public String getUse() {
        return this.m_use;
    }

    public void setUse(String use) {
        this.m_use = use;
    }

    public String getNamespaceURI() {
        return this.m_namespace;
    }

    public void setNamespaceURI(String ns) {
        this.m_namespace = ns;
    }

    public void setEncodingStyle(String style) {
        this.m_encStyle = style;
    }

    public String getEncodingStyle() {
        return this.m_encStyle;
    }
}

