/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseBlob;
import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseClob;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.db2.DB2Connection;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilJDKVersionChecker;
import com.metamatrix.util.UtilTempFile;
import com.metamatrix.util.UtilTransliterator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;

public final class DRDAUtil
extends DRDAConstants {
    private static String footprint = "$Revision:   3.25.1.4  $";
    int[] siDrdaType;
    FileOutputStream out;
    PrintStream p;
    private DRDACommunication comm;
    private String JVMUnicodeEncoding = null;
    final byte[] MostSigExpBits = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 1, 1, 2, 2, 0, 0};
    final int[] MostSigCoefDigit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 9, 8, 9, -1, -1};
    final byte[] DecletDigit1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 9, 9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 9, 9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 9, 9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 9, 9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 9, 9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 9, 9, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 9, 9};
    final byte[] DecletDigit2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 6, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 7, 7, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 8, 8, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 1, 1, 9, 9, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 2, 2, 6, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 9, 9, 3, 3, 7, 7, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 4, 4, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 5, 5, 9, 9, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 8, 8, 6, 6, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 9, 9, 7, 7, 9, 9};
    final byte[] DecletDigit3 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 0, 1, 0, 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 0, 1, 0, 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 0, 1, 0, 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 0, 1, 0, 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 0, 1, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 2, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 2, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 2, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 2, 3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 2, 3, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 4, 5, 4, 5, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 4, 5, 4, 5, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 4, 5, 4, 5, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 4, 5, 4, 5, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 4, 5, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 6, 7, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 6, 7, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 6, 7, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 6, 7, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 2, 3, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 6, 7, 6, 7, 8, 9};

    public DRDAUtil(DRDACommunication dRDACommunication) {
        this.comm = dRDACommunication;
        this.siDrdaType = new int[2];
    }

    public String[] readDelimitedStringFromBytes(byte[] byArray, int n, short s, UtilTransliterator utilTransliterator) throws UtilException {
        if (byArray == null || byArray.length == 0) {
            return new String[n];
        }
        int n2 = 0;
        int n3 = 0;
        String[] stringArray = new String[n];
        Short s2 = new Short(s);
        int n4 = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) {
                stringArray[n3++] = utilTransliterator.decode(byArray, n2, i - n2);
                return stringArray;
            }
            if (byArray[i] == s2.byteValue()) {
                stringArray[n3++] = utilTransliterator.decode(byArray, n2, i - n2);
                n2 = i + 1;
                continue;
            }
            if (i != byArray.length - 1) continue;
            stringArray[n3] = utilTransliterator.decode(byArray, n2, i + 1 - n2);
        }
        return stringArray;
    }

    public final String getNameForCPType(int n) {
        switch (n) {
            case 4658: {
                return "AGNPRMRM";
            }
        }
        return "0x" + Integer.toHexString(n);
    }

    public final String bigDecToPlainString(BigDecimal bigDecimal) {
        String string = bigDecimal.toString();
        if (string.indexOf(69) != -1) {
            if (bigDecimal.scale() < 0) {
                bigDecimal = bigDecimal.setScale(0);
            }
            if (bigDecimal.scale() == 0) {
                string = bigDecimal.unscaledValue().toString();
            } else {
                String string2 = bigDecimal.unscaledValue().abs().toString();
                int n = bigDecimal.signum();
                int n2 = string2.length() - bigDecimal.scale();
                if (n2 == 0) {
                    string = (n < 0 ? "-0." : "0.") + string2;
                } else if (n2 > 0) {
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    stringBuffer.insert(n2, '.');
                    if (n < 0) {
                        stringBuffer.insert(0, '-');
                    }
                    string = stringBuffer.toString();
                } else {
                    StringBuffer stringBuffer = new StringBuffer(3 - n2 + string2.length());
                    stringBuffer.append(n < 0 ? "-0." : "0.");
                    for (int i = 0; i < -n2; ++i) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                    string = stringBuffer.toString();
                }
            }
        }
        return string;
    }

    public final void convertColumnDescToParamDesc(BaseColumn baseColumn, BaseParameterInfo baseParameterInfo) throws SQLException {
        baseParameterInfo.precision = baseColumn.precision;
        baseParameterInfo.scale = baseColumn.scale;
        baseParameterInfo.nullable = baseColumn.isNullable;
        baseParameterInfo.nativeTypeName = baseColumn.typeName;
        baseParameterInfo.sqlType = baseColumn.type;
        baseParameterInfo.signed = baseColumn.isSigned;
        baseParameterInfo.mode = 0;
        switch (baseParameterInfo.sqlType) {
            case -7: {
                baseParameterInfo.typeClassName = "java.sql.Types.BIT";
                break;
            }
            case -6: {
                baseParameterInfo.typeClassName = "java.sql.Types.TINYINT";
                break;
            }
            case 5: {
                baseParameterInfo.typeClassName = "java.sql.Types.SMALLINT";
                break;
            }
            case 4: {
                baseParameterInfo.typeClassName = "java.sql.Types.INTEGER";
                break;
            }
            case -5: {
                baseParameterInfo.typeClassName = "java.sql.Types.BIGINT";
                break;
            }
            case 6: {
                baseParameterInfo.typeClassName = "java.sql.Types.FLOAT";
                break;
            }
            case 7: {
                baseParameterInfo.typeClassName = "java.sql.Types.REAL";
                break;
            }
            case 8: {
                baseParameterInfo.typeClassName = "java.sql.Types.DOUBLE";
                break;
            }
            case 2: {
                baseParameterInfo.typeClassName = "java.sql.Types.NUMERIC";
                break;
            }
            case 3: {
                baseParameterInfo.typeClassName = "java.sql.Types.DECIMAL";
                break;
            }
            case 1: {
                baseParameterInfo.typeClassName = "java.sql.Types.CHAR";
                break;
            }
            case 12: {
                baseParameterInfo.typeClassName = "java.sql.Types.VARCHAR";
                break;
            }
            case -1: {
                baseParameterInfo.typeClassName = "java.sql.Types.LONGVARCHAR";
                break;
            }
            case 91: {
                baseParameterInfo.typeClassName = "java.sql.Types.DATE";
                break;
            }
            case 92: {
                baseParameterInfo.typeClassName = "java.sql.Types.TIME";
                break;
            }
            case 93: {
                baseParameterInfo.typeClassName = "java.sql.Types.TIMESTAMP";
                break;
            }
            case -2: {
                baseParameterInfo.typeClassName = "java.sql.Types.BINARY";
                break;
            }
            case -3: {
                baseParameterInfo.typeClassName = "java.sql.Types.VARBINARY";
                break;
            }
            case -4: {
                baseParameterInfo.typeClassName = "java.sql.Types.LONGVARBINARY";
                break;
            }
            case 0: {
                baseParameterInfo.typeClassName = "java.sql.Types.NULL";
                break;
            }
            case 1111: {
                baseParameterInfo.typeClassName = "java.sql.Types.OTHER";
                break;
            }
            case 2000: {
                baseParameterInfo.typeClassName = "java.sql.Types.JAVA_OBJECT";
                break;
            }
            case 2001: {
                baseParameterInfo.typeClassName = "java.sql.Types.DISTINCT";
                break;
            }
            case 2002: {
                baseParameterInfo.typeClassName = "java.sql.Types.STRUCT";
                break;
            }
            case 2003: {
                baseParameterInfo.typeClassName = "java.sql.Types.ARRAY";
                break;
            }
            case 2004: {
                baseParameterInfo.typeClassName = "java.sql.Types.BLOB";
                break;
            }
            case 2005: {
                baseParameterInfo.typeClassName = "java.sql.Types.CLOB";
                break;
            }
            case 2006: {
                baseParameterInfo.typeClassName = "java.sql.Types.REF";
                break;
            }
            case 70: {
                baseParameterInfo.typeClassName = "java.sql.Types.DATALINK";
                break;
            }
            case 16: {
                baseParameterInfo.typeClassName = "java.sql.Types.BOOLEAN";
                break;
            }
            default: {
                baseParameterInfo.typeClassName = "java.sql.Types.CHAR";
            }
        }
    }

    public final Integer DB2ToJdbcTypeName(String string) {
        Integer n = new Integer(1);
        if ((string = string.trim()).equals("GRAPHIC")) {
            n = new Integer(1);
        } else if (string.indexOf("FOR BIT DATA") != -1) {
            n = string.indexOf("LONG VARCHAR") != -1 ? new Integer(-4) : (string.indexOf("VARCHAR") != -1 ? new Integer(-3) : new Integer(-2));
        } else if (string.equals("TINYINT")) {
            n = new Integer(-6);
        } else if (string.equals("SMALLINT")) {
            n = new Integer(5);
        } else if (string.equals("INTEGER")) {
            n = new Integer(4);
        } else if (string.equals("NUMERIC")) {
            n = new Integer(2);
        } else if (string.equals("DECIMAL")) {
            n = new Integer(3);
        } else if (string.equals("VARCHAR") || string.equals("CHARACTER VARYING")) {
            n = new Integer(12);
        } else if (string.equals("DATE")) {
            n = new Integer(91);
        } else if (string.equals("TIME")) {
            n = new Integer(92);
        } else if (string.equals("CLOB") || string.equals("CHARACTER LARGE OBJECT")) {
            n = new Integer(2005);
        } else if (string.equals("BLOB") || string.equals("BINARY LARGE OBJECT")) {
            n = new Integer(2004);
        } else if (string.equals("XML")) {
            n = new Integer(this.comm.implConn.xmlDescribeType);
        } else if (string.equals("DOUBLE PRECISION") || string.equals("DOUBLE")) {
            n = new Integer(8);
        } else if (string.equals("TIMESTMP") || string.equals("TIMESTAMP")) {
            n = new Integer(93);
        } else if (string.equals("LONGVAR") || string.equals("LONG VARCHAR")) {
            n = new Integer(-1);
        } else if (string.equals("REAL")) {
            n = new Integer(7);
        } else if (string.equals("FLOAT")) {
            n = new Integer(6);
        } else if (string.equals("BIGINT")) {
            n = new Integer(-5);
        } else if (string.equals("DECFLOAT")) {
            n = new Integer(3);
        } else if (string.equals("BINARY")) {
            n = new Integer(-2);
        } else if (string.equals("VARBINARY")) {
            n = new Integer(-3);
        } else if (string.equals("VARBIN")) {
            n = new Integer(-3);
        }
        return n;
    }

    public final int DB2ToJdbcType(int n, boolean bl, int n2) {
        int n3 = 0;
        switch (n) {
            case 384: 
            case 385: {
                n3 = 91;
                break;
            }
            case 388: 
            case 389: {
                n3 = 92;
                break;
            }
            case 392: 
            case 393: {
                n3 = 93;
                break;
            }
            case 452: 
            case 453: {
                if (bl) {
                    n3 = -2;
                    break;
                }
                n3 = 1;
                break;
            }
            case 408: 
            case 409: 
            case 412: 
            case 413: {
                n3 = 2005;
                break;
            }
            case 456: 
            case 457: {
                if (bl) {
                    n3 = -4;
                    break;
                }
                n3 = -1;
                break;
            }
            case 404: 
            case 405: {
                n3 = 2004;
                break;
            }
            case 988: 
            case 989: {
                if (this.comm.implConn.xmlDescribeType == 2005) {
                    n3 = 2005;
                    break;
                }
                n3 = 2004;
                break;
            }
            case 448: 
            case 449: {
                if (bl) {
                    n3 = -3;
                    break;
                }
                n3 = 12;
                break;
            }
            case 468: 
            case 469: {
                n3 = 1;
                break;
            }
            case 472: 
            case 473: {
                n3 = -1;
                break;
            }
            case 464: 
            case 465: {
                n3 = 12;
                break;
            }
            case 480: 
            case 481: {
                if (n2 == 4) {
                    n3 = 7;
                    break;
                }
                if (n2 == 8) {
                    n3 = 8;
                    break;
                }
                n3 = 6;
                break;
            }
            case 484: 
            case 485: 
            case 996: 
            case 997: {
                n3 = 3;
                break;
            }
            case 488: 
            case 489: {
                n3 = 2;
                break;
            }
            case 496: 
            case 497: {
                n3 = 4;
                break;
            }
            case 500: 
            case 501: {
                n3 = 5;
                break;
            }
            case 492: 
            case 493: {
                n3 = -5;
                break;
            }
            case 904: 
            case 905: {
                n3 = -2;
                break;
            }
            case 912: 
            case 913: {
                n3 = -2;
                break;
            }
            case 908: 
            case 909: {
                n3 = -3;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        return n3;
    }

    public final String getDB2TypeName(int n, boolean bl, int n2) {
        String string = null;
        switch (n) {
            case 384: 
            case 385: {
                string = "DATE";
                break;
            }
            case 388: 
            case 389: {
                string = "TIME";
                break;
            }
            case 392: 
            case 393: {
                string = "TIMESTAMP";
                break;
            }
            case 452: 
            case 453: {
                if (bl) {
                    string = "CHAR FOR BIT DATA";
                    break;
                }
                string = "CHAR";
                break;
            }
            case 408: 
            case 409: 
            case 412: 
            case 413: {
                string = "CLOB";
                break;
            }
            case 456: 
            case 457: {
                if (bl) {
                    string = "LONG VARCHAR FOR BIT DATA";
                    break;
                }
                string = "LONG VARCHAR";
                break;
            }
            case 404: 
            case 405: {
                string = "BLOB";
                break;
            }
            case 988: 
            case 989: {
                string = "XML";
                break;
            }
            case 448: 
            case 449: {
                if (bl) {
                    string = "VARCHAR FOR BIT DATA";
                    break;
                }
                string = "VARCHAR";
                break;
            }
            case 468: 
            case 469: {
                string = "GRAPHIC";
                break;
            }
            case 472: 
            case 473: {
                string = "LONG VARGRAPHIC";
                break;
            }
            case 464: 
            case 465: {
                string = "VARGRAPHIC";
                break;
            }
            case 480: 
            case 481: {
                if (n2 == 4) {
                    string = "REAL";
                    break;
                }
                if (n2 == 8) {
                    string = "DOUBLE";
                    break;
                }
                string = "FLOAT";
                break;
            }
            case 488: 
            case 489: {
                string = "NUMERIC";
                break;
            }
            case 484: 
            case 485: {
                string = "DECIMAL";
                break;
            }
            case 496: 
            case 497: {
                string = "INTEGER";
                break;
            }
            case 500: 
            case 501: {
                string = "SMALLINT";
                break;
            }
            case 492: 
            case 493: {
                string = "BIGINT";
                break;
            }
            case 904: 
            case 905: {
                string = "ROWID";
                break;
            }
            case 996: 
            case 997: {
                string = "DECFLOAT";
                break;
            }
            case 912: 
            case 913: {
                string = "BINARY";
                break;
            }
            case 908: 
            case 909: {
                string = "VARBINARY";
                break;
            }
            default: {
                string = "CHAR";
            }
        }
        return string;
    }

    public final int Drda2JdbcType(int n, boolean bl, boolean bl2) {
        int n2;
        switch (n) {
            case 30: {
                n2 = -3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 4;
                break;
            }
            case 4: 
            case 5: {
                n2 = 5;
                break;
            }
            case 10: 
            case 11: {
                n2 = 6;
                break;
            }
            case 12: 
            case 13: {
                n2 = 7;
                break;
            }
            case 14: 
            case 15: 
            case 186: 
            case 187: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
            case 32: 
            case 33: {
                n2 = 91;
                break;
            }
            case 34: 
            case 35: {
                n2 = 92;
                break;
            }
            case 36: 
            case 37: {
                n2 = 93;
                break;
            }
            case 38: 
            case 39: {
                if (bl) {
                    n2 = 1;
                    break;
                }
                n2 = -2;
                break;
            }
            case 48: 
            case 49: 
            case 60: 
            case 61: {
                if (bl2) {
                    n2 = -2;
                    break;
                }
                n2 = 1;
                break;
            }
            case 40: 
            case 41: {
                if (bl) {
                    n2 = 12;
                    break;
                }
                n2 = -3;
                break;
            }
            case 50: 
            case 51: 
            case 62: 
            case 63: {
                if (bl2) {
                    n2 = -3;
                    break;
                }
                n2 = 12;
                break;
            }
            case 42: 
            case 43: {
                if (bl) {
                    n2 = -1;
                    break;
                }
                n2 = -4;
                break;
            }
            case 52: 
            case 53: 
            case 64: 
            case 65: {
                if (bl2) {
                    n2 = -4;
                    break;
                }
                n2 = -1;
                break;
            }
            case 54: 
            case 55: {
                n2 = 1;
                break;
            }
            case 56: 
            case 57: {
                n2 = 12;
                break;
            }
            case 58: 
            case 59: {
                n2 = -1;
                break;
            }
            case 200: 
            case 201: {
                n2 = 2004;
                break;
            }
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                n2 = 2005;
                break;
            }
            case 22: 
            case 23: {
                n2 = -5;
                break;
            }
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                if (this.comm.implConn.xmlDescribeType == 2005) {
                    n2 = 2005;
                    break;
                }
                n2 = 2004;
                break;
            }
            case 192: 
            case 193: {
                n2 = -2;
                break;
            }
            case 194: 
            case 195: {
                n2 = -3;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    public final int JdbcToDB2Type(int n, boolean bl) {
        int n2 = 0;
        switch (n) {
            case 91: {
                n = 384;
                break;
            }
            case 92: {
                n2 = 388;
                break;
            }
            case 93: {
                n2 = 392;
                break;
            }
            case -2: 
            case 1: {
                n2 = 452;
                break;
            }
            case -3: 
            case 12: {
                n2 = 448;
                break;
            }
            case -4: 
            case -1: {
                n2 = 456;
                break;
            }
            case 6: {
                n2 = 480;
                break;
            }
            case 2: 
            case 3: {
                n2 = 484;
                break;
            }
            case 4: {
                n2 = 496;
                break;
            }
            case 5: {
                n2 = 500;
                break;
            }
            case 1111: {
                n2 = 386;
            }
        }
        if (bl && n != 1111) {
            ++n2;
        }
        return n2;
    }

    public final String JdbcToDB2TypeName(int n) {
        String string = String.valueOf(n);
        switch (n) {
            case 91: {
                string = "DATE";
                break;
            }
            case 92: {
                string = "TIME";
                break;
            }
            case 93: {
                string = "TIMESTAMP";
                break;
            }
            case -2: {
                string = "CHAR FOR BIT DATA";
                break;
            }
            case 1: {
                string = "CHAR";
                break;
            }
            case -3: {
                string = "VARCHAR FOR BIT DATA";
                break;
            }
            case 12: {
                string = "VARCHAR";
                break;
            }
            case -4: {
                string = "LONG VARCHAR FOR BIT DATA";
                break;
            }
            case -1: {
                string = "LONG VARCHAR";
                break;
            }
            case 6: {
                string = "FLOAT";
                break;
            }
            case 3: {
                string = "DECIMAL";
                break;
            }
            case 2: {
                string = "NUMERIC";
                break;
            }
            case 4: {
                string = "INT";
                break;
            }
            case 5: {
                string = "SMALLINT";
                break;
            }
            case -5: {
                string = "BIGINT";
                break;
            }
            case 2005: {
                string = "CLOB";
                break;
            }
            case 2004: {
                string = "BLOB";
                break;
            }
            case 8: {
                string = "DOUBLE";
                break;
            }
            case 7: {
                string = "REAL";
            }
        }
        return string;
    }

    public final int[] Jdbc2DrdaType(BaseParameter baseParameter, boolean bl, boolean bl2, boolean bl3) {
        switch (baseParameter.sqlType) {
            case -7: {
                this.siDrdaType[0] = 38;
                this.siDrdaType[1] = 1;
                break;
            }
            case 1: {
                this.siDrdaType[0] = bl2 ? 54 : (this.comm.useMultiByteCPForParams ? 60 : 48);
                this.siDrdaType[1] = 254;
                break;
            }
            case -2: {
                this.siDrdaType[0] = 38;
                this.siDrdaType[1] = 254;
                break;
            }
            case 12: {
                this.siDrdaType[0] = bl2 ? (bl3 ? 63 : 56) : (this.comm.useMultiByteCPForParams ? 62 : 50);
                this.siDrdaType[1] = 32672;
                break;
            }
            case -3: {
                this.siDrdaType[0] = 40;
                this.siDrdaType[1] = 32672;
                break;
            }
            case -1: {
                this.siDrdaType[0] = bl2 ? (bl3 ? 64 : 58) : (this.comm.useMultiByteCPForParams ? 64 : 52);
                if (this.comm.serverOS == 8) {
                    this.siDrdaType[1] = 32740;
                    break;
                }
                this.siDrdaType[1] = 32700;
                break;
            }
            case 2005: {
                this.siDrdaType[0] = bl2 ? 204 : 206;
                if (this.comm.SQLAMLevel >= 8) {
                    this.siDrdaType[1] = 32777;
                    break;
                }
                this.siDrdaType[1] = 32772;
                break;
            }
            case -4: {
                if (baseParameter.nativeType == 30) {
                    this.siDrdaType[0] = 30;
                    this.siDrdaType[1] = 40;
                    break;
                }
                this.siDrdaType[0] = 42;
                this.siDrdaType[1] = 32704;
                break;
            }
            case 2004: {
                this.siDrdaType[0] = 200;
                if (this.comm.SQLAMLevel >= 8) {
                    this.siDrdaType[1] = 32777;
                    break;
                }
                this.siDrdaType[1] = 32772;
                break;
            }
            case -5: {
                if (this.comm.enableRealBigint) {
                    this.siDrdaType[0] = 22;
                    this.siDrdaType[1] = 8;
                    break;
                }
                this.siDrdaType[0] = 10;
                this.siDrdaType[1] = 8;
                break;
            }
            case 6: 
            case 8: {
                this.siDrdaType[0] = 10;
                this.siDrdaType[1] = 8;
                break;
            }
            case 7: {
                this.siDrdaType[0] = 12;
                this.siDrdaType[1] = 4;
                break;
            }
            case 2: 
            case 3: {
                this.siDrdaType[0] = 14;
                this.siDrdaType[1] = 0;
                break;
            }
            case 4: {
                this.siDrdaType[0] = 2;
                this.siDrdaType[1] = 4;
                break;
            }
            case 5: {
                this.siDrdaType[0] = 4;
                this.siDrdaType[1] = 2;
                break;
            }
            case 91: {
                this.siDrdaType[0] = 32;
                this.siDrdaType[1] = 10;
                break;
            }
            case 92: {
                this.siDrdaType[0] = 34;
                this.siDrdaType[1] = 8;
                break;
            }
            case 93: {
                this.siDrdaType[0] = 36;
                this.siDrdaType[1] = 26;
                break;
            }
            default: {
                this.siDrdaType[0] = 48;
                this.siDrdaType[1] = 254;
            }
        }
        if (bl) {
            int n = this.siDrdaType[0];
            this.siDrdaType[0] = n + 1;
        }
        return this.siDrdaType;
    }

    public final byte[] convertStringBufferToDRDADecimal(StringBuffer stringBuffer) {
        int n = stringBuffer.length() / 2;
        byte[] byArray = new byte[n];
        byte by = 0;
        byte by2 = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringBuffer.length()) {
            by = (byte)stringBuffer.charAt(n2++);
            by2 = (byte)stringBuffer.charAt(n2++);
            switch (by2) {
                case 67: 
                case 99: {
                    by2 = (byte)12;
                    break;
                }
                case 68: 
                case 100: {
                    by2 = (byte)13;
                }
            }
            int n4 = by & 0xF;
            int n5 = by2 & 0xF;
            int n6 = (n4 << 4) + (n5 << 0);
            byArray[n3++] = (byte)n6;
        }
        return byArray;
    }

    public final String convertDRDADecimalToStringBuffer(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xF;
            int n3 = byArray[i] >> 4 & 0xF;
            int n4 = 0;
            int n5 = 0;
            n4 = n2 >= 0 && n2 <= 9 ? n2 + 48 : n2 + 97 - 10;
            n5 = n3 >= 0 && n3 <= 9 ? n3 + 48 : n3 + 97 - 10;
            stringBuffer.append((char)n5);
            stringBuffer.append((char)n4);
        }
        switch (stringBuffer.charAt(stringBuffer.length() - 1)) {
            case 'C': 
            case 'c': {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                break;
            }
            case 'D': 
            case 'd': {
                stringBuffer.insert(0, '-');
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
        }
        if (n > 0) {
            stringBuffer.insert(stringBuffer.length() - n, '.');
        }
        return stringBuffer.toString();
    }

    public final int ibm2IeeeSingleFloat(int n) {
        int n2 = ((n & 0x7F000000) >> 22) - 130;
        int n3 = n & 0xFFFFFF;
        if (n3 == 0) {
            n2 = 0;
        }
        while (n2 > 0 && (n3 & 0x800000) == 0) {
            n3 <<= 1;
            --n2;
        }
        n3 &= 0x7FFFFF;
        if (n2 < 0) {
            n2 = 0;
            n3 = 0;
        }
        if (n2 > 254) {
            n2 = 255;
            n3 = 0;
        }
        n3 |= n2 << 23;
        return n3 |= n & Integer.MIN_VALUE;
    }

    public final long ibm2IeeeDoubleFloat(long l) {
        long l2;
        long l3 = 0L;
        int[] nArray = new int[]{0, 0};
        int[] nArray2 = new int[]{0, 0};
        nArray[0] = (int)(l >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        nArray[1] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        int n = ((nArray[0] & 0x7F000000) >> 22) + 766;
        nArray2[0] = nArray[0] & 0xFFFFFF;
        nArray2[1] = nArray[1] & 0xFFFFFFFF;
        if (nArray2[0] == 0 && nArray2[1] == 0) {
            n = 0;
        }
        while (n > 0 && (nArray2[0] & 0x800000) == 0) {
            nArray2[0] = nArray2[0] << 1;
            if ((nArray2[1] & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                nArray2[0] = nArray2[0] | 1;
            }
            nArray2[1] = nArray2[1] << 1;
            --n;
        }
        nArray2[0] = nArray2[0] & 0x7FFFFF;
        nArray2[1] = nArray2[0] << 29 | nArray2[1] >> 3;
        nArray2[0] = nArray2[0] >> 3;
        if (n == 1274) {
            n = 2047;
            nArray2[0] = 0;
            nArray2[1] = 0;
        }
        nArray2[0] = nArray2[0] | n << 20;
        nArray2[0] = nArray2[0] | nArray[0] & Integer.MIN_VALUE;
        l3 = l2 = (((long)nArray2[0] & 0xFFFFFFFFL) << 32) + ((long)nArray2[1] & 0xFFFFFFFFL);
        return l3;
    }

    public final float hexFloatToIEEEFloat(byte[] byArray) {
        double d = 0.0;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n = byArray2[0] & 0x7F;
        if (n >= 33) {
            byte by = (byte)(byArray2[0] & 0xFFFFFF80);
            byArray2[0] = 0;
            int n2 = this.bytesToInt(this.reverse(byArray2));
            n -= 70;
            n = (short)(n << 2);
            double d2 = Math.pow(2.0, n);
            d = d2 * (double)n2;
            if (by != 0) {
                d = -d;
            }
        }
        return (float)d;
    }

    public int convertDecFloatValue(byte[] byArray, BaseData baseData, int n) throws SQLException {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = 128 == (byArray[0] & 0x80);
        int n6 = (byArray[0] & 0x7C) >> 2;
        byte by = this.MostSigExpBits[n6];
        int n7 = this.MostSigCoefDigit[n6];
        boolean bl2 = false;
        switch (n6) {
            case 31: {
                n5 = 0;
                break;
            }
            case 30: {
                n5 = 1;
                break;
            }
            default: {
                n5 = 2;
            }
        }
        block4 : switch (n5) {
            case 0: {
                switch (n) {
                    case 0: {
                        baseData.setData(7, (Object)new Double(Double.NaN));
                        break block4;
                    }
                    case 7: {
                        baseData.setData(7, (Object)new Double(Double.NaN));
                        break block4;
                    }
                    case 6: {
                        baseData.setData(6, (Object)new Float(Float.NaN));
                        break block4;
                    }
                }
                throw this.comm.exceptions.getException(7127);
            }
            case 1: {
                switch (n) {
                    case 0: {
                        if (bl) {
                            baseData.setData(7, (Object)new Double(Double.NEGATIVE_INFINITY));
                            break block4;
                        }
                        baseData.setData(7, (Object)new Double(Double.POSITIVE_INFINITY));
                        break block4;
                    }
                    case 7: {
                        if (bl) {
                            baseData.setData(7, (Object)new Double(Double.NEGATIVE_INFINITY));
                            break block4;
                        }
                        baseData.setData(7, (Object)new Double(Double.POSITIVE_INFINITY));
                        break block4;
                    }
                    case 6: {
                        if (bl) {
                            baseData.setData(6, (Object)new Float(Float.NEGATIVE_INFINITY));
                            break block4;
                        }
                        baseData.setData(6, (Object)new Float(Float.POSITIVE_INFINITY));
                        break block4;
                    }
                }
                throw this.comm.exceptions.getException(7128);
            }
        }
        if (n5 == 1 || n5 == 0) {
            return n5;
        }
        switch (byArray.length) {
            case 4: {
                int n8 = 8;
                n4 = 2;
                n3 = 12;
                int n9 = 101;
                n2 = (by << 6 | (byArray[0] & 3) << 4 | (byArray[1] & 0xF0) >> 4) - n9;
                break;
            }
            case 8: {
                int n8 = 10;
                n4 = 5;
                n3 = 14;
                int n9 = 398;
                n2 = (by << 8 | (byArray[0] & 3) << 6 | (byArray[1] & 0xFC) >> 2) - n9;
                break;
            }
            default: {
                int n8 = 14;
                n4 = 11;
                n3 = 18;
                int n9 = 6176;
                n2 = (by << 12 | (byArray[0] & 3) << 10 | (byArray[1] & 0xFF) << 2 | (byArray[2] & 0xC0) >> 6) - n9;
            }
        }
        int n10 = n4 * 3 + 1;
        char[] cArray = new char[n10];
        if (n2 > 6) {
            bl2 = true;
            boolean bl3 = true;
        }
        cArray[0] = (char)((n7 & 0xF) + 48);
        int n11 = 1;
        for (int i = 0; i < n4; ++i) {
            int n12 = n3 / 8;
            int n13 = n12 + 1;
            int n14 = n13 * 8 - n3;
            int n15 = 10 - n14;
            int n16 = ~(-256 >> 8 - n14);
            int n17 = -256 >>> n15;
            int n18 = n15;
            int n19 = 8 - n15;
            int n20 = (byArray[n12] & n16) << n18 | (byArray[n13] & 0xFF) >>> n19;
            cArray[n11++] = (char)((this.DecletDigit1[n20] & 0xF) + 48);
            cArray[n11++] = (char)((this.DecletDigit2[n20] & 0xF) + 48);
            cArray[n11++] = (char)((this.DecletDigit3[n20] & 0xF) + 48);
            n3 += 10;
        }
        String string = new String(cArray, 0, n10);
        string = string.concat("E" + n2);
        BigDecimal bigDecimal = new BigDecimal(string);
        if (bl) {
            bigDecimal = bigDecimal.negate();
        }
        baseData.setData(8, (Object)bigDecimal);
        return n5;
    }

    public final int bytesToInt(byte[] byArray) {
        return ((byArray[3] & 0xFF) << 24) + ((byArray[2] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[0] & 0xFF);
    }

    public final byte[] reverse(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        int n2 = byArray.length - 1;
        while (n < byArray.length) {
            byArray2[n] = byArray[n2];
            ++n;
            --n2;
        }
        return byArray2;
    }

    public final int getRowLength(BaseParameters baseParameters, int n, BaseExceptions baseExceptions, DB2Connection dB2Connection, int[] nArray) {
        try {
            int n2 = 0;
            block19: for (int i = 1; i <= n; ++i) {
                BaseParameter baseParameter = baseParameters.get(i, 1);
                if (!baseParameter.isNull()) {
                    switch (baseParameter.sqlType) {
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            switch (baseParameter.getType()) {
                                case 20: {
                                    n2 = (int)((long)n2 + ((BaseClob)baseParameter.getObject()).length());
                                    break;
                                }
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: {
                                    if (baseParameter.getType() == 16) {
                                        n2 = (int)((long)n2 + ((BaseInputStreamWrapper)baseParameter.getUTF8InputStream(-1, (BaseConnection)dB2Connection, baseExceptions)).determineLength());
                                        if (this.comm.sendStreamAsBlob || ((BaseInputStreamWrapper)baseParameter.getObject()).markSupported()) continue block19;
                                        ((BaseInputStreamWrapper)baseParameter.getObject()).cache();
                                        break;
                                    }
                                    baseParameter.setCharacterStreamReader(baseParameter.getCharacterStreamReader(-1, (BaseConnection)dB2Connection, baseExceptions));
                                    n2 = (int)((long)n2 + ((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)dB2Connection, baseExceptions)).determineLength());
                                    if (this.comm.sendStreamAsBlob || ((BaseCharacterStreamWrapper)baseParameter.getObject()).markSupported()) continue block19;
                                    ((BaseCharacterStreamWrapper)baseParameter.getObject()).cache();
                                    break;
                                }
                                case 2: {
                                    n2 += ((byte[])baseParameter.getObject()).length;
                                    break;
                                }
                                default: {
                                    if (nArray != null && nArray[i - 1] != 0) {
                                        baseParameter.setCharacterStreamReader(baseParameter.getCharacterStreamReader(-1, (BaseConnection)dB2Connection, baseExceptions));
                                        n2 = (int)((long)n2 + ((BaseCharacterStreamWrapper)baseParameter.getCharacterStreamReader(-1, (BaseConnection)dB2Connection, baseExceptions)).determineLength());
                                        break;
                                    }
                                    if (this.comm.useMultiByteCPForParams) {
                                        baseParameter.setBytes(BaseParameter.stringToBytes((String)baseParameter.getString(-1, this.comm.exceptions), (UtilTransliterator)this.comm.MultiByteClientTransliterator, (BaseExceptions)this.comm.exceptions));
                                    } else {
                                        baseParameter.setBytes(BaseParameter.stringToBytes((String)baseParameter.getString(-1, this.comm.exceptions), (UtilTransliterator)this.comm.SingleByteClientTransliterator, (BaseExceptions)this.comm.exceptions));
                                    }
                                    n2 += baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    break;
                                }
                            }
                            continue block19;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            switch (baseParameter.getType()) {
                                case 2: {
                                    n2 += baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    break;
                                }
                                case 19: {
                                    n2 = (int)((long)n2 + ((BaseBlob)baseParameter.getObject()).length());
                                    break;
                                }
                                case 14: {
                                    n2 = (int)((long)n2 + ((BaseInputStreamWrapper)baseParameter.getBinaryStream(-1, (BaseConnection)dB2Connection, baseExceptions)).determineLength());
                                    if (this.comm.sendStreamAsBlob || ((BaseInputStreamWrapper)baseParameter.getObject()).markSupported()) continue block19;
                                    ((BaseInputStreamWrapper)baseParameter.getObject()).cache();
                                    break;
                                }
                                default: {
                                    baseParameter.setBytes(baseParameter.getBytes(-1, this.comm.exceptions));
                                    n2 += baseParameter.getBytes(-1, this.comm.exceptions).length;
                                    break;
                                }
                            }
                            continue block19;
                        }
                        case 3: {
                            if (baseParameter.nativeType == 186 || baseParameter.nativeType == 186) {
                                n2 += 8;
                                break;
                            }
                            n2 += 31;
                            break;
                        }
                        case 2: {
                            n2 += 31;
                            break;
                        }
                        case -7: 
                        case -6: 
                        case 5: 
                        case 16: {
                            ++n2;
                            break;
                        }
                        default: {
                            n2 += 8;
                            break;
                        }
                    }
                    continue;
                }
                ++n2;
            }
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public final byte[] UCS2CharsToBytes(char[] cArray, int n) throws UnsupportedEncodingException, UtilException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        UtilTransliterator utilTransliterator = this.comm.DoubleByteClientTransliterator;
        utilTransliterator.encode((Reader)new CharArrayReader(cArray), n, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] CharsToBytes(String string, char[] cArray) throws UnsupportedEncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, string);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        byte[] byArray = null;
        try {
            bufferedWriter.write(cArray, 0, cArray.length);
            bufferedWriter.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new UnsupportedEncodingException(iOException.getMessage());
        }
        return byArray;
    }

    public String BytesToChars(String string, byte[] byArray) throws UnsupportedEncodingException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, string);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (bl) {
            object = new char[300];
            try {
                int n = bufferedReader.read((char[])object, 0, ((char[])object).length);
                if (n > 0) {
                    stringBuffer.append((char[])object, 0, n);
                    continue;
                }
                bl = false;
            }
            catch (IOException iOException) {
                throw new UnsupportedEncodingException(iOException.getMessage());
            }
        }
        object = stringBuffer.toString();
        return object;
    }

    public final String byteToHex(byte by) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[by >> 4 & 0xF], cArray[by & 0xF]};
        return new String(cArray2);
    }

    public final String bytesToHex(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[byArray.length * 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            cArray2[n++] = cArray[byArray[i] >> 4 & 0xF];
            cArray2[n++] = cArray[byArray[i] & 0xF];
        }
        return new String(cArray2);
    }

    public final byte[] intToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public final String getJVMUnicodeEncoding() {
        if (this.JVMUnicodeEncoding == null) {
            this.JVMUnicodeEncoding = UtilJDKVersionChecker.getJVMVersion() == 1.2f || UtilJDKVersionChecker.getJVMVersion() == 1.3f ? "UnicodeBig" : "UTF-16BE";
        }
        return this.JVMUnicodeEncoding;
    }

    public void displayBufferSysout(byte[] byArray, int n, int n2) {
        System.out.println("\n******************** BUFFER CONTENTS **********************");
        try {
            if (byArray == null) {
                System.out.println("EMPTY");
            } else {
                System.out.println("Num bytes in queue = " + n2);
                System.out.println("Buffer ID = " + byArray.toString());
                System.out.print("START --> ");
                for (int i = n; i < n2; ++i) {
                    System.out.print(UtilDataConversions.byteToHex((byte)byArray[n]) + " ");
                    if (i % 8 != 0) continue;
                    System.out.println("");
                }
                System.out.println("<-- END ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void displayBufferToFile(byte[] byArray, int n, int n2, DB2ImplStatement dB2ImplStatement) throws SQLException {
        try {
            if (this.p == null) {
                File file = UtilTempFile.createTempFile((String)"DD_DB2_Buffer_Trace");
                this.p = new PrintStream(new FileOutputStream(file));
            }
            this.p.println("\n******************** BUFFER CONTENTS **********************");
            if (byArray == null) {
                this.p.println("EMPTY");
            } else {
                this.p.println("Num bytes in buffer = " + n2);
                this.p.println("Buffer ID = " + byArray.toString());
                if (dB2ImplStatement != null) {
                    this.p.println("Statement ID = " + ((Object)((Object)dB2ImplStatement)).toString());
                    this.p.println("Connection ID = " + ((Object)((Object)dB2ImplStatement.implConn)).toString());
                }
                this.p.println("START --> ");
                for (int i = n; i < n2; ++i) {
                    this.p.print(UtilDataConversions.byteToHex((byte)byArray[i]) + " ");
                    if (i % 16 != 0 || i == 0) continue;
                    this.p.println("");
                }
                this.p.println("<-- END ");
            }
        }
        catch (Exception exception) {
            throw this.comm.exceptions.getException(exception);
        }
    }
}

