/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.ui.internal.wizards;

import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import com.metamatrix.vdb.edit.VdbEditException;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.internal.edit.InternalVdbEditingContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DimensionExtensionOperation
extends WorkspaceModifyOperation {
    protected static final String XML_HTTP_EXTENSION_NAME = "XMLHTTPExtension";
    private static final String HTTP_EXTENSION_MODEL = "XMLHttpConnectorExtensions.xmi";
    private static final String XML_EXTENSION_PROJECT = "XMLExtensionsProject";
    private Object m_internal;
    static /* synthetic */ Class class$org$eclipse$core$runtime$IProgressMonitor;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    public DimensionExtensionOperation(Object vdbContext) {
        this.m_internal = vdbContext;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IProject proj = null;
        try {
            Class<?> util = Class.forName("com.metamatrix.modeler.vdbview.ui.views.VdbViewUtil");
            Method getWorker = util.getMethod("getVdbViewWorker", null);
            Object worker = getWorker.invoke(null, null);
            Method getProj = worker.getClass().getMethod("getVdbProject", null);
            proj = (IProject)getProj.invoke(worker, null);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        boolean extensionExists = this.checkExtensionExists(proj);
        Path newPath = new Path(HTTP_EXTENSION_MODEL);
        IFile theFile = null;
        if (!extensionExists) {
            try {
                InputStream is = this.getExtensionAsStream();
                theFile = this.createNewFile((IPath)newPath, proj, is);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            IPath extPath = theFile.getFullPath();
            this.addExtensionToVdb(this.m_internal, extPath, theFile);
        }
    }

    private IFile createNewFile(IPath path, IProject project, InputStream is) throws CoreException {
        IFile file = project.getFile(path);
        file.create(is, true, null);
        return file;
    }

    private InputStream getExtensionAsStream() throws IOException {
        String extensionZip = this.deriveExtensionZipLocation("XMLExtensionsProject.zip");
        ZipFile zipFile = new ZipFile(extensionZip);
        ZipEntry sourceEntry = zipFile.getEntry(HTTP_EXTENSION_MODEL);
        InputStream is = zipFile.getInputStream(sourceEntry);
        return is;
    }

    private boolean checkExtensionExists(IProject project) throws ModelWorkspaceException {
        IFile contents = project.getFile(HTTP_EXTENSION_MODEL);
        return contents.exists();
    }

    private String deriveExtensionZipLocation(String zipName) throws IOException {
        URL zipUrl = ModelGeneratorWsdlPlugin.getDefault().find((IPath)new Path(zipName));
        URL resolvedZip = Platform.resolve((URL)zipUrl);
        return resolvedZip.getPath();
    }

    private void addExtensionToVdb(Object vdbContext, IPath modelPath, IFile theFile) throws VdbEditException {
        Class<?> objClass = vdbContext.getClass();
        boolean extensionModelsExist = false;
        try {
            Method meth = objClass.getMethod("getVirtualDatabase", null);
            VirtualDatabase vdb = (VirtualDatabase)meth.invoke(vdbContext, null);
            EList modelList = vdb.getModels();
            Iterator iter = modelList.iterator();
            while (iter.hasNext()) {
                ModelReference ref = (ModelReference)iter.next();
                if (!HTTP_EXTENSION_MODEL.equals(ref.getName())) continue;
                extensionModelsExist = true;
                break;
            }
        }
        catch (Exception nme) {
            throw new VdbEditException((Throwable)nme);
        }
        if (!extensionModelsExist) {
            ModelReference[] ref = null;
            if (vdbContext instanceof InternalVdbEditingContext) {
                ref = ((InternalVdbEditingContext)vdbContext).addModel(null, modelPath, false);
            } else {
                try {
                    Method addModel = objClass.getMethod("addModel", class$org$eclipse$core$runtime$IProgressMonitor == null ? (class$org$eclipse$core$runtime$IProgressMonitor = DimensionExtensionOperation.class$("org.eclipse.core.runtime.IProgressMonitor")) : class$org$eclipse$core$runtime$IProgressMonitor, class$java$io$File == null ? (class$java$io$File = DimensionExtensionOperation.class$("java.io.File")) : class$java$io$File, class$java$lang$String == null ? (class$java$lang$String = DimensionExtensionOperation.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
                    String strPath = theFile.getFullPath().toString();
                    File modelFile = theFile.getLocation().toFile();
                    ref = (ModelReference[])addModel.invoke(vdbContext, null, modelFile, strPath, Boolean.FALSE);
                }
                catch (Exception ie) {
                    if (ie instanceof InvocationTargetException) {
                        throw new VdbEditException(ie.getCause());
                    }
                    throw new VdbEditException((Throwable)ie);
                }
            }
            try {
                ref[0].eResource().save(Collections.EMPTY_MAP);
            }
            catch (IOException ioe) {
                throw new VdbEditException((Throwable)ioe);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

