/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.OracleInternalParameter;
import com.metamatrix.jdbc.oracle.OracleInternalParameterSet;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIDCBDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class TTIRXDDataPacket
extends TTIDataPacket {
    private static String footprint = "$Revision:   3.51.1.4  $";
    private BaseColumn[] cols;
    private int nrOfCols;
    private byte[][] CurrentRow;
    private int[] CurrentLen;
    private int Offset;
    private byte[][] TmpBuf = new byte[1][];
    private int[] TmpLen = new int[1];
    private OracleInternalParameterSet m_parameters;
    public boolean isPLSQLBlock = true;
    private boolean[] m_writeAtEndOfRXD;
    private BaseExceptions baseexcepts;
    private OracleImplConnection myImplConn = null;
    private OracleDataConsumer writerInUse = null;
    private OracleDataProvider readerInUse = null;
    private static byte[] nullValue = new byte[0];
    private int[] returnedLength = new int[1];
    private byte[] vnuBuffer = null;
    private byte[] timeStampWithTZBuff = null;
    public byte[] m_sentMask = null;
    private boolean useOAll7;
    static byte[] s_base64CharMap = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public TTIRXDDataPacket(OracleImplConnection oracleImplConnection) {
        this.myImplConn = oracleImplConnection;
        this.cols = null;
        this.nrOfCols = 0;
        this.m_parameters = null;
        this.TTCCode = 7;
        this.useOAll7 = false;
    }

    public TTIRXDDataPacket(OracleImplConnection oracleImplConnection, int n) {
        this.myImplConn = oracleImplConnection;
        this.cols = null;
        this.nrOfCols = 0;
        this.m_parameters = null;
        this.TTCCode = n;
        this.useOAll7 = false;
    }

    public TTIRXDDataPacket(OracleImplConnection oracleImplConnection, boolean bl, OracleInternalParameterSet oracleInternalParameterSet) {
        this.myImplConn = oracleImplConnection;
        this.cols = null;
        this.nrOfCols = 0;
        this.m_parameters = oracleInternalParameterSet;
        this.TTCCode = 7;
        this.useOAll7 = bl;
    }

    public TTIRXDDataPacket(OracleImplConnection oracleImplConnection, boolean bl, BaseColumn[] baseColumnArray) {
        this.myImplConn = oracleImplConnection;
        this.nrOfCols = baseColumnArray.length;
        this.cols = baseColumnArray;
        this.m_parameters = null;
        this.TTCCode = 7;
        this.CurrentRow = null;
        this.useOAll7 = bl;
    }

    public OracleDataProvider getReader() {
        return this.readerInUse;
    }

    public void setCurrentRow(byte[][] byArray, int[] nArray, int n) {
        this.CurrentRow = byArray;
        this.CurrentLen = nArray;
        this.Offset = n;
    }

    public void reset(BaseColumn[] baseColumnArray) {
        this.nrOfCols = baseColumnArray.length;
        this.cols = baseColumnArray;
        this.m_parameters = null;
        this.TTCCode = 7;
    }

    public OracleInternalParameterSet getParameters() {
        return this.m_parameters;
    }

    public void setParameters(OracleInternalParameterSet oracleInternalParameterSet) {
        this.m_parameters = oracleInternalParameterSet;
    }

    public void setParameterBindings(OracleInternalParameterSet oracleInternalParameterSet) {
        int n = oracleInternalParameterSet == null ? 0 : oracleInternalParameterSet.getNumParams();
        this.m_writeAtEndOfRXD = new boolean[n];
        for (int i = 0; i < n; ++i) {
            OracleInternalParameter oracleInternalParameter = oracleInternalParameterSet.paramSet[i];
            int n2 = oracleInternalParameter.m_nativeBindType;
            this.m_writeAtEndOfRXD[i] = n2 == 96 || n2 == 1 || n2 == 8 ? oracleInternalParameter.m_maxlen > (long)this.myImplConn.writeCharParamAtEndOfRXDThreshold : oracleInternalParameter.m_maxlen > 4000L;
        }
    }

    public void setBaseExceptions(BaseExceptions baseExceptions) {
        this.baseexcepts = baseExceptions;
    }

    public int readRXDDataInBuffer(byte[] byArray, int n, BaseExceptions baseExceptions) throws SQLException {
        int n2;
        try {
            n2 = this.readerInUse.readCLRInBuf(byArray, n, byArray.length - n);
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException(utilException);
        }
        return n2;
    }

    public int readRXDDataInBuffer(byte[] byArray, BaseExceptions baseExceptions) throws SQLException {
        int n;
        try {
            n = this.readerInUse.readCLRInBuf(byArray, 0, byArray.length);
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException(utilException);
        }
        return n;
    }

    public int readExtraLongLen(BaseExceptions baseExceptions) throws SQLException {
        int n = 0;
        try {
            n = this.readerInUse.readB4();
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException(utilException);
        }
        return n;
    }

    public byte[] readRXDData(int n, BaseExceptions baseExceptions) throws SQLException {
        byte[] byArray = null;
        try {
            byArray = this.readerInUse.readCLR(n);
            if (this.readerInUse.readB2() != 0) {
                byArray = null;
            }
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException(utilException);
        }
        return byArray;
    }

    public byte[] readRXDDataWithoutIndicator(int n, BaseExceptions baseExceptions) throws SQLException {
        byte[] byArray = null;
        try {
            byArray = this.readerInUse.readCLR(n);
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException(utilException);
        }
        return byArray;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException, SQLException {
        if (this.m_parameters != null) {
            OracleInternalParameter oracleInternalParameter;
            int n;
            boolean bl = false;
            int n2 = this.m_parameters.getNumParams();
            for (n = 0; n < n2; ++n) {
                oracleInternalParameter = this.m_parameters.paramSet[n];
                if ((oracleInternalParameter.m_direction & 0x20) != 0) {
                    int n3 = oracleInternalParameter.m_nativeBindType;
                    if (this.m_writeAtEndOfRXD != null && this.m_writeAtEndOfRXD[n]) {
                        bl = true;
                        continue;
                    }
                    oracleInternalParameter.writeData(oracleDataConsumer);
                    continue;
                }
                oracleDataConsumer.writeByte((byte)0);
            }
            if (bl) {
                for (n = 0; n < n2; ++n) {
                    oracleInternalParameter = this.m_parameters.paramSet[n];
                    if ((oracleInternalParameter.m_direction & 0x20) == 0 || !this.m_writeAtEndOfRXD[n]) continue;
                    oracleInternalParameter.writeData(oracleDataConsumer);
                }
            }
        }
    }

    private boolean skipValue(int n) {
        if (this.m_sentMask == null) {
            return false;
        }
        int n2 = 1 << n % 8;
        byte by = this.m_sentMask[n / 8];
        return (n2 & by) == 0;
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        block67: {
            block66: {
                this.readerInUse = oracleDataProvider;
                if (this.cols == null) break block66;
                for (int i = 0; i < this.nrOfCols; ++i) {
                    OracleColumn oracleColumn = (OracleColumn)this.cols[i];
                    if (this.skipValue(i)) {
                        if (this.CurrentRow != null) {
                            if (oracleColumn.indicator != 0) {
                                this.CurrentLen[this.Offset + i] = -1;
                            } else {
                                this.CurrentLen[this.Offset + i] = oracleColumn.len;
                                if (oracleColumn.data != null) {
                                    if (this.CurrentRow[this.Offset + i] == null || this.CurrentRow[this.Offset + i].length < oracleColumn.data.length) {
                                        this.CurrentRow[this.Offset + i] = new byte[oracleColumn.data.length];
                                    }
                                    System.arraycopy(oracleColumn.data, 0, this.CurrentRow[this.Offset + i], 0, oracleColumn.data.length);
                                    oracleColumn.data = this.CurrentRow[this.Offset + i];
                                }
                            }
                        }
                    } else {
                        oracleColumn.indicator = 0;
                        if (!this.useOAll7 && oracleColumn.isAlwaysNull) {
                            oracleColumn.indicator = -1;
                        } else {
                            int n = Math.min(oracleColumn.precision, 4000);
                            if (oracleColumn.OCINativeType == 109) {
                                int n2 = oracleDataProvider.readB4();
                                if (n2 > 0) {
                                    oracleDataProvider.readCLR(n2);
                                }
                                if ((n2 = oracleDataProvider.readB4()) > 0) {
                                    oracleDataProvider.readCLR(n2);
                                }
                                if ((n2 = oracleDataProvider.readB4()) > 0) {
                                    oracleDataProvider.readCLR(n2);
                                }
                                n2 = oracleDataProvider.readB2();
                                int n3 = oracleDataProvider.readB4();
                                n2 = oracleDataProvider.readB2();
                                if (n3 > 0) {
                                    byte[] byArray = oracleDataProvider.readCLR(n3);
                                    if (byArray[4] == 1) {
                                        oracleColumn.isSupportedColumnType = false;
                                        oracleColumn.data = nullValue;
                                        oracleColumn.indicator = -1;
                                    } else {
                                        int n4 = 0;
                                        if (byArray[2] == -2) {
                                            if (byArray[9] == 2) {
                                                if (byArray[8] == 1) {
                                                    oracleColumn.isSupportedColumnType = false;
                                                    oracleColumn.data = nullValue;
                                                    oracleColumn.indicator = -1;
                                                } else if (byArray[10] == 2) {
                                                    oracleColumn.isSupportedColumnType = false;
                                                    oracleColumn.data = nullValue;
                                                    oracleColumn.indicator = -1;
                                                } else {
                                                    n4 = byArray[11] == 25 ? 32 : 12;
                                                }
                                            } else {
                                                n4 = 12;
                                                oracleColumn.OCINativeType = 96;
                                            }
                                        } else if (byArray[7] == 25) {
                                            n4 = 28;
                                        } else {
                                            n4 = 8;
                                            if (byArray[7] == 20) {
                                                oracleColumn.OCINativeType = 96;
                                            }
                                        }
                                        if (oracleColumn.isSupportedColumnType) {
                                            byte[] byArray2 = new byte[n3 - n4];
                                            System.arraycopy(byArray, n4, byArray2, 0, n3 - n4);
                                            oracleColumn.data = byArray2;
                                            oracleColumn.len = byArray2.length;
                                        }
                                    }
                                } else {
                                    oracleColumn.data = nullValue;
                                    oracleColumn.indicator = -1;
                                }
                            } else if (oracleColumn.OCINativeType == 208) {
                                int n5 = oracleDataProvider.readB4();
                                if (n5 > 0) {
                                    oracleColumn.data = oracleDataProvider.readCLR(n);
                                    oracleColumn.len = oracleColumn.data.length;
                                }
                            } else if (oracleColumn.OCINativeType == 11) {
                                long l = 0L;
                                long l2 = 0L;
                                long l3 = 0L;
                                long l4 = 0L;
                                byte by = oracleDataProvider.readByte();
                                if (by != 0) {
                                    l = oracleDataProvider.readSB4();
                                    l2 = oracleDataProvider.readB4();
                                    oracleDataProvider.readByte();
                                    l3 = oracleDataProvider.readSB4();
                                    l4 = oracleDataProvider.readB4();
                                }
                                if (l == 0L && l2 == 0L && l3 == 0L && l4 == 0L) {
                                    oracleColumn.len = -1;
                                } else {
                                    oracleColumn.data = new byte[18];
                                    oracleColumn.len = TTIRXDDataPacket.ConvertRowidSegmentsToBase64Ascii(l, l2, l3, l4, oracleColumn.data, 0);
                                }
                            } else if (oracleColumn.OCINativeType == 112 || oracleColumn.OCINativeType == 113 || oracleColumn.OCINativeType == 114) {
                                n = oracleDataProvider.readB4();
                                if (n > 0) {
                                    oracleColumn.data = oracleDataProvider.readCLR(n);
                                    oracleColumn.len = oracleColumn.data.length;
                                } else {
                                    oracleColumn.indicator = -1;
                                }
                            } else if (this.CurrentRow != null) {
                                this.TmpBuf[0] = this.CurrentRow[this.Offset + i];
                                if (this.TmpBuf[0] == null) {
                                    if (this.myImplConn.initialColumnBufferSize > 0) {
                                        this.TmpBuf[0] = new byte[this.myImplConn.initialColumnBufferSize + 1];
                                    } else if (oracleColumn.m_defineMaxLength < 128) {
                                        this.TmpBuf[0] = new byte[oracleColumn.m_defineMaxLength];
                                    } else if (oracleColumn.m_defineMaxLength < Short.MAX_VALUE) {
                                        int n6 = (oracleColumn.m_defineMaxLength + 7) / 8;
                                        this.TmpBuf[0] = new byte[n6];
                                    } else {
                                        this.TmpBuf[0] = new byte[1024];
                                    }
                                }
                                oracleColumn.len = oracleDataProvider.readCLR(this.TmpBuf);
                                oracleColumn.data = this.TmpBuf[0];
                            } else {
                                oracleColumn.data = oracleDataProvider.readCLR(n);
                                oracleColumn.len = oracleColumn.data.length;
                            }
                        }
                        if (this.useOAll7) {
                            oracleColumn.indicator = oracleDataProvider.readB2();
                        } else if (this.myImplConn.oracleServerVersion < 902000000L || oracleColumn.OCINativeType == 8 || oracleColumn.OCINativeType == 24) {
                            oracleColumn.indicator = oracleDataProvider.readB2();
                            oracleDataProvider.skipB4();
                        }
                    }
                    if (this.CurrentRow == null) continue;
                    if (oracleColumn.indicator != 0) {
                        this.CurrentLen[this.Offset + i] = -1;
                        continue;
                    }
                    this.CurrentRow[this.Offset + i] = oracleColumn.data;
                    this.CurrentLen[this.Offset + i] = oracleColumn.len;
                }
                break block67;
            }
            if (this.m_parameters == null || this.m_parameters.getNumParams() <= 0) break block67;
            boolean bl = true;
            boolean bl2 = false;
            for (int i = 0; i < this.m_parameters.getNumParams(); ++i) {
                OracleInternalParameter oracleInternalParameter = this.m_parameters.paramSet[i];
                if (!oracleInternalParameter.isActualOutputParam()) continue;
                if (bl2) {
                    oracleDataProvider.readByte();
                }
                if (this.isPLSQLBlock && oracleInternalParameter.m_maxlen > 4000L && (this.useOAll7 || this.myImplConn.oracleServerVersion < 1000000000L)) {
                    if (!bl && !bl2) {
                        oracleDataProvider.readByte();
                    }
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                if (oracleInternalParameter.m_nativeBindType == 102) {
                    if (this.useOAll7) {
                        byte by = oracleDataProvider.readByte();
                    } else {
                        oracleDataProvider.readByte();
                        oracleDataProvider.readB2();
                        TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this.myImplConn);
                        tTIDCBDataPacket.ColumnsStreamIn(oracleDataProvider);
                        oracleInternalParameter.m_columnDescriptions = tTIDCBDataPacket.getColumns();
                    }
                }
                if (this.isPLSQLBlock) {
                    oracleInternalParameter.readData(1, oracleDataProvider);
                } else {
                    int n = oracleDataProvider.readB4();
                    oracleInternalParameter.readData(n, oracleDataProvider);
                }
                bl = false;
            }
        }
    }

    private static int ConvertUIntegerToBase64Ascii(byte[] byArray, long l, int n, int n2) {
        int n3 = n2 + n;
        while (n > 0) {
            byArray[n2 + n - 1] = s_base64CharMap[(int)l & 0x3F];
            l = l >> 6 & 0x3FFFFFFL;
            --n;
        }
        return n3;
    }

    static int ConvertRowidSegmentsToBase64Ascii(long l, long l2, long l3, long l4, byte[] byArray, int n) {
        n = TTIRXDDataPacket.ConvertUIntegerToBase64Ascii(byArray, l, 6, n);
        n = TTIRXDDataPacket.ConvertUIntegerToBase64Ascii(byArray, l2, 3, n);
        n = TTIRXDDataPacket.ConvertUIntegerToBase64Ascii(byArray, l3, 6, n);
        n = TTIRXDDataPacket.ConvertUIntegerToBase64Ascii(byArray, l4, 3, n);
        return 18;
    }
}

