/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.eval;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.function.FunctionLibrary;
import com.metamatrix.query.function.FunctionLibraryManager;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.ScalarSubquery;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.util.ValueIterator;
import com.metamatrix.query.util.CommandContext;
import java.util.List;
import java.util.Map;

public class ExpressionEvaluator {
    private ExpressionEvaluator() {
    }

    public static Object evaluate(Expression expression, Map elements, List tuple) throws ExpressionEvaluationException, BlockedException, MetaMatrixComponentException {
        return ExpressionEvaluator.evaluate(expression, elements, tuple, null, null);
    }

    public static Object evaluate(Expression expression, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws ExpressionEvaluationException, BlockedException, MetaMatrixComponentException {
        if (expression instanceof SingleElementSymbol) {
            Assertion.isNotNull((Object)elements);
            Integer index = (Integer)elements.get(expression);
            if (index != null) {
                Assertion.isNotNull((Object)tuple, (String)QueryPlugin.Util.getString("ERR.015.006.0033", (Object)"tuple", (Object)("SingleElementSymbol with elements must also have tuple. The type of this expression is: " + (expression.getType() == null ? "Unknown" : expression.getType().getName()))));
                return tuple.get(index);
            }
            if (expression instanceof ExpressionSymbol && !(expression instanceof AggregateSymbol)) {
                ExpressionSymbol exprSyb = (ExpressionSymbol)expression;
                Expression expr = exprSyb.getExpression();
                return ExpressionEvaluator.evaluate(expr, elements, tuple, dataMgr, context);
            }
            throw new ExpressionEvaluationException("ERR.015.006.0033", QueryPlugin.Util.getString("ERR.015.006.0033", (Object)expression, (Object)"No value was available"));
        }
        if (expression instanceof Constant) {
            return ((Constant)expression).getValue();
        }
        if (expression instanceof Function) {
            return ExpressionEvaluator.evaluate((Function)expression, elements, tuple, dataMgr, context);
        }
        if (expression instanceof CaseExpression) {
            return ExpressionEvaluator.evaluate((CaseExpression)expression, elements, tuple, dataMgr, context);
        }
        if (expression instanceof SearchedCaseExpression) {
            return ExpressionEvaluator.evaluate((SearchedCaseExpression)expression, elements, tuple, dataMgr, context);
        }
        if (expression instanceof Reference) {
            return ((Reference)expression).getValue(dataMgr, context);
        }
        if (expression instanceof ScalarSubquery) {
            return ExpressionEvaluator.evaluate((ScalarSubquery)expression, elements, tuple, dataMgr, context);
        }
        throw new ExpressionEvaluationException("ERR.015.006.0016", QueryPlugin.Util.getString("ERR.015.006.0016", (Object)expression.getClass().getName()));
    }

    private static Object evaluate(CaseExpression expr, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws ExpressionEvaluationException, BlockedException, MetaMatrixComponentException {
        Object exprVal = ExpressionEvaluator.evaluate(expr.getExpression(), elements, tuple, dataMgr, context);
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            if (!EquivalenceUtil.areEqual((Object)exprVal, (Object)ExpressionEvaluator.evaluate(expr.getWhenExpression(i), elements, tuple, dataMgr, context))) continue;
            return ExpressionEvaluator.evaluate(expr.getThenExpression(i), elements, tuple, dataMgr, context);
        }
        if (expr.getElseExpression() != null) {
            return ExpressionEvaluator.evaluate(expr.getElseExpression(), elements, tuple, dataMgr, context);
        }
        return null;
    }

    private static Object evaluate(SearchedCaseExpression expr, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws ExpressionEvaluationException, BlockedException, MetaMatrixComponentException {
        for (int i = 0; i < expr.getWhenCount(); ++i) {
            try {
                if (!CriteriaEvaluator.evaluate((Criteria)expr.getWhenCriteria(i), (Map)elements, (List)tuple, (LookupEvaluator)dataMgr, (CommandContext)context)) continue;
                return ExpressionEvaluator.evaluate(expr.getThenExpression(i), elements, tuple, dataMgr, context);
            }
            catch (CriteriaEvaluationException e) {
                throw new ExpressionEvaluationException((Throwable)e, "ERR.015.006.0033", QueryPlugin.Util.getString("ERR.015.006.0033", (Object)"CASE", (Object)expr.getWhenCriteria(i)));
            }
        }
        if (expr.getElseExpression() != null) {
            return ExpressionEvaluator.evaluate(expr.getElseExpression(), elements, tuple, dataMgr, context);
        }
        return null;
    }

    private static Object evaluate(Function function, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws ExpressionEvaluationException, BlockedException, MetaMatrixComponentException {
        FunctionDescriptor fd = function.getFunctionDescriptor();
        Expression[] args = function.getArgs();
        Object[] values = null;
        int start = 0;
        if (fd.requiresContext()) {
            values = new Object[args.length + 1];
            values[0] = context;
            start = 1;
        } else {
            values = new Object[args.length];
        }
        for (int i = 0; i < args.length; ++i) {
            values[i + start] = ExpressionEvaluator.evaluate(args[i], elements, tuple, dataMgr, context);
        }
        if (fd.getPushdown() == 2) {
            throw new MetaMatrixComponentException(QueryPlugin.Util.getString("ExpressionEvaluator.Must_push", (Object)fd.getName()));
        }
        if (fd.getName().equalsIgnoreCase("lookup")) {
            if (dataMgr == null) {
                throw new ComponentNotFoundException("ERR.015.006.0055", QueryPlugin.Util.getString("ERR.015.006.0055"));
            }
            String codeTableName = (String)values[0];
            String returnElementName = (String)values[1];
            String keyElementName = (String)values[2];
            return dataMgr.lookupCodeValue(context, codeTableName, returnElementName, keyElementName, values[3]);
        }
        FunctionLibrary library = FunctionLibraryManager.getFunctionLibrary();
        Object result = library.invokeFunction(fd, values);
        return result;
    }

    private static Object evaluate(ScalarSubquery scalarSubquery, Map elements, List tuple, LookupEvaluator dataMgr, CommandContext context) throws ExpressionEvaluationException, BlockedException, MetaMatrixComponentException {
        Object result = null;
        ValueIterator valueIter = scalarSubquery.getValueIterator();
        if (valueIter.hasNext()) {
            result = valueIter.next();
            if (valueIter.hasNext()) {
                throw new ExpressionEvaluationException("ERR.015.006.0058", QueryPlugin.Util.getString("ERR.015.006.0058", (Object)scalarSubquery.getCommand()));
            }
        }
        return result;
    }
}

