/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.pool;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.DataPlugin;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CredentialMap
implements Serializable {
    public static final String SYSTEM_KEYWORD = "system";
    public static final String USER_KEYWORD = "user";
    public static final String PASSWORD_KEYWORD = "password";
    public static final String ESCAPE_CHAR = "\\";
    public static final String DEFAULT_SYSTEM = "default";
    private static final String ESCAPE_SLASH = "ESCAPE_SLASH";
    private static final String ESCAPE_COMMA = "ESCAPE_COMMA";
    private static final String ESCAPE_EQUAL = "ESCAPE_EQUAL";
    private static final String[] escape_chars = new String[]{"\\/", "\\,", "\\="};
    private static final String[] escape_strings = new String[]{"ESCAPE_SLASH", "ESCAPE_COMMA", "ESCAPE_EQUAL"};
    public static final short MODE_IGNORE_DEFAULTS = 0;
    public static final short MODE_USE_DEFAULTS_GLOBALLY = 1;
    public static final short MODE_USE_DEFAULTS_ON_EXISTING = 2;
    private Map map = new HashMap();
    private short defaultCredentialMode = 0;
    private Map defaultCredentials;

    public static CredentialMap parseCredentials(String inputStr) throws Exception {
        for (int i = 0; i < escape_chars.length; ++i) {
            inputStr = StringUtil.replaceAll(inputStr, escape_chars[i], escape_strings[i]);
        }
        if (inputStr == null) {
            throw new Exception(DataPlugin.Util.getString("CredentialMap.Null_input"));
        }
        inputStr = inputStr.trim();
        CredentialMap credentialMap = new CredentialMap();
        int strLen = inputStr.length();
        if (strLen == 0) {
            throw new Exception(DataPlugin.Util.getString("CredentialMap.Empty_input"));
        }
        if (!inputStr.startsWith("(") || !inputStr.endsWith(")")) {
            throw new Exception(DataPlugin.Util.getString("CredentialMap.Missing_parens"));
        }
        inputStr = inputStr.substring(1, inputStr.length() - 1);
        List credentials = StringUtil.getTokens(inputStr, "/");
        for (String credential : credentials) {
            Map newMap = CredentialMap.getCredentialMap((credential = StringUtil.replaceAll(credential, escape_strings[0], "/")).trim());
            String system = (String)newMap.get(SYSTEM_KEYWORD);
            if (system == null || system.length() == 0) {
                throw new Exception(DataPlugin.Util.getString("CredentialMap.Missing_system_prop"));
            }
            credentialMap.addSystemCredentials(system, newMap);
        }
        return credentialMap;
    }

    private static Map getCredentialMap(String credential) {
        List propList = StringUtil.getTokens(credential, ",");
        Iterator propIter = propList.iterator();
        HashMap<String, String> map = new HashMap<String, String>();
        while (propIter.hasNext()) {
            String propVal = (String)propIter.next();
            List pvList = StringUtil.getTokens(propVal, "=");
            String key = null;
            String val = null;
            if (pvList.size() > 0) {
                key = (String)pvList.get(0);
                key = key.trim();
            }
            if (pvList.size() > 1) {
                val = (String)pvList.get(1);
                val = val.trim();
                val = StringUtil.replaceAll(val, escape_strings[1], ",");
                val = StringUtil.replaceAll(val, escape_strings[2], "=");
            }
            map.put(key, val);
        }
        return map;
    }

    public String[] getSystems() {
        Set keySet = this.map.keySet();
        String[] keys = new String[keySet.size()];
        Iterator it = keySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            keys[i] = (String)it.next();
            ++i;
        }
        return keys;
    }

    public void addSystemCredentials(String system, Map credentials) {
        this.map.put(system.toUpperCase(), credentials);
    }

    public void setDefaultCredentials(Map defaultCredentials) {
        this.defaultCredentials = defaultCredentials;
    }

    public void setDefaultCredentialMode(short mode) {
        this.defaultCredentialMode = mode;
    }

    public Map getSystemCredentials(String systemName) {
        Map systemCredentials = (Map)this.map.get(systemName.toUpperCase());
        if (this.defaultCredentialMode == 0) {
            return systemCredentials;
        }
        HashMap workingMap = null;
        if (this.defaultCredentials != null && (this.defaultCredentialMode == 1 || this.defaultCredentialMode == 2 && systemCredentials != null)) {
            workingMap = new HashMap();
            workingMap.putAll(this.defaultCredentials);
        }
        if (systemCredentials != null) {
            if (workingMap == null) {
                workingMap = new HashMap();
            }
            workingMap.putAll(systemCredentials);
        }
        return workingMap;
    }

    public String getUser(String systemName) {
        Map credentials = this.getSystemCredentials(systemName);
        if (credentials != null) {
            return (String)credentials.get(USER_KEYWORD);
        }
        return null;
    }

    public String getPassword(String systemName) {
        Map credentials = this.getSystemCredentials(systemName);
        if (credentials != null) {
            return (String)credentials.get(PASSWORD_KEYWORD);
        }
        return null;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String[] systems = this.getSystems();
        for (int i = 0; i < systems.length; ++i) {
            String system = systems[i];
            Map map = this.getSystemCredentials(system);
            b.append("\n");
            b.append(system);
            b.append("\n");
            for (Object key : map.keySet()) {
                b.append("\t");
                b.append(key);
                b.append("=");
                b.append(map.get(key));
                b.append("\n");
            }
        }
        return b.toString();
    }
}

