/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.SecureAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class EclipseLog
implements FrameworkLog {
    private static final String PASSWORD = "-password";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String SUBENTRY = "!SUBENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final String LINE_SEPARATOR;
    protected static final String TAB_STRING = "\t";
    public static final int DEFAULT_LOG_SIZE = 1000;
    public static final int DEFAULT_LOG_FILES = 10;
    public static final int LOG_SIZE_MIN = 10;
    public static final String PROP_LOG_SIZE_MAX = "eclipse.log.size.max";
    public static final String PROP_LOG_FILE_MAX = "eclipse.log.backup.max";
    public static final String LOG_EXT = ".log";
    public static final String BACKUP_MARK = ".bak_";
    private static final SecureAction secureAction;
    protected boolean consoleLog = false;
    protected boolean newSession = true;
    protected File outFile;
    protected Writer writer;
    int maxLogSize = 1000;
    int maxLogFiles = 10;
    int backupIdx = 0;

    public EclipseLog(File outFile) {
        this.outFile = outFile;
        this.writer = null;
        this.readLogProperties();
    }

    public EclipseLog(Writer writer) {
        this.writer = writer == null ? this.logForStream(System.err) : writer;
    }

    public EclipseLog() {
        this((Writer)null);
    }

    private Throwable getRoot(Throwable t) {
        Throwable deeplyNested;
        Throwable root = null;
        if (t instanceof BundleException) {
            root = ((BundleException)t).getNestedException();
        }
        if (t instanceof InvocationTargetException) {
            root = ((InvocationTargetException)t).getTargetException();
        }
        if ((root instanceof InvocationTargetException || root instanceof BundleException) && (deeplyNested = this.getRoot(root)) != null) {
            root = deeplyNested;
        }
        return root;
    }

    protected void writeArgs(String header, String[] args) throws IOException {
        if (args == null || args.length == 0) {
            return;
        }
        this.write(header);
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && PASSWORD.equals(args[i - 1])) {
                this.write(" (omitted)");
                continue;
            }
            this.write(" " + args[i]);
        }
        this.writeln();
    }

    protected String getSessionTimestamp() {
        String ts = System.getProperty("eclipse.startTime");
        if (ts != null) {
            try {
                return this.getDate(new Date(Long.parseLong(ts)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.getDate(new Date());
    }

    protected void writeSession() throws IOException {
        this.write(SESSION);
        this.writeSpace();
        String date = this.getSessionTimestamp();
        this.write(date);
        this.writeSpace();
        for (int i = SESSION.length() + date.length(); i < 78; ++i) {
            this.write("-");
        }
        this.writeln();
        try {
            String key = "eclipse.buildId";
            String value = System.getProperty(key, "unknown");
            this.writeln(key + "=" + value);
            key = "java.fullversion";
            value = System.getProperty(key);
            if (value == null) {
                key = "java.version";
                value = System.getProperty(key);
                this.writeln(key + "=" + value);
                key = "java.vendor";
                value = System.getProperty(key);
                this.writeln(key + "=" + value);
            } else {
                this.writeln(key + "=" + value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.write("BootLoader constants: OS=" + EclipseEnvironmentInfo.getDefault().getOS());
        this.write(", ARCH=" + EclipseEnvironmentInfo.getDefault().getOSArch());
        this.write(", WS=" + EclipseEnvironmentInfo.getDefault().getWS());
        this.writeln(", NL=" + EclipseEnvironmentInfo.getDefault().getNL());
        this.writeArgs("Framework arguments: ", EclipseEnvironmentInfo.getDefault().getNonFrameworkArgs());
        this.writeArgs("Command-line arguments: ", EclipseEnvironmentInfo.getDefault().getCommandLineArgs());
    }

    public void close() {
        try {
            if (this.writer != null) {
                Writer tmpWriter = this.writer;
                this.writer = null;
                tmpWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void openFile() {
        if (this.writer == null) {
            if (this.outFile != null) {
                try {
                    this.writer = this.logForStream(secureAction.getFileOutputStream(this.outFile, true));
                }
                catch (IOException e) {
                    this.writer = this.logForStream(System.err);
                }
            } else {
                this.writer = this.logForStream(System.err);
            }
        }
    }

    protected void closeFile() {
        if (this.outFile != null && this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.writer = null;
        }
    }

    public void log(FrameworkEvent frameworkEvent) {
        Bundle b = frameworkEvent.getBundle();
        Throwable t = frameworkEvent.getThrowable();
        FrameworkLogEntry logEntry = new FrameworkLogEntry(b.getLocation() + " 0 0", "FrameworkEvent.ERROR", 0, t, null);
        this.log(logEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void log(FrameworkLogEntry logEntry) {
        if (logEntry == null) {
            return;
        }
        try {
            this.checkLogFileSize();
            this.openFile();
            if (this.newSession) {
                this.writeSession();
                this.newSession = false;
            }
            this.writeLog(0, logEntry);
            this.writer.flush();
        }
        catch (Exception e) {
            System.err.println("An exception occurred while writing to the platform log:");
            e.printStackTrace(System.err);
            System.err.println("Logging to the console instead.");
            try {
                this.writer = this.logForStream(System.err);
                this.writeLog(0, logEntry);
                this.writer.flush();
            }
            catch (Exception e2) {
                System.err.println("An exception occurred while logging to the console:");
                e2.printStackTrace(System.err);
            }
        }
        finally {
            this.closeFile();
        }
    }

    public synchronized void setWriter(Writer newWriter, boolean append) {
        this.setOutput(null, newWriter, append);
    }

    public synchronized void setFile(File newFile, boolean append) throws IOException {
        if (newFile != null && !newFile.equals(this.outFile)) {
            this.readLogProperties();
            this.backupIdx = 0;
        }
        this.setOutput(newFile, null, append);
        System.getProperties().put("osgi.logfile", newFile.getAbsolutePath());
    }

    public synchronized File getFile() {
        return this.outFile;
    }

    public void setConsoleLog(boolean consoleLog) {
        this.consoleLog = consoleLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutput(File newOutFile, Writer newWriter, boolean append) {
        if (newOutFile == null || !newOutFile.equals(this.outFile)) {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.writer = null;
            }
            File oldOutFile = this.outFile;
            this.outFile = newOutFile;
            this.writer = newWriter;
            boolean copyFailed = false;
            if (append && oldOutFile != null && oldOutFile.isFile()) {
                Reader fileIn = null;
                try {
                    this.openFile();
                    fileIn = new InputStreamReader((InputStream)secureAction.getFileInputStream(oldOutFile), "UTF-8");
                    this.copyReader(fileIn, this.writer);
                }
                catch (IOException e) {
                    copyFailed = true;
                    e.printStackTrace();
                }
                finally {
                    if (fileIn != null) {
                        try {
                            fileIn.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (!copyFailed) {
                            oldOutFile.delete();
                        }
                    }
                    this.closeFile();
                }
            }
        }
    }

    private void copyReader(Reader reader, Writer aWriter) throws IOException {
        int count;
        char[] buffer = new char[1024];
        while ((count = reader.read(buffer, 0, buffer.length)) > 0) {
            aWriter.write(buffer, 0, count);
        }
    }

    protected String getDate(Date date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
            return formatter.format(date);
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    protected String getStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        Throwable root = this.getRoot(t);
        if (root != null) {
            pw.println("Root exception:");
            root.printStackTrace(pw);
        }
        return sw.toString();
    }

    protected Writer logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    protected void writeLog(int depth, FrameworkLogEntry entry) throws IOException {
        this.writeEntry(depth, entry);
        this.writeMessage(entry);
        this.writeStack(entry);
        FrameworkLogEntry[] children = entry.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.writeLog(depth + 1, children[i]);
            }
        }
    }

    protected void writeEntry(int depth, FrameworkLogEntry entry) throws IOException {
        if (depth == 0) {
            this.writeln();
            this.write(ENTRY);
        } else {
            this.write(SUBENTRY);
            this.writeSpace();
            this.write(Integer.toString(depth));
        }
        this.writeSpace();
        this.write(entry.getEntry());
        this.writeSpace();
        this.write(this.getDate(new Date()));
        this.writeln();
    }

    protected void writeMessage(FrameworkLogEntry entry) throws IOException {
        this.write(MESSAGE);
        this.writeSpace();
        this.writeln(entry.getMessage());
    }

    protected void writeStack(FrameworkLogEntry entry) throws IOException {
        Throwable t = entry.getThrowable();
        if (t != null) {
            String stack = this.getStackTrace(t);
            this.write(STACK);
            this.writeSpace();
            this.write(Integer.toString(entry.getStackCode()));
            this.writeln();
            this.write(stack);
        }
    }

    protected void write(String message) throws IOException {
        if (message != null) {
            this.writer.write(message);
            if (this.consoleLog) {
                System.out.print(message);
            }
        }
    }

    protected void writeln(String s) throws IOException {
        this.write(s);
        this.writeln();
    }

    protected void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    protected void writeSpace() throws IOException {
        this.write(" ");
    }

    protected boolean checkLogFileSize() {
        if (this.maxLogSize == 0) {
            return true;
        }
        boolean isBackupOK = true;
        if (this.outFile != null && this.outFile.length() >> 10 > (long)this.maxLogSize) {
            boolean isRenameOK;
            String logFilename = this.outFile.getAbsolutePath();
            String backupFilename = "";
            backupFilename = logFilename.toLowerCase().endsWith(LOG_EXT) ? logFilename.substring(0, logFilename.length() - LOG_EXT.length()) + BACKUP_MARK + this.backupIdx + LOG_EXT : logFilename + BACKUP_MARK + this.backupIdx;
            File backupFile = new File(backupFilename);
            if (backupFile.exists() && !backupFile.delete()) {
                System.err.println("Error when trying to delete old log file: " + backupFile.getName());
                if (backupFile.renameTo(new File(backupFile.getAbsolutePath() + System.currentTimeMillis()))) {
                    System.err.println("So we rename it to filename: " + backupFile.getName());
                } else {
                    System.err.println("And we also cannot rename it!");
                    isBackupOK = false;
                }
            }
            if (!(isRenameOK = this.outFile.renameTo(backupFile))) {
                System.err.println("Error when trying to rename log file to backup one.");
                isBackupOK = false;
            }
            File newFile = new File(logFilename);
            this.setOutput(newFile, null, false);
            this.openFile();
            try {
                this.writeSession();
                this.writeln();
                this.writeln("This is a continuation of log file " + backupFile.getAbsolutePath());
                this.writeln("Created Time: " + this.getDate(new Date(System.currentTimeMillis())));
                this.writer.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace(System.err);
            }
            this.closeFile();
            ++this.backupIdx;
            this.backupIdx %= this.maxLogFiles;
        }
        return isBackupOK;
    }

    protected void readLogProperties() {
        String newMaxLogFiles;
        String newMaxLogSize = secureAction.getProperty(PROP_LOG_SIZE_MAX);
        if (newMaxLogSize != null) {
            this.maxLogSize = Integer.parseInt(newMaxLogSize);
            if (this.maxLogSize != 0 && this.maxLogSize < 10) {
                this.maxLogSize = 10;
            }
        }
        if ((newMaxLogFiles = secureAction.getProperty(PROP_LOG_FILE_MAX)) != null) {
            this.maxLogFiles = Integer.parseInt(newMaxLogFiles);
            if (this.maxLogFiles < 1) {
                this.maxLogFiles = 10;
            }
        }
    }

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
        secureAction = new SecureAction();
    }
}

