/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.transport;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.jdbc.transport.LocalTransportHandler;

class KillableServerListener
implements ServerListener {
    private ServerListener delegate;
    private LocalTransportHandler handler;
    private String errorMessage;

    private void checkAlive() {
        if (!this.handler.isAlive()) {
            throw new MetaMatrixRuntimeException(this.errorMessage);
        }
    }

    public KillableServerListener(ServerListener delegate, LocalTransportHandler handler, String errorMessage) {
        this.delegate = delegate;
        this.handler = handler;
        this.errorMessage = errorMessage;
    }

    public void connectionAdded(ClientConnection connection) {
        this.checkAlive();
        this.delegate.connectionAdded(connection);
    }

    public void connectionRemoved(ClientConnection connection) {
        if (this.handler.isAlive()) {
            this.delegate.connectionRemoved(connection);
        }
    }

    public Message receive(ClientConnection connection, Message message) throws ApplicationException {
        this.checkAlive();
        return this.delegate.receive(connection, message);
    }

    public void receive(ClientConnection connection, Message message, String messageKey) {
        this.checkAlive();
        this.delegate.receive(connection, message, messageKey);
    }
}

