/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.core.log.Logger;
import com.metamatrix.dqp.metadata.ResultsMetadataConstants;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.ResultsMetadataProvider;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import java.sql.SQLException;

public class ResultsMetadataWithProvider
implements ResultSetMetaData {
    private ResultsMetadataProvider provider;
    Logger logger;
    static /* synthetic */ Class class$com$metamatrix$jdbc$ResultsMetadataProvider;
    static /* synthetic */ Class class$com$metamatrix$jdbc$ResultsMetadataWithProvider;
    static /* synthetic */ Class class$com$metamatrix$core$log$Logger;

    public static ResultsMetadataWithProvider newInstance(ResultsMetadataProvider provider, Logger logger) {
        if (AOP.useproxy()) {
            Class<?> clazz;
            Class<?> clazz2 = class$com$metamatrix$jdbc$ResultsMetadataWithProvider;
            if (clazz2 == null) {
                clazz2 = class$com$metamatrix$jdbc$ResultsMetadataWithProvider = new ResultsMetadataWithProvider[0].getClass().getComponentType();
            }
            Class[] classArray = new Class[2];
            Class clazz3 = class$com$metamatrix$jdbc$ResultsMetadataProvider;
            if (clazz3 == null) {
                clazz3 = classArray[0] = (class$com$metamatrix$jdbc$ResultsMetadataProvider = new ResultsMetadataProvider[0].getClass().getComponentType());
            }
            if ((clazz = class$com$metamatrix$core$log$Logger) == null) {
                clazz = class$com$metamatrix$core$log$Logger = new Logger[0].getClass().getComponentType();
            }
            classArray[1] = clazz;
            return (ResultsMetadataWithProvider)ProxyFactory.extend(clazz2, classArray, new Object[]{provider, logger});
        }
        return new ResultsMetadataWithProvider(provider, logger);
    }

    public ResultsMetadataWithProvider(ResultsMetadataProvider provider, Logger logger) {
        this.setMetadataProvider(provider);
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    void setMetadataProvider(ResultsMetadataProvider provider) {
        this.provider = provider;
    }

    private void verifyProvider() throws SQLException {
        if (this.provider == null) {
            throw new SQLException(JDBCPlugin.Util.getString("ResultsMetadataWithProvider.No_provider"));
        }
    }

    private int adjustColumn(int index) {
        return index - 1;
    }

    public String getVirtualDatabaseName(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.VIRTUAL_DATABASE_NAME);
    }

    public String getVirtualDatabaseVersion(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.VIRTUAL_DATABASE_VERSION);
    }

    public int getColumnCount() throws SQLException {
        this.verifyProvider();
        return this.provider.getColumnCount();
    }

    public boolean isAutoIncrement(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.AUTO_INCREMENTING);
    }

    public boolean isCaseSensitive(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.CASE_SENSITIVE);
    }

    public boolean isSearchable(int index) throws SQLException {
        this.verifyProvider();
        Integer searchable = (Integer)this.provider.getValue(this.adjustColumn(index), ResultsMetadataConstants.SEARCHABLE);
        return !ResultsMetadataConstants.SEARCH_TYPES.UNSEARCHABLE.equals(searchable);
    }

    public boolean isCurrency(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.CURRENCY);
    }

    public int isNullable(int index) throws SQLException {
        this.verifyProvider();
        Object nullable = this.provider.getValue(this.adjustColumn(index), ResultsMetadataConstants.NULLABLE);
        if (nullable.equals(ResultsMetadataConstants.NULL_TYPES.NULLABLE)) {
            return 1;
        }
        if (nullable.equals(ResultsMetadataConstants.NULL_TYPES.NOT_NULL)) {
            return 0;
        }
        return 2;
    }

    public boolean isSigned(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.SIGNED);
    }

    public int getColumnDisplaySize(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.DISPLAY_SIZE);
    }

    public String getColumnLabel(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.ELEMENT_LABEL);
    }

    public String getColumnName(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.ELEMENT_NAME);
    }

    public String getSchemaName(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.VIRTUAL_DATABASE_NAME);
    }

    public int getPrecision(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.PRECISION);
    }

    public int getScale(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getIntValue(this.adjustColumn(index), ResultsMetadataConstants.SCALE);
    }

    public String getTableName(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.GROUP_NAME);
    }

    public String getCatalogName(int index) throws SQLException {
        return null;
    }

    public int getColumnType(int index) throws SQLException {
        this.verifyProvider();
        String runtimeTypeName = this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.DATA_TYPE);
        return MMJDBCSQLTypeInfo.getSQLType(runtimeTypeName);
    }

    public String getColumnTypeName(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getStringValue(this.adjustColumn(index), ResultsMetadataConstants.DATA_TYPE);
    }

    public boolean isReadOnly(int index) throws SQLException {
        this.verifyProvider();
        return !this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    public boolean isWritable(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    public boolean isDefinitelyWritable(int index) throws SQLException {
        this.verifyProvider();
        return this.provider.getBooleanValue(this.adjustColumn(index), ResultsMetadataConstants.WRITABLE);
    }

    public String getColumnClassName(int index) throws SQLException {
        this.verifyProvider();
        return MMJDBCSQLTypeInfo.getJavaClassName(this.getColumnType(index));
    }

    public int getParameterCount() throws SQLException {
        return this.provider.getParameterCount();
    }
}

