/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.classloader.NonDelegatingClassLoader;
import com.metamatrix.common.protocol.MetaMatrixURLStreamHandlerFactory;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.jdbc.BaseDataSource;
import com.metamatrix.jdbc.BaseDriver;
import com.metamatrix.jdbc.EmbeddedConnectionFactory;
import com.metamatrix.jdbc.EmbeddedConnectionTracker;
import com.metamatrix.jdbc.EmbeddedSQLException;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.XAConnection;

public final class EmbeddedDriver
implements BaseDriver {
    static final String URL_PATTERN = "jdbc:metamatrix:(\\w+)@(([^;]*)[;]?)((.*)*)";
    static final String BASE_PATTERN = "jdbc:metamatrix:((\\w+)[;]?)(;([^@])+)*";
    public static final int MAJOR_VERSION = 5;
    public static final int MINOR_VERSION = 5;
    public static final String DRIVER_NAME = "MetaMatrix Query JDBC Driver";
    static final String DQP_IDENTITY = "dqp.identity";
    static final String MM_IO_TMPDIR = "mm.io.tmpdir";
    private static Hashtable transportMap = new Hashtable();
    static Pattern urlPattern = Pattern.compile("jdbc:metamatrix:(\\w+)@(([^;]*)[;]?)((.*)*)");
    static Pattern basePattern = Pattern.compile("jdbc:metamatrix:((\\w+)[;]?)(;([^@])+)*");

    public Connection connect(String url, Properties info) throws SQLException {
        Connection conn = null;
        if (info == null) {
            info = new Properties();
        }
        if (!this.acceptsURL(url)) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.Invalid_URL_format");
            DriverManager.println(logMsg);
            throw new SQLException(logMsg);
        }
        this.parseURL(url, info);
        conn = this.createConnection(info);
        return conn;
    }

    XAConnection createXAConnection(Properties info) throws SQLException {
        this.validateProperties(info);
        URL dqpURL = (URL)info.get("bootstrapFile");
        EmbeddedTransport transport = this.getDQPTransport(dqpURL, info);
        XAConnection conn = transport.createXAConnection(info);
        transportMap.put(dqpURL, transport);
        return conn;
    }

    Connection createConnection(Properties info) throws SQLException {
        this.validateProperties(info);
        URL dqpURL = (URL)info.get("bootstrapFile");
        EmbeddedTransport transport = this.getDQPTransport(dqpURL, info);
        Connection conn = transport.createConnection(info);
        transportMap.put(dqpURL, transport);
        return conn;
    }

    private EmbeddedTransport getDQPTransport(URL dqpURL, Properties info) throws SQLException {
        EmbeddedTransport transport = (EmbeddedTransport)transportMap.get(dqpURL);
        if (transport != null) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.use_existing_transport");
            DriverManager.println(logMsg);
        } else {
            transport = new EmbeddedTransport(dqpURL, info, this);
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.use_new_transport");
            DriverManager.println(logMsg);
        }
        return transport;
    }

    void parseURL(String url, Properties info) throws SQLException {
        if (url == null || url.trim().length() == 0) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.URL_must_be_specified");
            DriverManager.println(logMsg);
            throw new SQLException(logMsg);
        }
        try {
            MMJDBCURL jdbcURL = new MMJDBCURL(url);
            info.setProperty("VirtualDatabaseName", jdbcURL.getVDBName());
            String connectionURL = jdbcURL.getConnectionURL();
            if (connectionURL == null) {
                connectionURL = this.getDefaultConnectionURL(jdbcURL.getVDBName());
            }
            URL dqpURL = URLHelper.buildURL((String)connectionURL);
            Properties optionalParams = jdbcURL.getProperties();
            MMJDBCURL.normalizeProperties(info);
            Enumeration<Object> keys = optionalParams.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                if (info.containsKey(propName)) continue;
                info.setProperty(propName, optionalParams.getProperty(propName));
            }
            if (optionalParams.containsKey("version") && !info.containsKey("VirtualDatabaseVersion")) {
                info.setProperty("VirtualDatabaseVersion", optionalParams.getProperty("version"));
            }
            info.put("bootstrapFile", dqpURL);
        }
        catch (Exception e) {
            String logMsg = e.getClass() + ": " + e.getMessage();
            DriverManager.println(logMsg);
            DriverManager.println(e.getStackTrace().toString());
            throw new SQLException(logMsg);
        }
    }

    String getDefaultConnectionURL(String vdbName) {
        return "classpath:" + vdbName + "/mm.properties";
    }

    void validateProperties(Properties info) throws SQLException {
        String value = null;
        value = info.getProperty("VirtualDatabaseName");
        if (value == null || value.trim().length() == 0) {
            String logMsg = BaseDataSource.getResourceMessage("MMDataSource.Virtual_database_name_must_be_specified");
            DriverManager.println(logMsg);
            throw new SQLException(logMsg);
        }
        URL url = (URL)info.get("bootstrapFile");
        if (url == null) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDataSource.Configuration_file_must_be_specified");
            DriverManager.println(logMsg);
            throw new SQLException(logMsg);
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        Matcher m = urlPattern.matcher(url);
        boolean matched = m.matches();
        if (matched) {
            String name = m.group(2).toLowerCase();
            return !name.startsWith("mm://") && !name.startsWith("mms://");
        }
        m = basePattern.matcher(url);
        matched = m.matches();
        return matched;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        this.parseURL(url, info);
        LinkedList<DriverPropertyInfo> driverProps = new LinkedList<DriverPropertyInfo>();
        if (info.getProperty("VirtualDatabaseName") == null) {
            driverProps.add(new DriverPropertyInfo("VirtualDatabaseName", null));
        }
        if (info.getProperty("VirtualDatabaseVersion") == null) {
            driverProps.add(new DriverPropertyInfo("VirtualDatabaseVersion", null));
        }
        if (info.getProperty("ApplicationName") == null) {
            driverProps.add(new DriverPropertyInfo("ApplicationName", null));
        }
        if (info.getProperty("bootstrapFile") == null) {
            driverProps.add(new DriverPropertyInfo("bootstrapFile", null));
        }
        if (info.getProperty("user") == null) {
            driverProps.add(new DriverPropertyInfo("user", null));
        }
        if (info.getProperty("password") == null) {
            driverProps.add(new DriverPropertyInfo("password", null));
        }
        if (info.getProperty("logFile") == null) {
            driverProps.add(new DriverPropertyInfo("logFile", null));
        }
        if (info.getProperty("logLevel") == null) {
            driverProps.add(new DriverPropertyInfo("logLevel", null));
        }
        if (info.getProperty("partialResultsMode") == null) {
            driverProps.add(new DriverPropertyInfo("partialResultsMode", null));
        }
        if (info.getProperty("resultSetCacheMode") == null) {
            driverProps.add(new DriverPropertyInfo("resultSetCacheMode", null));
        }
        if (info.getProperty("clientToken") == null) {
            driverProps.add(new DriverPropertyInfo("clientToken", null));
        }
        if (info.getProperty("allowDoubleQuotedVariable") == null) {
            driverProps.add(new DriverPropertyInfo("allowDoubleQuotedVariable", null));
        }
        if (info.getProperty("sqlOptions") == null) {
            driverProps.add(new DriverPropertyInfo("sqlOptions", null));
        }
        DriverPropertyInfo[] propInfo = new DriverPropertyInfo[driverProps.size()];
        return driverProps.toArray(propInfo);
    }

    public int getMajorVersion() {
        return 5;
    }

    public int getMinorVersion() {
        return 5;
    }

    public String getDriverName() {
        return DRIVER_NAME;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public synchronized void shutdown(URL dqpURL) {
        EmbeddedTransport transport = (EmbeddedTransport)transportMap.get(dqpURL);
        if (transport != null) {
            try {
                transport.shutdown();
            }
            catch (SQLException e) {
                DriverManager.println(e.getMessage());
            }
            transportMap.remove(dqpURL);
        }
    }

    static {
        try {
            DriverManager.registerDriver(new EmbeddedDriver());
        }
        catch (SQLException e) {
            String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.MMDQP_DRIVER_could_not_be_registered");
            DriverManager.println(logMsg);
        }
    }

    static class EmbeddedTransport {
        private EmbeddedConnectionFactory connectionFactory;
        private EmbeddedConnectionTracker connectionTracker;
        private ClassLoader classLoader;
        private String workspaceDirectory = this.createWorkspace(this.getDQPIdentity());

        public EmbeddedTransport(URL dqpURL, Properties info, EmbeddedDriver driver) throws SQLException {
            this.connectionTracker = new EmbeddedConnectionTracker(dqpURL, driver);
            Properties props = this.loadDQPProperties(dqpURL);
            props.putAll((Map<?, ?>)info);
            this.classLoader = this.getClass().getClassLoader();
            String classPath = props.getProperty("dqp.classpath");
            if (classPath != null && classPath.length() > 0) {
                URL[] dqpClassPath = this.resolveClassPath(classPath, dqpURL);
                this.classLoader = new NonDelegatingClassLoader(dqpClassPath, Thread.currentThread().getContextClassLoader(), (URLStreamHandlerFactory)new MetaMatrixURLStreamHandlerFactory());
                String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.use_classpath");
                DriverManager.println(logMsg);
                for (int i = 0; i < dqpClassPath.length; ++i) {
                    DriverManager.println(dqpClassPath[i].toString());
                }
            }
            ClassLoader current = null;
            try {
                System.setProperty("shutdownHookInstalled", String.valueOf(Boolean.TRUE));
                current = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
                String className = "com.metamatrix.jdbc.EmbeddedConnectionFactoryImpl";
                Class<?> clazz = this.classLoader.loadClass(className);
                this.connectionFactory = (EmbeddedConnectionFactory)clazz.newInstance();
                this.connectionFactory.registerConnectionListener(this.connectionTracker);
                Thread.currentThread().setContextClassLoader(current);
            }
            catch (Exception e) {
                try {
                    DriverManager.println(e.getClass() + ": " + e.getMessage());
                    DriverManager.println(e.getStackTrace().toString());
                    throw new EmbeddedSQLException(e);
                }
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(current);
                    throw throwable;
                }
            }
        }

        URL[] resolveClassPath(String classPath, URL dqpContext) throws SQLException {
            if (classPath == null || classPath.trim().length() == 0) {
                String logMsg = BaseDataSource.getResourceMessage("EmbeddedTransport.no_classpath");
                DriverManager.println(logMsg);
                throw new EmbeddedSQLException(logMsg);
            }
            try {
                ArrayList<URL> urls = new ArrayList<URL>();
                StringTokenizer st = new StringTokenizer(classPath, ";");
                while (st.hasMoreTokens()) {
                    String path = st.nextToken();
                    if ((path = path.trim()).length() <= 0) continue;
                    urls.add(URLHelper.buildURL((URL)dqpContext, (String)path));
                }
                return urls.toArray(new URL[urls.size()]);
            }
            catch (MalformedURLException e) {
                DriverManager.println(e.getClass() + ": " + e.getMessage());
                DriverManager.println(e.getStackTrace().toString());
                throw new EmbeddedSQLException(e);
            }
        }

        Properties loadDQPProperties(URL dqpURL) throws SQLException {
            InputStream in = null;
            try {
                in = dqpURL.openStream();
                Properties props = new Properties();
                props.load(in);
                String logMsg = BaseDataSource.getResourceMessage("EmbeddedDriver.use_properties");
                DriverManager.println(logMsg);
                Iterator<Object> i = props.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    DriverManager.println(key + "=" + props.getProperty(key));
                }
                Properties properties = props;
                return properties;
            }
            catch (IOException e) {
                String logMsg = BaseDataSource.getResourceMessage("EmbeddedTransport.invalid_dqpproperties_path", new Object[]{dqpURL});
                DriverManager.println(e.getClass() + ": " + e.getMessage());
                DriverManager.println(e.getStackTrace().toString());
                throw new EmbeddedSQLException(e, logMsg);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        void shutdown() throws SQLException {
            File file;
            this.connectionFactory.shutdown();
            if (this.workspaceDirectory != null && (file = new File(this.workspaceDirectory)).exists()) {
                this.delete(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connection createConnection(Properties info) throws SQLException {
            ClassLoader current = null;
            try {
                current = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
                Connection connection = this.connectionFactory.createConnection(info);
                return connection;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        XAConnection createXAConnection(Properties info) throws SQLException {
            ClassLoader current = null;
            try {
                current = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classLoader);
                XAConnection xAConnection = this.connectionFactory.createXAConnection(info);
                return xAConnection;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }

        String getDQPIdentity() {
            String id = System.getProperty(EmbeddedDriver.DQP_IDENTITY, "0");
            int identity = Integer.parseInt(id) + 1;
            id = String.valueOf(identity);
            System.setProperty(EmbeddedDriver.DQP_IDENTITY, id);
            return id;
        }

        String createWorkspace(String identity) {
            String dir = System.getProperty("java.io.tmpdir") + "/metamatrix/" + identity;
            System.setProperty(EmbeddedDriver.MM_IO_TMPDIR, dir);
            File f = new File(dir);
            if (f.exists()) {
                this.delete(f);
            }
            if (!f.exists()) {
                f.mkdirs();
            }
            return dir;
        }

        private void delete(File file) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.delete(files[i]);
                }
            }
            if (file.getName().endsWith(".jar")) {
                file.delete();
            }
        }
    }
}

