/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.io;

import com.metamatrix.core.io.StringLineReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetReader
extends StringLineReader {
    ResultSet source = null;
    int columnCount = 0;
    String delimiter = "    ";
    boolean firstTime = true;
    int[] columnTypes = null;

    public ResultSetReader(ResultSet in) {
        this.source = in;
    }

    public ResultSetReader(ResultSet in, String delimiter) {
        this.source = in;
        this.delimiter = delimiter;
    }

    public void close() throws IOException {
        try {
            this.source.close();
            super.close();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected String nextLine() throws IOException {
        try {
            if (this.firstTime) {
                this.firstTime = false;
                ResultSetMetaData metadata = this.source.getMetaData();
                this.columnCount = metadata.getColumnCount();
                this.columnTypes = new int[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.columnTypes[i] = metadata.getColumnType(i + 1);
                }
                return this.firstLine(metadata);
            }
            if (this.source.next()) {
                StringBuffer sb = new StringBuffer();
                for (int col = 1; col <= this.columnCount; ++col) {
                    Object anObj = this.source.getObject(col);
                    if (this.columnTypes[col - 1] == 2005) {
                        sb.append(anObj != null ? anObj : "null");
                    } else if (this.columnTypes[col - 1] == 2004) {
                        sb.append(anObj != null ? "BLOB" : "null");
                    } else {
                        sb.append(anObj != null ? anObj : "null");
                    }
                    if (col == this.columnCount) continue;
                    sb.append(this.delimiter);
                }
                sb.append("\n");
                return sb.toString();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    String firstLine(ResultSetMetaData metadata) throws SQLException {
        StringBuffer sb = new StringBuffer();
        for (int col = 1; col <= this.columnCount; ++col) {
            sb.append(metadata.getColumnName(col)).append("[").append(metadata.getColumnTypeName(col)).append("]");
            if (col == this.columnCount) continue;
            sb.append(this.delimiter);
        }
        sb.append("\n");
        return sb.toString();
    }
}

