/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.common.types.XMLTranslator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class BaseXMLTranslator
implements XMLTranslator {
    static final String XMLPI = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String newLine = "\n";
    Properties properties;

    protected BaseXMLTranslator(Properties props) {
        this.properties = props;
    }

    public String getString() throws IOException {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(idenityTransform)));
            StringWriter sw = new StringWriter();
            sw.write(XMLPI);
            if (this.useIndentation()) {
                sw.write(newLine);
            }
            t.transform(this.getSource(), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.getString());
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getBytes());
    }

    public byte[] getBytes() throws IOException {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(idenityTransform)));
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(XMLPI.getBytes());
            if (this.useIndentation()) {
                stream.write(newLine.getBytes());
            }
            t.transform(this.getSource(), new StreamResult(stream));
            return stream.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    private boolean useIndentation() {
        if (this.getProperties() != null) {
            return "yes".equalsIgnoreCase(this.getProperties().getProperty("indent"));
        }
        return false;
    }
}

