/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.schema.tools.processing.internal;

import com.metamatrix.core.log.Logger;
import com.metamatrix.modeler.schema.tools.ToolsPlugin;
import com.metamatrix.modeler.schema.tools.model.schema.QName;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.AttributeColumn;
import com.metamatrix.modeler.schema.tools.model.schema.impl.BaseSchemaObject;
import com.metamatrix.modeler.schema.tools.model.schema.impl.ElementImpl;
import com.metamatrix.modeler.schema.tools.model.schema.impl.IdColumn;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SOAPArrayDefinition;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SOAPElement;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SchemaModelImpl;
import com.metamatrix.modeler.schema.tools.model.schema.impl.SoapArrayColumn;
import com.metamatrix.modeler.schema.tools.model.schema.impl.TextColumn;
import com.metamatrix.modeler.schema.tools.model.schema.impl.TypeDefinition;
import com.metamatrix.modeler.schema.tools.processing.SchemaProcessingException;
import com.metamatrix.modeler.schema.tools.processing.SchemaProcessor;
import com.metamatrix.modeler.schema.tools.processing.SchemaUtil;
import com.metamatrix.modeler.schema.tools.processing.internal.ElementContentTraversalContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDParser;

public class SchemaProcessorImpl
implements SchemaProcessor {
    private Map namespaces;
    private HashMap duplicateNamespaceFilter;
    private ArrayList defaultNamespaces;
    private ArrayList elements;
    private ElementContentTraversalContext traverseCtx;
    private boolean representTypes = false;
    private Logger log;
    private String separator;

    public SchemaProcessorImpl(Logger log, String separator) {
        this.log = log;
        this.separator = separator;
        this.clear();
    }

    public void clear() {
        this.namespaces = new HashMap();
        this.duplicateNamespaceFilter = new HashMap();
        this.defaultNamespaces = new ArrayList();
        this.elements = new ArrayList();
        this.traverseCtx = new ElementContentTraversalContext(null, null);
    }

    public void processSchemas(XSDSchema[] schemas) throws SchemaProcessingException {
        XSDSchema schema;
        int i;
        for (i = 0; i < schemas.length; ++i) {
            schema = schemas[i];
            this.processSchemaRootElements(schema, this.traverseCtx);
        }
        for (i = 0; i < schemas.length; ++i) {
            schema = schemas[i];
            this.processSchema(schema, this.traverseCtx);
        }
    }

    public void processSchemaURIs(List schemaURIs) throws Exception {
        ArrayList<XSDSchema> schemas = new ArrayList<XSDSchema>();
        for (Object o : schemaURIs) {
            URI uri = (URI)o;
            XSDSchema schema = SchemaProcessorImpl.getSchemaFromURI(uri);
            schemas.add(schema);
        }
        XSDSchema[] xsdSchemas = new XSDSchema[schemas.size()];
        schemas.toArray(xsdSchemas);
        this.processSchemas(xsdSchemas);
    }

    public static XSDSchema getSchemaFromURI(URI uri) {
        XSDParser parser = new XSDParser();
        String path = null;
        if (uri.scheme() == "ACSResponse" || uri.scheme() == "ACSRequest") {
            String schemaString = uri.fragment();
            parser.parseString(schemaString);
        } else {
            path = uri.toFileString();
            parser.parse(path);
        }
        XSDSchema schema = parser.getSchema();
        if (schema.getSchemaLocation() == null) {
            schema.setSchemaLocation(path);
        }
        return schema;
    }

    private void processSchemaRootElements(XSDSchema schema, ElementContentTraversalContext traverseCtx) {
        for (Object oelem : schema.getElementDeclarations()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)oelem;
            this.addRootElement(elem, traverseCtx);
        }
        for (Object otype : schema.getTypeDefinitions()) {
            XSDTypeDefinition type = (XSDTypeDefinition)otype;
            this.addRootType(type, traverseCtx);
        }
    }

    private void processSchema(XSDSchema schema, ElementContentTraversalContext traverseCtx) throws SchemaProcessingException {
        this.processNamespaces(schema);
        for (Object oelem : schema.getElementDeclarations()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)oelem;
            this.processElement(elem, traverseCtx, schema);
        }
        if (this.representTypes) {
            for (Object otype : schema.getTypeDefinitions()) {
                XSDTypeDefinition type = (XSDTypeDefinition)otype;
                this.processType(type, traverseCtx, schema);
            }
        }
    }

    private void processNamespaces(XSDSchema schema) {
        Map schemaNamespaces = schema.getQNamePrefixToNamespaceMap();
        for (String key : schemaNamespaces.keySet()) {
            String value;
            if (key == null || key.trim().equals("")) {
                key = "mmn0";
            }
            if (null == (value = (String)schemaNamespaces.get(key))) continue;
            int i = 1;
            if (this.namespaces.get(key) != null && value.equals((String)this.namespaces.get(key))) continue;
            if (null != this.duplicateNamespaceFilter.get(value)) {
                String prefix = (String)this.duplicateNamespaceFilter.get(value);
                if (!prefix.startsWith("mmn")) continue;
                prefix = key;
                continue;
            }
            while (this.namespaces.get(key) != null) {
                if (key != null) {
                    key = key + i++;
                    continue;
                }
                key = "ns" + i;
            }
            this.namespaces.put(key, value);
            this.duplicateNamespaceFilter.put(value, key);
        }
        String namespace = schema.getTargetNamespace();
        if (null != namespace && null == this.duplicateNamespaceFilter.get(namespace)) {
            String tns = "mmn";
            int ctr = 0;
            if (this.namespaces.get("mmn" + ctr) != null) {
                ++ctr;
            }
            this.namespaces.put("mmn" + ctr, namespace);
        }
    }

    private void addRootElement(XSDElementDeclaration elem, ElementContentTraversalContext traverseCtx) {
        String name = elem.getName();
        String namespace = elem.getTargetNamespace();
        if (name == null) {
            return;
        }
        QName qname = SchemaUtil.getQName(namespace, name);
        if (traverseCtx.getGlobalElement(qname) != null) {
            return;
        }
        traverseCtx.putGlobalElement(qname, elem);
    }

    private void addRootType(XSDTypeDefinition type, ElementContentTraversalContext traverseCtx) {
        String name = type.getName();
        String namespace = type.getTargetNamespace();
        if (name == null) {
            return;
        }
        QName qname = SchemaUtil.getQName(namespace, name);
        if (traverseCtx.getGlobalType(qname) != null) {
            return;
        }
        traverseCtx.putGlobalType(qname, type);
    }

    private void processType(XSDTypeDefinition type, ElementContentTraversalContext traverseCtx2, XSDSchema schema) throws SchemaProcessingException {
        BaseSchemaObject typeDecl;
        String namespacePrefix = this.getNameSpacePrefix(type.getTargetNamespace());
        boolean isSOAPArray = SOAPArrayDefinition.isSOAPArray(type);
        if (isSOAPArray) {
            XSDTypeDefinition arrayType = SOAPArrayDefinition.getSOAPArrayType(type);
            typeDecl = new SOAPArrayDefinition(type, arrayType, namespacePrefix, schema);
        } else {
            typeDecl = new TypeDefinition(type, namespacePrefix, schema);
        }
        String fileName = SchemaUtil.shortenFileName(schema.getSchemaLocation());
        typeDecl.setFileName(fileName);
        this.addElement(typeDecl);
        this.processAttributes(typeDecl, this.traverseCtx);
        this.processElementText(typeDecl);
        this.processElementContents(typeDecl, this.traverseCtx);
    }

    private void processElement(XSDElementDeclaration elem, ElementContentTraversalContext traverseCtx, XSDSchema schema) throws SchemaProcessingException {
        String name = elem.getName();
        String namespace = elem.getTargetNamespace();
        String fileName = SchemaUtil.shortenFileName(schema.getSchemaLocation());
        XSDElementDeclaration refElem = this.resolveElementRef(elem, traverseCtx);
        if (name == null) {
            if (refElem != elem) {
                this.processElement(refElem, traverseCtx, schema);
                return;
            }
            this.log.log(2, "Element Name is null and reference points to Element");
            return;
        }
        if (refElem == null || refElem != elem) {
            // empty if block
        }
        XSDTypeDefinition type = this.resolveElementType(elem, traverseCtx);
        QName qname = SchemaUtil.getQName(namespace, name);
        Map tablesForName = traverseCtx.getElementsByNameThenType(qname);
        SchemaObject element = (SchemaObject)tablesForName.get(type);
        boolean isSoapType = false;
        if (element == null) {
            XSDTypeDefinition soapType = SOAPArrayDefinition.getSOAPArrayType(type);
            if (null != soapType) {
                isSoapType = true;
                element = new SOAPElement(elem, this.getNameSpacePrefix(elem.getTargetNamespace()), soapType, schema);
                type = soapType;
            } else {
                element = new ElementImpl(elem, this.getNameSpacePrefix(elem.getTargetNamespace()), type, schema);
            }
            element.setFileName(fileName);
            tablesForName.put(type, element);
            this.addElement(element);
            this.processAttributes(element, traverseCtx);
            this.processElementText(element);
            this.processElementContents(element, traverseCtx);
        }
        int minOccurs = traverseCtx.calculateMinOccurs(1);
        int maxOccurs = traverseCtx.calculateMaxOccurs(1);
        if (isSoapType) {
            element.addParent(traverseCtx.getParentTable(), minOccurs, -1);
        } else {
            element.addParent(traverseCtx.getParentTable(), minOccurs, maxOccurs);
        }
    }

    private void addElement(SchemaObject element) {
        this.elements.add(element);
    }

    private XSDElementDeclaration resolveElementRef(XSDElementDeclaration ref, ElementContentTraversalContext traverseCtx) {
        XSDElementDeclaration elem = ref.getResolvedElementDeclaration();
        String name = elem.getName();
        String namespace = elem.getTargetNamespace();
        QName qname = SchemaUtil.getQName(namespace, name);
        Object oGlobal = traverseCtx.getGlobalElement(qname);
        XSDElementDeclaration retval = oGlobal != null ? (XSDElementDeclaration)oGlobal : elem;
        return retval;
    }

    private XSDTypeDefinition resolveElementType(XSDElementDeclaration elem, ElementContentTraversalContext traverseCtx) throws SchemaProcessingException {
        XSDTypeDefinition type = elem.getType();
        if (null == type) {
            throw new SchemaProcessingException(ToolsPlugin.Util.getString("SchemaProcessor.no.type.declaration", (Object)elem.getName()));
        }
        return this.resolveType(type, traverseCtx);
    }

    private XSDTypeDefinition resolveType(XSDTypeDefinition type, ElementContentTraversalContext traverseCtx) {
        String name = type.getName();
        String namespace = type.getTargetNamespace();
        QName qname = SchemaUtil.getQName(namespace, name);
        Object oGlobal = traverseCtx.getGlobalType(qname);
        XSDTypeDefinition retval = oGlobal != null ? (XSDTypeDefinition)oGlobal : type;
        return retval;
    }

    private boolean isTypeResolved(XSDTypeDefinition type, ElementContentTraversalContext traverseCtx) {
        String name = type.getName();
        String namespace = type.getTargetNamespace();
        QName qname = SchemaUtil.getQName(namespace, name);
        return null != traverseCtx.getGlobalType(qname);
    }

    private void processAttributes(SchemaObject element, ElementContentTraversalContext traverseCtx) throws SchemaProcessingException {
        IdColumn idcol = new IdColumn(SchemaUtil.getStringType(element.getSchema()));
        element.addAttribute(idcol);
        List attrs = element.getAttributeList();
        for (Object o : attrs) {
            XSDAttributeUse attrUse = (XSDAttributeUse)o;
            XSDAttributeDeclaration attrDecl = attrUse.getAttributeDeclaration();
            AttributeColumn col = new AttributeColumn(attrDecl, this.getNameSpacePrefix(attrDecl.getTargetNamespace()), false);
            element.addAttribute(col);
        }
    }

    private String getNameSpacePrefix(String targetNamespace) {
        Map namespacePrefixes = this.getNamespacePrefixes();
        return (String)namespacePrefixes.get(targetNamespace);
    }

    public Map getNamespacePrefixes() {
        Map nsMap = this.getNamespaces();
        HashMap returnMap = new HashMap();
        for (String key : nsMap.keySet()) {
            returnMap.put(nsMap.get(key), key);
        }
        return returnMap;
    }

    private void processElementText(SchemaObject element) {
        XSDSimpleTypeDefinition textType = element.getTextType();
        if (element instanceof SOAPArrayDefinition) {
            if (textType != null) {
                SoapArrayColumn col = new SoapArrayColumn(false, textType, element);
                element.addAttribute(col);
            }
        } else if (textType != null) {
            TextColumn col = new TextColumn(false, textType);
            element.addAttribute(col);
        }
    }

    private void processElementContents(SchemaObject element, ElementContentTraversalContext traverseCtx) throws SchemaProcessingException {
        XSDComplexTypeContent content = element.getContent();
        if (null == content || !(content instanceof XSDParticle)) {
            return;
        }
        XSDParticle particle = (XSDParticle)content;
        ElementContentTraversalContext childTraverseCtx = new ElementContentTraversalContext(element, traverseCtx);
        this.processParticle(particle, childTraverseCtx, element.getSchema());
    }

    private void processParticle(XSDParticle particle, ElementContentTraversalContext traverseCtx, XSDSchema schema) throws SchemaProcessingException {
        XSDParticleContent content = particle.getContent();
        int min = particle.getMinOccurs();
        int max = particle.getMaxOccurs();
        traverseCtx.addMinOccurs(new Integer(min));
        traverseCtx.addMaxOccurs(new Integer(max));
        if (content instanceof XSDElementDeclaration) {
            XSDElementDeclaration elem = (XSDElementDeclaration)content;
            this.processElement(elem, traverseCtx, schema);
        } else if (content instanceof XSDModelGroup) {
            XSDModelGroup group = (XSDModelGroup)content;
            this.processGroup(group, traverseCtx, schema);
        } else if (content instanceof XSDModelGroupDefinition) {
            XSDModelGroup group;
            XSDModelGroupDefinition groupDef = (XSDModelGroupDefinition)content;
            XSDModelGroupDefinition resolvedGroup = groupDef.getResolvedModelGroupDefinition();
            XSDModelGroup xSDModelGroup = group = resolvedGroup == null ? null : resolvedGroup.getModelGroup();
            if (group != null) {
                this.processGroup(group, traverseCtx, schema);
            }
        } else if (content instanceof XSDTerm || content instanceof XSDWildcard) {
            // empty if block
        }
        traverseCtx.removeMinOccurs(traverseCtx.minOccurs.size() - 1);
        traverseCtx.removeMaxOccurs(traverseCtx.maxOccurs.size() - 1);
    }

    private void processGroup(XSDModelGroup group, ElementContentTraversalContext traverseCtx, XSDSchema schema) throws SchemaProcessingException {
        int min;
        int compositor = group.getCompositor().getValue();
        switch (compositor) {
            case 0: {
                min = 0;
                break;
            }
            case 1: {
                min = 0;
                break;
            }
            case 2: {
                min = 1;
                break;
            }
            default: {
                min = 1;
            }
        }
        traverseCtx.addMinOccurs(new Integer(min));
        traverseCtx.addMaxOccurs(new Integer(1));
        EList particles = group.getParticles();
        for (Object o : particles) {
            XSDParticle particle = (XSDParticle)o;
            this.processParticle(particle, traverseCtx, schema);
        }
        traverseCtx.removeMinOccurs(traverseCtx.minOccurs.size() - 1);
        traverseCtx.removeMaxOccurs(traverseCtx.maxOccurs.size() - 1);
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public ArrayList getDefaultNamespaces() {
        return this.defaultNamespaces;
    }

    public SchemaModel getSchemaModel() {
        SchemaModelImpl model = new SchemaModelImpl(this.elements, this.defaultNamespaces, this.namespaces, this.separator);
        model.setTypeAware(this.representTypes);
        return model;
    }

    public void representTypes(boolean representTypes) {
        this.representTypes = representTypes;
        this.log.log(1, "SchemaProcessor configured for Types");
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }
}

